/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.exception.InvalidHostfileException;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringUtils;

public class Mount {
    private MountingType mountingType;
    private String mountAs;
    private char driveletter;
    private String label;
    private File[] path;
    private File write;
    private String lowlevelCD;
    private String useCD;
    private String freesize;
    private boolean unmounted;

    public Mount(MountingType mountingType, String mountAs, String driveletter, String[] paths, String label, String low, String usecd, String write, String freesize) {
        this.mountingType = mountingType;
        this.mountAs = mountAs.toLowerCase();
        this.driveletter = Character.toUpperCase(driveletter.charAt(0));
        this.path = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.path[i] = new File(paths[i]);
        }
        this.write = write == null ? null : new File(write);
        this.label = label;
        this.lowlevelCD = low;
        this.useCD = usecd;
        this.freesize = freesize;
        this.unmounted = false;
    }

    public Mount(Mount otherMount) {
        this.mountingType = otherMount.mountingType;
        this.mountAs = otherMount.mountAs;
        this.driveletter = otherMount.driveletter;
        this.label = otherMount.label;
        this.path = (File[])otherMount.path.clone();
        this.write = otherMount.write;
        this.lowlevelCD = otherMount.lowlevelCD;
        this.useCD = otherMount.useCD;
        this.freesize = otherMount.freesize;
        this.unmounted = otherMount.unmounted;
    }

    private void init() {
        this.mountingType = MountingType.DIR;
        this.mountAs = "";
        this.driveletter = '\u0000';
        this.label = "";
        this.path = new File[0];
        this.write = null;
        this.lowlevelCD = "";
        this.useCD = "";
        this.freesize = "";
        this.unmounted = false;
    }

    private void initForPhysFS(String physFSPath) {
        this.mountingType = MountingType.PHYSFS;
        int colonIndex1 = physFSPath.indexOf(58);
        if (colonIndex1 == 1) {
            colonIndex1 = physFSPath.indexOf(":", colonIndex1 + 1);
        }
        int colonIndex2 = physFSPath.lastIndexOf(":");
        this.path = new File[1];
        if (colonIndex1 == colonIndex2) {
            this.path[0] = new File(physFSPath.substring(0, colonIndex2));
        } else {
            this.write = new File(physFSPath.substring(0, colonIndex1));
            this.path[0] = new File(physFSPath.substring(colonIndex1 + 1, colonIndex2));
        }
    }

    private void initForIso(String IsoPath) {
        this.mountingType = MountingType.IMAGE;
        this.mountAs = "iso";
        this.path = new File[1];
        this.path[0] = new File(IsoPath.substring(0, FileUtils.containsIso(IsoPath)));
    }

    public Mount(boolean floppy, String hostFileLocation, String[] existingMounts) throws InvalidHostfileException, InvalidMountstringException, DrivelettersExhaustedException {
        this.init();
        if ("".equals(hostFileLocation)) {
            throw new InvalidHostfileException();
        }
        this.driveletter = Mount.getFreeDriveletter(floppy, existingMounts);
        if (FileUtils.containsPhysFS(hostFileLocation) != -1) {
            this.initForPhysFS(hostFileLocation);
        } else if (FileUtils.containsIso(hostFileLocation) != -1) {
            this.initForIso(hostFileLocation);
        } else {
            File file = new File(hostFileLocation);
            this.path = new File[1];
            this.path[0] = file.getParentFile();
            if (this.path[0] == null) {
                this.path[0] = new File(".");
            }
        }
    }

    public Mount(String mount) throws InvalidMountstringException {
        this.init();
        if ("".equals(mount)) {
            throw new InvalidMountstringException();
        }
        int spaceIndex = mount.indexOf(32);
        this.driveletter = Character.toUpperCase(mount.charAt(spaceIndex + 1));
        int firstQuoteIndex = mount.indexOf(34);
        int secondQuoteIndex = mount.lastIndexOf(34);
        if (firstQuoteIndex == -1 && secondQuoteIndex == -1) {
            firstQuoteIndex = mount.indexOf(32, spaceIndex + 1);
            secondQuoteIndex = mount.indexOf(32, firstQuoteIndex + 1);
        }
        if (secondQuoteIndex == -1 || firstQuoteIndex == secondQuoteIndex) {
            secondQuoteIndex = mount.length();
        }
        String mountLocation = PlatformUtils.toNativePath(mount.substring(firstQuoteIndex + 1, secondQuoteIndex));
        String[] paths = StringUtils.mountToStringArray(mountLocation);
        this.path = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.path[i] = FileUtils.makeRelativeToDosroot(new File(paths[i]));
        }
        if (mount.toLowerCase().startsWith("mount ")) {
            int freesizeIndex;
            String[] lowlevel_types;
            int labelIndex;
            int unmountIndex;
            if (FileUtils.isPhysFS(mountLocation)) {
                this.initForPhysFS(mountLocation);
            }
            if ((unmountIndex = mount.indexOf("-u ")) != -1) {
                this.unmounted = true;
                this.driveletter = Character.toUpperCase(mount.charAt(unmountIndex + 3));
                return;
            }
            int typeIndex = mount.indexOf("-t ");
            if (typeIndex != -1) {
                int spaceIndex2 = mount.indexOf(" ", typeIndex + 3);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.mountAs = mount.substring(typeIndex + 3, spaceIndex2);
            }
            if ((labelIndex = mount.indexOf("-label ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", labelIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.label = mount.substring(labelIndex + 7, spaceIndex2);
            }
            for (String ll_type : lowlevel_types = Settings.getInstance().getSettings().getValues("profile", "lowlevelcd_type")) {
                if (mount.indexOf(" -" + ll_type) == -1) continue;
                this.lowlevelCD = ll_type;
            }
            int usecdIndex = mount.indexOf("-usecd ");
            if (usecdIndex != -1) {
                int spaceIndex2 = mount.indexOf(" ", usecdIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.useCD = mount.substring(usecdIndex + 7, spaceIndex2);
            }
            if ((freesizeIndex = mount.indexOf("-freesize ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", freesizeIndex + 10);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.freesize = mount.substring(freesizeIndex + 10, spaceIndex2);
            }
        } else if (mount.toLowerCase().startsWith("imgmount ")) {
            this.mountingType = MountingType.IMAGE;
            this.mountAs = "iso";
        }
    }

    public static char getFreeDriveletter(boolean floppy, String[] existingMounts) throws InvalidMountstringException, DrivelettersExhaustedException {
        int start;
        int i;
        Mount[] mnts = new Mount[existingMounts.length];
        for (int i2 = 0; i2 < mnts.length; ++i2) {
            mnts[i2] = new Mount(existingMounts[i2]);
        }
        ArrayList<Character> freeDriveletters = new ArrayList<Character>();
        for (i = start = floppy ? 65 : 67; i < 90; i = (int)((char)(i + '\u0001'))) {
            freeDriveletters.add(Character.valueOf((char)i));
        }
        if (!floppy) {
            freeDriveletters.add(Character.valueOf('A'));
            freeDriveletters.add(Character.valueOf('B'));
        }
        for (i = 0; i < mnts.length; ++i) {
            freeDriveletters.remove(new Character(mnts[i].getDriveletter()));
        }
        if (freeDriveletters.isEmpty()) {
            throw new DrivelettersExhaustedException();
        }
        return ((Character)freeDriveletters.get(0)).charValue();
    }

    public String toString(boolean forList) {
        StringBuffer result = new StringBuffer();
        switch (this.mountingType) {
            case DIR: {
                result.append("mount ").append(this.driveletter).append(" \"").append(this.getPathAsString()).append('\"');
                if (this.lowlevelCD.length() > 0) {
                    result.append(" -").append(this.lowlevelCD);
                }
                if (this.useCD.length() <= 0) break;
                result.append(" -usecd ").append(this.useCD);
                break;
            }
            case PHYSFS: {
                result.append("mount ").append(this.driveletter).append(" \"");
                if (this.write != null) {
                    result.append(this.write.getPath()).append(':');
                }
                result.append(this.path[0].getPath()).append(":\\\"");
                break;
            }
            case IMAGE: {
                result.append("imgmount ").append(this.driveletter);
                for (int i = 0; i < this.path.length; ++i) {
                    result.append(" \"").append(this.path[i].getPath()).append('\"');
                }
                break;
            }
        }
        if (!"".equals(this.label)) {
            result.append(" -label ").append(this.label);
        }
        if (!"".equals(this.mountAs)) {
            result.append(" -t ").append(this.mountAs);
        }
        if (!"".equals(this.freesize)) {
            result.append(" -freesize ").append(this.freesize);
        }
        if (this.unmounted) {
            if (forList) {
                result.append(" (UNMOUNTED)");
            } else {
                result = new StringBuffer("mount -u ").append(this.driveletter);
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public void toggleMount() {
        this.unmounted = !this.unmounted;
    }

    public char getDriveletter() {
        return this.driveletter;
    }

    public String getDriveletterString() {
        return String.valueOf(this.driveletter);
    }

    public String getLowlevelCD() {
        return this.lowlevelCD;
    }

    public String getUseCD() {
        return this.useCD;
    }

    public boolean isUnmounted() {
        return this.unmounted;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPathAsString() {
        if (this.path.length <= 0) {
            return "";
        }
        return this.path[0].getPath();
    }

    public File getWrite() {
        return this.write;
    }

    public char getDriveletterFromPath() {
        return Character.toUpperCase(this.path[0].getAbsolutePath().charAt(0));
    }

    public String getImgMountAsString(String delimiter) {
        String[] paths = new String[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            paths[i] = this.path[i].getPath();
        }
        return StringUtils.stringArrayToString(paths, delimiter);
    }

    public String getHostPathAsString() {
        return this.mountingType == MountingType.PHYSFS ? this.getPathAsString() + ':' : this.getPathAsString();
    }

    public MountingType getMountingType() {
        return this.mountingType;
    }

    public String getMountAs() {
        return this.mountAs;
    }

    public String getFreesize() {
        return this.freesize;
    }

    public File canBeUsedFor(File hostFile) {
        if (!this.unmounted) {
            File canHostFile = FileUtils.getCanMainFile(hostFile);
            File mountFile = FileUtils.canonicalToDosroot(this.getPathAsString());
            if (FileUtils.isIsoFile(canHostFile.getPath()) || FileUtils.isArchive(canHostFile.getPath())) {
                return mountFile.equals(canHostFile) ? FileUtils.makeRelativeTo(FileUtils.canonicalToDosroot(hostFile.getPath()), FileUtils.canonicalToDosroot(this.getHostPathAsString())) : null;
            }
            if (FileUtils.areRelated(mountFile, canHostFile)) {
                return FileUtils.makeRelativeTo(canHostFile, mountFile);
            }
        }
        return null;
    }

    public boolean mostlyMatches(Mount m) {
        return this.unmounted == m.unmounted && this.mountingType == m.mountingType && this.driveletter == m.driveletter && this.getPathAsString().equals(m.getPathAsString());
    }

    public void migrateToDosroot(File fromPath) {
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = FileUtils.makeRelativeTo(this.path[i], fromPath);
        }
        if (this.write != null) {
            this.write = FileUtils.makeRelativeTo(this.write, fromPath);
        }
    }

    public void updateForTargetImportBaseDir(File basePath) {
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = FileUtils.prefixAndSanitizeToDosroot(basePath, this.path[i]);
        }
        if (this.write != null) {
            this.write = FileUtils.prefixAndSanitizeToDosroot(basePath, this.write);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mount otherMount = (Mount)obj;
        return this.driveletter == otherMount.driveletter && this.unmounted == otherMount.unmounted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MountingType {
        DIR,
        IMAGE,
        PHYSFS;

    }
}

