/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerException;
import org.dbgl.model.ExpProfile;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringUtils;
import org.dbgl.util.UIThread;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportThread
extends UIThread {
    private Document xmlDoc;
    private boolean exportCaptures;
    private boolean exportMapperfiles;
    private boolean exportGameData;
    private File target;
    private ZipOutputStream zos;

    public ExportThread(Text log, ProgressBar progressBar, Label status, List<ExpProfile> p, Document doc, boolean captures, boolean mapperfiles, boolean gamedata, File zipfile) throws IOException, SQLException {
        super(log, progressBar, status);
        this.xmlDoc = doc;
        this.exportCaptures = captures;
        this.exportMapperfiles = mapperfiles;
        this.exportGameData = gamedata;
        this.target = zipfile;
        this.objects = p;
        this.progressBar.setMaximum(this.objects.size());
        this.zos = new ZipOutputStream(new FileOutputStream(this.target));
        try {
            XmlUtils.domToZipOutputStream(this.xmlDoc, new File("profiles.xml"), this.zos);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void doFancyStuff(Object obj, StringBuffer messageLog) throws IOException {
        File orgMapperfile;
        ExpProfile prof = (ExpProfile)obj;
        this.displayTitle(this.settings.msg("dialog.export.exporting", new Object[]{prof.getTitle()}));
        File relativeGameDir = prof.getGameDir();
        File relativeGameDirInZip = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(prof.getId()), relativeGameDir.getPath()).getPath());
        if (this.exportCaptures) {
            File captures = new File(FileUtils.constructCapturesDir(prof.getId()));
            try {
                FileUtils.zipDir(prof.getCanonicalCaptures(), this.zos, captures);
            }
            catch (IOException e) {
                throw new IOException(this.settings.msg("dialog.export.error.exportcaptures", new Object[]{prof.getTitle(), StringUtils.toString(e)}), e);
            }
        }
        if (this.exportMapperfiles && (orgMapperfile = prof.getConf().getCustomMapperFile()) != null) {
            File dstMapperfile = new File(FileUtils.constructMapperFile(prof.getId()));
            FileUtils.zipEntry(orgMapperfile, dstMapperfile, this.zos);
        }
        if (this.exportGameData) {
            boolean uniqueGameFolder = true;
            for (Object obj2 : this.objects) {
                ExpProfile prof2 = (ExpProfile)obj2;
                if (prof == prof2 || !prof.getGameDir().equals(prof2.getGameDir()) || prof.getId() <= prof2.getId()) continue;
                uniqueGameFolder = false;
            }
            if (uniqueGameFolder) {
                try {
                    FileUtils.zipDir(FileUtils.canonicalToDosroot(relativeGameDir.getPath()), this.zos, relativeGameDirInZip);
                }
                catch (IOException e) {
                    throw new IOException(this.settings.msg("dialog.export.error.exportgamedata", new Object[]{prof.getTitle(), StringUtils.toString(e)}), e);
                }
            }
        }
    }

    @Override
    public String getTitle(Object o) {
        return ((ExpProfile)o).getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        this.zos.close();
    }
}

