/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.dbgl.gui.StreamGobbler;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int ZIP_BUFFER = 10240;
    private static final File DATA_DIR_FILE;
    private static final File DOSROOT_DIR_FILE;
    private static final File DOSBOX_DIR_FILE;
    private static final String TEMPLATES_DIR;
    private static final String SETUP_CONF = "setup.conf";
    private static final String TEMPLATE_CONF = "template.conf";
    public static final String PROFILES_XML = "profiles.xml";
    public static final String DOSROOT_DIR;
    public static final String CAPTURES_DIR;
    public static final String MAPPER_DIR;
    public static final String PROFILES_DIR;
    public static final String EXPORT_DIR;
    public static final String XSL_DIR;
    public static final String XSL_EXT = ".xsl";
    public static final String XML_EXT = ".xml";
    public static final String CONF_EXT = ".conf";
    public static final String MAPPER_EXT = ".map";
    public static final String GAMEPACKARCHIVE_EXT = ".dbgl.zip";
    public static final String[] CDIMAGES;
    public static final String[] EXECUTABLES;
    public static final String[] ARCHIVES;
    public static final String[] BOOTERIMAGES;
    public static final String[] PICTURES;
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String CNF_FILTER = "*.conf;*.CONF";
    public static final String EXE_FILTER = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
    public static final String ARC_FILTER = "*.zip;*.ZIP;*.7z;*.7Z";
    public static final String DBGLZIP_FILTER = "*.dbgl.zip;*.DBGL.ZIP";
    public static final String BTR_FILTER = "*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0";
    public static final String CDI_FILTER = "*.iso;*.ISO;*.cue;*.CUE";
    public static final String ALL_FILTER = "*";
    public static final String INVALID_FILENAME_CHARS_REGEXP = "[^a-zA-Z_0-9()]";

    public static String getCanonicalPath(String path) {
        String canPath = path;
        if ((PlatformUtils.IS_LINUX || PlatformUtils.IS_OSX) && (canPath.startsWith("~/") || canPath.length() == 1 && canPath.charAt(0) == '~')) {
            canPath = canPath.replaceAll("^~", System.getProperty("user.home"));
        }
        try {
            return new File(canPath).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(canPath).getAbsolutePath();
        }
    }

    public static boolean isExistingFile(File file) {
        return file.isFile() && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copy(File source, File dest) {
        block22: {
            AbstractInterruptibleChannel outStream;
            FileChannel inStream;
            block20: {
                inStream = null;
                outStream = null;
                inStream = new FileInputStream(source).getChannel();
                outStream = new FileOutputStream(dest).getChannel();
                inStream.transferTo(0L, inStream.size(), (WritableByteChannel)((Object)outStream));
                if (inStream == null) break block20;
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException ex) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                }
            }
            break block22;
            catch (IOException e) {
                block21: {
                    try {
                        System.err.println(Settings.getInstance().msg("general.error.copyfile", new Object[]{source, dest}));
                        if (inStream == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ex) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                            }
                        }
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (IOException ex) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                    }
                }
            }
        }
    }

    private static List<String> initCommands(DosboxVersion dbversion, boolean forceDBConf) {
        ArrayList<String> execCommands = new ArrayList<String>();
        if (dbversion.isUsingCurses() && PlatformUtils.IS_WINDOWS) {
            execCommands.add("rundll32");
            execCommands.add("SHELL32.DLL,ShellExec_RunDLL");
        }
        execCommands.add(dbversion.getCanonicalExecutable().getPath());
        if (dbversion.isMultiConfig() && FileUtils.isReadableFile(dbversion.getCanonicalConfFile()) || forceDBConf) {
            execCommands.add("-conf");
            execCommands.add(dbversion.getCanonicalConfFile().getPath());
        }
        return execCommands;
    }

    private static void postCommands(DosboxVersion dbversion, List<String> execCommands) {
        if (dbversion.getParameters().length() > 0) {
            for (String p : dbversion.getParameters().split(" ")) {
                execCommands.add(p);
            }
        }
        if (Settings.getInstance().getSettings().getBooleanValue("dosbox", "hideconsole")) {
            execCommands.add("-noconsole");
        }
    }

    private static void executeCommand(List<String> execCommands, File cwd, Map<String, String> env, boolean waitFor) throws IOException {
        StringBuffer cmd = new StringBuffer();
        try {
            String[] rtCmds = new String[execCommands.size()];
            for (int i = 0; i < execCommands.size(); ++i) {
                rtCmds[i] = execCommands.get(i);
                cmd.append(rtCmds[i]).append(' ');
            }
            System.out.print(cmd);
            File dir = cwd == null ? DOSROOT_DIR_FILE : cwd;
            ProcessBuilder pb = new ProcessBuilder(rtCmds);
            pb.directory(dir);
            Map<String, String> environment = pb.environment();
            if (env != null) {
                environment.putAll(env);
                System.out.print(env);
            }
            System.out.println();
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
            outputGobbler.start();
            errorGobbler.start();
            if (waitFor) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(Settings.getInstance().msg("general.error.startdosbox", new Object[]{cmd}));
        }
    }

    private static void doRunDosbox(DosboxVersion dbversion, String[] parameters, boolean forceDBConf, File cwd, Map<String, String> env, boolean waitFor) throws IOException {
        List<String> commandItems = FileUtils.initCommands(dbversion, forceDBConf);
        commandItems.addAll(Arrays.asList(parameters));
        FileUtils.postCommands(dbversion, commandItems);
        FileUtils.executeCommand(commandItems, cwd, env, waitFor);
    }

    private static File canonicalTo(File base, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                return file.getAbsoluteFile();
            }
        }
        try {
            return new File(base, file.getPath()).getCanonicalFile();
        }
        catch (IOException e) {
            return new File(base, file.getPath()).getAbsoluteFile();
        }
    }

    public static boolean areRelated(File parent, File child) {
        for (File remainder = child.getParentFile(); remainder != null; remainder = remainder.getParentFile()) {
            if (!parent.equals(remainder)) continue;
            return true;
        }
        return false;
    }

    public static String getDosRoot() {
        return DOSROOT_DIR_FILE.getPath();
    }

    public static File makeRelativeTo(File file, File basePath) {
        if (!file.isAbsolute()) {
            return file;
        }
        if (file.equals(basePath)) {
            return new File(".");
        }
        File remainder = new File(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(basePath)) {
                return remainder;
            }
            remainder = new File(parent.getName(), remainder.getPath());
        }
        return file;
    }

    public static File makeRelativeToData(File file) {
        return FileUtils.makeRelativeTo(file, DATA_DIR_FILE);
    }

    public static File makeRelativeToDosroot(File file) {
        return FileUtils.makeRelativeTo(file, DOSROOT_DIR_FILE);
    }

    public static File makeRelativeToDosbox(File file) {
        return FileUtils.makeRelativeTo(file, DOSBOX_DIR_FILE);
    }

    public static File canonicalToData(String path) {
        return FileUtils.canonicalTo(DATA_DIR_FILE, path);
    }

    public static File canonicalToDosbox(String path) {
        return FileUtils.canonicalTo(DOSBOX_DIR_FILE, path);
    }

    public static File canonicalToDosroot(String path) {
        return FileUtils.canonicalTo(DOSROOT_DIR_FILE, path);
    }

    public static String sanitizeToDosroot(String path) {
        return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(path)).getPath();
    }

    public static File prefixAndSanitizeToDosroot(File basePath, File file) {
        if (!file.isAbsolute()) {
            return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(new File(basePath, file.getPath()).getPath()));
        }
        return file;
    }

    public static File constructRelativeDBConfLocation(String path) {
        return FileUtils.makeRelativeToDosbox(new File(path, DOSBOX_CONF));
    }

    public static File constructCanonicalDBExeLocation(String path) {
        return FileUtils.canonicalToDosbox(new File(path, PlatformUtils.DB_EXECUTABLE).getPath());
    }

    public static String constructCapturesDir(int profileId) {
        return CAPTURES_DIR + profileId;
    }

    public static String constructMapperFile(int profileId) {
        return MAPPER_DIR + profileId + MAPPER_EXT;
    }

    public static String constructRelativeCapturesDir(int profileId) {
        return ".." + File.separatorChar + FileUtils.constructCapturesDir(profileId);
    }

    public static File constructCanonicalTemplateFileLocation(int templateId) {
        return FileUtils.canonicalToData(TEMPLATES_DIR + templateId + CONF_EXT);
    }

    public static String constructUniqueConfigFileString(int profileId, String profileTitle, File canonicalMainDir) {
        SectionsWrapper set = Settings.getInstance().getSettings();
        File path = set.getIntValue("profiledefaults", "confpath") == 0 ? new File(PROFILES_DIR) : canonicalMainDir;
        String prefix = set.getIntValue("profiledefaults", "conffile") == 0 ? String.valueOf(profileId) : profileTitle;
        File candidate = null;
        int nr = 1;
        do {
            candidate = new File(path, FileUtils.fileSystemSafe(prefix + (nr > 1 ? "(" + nr + ")" : "")) + CONF_EXT);
            ++nr;
        } while (FileUtils.isExistingFile(FileUtils.canonicalToData(candidate.getPath())));
        return candidate.getPath();
    }

    public static void doRunDosbox(DosboxVersion dbversion, Map<String, String> env) throws IOException {
        FileUtils.doRunDosbox(dbversion, new String[0], true, null, env, false);
    }

    public static void doCreateDosboxConf(DosboxVersion dbversion) throws IOException {
        FileUtils.doRunDosbox(dbversion, new String[]{"-c", "config -writeconf '" + dbversion.getCanonicalConfFile() + "'", "-c", "exit"}, false, dbversion.getCanonicalExecutable().getParentFile(), null, true);
    }

    public static void doRunProfile(Profile prof, List<DosboxVersion> dbversions, Map<String, String> env, int setup) throws IOException {
        DosboxVersion dbv = dbversions.get(DosboxVersion.findById(dbversions, prof.getDbversionId()));
        FileUtils.doRunProfile(prof, dbv, env, setup);
    }

    public static void doRunTemplate(Template template, List<DosboxVersion> dbversions, Map<String, String> env) throws IOException {
        DosboxVersion dbv = dbversions.get(DosboxVersion.findById(dbversions, template.getDbversionId()));
        FileUtils.doRunTemplate(template, dbv, env);
    }

    public static void doRunProfile(Profile prof, DosboxVersion dbversion, Map<String, String> env, int setup) throws IOException {
        File file = prof.getCanonicalConfFile();
        if (setup != -1 && prof.hasSetup(setup)) {
            file = FileUtils.canonicalToData(PROFILES_DIR + SETUP_CONF);
            Conf conf = new Conf(prof, prof.getSetup(setup), prof.getSetupParameters(setup), file, dbversion, System.err);
            conf.save();
        }
        FileUtils.doRunDosbox(dbversion, new String[]{"-conf", file.getPath()}, false, null, env, false);
    }

    public static void doRunTemplate(Template template, DosboxVersion dbversion, Map<String, String> env) throws IOException {
        File file = FileUtils.canonicalToData(PROFILES_DIR + TEMPLATE_CONF);
        Conf conf = new Conf(template, file, dbversion, System.err);
        conf.save();
        FileUtils.doRunDosbox(dbversion, new String[]{"-conf", file.getPath()}, false, null, env, false);
    }

    public static void createDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{dir}));
        }
    }

    public static void copyFiles(File srcDir, File dstDir) {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            for (File src : srcFiles) {
                if (!src.isFile()) continue;
                File dst = new File(dstDir, src.getName());
                FileUtils.copy(src, dst);
                dst.setLastModified(src.lastModified());
            }
        }
    }

    public static void removeFile(File file) {
        if (!file.isFile() || !file.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFilesInDirAndDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                System.err.println(Settings.getInstance().msg("general.error.dirtobedeletedcontainsdir", new Object[]{dir.getPath()}));
                return;
            }
            for (File file : files) {
                if (file.delete()) continue;
                System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file}));
            }
        }
        if (!dir.isDirectory() || !dir.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletedir", new Object[]{dir.getPath()}));
        }
    }

    public static boolean isReadableFile(File file) {
        return file.isFile() && file.canRead();
    }

    public static void createDosrootIfNecessary() {
        if (!DOSROOT_DIR_FILE.isDirectory()) {
            System.out.println(Settings.getInstance().msg("general.notice.createdir", new Object[]{DOSROOT_DIR_FILE.getPath()}));
            if (!DOSROOT_DIR_FILE.mkdirs()) {
                System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{DOSROOT_DIR_FILE.getPath()}));
            }
        }
    }

    public static boolean isExecutable(String filename) {
        for (String ext : EXECUTABLES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchive(String filename) {
        for (String ext : ARCHIVES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhysFS(String mountPath) {
        for (String ext : ARCHIVES) {
            if (!mountPath.toLowerCase().endsWith(ext + ':' + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    public static int containsPhysFS(String mountPath) {
        for (String ext : ARCHIVES) {
            int idx = mountPath.toLowerCase().indexOf(ext + ':' + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isBooterImage(String filename) {
        for (String ext : BOOTERIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfFile(String filename) {
        return filename.toLowerCase().endsWith(CONF_EXT);
    }

    public static boolean isGamePackArchiveFile(String filename) {
        return filename.toLowerCase().endsWith(GAMEPACKARCHIVE_EXT);
    }

    public static boolean isIsoFile(String filename) {
        for (String ext : CDIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static int containsIso(String mountPath) {
        for (String ext : CDIMAGES) {
            int idx = mountPath.toLowerCase().indexOf(ext + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isPicture(String filename) {
        for (String ext : PICTURES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static File getCanMainFile(File file) {
        String f = file.getPath();
        int isoIdx = FileUtils.containsIso(f);
        int pfsIdx = FileUtils.containsPhysFS(f);
        if (isoIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, isoIdx));
        }
        if (pfsIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, pfsIdx));
        }
        return FileUtils.canonicalToDosroot(file.getPath());
    }

    public static String[] getExecutablesInZipOrIso(String archive) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File arcFile = new File(archive);
        if (archive.toLowerCase().endsWith(ARCHIVES[0])) {
            ZipFile zfile = new ZipFile(arcFile);
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            zfile.close();
        } else if (archive.toLowerCase().endsWith(ARCHIVES[1])) {
            Handler zArchive = new Handler();
            MyRandomAccessFile istream = new MyRandomAccessFile(archive, "r");
            if (zArchive.Open(istream) != 0) {
                throw new IOException(Settings.getInstance().msg("general.error.opensevenzip", new Object[]{archive}));
            }
            for (int i = 0; i < zArchive.size(); ++i) {
                SevenZipEntry entry = zArchive.getEntry(i);
                String name = entry.getName();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            zArchive.close();
        } else if (FileUtils.isIsoFile(archive)) {
            ISO9660FileSystem iso = new ISO9660FileSystem(new File(archive));
            Enumeration<ISO9660FileEntry> entries = iso.getEntries();
            while (entries.hasMoreElements()) {
                ISO9660FileEntry entry = entries.nextElement();
                String name = entry.getPath();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            iso.close();
        }
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String string1, String string2) {
                int count2;
                int count1 = StringUtils.countCharacters(string1, '\\');
                if (count1 == (count2 = StringUtils.countCharacters(string2, '\\'))) {
                    return string1.compareTo(string2);
                }
                return count1 - count2;
            }
        });
        return result.toArray(new String[result.size()]);
    }

    public static void zipEntry(File orgFile, File fileEntry, ZipOutputStream zos) throws IOException {
        ZipEntry anEntry = new ZipEntry(PlatformUtils.toArchivePath(fileEntry, orgFile.isDirectory()));
        anEntry.setTime(orgFile.lastModified());
        if (orgFile.isFile() && !orgFile.canWrite()) {
            anEntry.setExtra(new byte[]{1});
        }
        zos.putNextEntry(anEntry);
        if (orgFile.isFile()) {
            byte[] readBuffer = new byte[10240];
            int bytes = 0;
            FileInputStream is = new FileInputStream(orgFile);
            while ((bytes = is.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytes);
            }
            is.close();
        }
        zos.closeEntry();
    }

    public static void zipDir(File dirToZip, ZipOutputStream zos, File dstDirInZip) throws IOException {
        FileUtils.zipDir(dirToZip, zos, dirToZip, dstDirInZip);
    }

    private static void zipDir(File dirToZip, ZipOutputStream zos, File zipRootDir, File dstDirInZip) throws IOException {
        String[] dirList = dirToZip.list();
        if (dirList == null) {
            throw new IOException(Settings.getInstance().msg("general.error.opendir", new Object[]{dirToZip}));
        }
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(dirToZip, dirList[i]);
            FileUtils.zipEntry(f, new File(dstDirInZip, FileUtils.makeRelativeTo(f, zipRootDir).getPath()), zos);
            if (!f.isDirectory()) continue;
            FileUtils.zipDir(f, zos, zipRootDir, dstDirInZip);
        }
    }

    public static long extractZipSizeInBytes(File archive, File dirToBeExtracted) throws IOException {
        long bytes = 0L;
        ZipFile zf = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!FileUtils.areRelated(dirToBeExtracted, new File(entry.getName()))) continue;
            bytes += entry.getSize();
        }
        zf.close();
        return bytes;
    }

    public static long extractZipEntrySizeInBytes(File archive, String zipEntryToBeExtracted) throws IOException {
        ZipFile zf = new ZipFile(archive);
        ZipEntry entry = zf.getEntry(zipEntryToBeExtracted);
        zf.close();
        if (entry != null) {
            return entry.getSize();
        }
        return 0L;
    }

    public static void extractZip(File archive, File dirToBeExtracted, File dstDir, ProgressNotifyable prog) throws IOException {
        ZipFile zf = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!FileUtils.areRelated(dirToBeExtracted, new File(entry.getName()))) continue;
            File dstFile = FileUtils.canonicalTo(dstDir, FileUtils.strip(new File(entry.getName()), dirToBeExtracted).getPath());
            FileUtils.extractEntry(zf, entry, dstFile, prog);
        }
        zf.close();
    }

    public static void extractZip(File archive, String zipEntryToBeExtracted, File dstFile, ProgressNotifyable prog) throws IOException {
        ZipFile zf = new ZipFile(archive);
        ZipEntry entry = zf.getEntry(zipEntryToBeExtracted);
        if (entry != null) {
            FileUtils.extractEntry(zf, entry, dstFile, prog);
        }
        zf.close();
    }

    private static void extractEntry(ZipFile zf, ZipEntry srcEntry, File dstFile, ProgressNotifyable prog) throws IOException {
        if (dstFile.exists()) {
            throw new IOException(Settings.getInstance().msg("general.error.filetobeextractedexists", new Object[]{dstFile}));
        }
        if (srcEntry.isDirectory()) {
            if (!dstFile.exists()) {
                FileUtils.createDir(dstFile);
            }
        } else {
            int bytesIn;
            if (dstFile.getParentFile() != null) {
                FileUtils.createDir(dstFile.getParentFile());
            }
            FileOutputStream fos = new FileOutputStream(dstFile);
            InputStream is = zf.getInputStream(srcEntry);
            byte[] readBuffer = new byte[10240];
            while ((bytesIn = is.read(readBuffer)) != -1) {
                fos.write(readBuffer, 0, bytesIn);
            }
            fos.flush();
            fos.close();
            is.close();
            byte[] extra = srcEntry.getExtra();
            if (extra != null && extra[0] == 1) {
                dstFile.setReadOnly();
            }
        }
        dstFile.setLastModified(srcEntry.getTime());
        prog.notifyOfProgress(srcEntry.getSize());
    }

    private static File strip(File file, File basePath) {
        if (file.equals(basePath)) {
            return new File(".");
        }
        File remainder = new File(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(basePath)) {
                return remainder;
            }
            remainder = new File(parent.getName(), remainder.getPath());
        }
        return file;
    }

    public static String getUrlFromFile(File file) throws MalformedURLException {
        return file.toURI().toURL().toString();
    }

    public static String fileSystemSafe(String s) {
        return s.replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    public static String fileSystemSafeWebImages(String s) {
        return s.replaceAll(" ", "_").replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    static {
        TEMPLATES_DIR = "templates" + File.separatorChar;
        DOSROOT_DIR = "dosroot" + File.separatorChar;
        CAPTURES_DIR = "captures" + File.separatorChar;
        MAPPER_DIR = "mapper" + File.separatorChar;
        PROFILES_DIR = "profiles" + File.separatorChar;
        EXPORT_DIR = "export" + File.separatorChar;
        XSL_DIR = "xsl" + File.separatorChar;
        CDIMAGES = new String[]{".iso", ".cue", ".bin"};
        EXECUTABLES = new String[]{".exe", ".com", ".bat"};
        ARCHIVES = new String[]{".zip", ".7z"};
        BOOTERIMAGES = new String[]{".cp2", ".dcf", ".img", ".jrc", ".td0"};
        PICTURES = new String[]{".png", ".gif", ".jpg", ".tif", ".tiff", ".ico", ".bmp"};
        Settings settings = Settings.getInstance();
        String DATADIR = FileUtils.getCanonicalPath(settings.getSettings().getValue("directory", "data"));
        DATA_DIR_FILE = new File(DATADIR);
        DOSROOT_DIR_FILE = new File(DATADIR, DOSROOT_DIR);
        String DOSBOXDIR = FileUtils.getCanonicalPath(settings.getSettings().getValue("directory", "dosbox"));
        DOSBOX_DIR_FILE = new File(DOSBOXDIR);
        FileUtils.createDosrootIfNecessary();
    }
}

