/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.StringUtils;
import org.dbgl.util.searchengine.WebSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyGamesSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<div class=\"searchSubSection\"><div>Results";
    private static final String HTML_GAME_TITLE_START = "<div class=\"searchTitle\">";
    private static final String HTML_GAME_END_MARKER = "<br clear=\"all\"></div>";
    private static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";
    private static final int RESULTS_PER_PAGE = 50;

    private MobyGamesSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "moby.png";
    }

    @Override
    public String getName() {
        return "MobyGames";
    }

    @Override
    public String getSimpleName() {
        return "mobygames";
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        int pages = 1;
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = MobyGamesSearchEngine.getResponseContent("http://www.mobygames.com/search/quick?ajax=1&sFilter=1&p=-1&sG=on&q=" + URLEncoder.encode(title.replaceAll("/", " "), "UTF-8") + "&offset=" + pageIdx * 50, "UTF-8");
            if (pageIdx == 0) {
                pages = MobyGamesSearchEngine.getPages(content);
            }
            allEntries.addAll(MobyGamesSearchEngine.extractEntries(content));
        }
        return MobyGamesSearchEngine.filterEntries(platforms, allEntries);
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf(123);
        int j = htmlChunk.indexOf(125, i);
        return StringUtils.countCharacters(htmlChunk.substring(i, j), ',');
    }

    private static List<WebProfile> extractEntries(String html) {
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int gameMatchEntryIndex = (html = html.replaceAll("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex = html.indexOf("<div", gameMatchEntryIndex);
            int gameTitleIdx = html.indexOf(HTML_GAME_TITLE_START, gameMatchEntryIndex);
            String gameTitleData = MobyGamesSearchEngine.extractNextContent(html, gameTitleIdx, "<div", "</div>");
            String gameTitle = MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(gameTitleData)).substring(6);
            String url = MobyGamesSearchEngine.extractNextHrefContent(html, gameTitleIdx);
            String details = MobyGamesSearchEngine.extractNextContent(html, gameTitleIdx + gameTitleData.length(), "<div", "</div>");
            int platformIdx = details.indexOf("<span ");
            while (platformIdx != -1) {
                String platform = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<span ", "</span>");
                if (platform.indexOf("<a ") != -1) {
                    platform = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<a ", "</a>");
                    url = MobyGamesSearchEngine.extractNextHrefContent(details, platformIdx);
                } else {
                    int yrIdx = platform.indexOf(" (");
                    if (yrIdx != -1) {
                        platform = platform.substring(0, yrIdx);
                    }
                }
                url = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, url);
                String year = MobyGamesSearchEngine.extractNextContent(details, platformIdx, "<em>", "</em>");
                WebProfile gameEntry = new WebProfile();
                gameEntry.setTitle(gameTitle);
                gameEntry.setUrl(url);
                gameEntry.setPlatform(platform);
                gameEntry.setPublisherName("");
                gameEntry.setYear(year);
                allEntries.add(gameEntry);
                platformIdx = details.indexOf("<span ", platformIdx + 1);
            }
            int endIdx = html.indexOf(HTML_GAME_END_MARKER, gameTitleIdx);
            gameMatchEntryIndex = html.indexOf("<div", endIdx + HTML_GAME_END_MARKER.length());
        }
        return allEntries;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws UnknownHostException, IOException {
        WebProfile result = new WebProfile();
        result.setTitle(entry.getTitle());
        result.setYear(entry.getYear());
        result.setUrl(entry.getUrl());
        String responseEntry = MobyGamesSearchEngine.getResponseContent(entry.getUrl(), "UTF-8");
        result.setDeveloperName(MobyGamesSearchEngine.extractCategory(responseEntry, ">Developed by</div>"));
        result.setPublisherName(MobyGamesSearchEngine.extractCategory(responseEntry, ">Published by</div>"));
        result.setGenre(MobyGamesSearchEngine.extractCategory(responseEntry, ">Genre</div>"));
        result.setNotes(MobyGamesSearchEngine.extractDescription(responseEntry));
        result.setRank(MobyGamesSearchEngine.extractRank(responseEntry));
        result.setCoreGameCoverUrl(MobyGamesSearchEngine.extractCoreGameCoverUrl(responseEntry));
        return result;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax) throws IOException {
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        if (coverArtMax > 0) {
            result.addAll(this.getEntryCoverArtInformation(entry, coverArtMax));
        }
        if (screenshotsMax > 0) {
            result.addAll(this.getEntryScreenshotInformation(entry, screenshotsMax));
        }
        entry.setWebImages(result.toArray(new SearchEngineImageInformation[0]));
        return entry.getWebImages();
    }

    private static String extractCoreGameCoverUrl(String htmlChunk) {
        String marker = "<div id=\"coreGameCover\">";
        int startIndex = htmlChunk.indexOf(marker) + marker.length();
        return MobyGamesSearchEngine.extractNextHrefContent(htmlChunk, startIndex);
    }

    private static String extractCategory(String htmlChunk, String marker) {
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1) {
            int endIndex = htmlChunk.indexOf("</div>", startIndex + marker.length());
            return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(htmlChunk.substring(startIndex + marker.length(), endIndex + "</div>".length())));
        }
        return "";
    }

    private static String extractDescription(String htmlChunk) {
        String marker = "<h2 class=\"m5\">Description</h2>";
        int startIndex = htmlChunk.indexOf(marker) + marker.length();
        int endIndex = htmlChunk.indexOf("<div", startIndex);
        return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(htmlChunk.substring(startIndex, endIndex)));
    }

    private static Integer extractRank(String htmlChunk) {
        String header = "scoreBoxBig";
        int startIndex = htmlChunk.indexOf(">", htmlChunk.indexOf(header) + header.length()) + 1;
        int endIndex = htmlChunk.indexOf("<", startIndex);
        try {
            return new Integer(htmlChunk.substring(startIndex, endIndex));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile entry, int max) throws IOException {
        String endMarker;
        int endIndex;
        String marker;
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        String htmlChunk = MobyGamesSearchEngine.getResponseContent(entry.getScreenshotsUrl(), "UTF-8");
        int startIndex = htmlChunk.indexOf(marker = "<div class=\"thumbnailContainer\">");
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf(endMarker = "<br class=\"clearBoth\">", startIndex)) != -1) {
            htmlChunk = htmlChunk.substring(startIndex, endIndex);
            startIndex = htmlChunk.indexOf(" src=\"");
            for (int found = 0; found < max && startIndex != -1; ++found) {
                String imgUrl = MobyGamesSearchEngine.extractNextSrcContent(htmlChunk, startIndex);
                imgUrl = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, imgUrl.replaceAll("/images/shots/s/", "/images/shots/l/"));
                String imgDescription = MobyGamesSearchEngine.extractNextContent(htmlChunk, startIndex, "<p ", "</p>").replace("<br>", " ").replace("<br/>", " ");
                result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, imgUrl, imgDescription));
                startIndex = htmlChunk.indexOf(" src=\"", startIndex + 1);
            }
        }
        return result;
    }

    private List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile entry, int max) throws IOException {
        String endMarker;
        int endIndex;
        String marker;
        ArrayList<SearchEngineImageInformation> result = new ArrayList<SearchEngineImageInformation>();
        String htmlChunk = MobyGamesSearchEngine.getResponseContent(entry.getCoverArtUrl(), "UTF-8");
        int startIndex = htmlChunk.indexOf(marker = entry.getCoreGameCoverUrl());
        if (startIndex != -1 && (endIndex = htmlChunk.indexOf(endMarker = "<br class=\"clearBoth\">", startIndex)) != -1) {
            htmlChunk = htmlChunk.substring(startIndex - " href=\"".length(), endIndex);
            startIndex = htmlChunk.indexOf(" src=\"");
            for (int found = 0; found < max && startIndex != -1; ++found) {
                String imgUrl = MobyGamesSearchEngine.extractNextSrcContent(htmlChunk, startIndex);
                imgUrl = MobyGamesSearchEngine.absoluteUrl(MOBY_GAMES_HOST_NAME, imgUrl.replaceAll("/images/covers/small/", "/images/covers/large/"));
                String imgDescription = MobyGamesSearchEngine.extractNextContent(htmlChunk, startIndex, "<p ", "</p>").replace("<br>", " ").replace("<br/>", " ");
                result.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.CoverArt, imgUrl, imgDescription));
                startIndex = htmlChunk.indexOf(" src=\"", startIndex + 1);
            }
        }
        return result;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new MobyGamesSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

