/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.graphics.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PouetSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<tr bgcolor=\"#557799\"><td nowrap><table cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
    private static final String HTML_NEXT_RESULT_MARKER_START = "<td nowrap><table cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap>";
    private static final String HTML_GAME_END_MARKER = "     </tr>";
    private static final String HOST_NAME = "pouet.net";

    private PouetSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "pouet.png";
    }

    @Override
    public String getName() {
        return "Pou\u00ebt.net";
    }

    @Override
    public String getSimpleName() {
        return "pouet";
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        int pages = 1;
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = PouetSearchEngine.getResponseContent("http://pouet.net/search.php?type=prod&what=" + URLEncoder.encode(title.replaceAll("/", " "), "ISO-8859-1") + "&page=" + (pageIdx + 1), "ISO-8859-1");
            if (pageIdx == 0) {
                pages = PouetSearchEngine.getPages(content);
            }
            allEntries.addAll(PouetSearchEngine.extractEntries(content));
        }
        return PouetSearchEngine.filterEntries(platforms, allEntries);
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf("<select name=\"page\">");
        if (i != -1) {
            int j = htmlChunk.indexOf("<b>", i);
            int k = htmlChunk.indexOf(32, j);
            int l = htmlChunk.indexOf("</b>", k);
            return Integer.parseInt(htmlChunk.substring(k + 1, l));
        }
        return 0;
    }

    private static List<WebProfile> extractEntries(String html) {
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int gameMatchEntryIndex = (html = html.replaceAll("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (gameMatchEntryIndex != -1) {
            String category = "";
            String imgTypeData = PouetSearchEngine.extractNextContent(html, gameMatchEntryIndex, "<a ", "</a>");
            int typeTitle1 = imgTypeData.indexOf("title=\"");
            int typeTitle2 = imgTypeData.indexOf("\"", typeTitle1 + 7);
            if (typeTitle1 != -1 && typeTitle2 != -1) {
                category = imgTypeData.substring(typeTitle1 + 7, typeTitle2);
            }
            category = StringUtils.capitalize(category);
            int startGameTitleIdx = gameMatchEntryIndex = html.indexOf("<td nowrap>", gameMatchEntryIndex);
            int gameTitleIdx = gameMatchEntryIndex;
            String gameTitleData = PouetSearchEngine.extractNextContent(html, gameTitleIdx, "<a ", "</a>");
            String gameTitle = PouetSearchEngine.unescapeHtml(PouetSearchEngine.removeAllTags(gameTitleData));
            gameTitle = StringUtils.capitalize(gameTitle);
            String url = PouetSearchEngine.extractNextHrefContent(html, gameTitleIdx);
            url = PouetSearchEngine.absoluteUrl(HOST_NAME, url);
            int endGameTitleIdx = html.indexOf("</table></td>", gameTitleIdx);
            gameTitleIdx = html.indexOf("<td>", endGameTitleIdx);
            String developerName = PouetSearchEngine.extractNextContent(html, gameTitleIdx + 4, "<a ", "</a>");
            developerName = StringUtils.capitalize(developerName);
            gameTitleIdx = html.indexOf("</td>", gameTitleIdx);
            gameTitleIdx = html.indexOf("</td>", gameTitleIdx);
            String year = PouetSearchEngine.extractNextContent(html, (gameTitleIdx = html.indexOf("<td>", gameTitleIdx)) + 4, "<td>", "</td>");
            if (year.endsWith("<br />")) {
                year = year.substring(0, year.length() - 6);
            }
            year = year.indexOf(32) != -1 ? year.substring(year.indexOf(32) + 1) : "";
            gameTitleIdx = html.indexOf("</td>", gameTitleIdx);
            gameTitleIdx = html.indexOf("<table cellspacing=\"0\" cellpadding=\"0\"><tr><td>&nbsp;</td>", gameTitleIdx);
            int rank = 0;
            try {
                String score = PouetSearchEngine.extractNextContent(html, gameTitleIdx + 58, "<td>", "</td>");
                rank = (int)((Double.parseDouble(score) + 1.0) * 50.0);
            }
            catch (Exception e) {
                // empty catch block
            }
            String details = html.substring(startGameTitleIdx, endGameTitleIdx);
            int platformIdx = details.indexOf("<td align=\"right\">");
            while (platformIdx != -1) {
                String platform = "";
                String imgPlatformData = PouetSearchEngine.extractNextContent(details, platformIdx, "<a ", "</a>");
                int platformTitle1 = imgPlatformData.indexOf("title=\"");
                int platformTitle2 = imgPlatformData.indexOf("\"", platformTitle1 + 7);
                if (platformTitle1 != -1 && platformTitle2 != -1) {
                    platform = imgPlatformData.substring(platformTitle1 + 7, platformTitle2);
                }
                WebProfile gameEntry = new WebProfile();
                gameEntry.setTitle(gameTitle);
                gameEntry.setUrl(url);
                gameEntry.setPlatform(platform);
                gameEntry.setPublisherName("");
                gameEntry.setDeveloperName(developerName);
                gameEntry.setYear(year);
                gameEntry.setGenre(category);
                gameEntry.setRank(rank);
                gameEntry.setNotes("");
                allEntries.add(gameEntry);
                platformIdx = details.indexOf("<td align=\"right\">", platformIdx + 1);
            }
            int endIdx = html.indexOf(HTML_GAME_END_MARKER, gameTitleIdx);
            gameMatchEntryIndex = html.indexOf(HTML_NEXT_RESULT_MARKER_START, endIdx + HTML_GAME_END_MARKER.length());
            if (gameMatchEntryIndex == -1) continue;
            gameMatchEntryIndex += HTML_NEXT_RESULT_MARKER_START.length();
        }
        return allEntries;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws UnknownHostException, IOException {
        return entry;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax) throws IOException {
        String html = PouetSearchEngine.getResponseContent(entry.getUrl(), "ISO-8859-1");
        int imgMatchEntryIndex = html.indexOf("<img src=\"screenshots/");
        if (imgMatchEntryIndex == -1) {
            entry.setWebImages(new SearchEngineImageInformation[0]);
        } else {
            String imgUrl = PouetSearchEngine.absoluteUrl(HOST_NAME, PouetSearchEngine.extractNextSrcContent(html, imgMatchEntryIndex));
            String imgDescription = this.getSimpleName();
            if (imgUrl.toLowerCase().endsWith(".gif")) {
                ImageData[] images = SWTImageManager.getAnimatedImageData(imgUrl);
                SearchEngineImageInformation[] result = new SearchEngineImageInformation[images.length];
                for (int i = 0; i < images.length; ++i) {
                    result[i] = new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, imgUrl, imgDescription);
                    result[i].setData(images[i]);
                }
                entry.setWebImages(result);
            } else {
                entry.setWebImages(new SearchEngineImageInformation[]{new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, imgUrl, imgDescription)});
            }
        }
        return entry.getWebImages();
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new PouetSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

