/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchEngineThread
extends Thread {
    private WebSearchEngine engine;
    private List<Configurable> profiles;
    private String title;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private final Display display;
    private final String lineDelimiter;

    public SearchEngineThread(WebSearchEngine engine, List<Configurable> profs, Text log, ProgressBar progressBar, Label profileLabel) {
        this.engine = engine;
        this.profiles = profs;
        this.log = log;
        this.lineDelimiter = log.getLineDelimiter();
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database dbase = Database.getInstance();
        Settings settings = Settings.getInstance();
        final StringBuffer displayedLog = new StringBuffer();
        final StringBuffer messageLog = new StringBuffer();
        while (true) {
            block21: {
                try {
                    ExpProfile prof;
                    List<Configurable> list = this.profiles;
                    synchronized (list) {
                        prof = (ExpProfile)this.profiles.remove(0);
                    }
                    this.title = prof.getTitle();
                    try {
                        int firstMatch;
                        List<WebProfile> webGamesList = this.engine.getEntries(this.title, settings.getSettings().getValues(this.engine.getSimpleName(), "platform_filter"));
                        if (webGamesList.size() > 1 && (firstMatch = WebSearchEngine.getEntryFirstMatchIndex(this.title, webGamesList)) != -1) {
                            webGamesList = webGamesList.subList(firstMatch, firstMatch + 1);
                        }
                        if (webGamesList.size() == 1) {
                            WebProfile thisGame = this.engine.getEntryDetailedInformation(webGamesList.get(0));
                            SearchEngineThread searchEngineThread = this;
                            synchronized (searchEngineThread) {
                                String title = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_title") ? thisGame.getTitle() : prof.getTitle();
                                String dev = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_developer") ? thisGame.getDeveloperName() : prof.getDeveloperName();
                                String publ = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_publisher") ? thisGame.getPublisherName() : prof.getPublisherName();
                                String year = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_year") ? thisGame.getYear() : prof.getYear();
                                String genre = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_genre") ? thisGame.getGenre() : prof.getGenre();
                                String link1 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_link") ? thisGame.getUrl() : prof.getLink(0);
                                String[] links = new String[]{link1, prof.getLink(1), prof.getLink(2), prof.getLink(3), prof.getLink(4), prof.getLink(5), prof.getLink(6), prof.getLink(7)};
                                String linkTitle1 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_link") ? settings.msg("dialog.profile.searchengine.link.maininfo", new String[]{this.engine.getName()}) : prof.getLinkTitle(0);
                                String[] linkTitles = new String[]{linkTitle1, prof.getLinkTitle(1), prof.getLinkTitle(2), prof.getLinkTitle(3), prof.getLinkTitle(4), prof.getLinkTitle(5), prof.getLinkTitle(6), prof.getLinkTitle(7)};
                                StringBuffer notes = new StringBuffer(prof.getNotes());
                                String p = thisGame.getNotes().replaceAll("\n", this.lineDelimiter);
                                if (settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_description") && !prof.getNotes().endsWith(p)) {
                                    if (notes.length() > 0) {
                                        notes.append(this.lineDelimiter + this.lineDelimiter);
                                    }
                                    notes.append(p);
                                }
                                int rank = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_rank") ? thisGame.getRank() : prof.getCustomInt(0);
                                int[] customInts = new int[]{rank, prof.getCustomInt(1)};
                                dbase.addOrEditProfile(title, dev, publ, genre, year, prof.getStatus(), notes.toString(), prof.isDefault(), prof.getSetup(), prof.getSetupParameters(), prof.getDbversionId(), links, linkTitles, prof.getCustomStrings(), customInts, prof.getId());
                            }
                            SearchEngineImageInformation[] imageInformation = this.engine.getEntryImages(thisGame, settings.getSettings().getIntValue(this.engine.getSimpleName(), "multi_max_coverart"), settings.getSettings().getIntValue(this.engine.getSimpleName(), "multi_max_screenshot"));
                            for (int i = 0; i < imageInformation.length; ++i) {
                                File file;
                                String filename;
                                String description = FileUtils.fileSystemSafeWebImages(imageInformation[i].description);
                                if (imageInformation[i].type == SearchEngineImageInformation.SearchEngineImageType.CoverArt) {
                                    filename = settings.msg("dialog.profile.mobygames.coverartfilename", new Object[]{i, description});
                                    file = new File(prof.getCanonicalCaptures(), filename + ".jpg");
                                } else {
                                    filename = settings.msg("dialog.profile.mobygames.screenshotfilename", new Object[]{i, description});
                                    file = new File(prof.getCanonicalCaptures(), filename + ".png");
                                }
                                if (!FileUtils.isExistingFile(file)) {
                                    SWTImageManager.save(thisGame.getWebImage(i), file.getPath());
                                    continue;
                                }
                                messageLog.append(this.title).append(": ").append(settings.msg("dialog.profile.error.imagealreadyexists", new String[]{file.getPath(), this.engine.getName()})).append('\n');
                            }
                            break block21;
                        }
                        if (webGamesList.size() == 0) {
                            messageLog.append(this.title).append(": ").append(settings.msg("general.notice.searchenginenoresults", new String[]{this.engine.getName(), this.title})).append('\n');
                            break block21;
                        }
                        messageLog.append(this.title).append(": ").append(settings.msg("dialog.multiprofile.notice.titlenotunique", new String[]{this.engine.getName(), this.title})).append('\n');
                    }
                    catch (SQLException e) {
                        messageLog.append(StringUtils.toString(e)).append('\n');
                    }
                }
                catch (IOException e) {
                    messageLog.append(this.title).append(": ").append(settings.msg("general.error.retrieveinfosearchengine", new String[]{this.engine.getName(), this.title, e.toString()})).append('\n');
                }
                catch (IndexOutOfBoundsException iobe) {
                    return;
                }
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    SearchEngineThread.this.profileLabel.setText(Settings.getInstance().msg("dialog.multiprofile.updating", new Object[]{SearchEngineThread.this.title}));
                    SearchEngineThread.this.profileLabel.pack();
                    if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        SearchEngineThread.this.log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
                    SearchEngineThread.this.progressBar.setSelection(SearchEngineThread.this.progressBar.getSelection() + 1);
                }
            });
        }
    }
}

