/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.dbgl.model.conf.Settings;
import org.dbgl.util.ProgressNotifyable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public final class ProgressDialog
extends Dialog
implements ProgressNotifyable {
    private Shell shell;
    private String title;
    private Thread thread;
    private ProgressBar progressBar;
    private Display display;

    public ProgressDialog(Shell parent, String title) {
        super(parent, 0);
        this.title = title;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        this.display = this.getParent().getDisplay();
        this.thread.start();
        while (!this.shell.isDisposed() && this.thread.isAlive()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.shell.close();
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setSize(400, 100);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setText(this.title);
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        progressGroup.setText(Settings.getInstance().msg("dialog.migration.progress"));
        progressGroup.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)progressGroup, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void setTotal(final int total) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ProgressDialog.this.progressBar.setMaximum(total);
                }
            });
        }
    }

    public void incrProgress(final int progress) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ProgressDialog.this.progressBar.setSelection(ProgressDialog.this.progressBar.getSelection() + progress);
                }
            });
        }
    }

    public void setProgress(final int progress) {
        if (!this.display.isDisposed() && !this.progressBar.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    ProgressDialog.this.progressBar.setSelection(progress);
                }
            });
        }
    }
}

