/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.DFendImportThread;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.SevenzipExtractFilesCallback;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportThread
extends UIThread {
    private boolean importCaptures;
    private boolean importMapperfiles;
    private boolean importGameData;
    private boolean importFullSettings;
    private boolean customValues;
    private String[] customFields;
    private boolean useExistingConf;
    private File zipfile;
    private boolean sevenzip;
    private int[] entryIdsToBeExtracted;
    private Map<Integer, File> sevenzipDstFileMap = new TreeMap<Integer, File>();
    private IInArchive zArchive;

    public ImportThread(Text log, ProgressBar progressBar, Label status, List<ExpProfile> profs, File zipfile, boolean captures, boolean mapperfiles, boolean useExistingConf, boolean gamedata, boolean fullSettings, boolean customValues, String[] customFields) throws IOException, SQLException {
        super(log, progressBar, status);
        this.zipfile = zipfile;
        this.importCaptures = captures;
        this.importMapperfiles = mapperfiles;
        this.useExistingConf = useExistingConf;
        this.importGameData = gamedata;
        this.importFullSettings = fullSettings;
        this.customValues = customValues;
        this.customFields = customFields != null ? (String[])customFields.clone() : null;
        this.sevenzip = zipfile.getPath().toLowerCase().endsWith(FileUtils.ARCHIVES[1]);
        long bytes = 0L;
        if (this.sevenzip) {
            MyRandomAccessFile istream = new MyRandomAccessFile(zipfile.getPath(), "r");
            this.zArchive = new Handler();
            if (this.zArchive.Open(istream) != 0) {
                throw new IOException(this.settings.msg("general.error.opensevenzip", new Object[]{zipfile.getPath()}));
            }
            for (int i = 0; i < this.zArchive.size(); ++i) {
                bytes += this.zArchive.getEntry(i).getSize();
            }
        } else {
            for (ExpProfile ep : profs) {
                if (this.importCaptures) {
                    bytes += FileUtils.extractZipSizeInBytes(zipfile, new File(ep.getCaptures()));
                }
                if (this.importMapperfiles && ep.getMapperfile() != null) {
                    bytes += FileUtils.extractZipEntrySizeInBytes(zipfile, PlatformUtils.toArchivePath(ep.getMapperfile()));
                }
                if (!this.importGameData) continue;
                bytes += FileUtils.extractZipSizeInBytes(zipfile, new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(ep.getImportedId()), ep.getGameDir().getPath()).getPath()));
            }
        }
        this.objects = profs;
        this.setTotal((int)(bytes / 1024L));
        this.extensiveLogging = true;
    }

    @Override
    public void doFancyStuff(Object obj, StringBuffer messageLog) throws IOException, SQLException {
        ExpProfile prof = (ExpProfile)obj;
        this.displayTitle(this.settings.msg("dialog.import.importing", new Object[]{prof.getTitle()}));
        int devId = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), prof.getDeveloperName());
        int publId = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), prof.getPublisherName());
        int genId = KeyValuePair.findIdByValue(this.dbase.readGenresList(), prof.getGenre());
        int yrId = KeyValuePair.findIdByValue(this.dbase.readYearsList(), prof.getYear());
        int statId = KeyValuePair.findIdByValue(this.dbase.readStatusList(), prof.getStatus());
        String[] customStrings = DFendImportThread.CUST_STRINGS;
        int[] customInts = DFendImportThread.CUST_INTS;
        int[] custIDs = DFendImportThread.CUST_IDS;
        if (this.customValues) {
            customStrings = prof.getCustomStrings();
            customInts = prof.getCustomInts();
            for (int i = 0; i < 4; ++i) {
                custIDs[i] = KeyValuePair.findIdByValue(this.dbase.readCustomList(i), prof.getCustomString(i));
            }
        }
        int profileId = this.dbase.addOrEditProfile(prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getStatus(), prof.getNotes(), prof.isDefault(), prof.getSetup(), prof.getSetupParameters(), devId, publId, genId, yrId, statId, prof.getDbversionId(), prof.getLinks(), prof.getLinkTitles(), customStrings, customInts, custIDs, -1);
        String newCapturesString = FileUtils.constructCapturesDir(profileId);
        File relativeCapturesDirInZip = new File(prof.getCaptures());
        File canonicalCapturesDir = FileUtils.canonicalToData(newCapturesString);
        if (!canonicalCapturesDir.exists()) {
            FileUtils.createDir(canonicalCapturesDir);
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{canonicalCapturesDir})).append('\n');
            if (this.importCaptures) {
                if (this.sevenzip) {
                    for (int i : FileUtils.findRelatedEntryIds(this.zArchive, relativeCapturesDirInZip)) {
                        this.sevenzipDstFileMap.put(i, FileUtils.determineDstSevenzipFile(relativeCapturesDirInZip, canonicalCapturesDir, this.zArchive.getEntry(i).getName()));
                    }
                } else {
                    try {
                        FileUtils.extractZip(this.zipfile, relativeCapturesDirInZip, canonicalCapturesDir, (ProgressNotifyable)this);
                        messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.extractedcaptures", new Object[]{canonicalCapturesDir})).append('\n');
                    }
                    catch (IOException e) {
                        messageLog.append("  - ").append(this.settings.msg("dialog.import.error.capturesextraction", new Object[]{StringRelatedUtils.toString(e)})).append('\n');
                    }
                }
            }
        } else {
            messageLog.append("  - ").append(this.settings.msg("dialog.import.error.capturesdirexists", new Object[]{canonicalCapturesDir})).append('\n');
        }
        File relativeGameDir = prof.getGameDir();
        File relativeGameDirInZip = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(prof.getImportedId()), relativeGameDir.getPath()).getPath());
        File canonicalGameDir = FileUtils.canonicalToDosroot(new File(prof.getBaseDir(), prof.getGameDir().getPath()).getPath());
        if (this.importGameData && !canonicalGameDir.exists()) {
            FileUtils.createDir(canonicalGameDir);
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{canonicalGameDir})).append('\n');
            if (this.sevenzip) {
                for (int i : FileUtils.findRelatedEntryIds(this.zArchive, relativeGameDirInZip)) {
                    this.sevenzipDstFileMap.put(i, FileUtils.determineDstSevenzipFile(relativeGameDirInZip, canonicalGameDir, this.zArchive.getEntry(i).getName()));
                }
            } else {
                try {
                    FileUtils.extractZip(this.zipfile, relativeGameDirInZip, canonicalGameDir, (ProgressNotifyable)this);
                    messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.extractedgamedata", new Object[]{canonicalGameDir})).append('\n');
                }
                catch (IOException e) {
                    throw new IOException(this.settings.msg("dialog.import.error.gamedataextraction", new Object[]{StringRelatedUtils.toString(e)}), e);
                }
            }
        }
        DosboxVersion assocDBVersion = (DosboxVersion)DosboxVersion.findById(this.dbversions, prof.getDbversionId());
        String newConfString = null;
        if (this.useExistingConf && FileUtils.areRelated(new File(FileUtils.getDosRoot()), prof.getCanonicalConfFile()) && FileUtils.isExistingFile(prof.getCanonicalConfFile())) {
            newConfString = prof.getCanonicalConfFile().getPath();
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.usingexistingconf", new Object[]{prof.getCanonicalConfFile()})).append('\n');
        } else {
            Conf gameConf = new Conf(prof.getImportedFullConfig(), prof.getImportedIncrConfig(), this.importFullSettings, this.zipfile.getPath(), prof, profileId, assocDBVersion, this.ps);
            newConfString = FileUtils.makeRelativeToData(gameConf.getConfFile()).getPath();
            Profile newProfile = new Profile(profileId, newConfString, newCapturesString, prof);
            if (!newProfile.getCanonicalConfFile().getParentFile().exists()) {
                FileUtils.createDir(newProfile.getCanonicalConfFile().getParentFile());
                messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{newProfile.getCanonicalConfFile().getParentFile()})).append('\n');
            }
            String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
            gameConf.getSettings().setValue("dosbox", "captures", dstCapRelative);
            String mapperfileEntry = prof.getMapperfile();
            if (this.importMapperfiles && mapperfileEntry != null) {
                File dstFile = new File(StringUtils.replace((String)newProfile.getCanonicalConfFile().getPath(), (String)".conf", (String)".map"));
                gameConf.getSettings().setValue("sdl", "mapperfile", dstFile.getName());
                if (this.sevenzip) {
                    int i = FileUtils.findEntryId(this.zArchive, PlatformUtils.toArchivePath(mapperfileEntry));
                    if (i != -1) {
                        this.sevenzipDstFileMap.put(i, dstFile);
                    }
                } else {
                    try {
                        FileUtils.extractZip(this.zipfile, PlatformUtils.toArchivePath(mapperfileEntry), dstFile, (ProgressNotifyable)this);
                        messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.extractedmapperfile", new Object[]{dstFile})).append('\n');
                    }
                    catch (IOException e) {
                        messageLog.append("  - ").append(this.settings.msg("dialog.import.error.mapperfileextraction", new Object[]{StringRelatedUtils.toString(e)})).append('\n');
                    }
                }
            }
            gameConf.save();
            messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createdconf", new Object[]{newProfile.getCanonicalConfFile()}));
        }
        this.dbase.updateProfileConf(newConfString, newCapturesString, profileId);
        String[] setup = prof.getSetup();
        for (int i = 0; i < setup.length; ++i) {
            if (setup[i].length() <= 0) continue;
            setup[i] = FileUtils.prefixAndSanitizeToDosroot(prof.getBaseDir(), new File(setup[i])).getPath();
        }
        String[] links = prof.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (links[i].equals("") || links[i].contains("://")) continue;
            links[i] = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(links[i])).getPath();
            links[i] = FileUtils.prefixAndSanitizeToDosroot(prof.getBaseDir(), new File(links[i])).getPath();
            if (prof.getBaseDir().isAbsolute()) continue;
            links[i] = FileUtils.DOSROOT_DIR + links[i];
        }
        this.dbase.updateProfileSetupAndLinks(setup, links, profileId);
        messageLog.append("  + ").append(this.settings.msg("dialog.import.notice.createddbentry", new Object[]{profileId, newConfString, newCapturesString, assocDBVersion.getTitle()})).append('\n');
    }

    @Override
    public String getTitle(Object o) {
        return ((ExpProfile)o).getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        if (this.customFields != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.customFields[i].equalsIgnoreCase("Custom" + (i + 1))) continue;
                this.settings.getSettings().setValue("gui", "custom" + (i + 1), this.customFields[i]);
            }
        }
        if (this.sevenzip) {
            this.entryIdsToBeExtracted = ArrayUtils.toPrimitive((Integer[])this.sevenzipDstFileMap.keySet().toArray(new Integer[0]));
            SevenzipExtractFilesCallback extractCallback = new SevenzipExtractFilesCallback(this, this.zArchive, this.sevenzipDstFileMap);
            this.zArchive.Extract(this.entryIdsToBeExtracted, this.entryIdsToBeExtracted.length, 0, extractCallback);
            for (int i = 0; i < this.entryIdsToBeExtracted.length; ++i) {
                int id = this.entryIdsToBeExtracted[i];
                FileUtils.fileSetLastModified(this.sevenzipDstFileMap.get(id), this.zArchive.getEntry(id).getTime());
            }
            this.zArchive.close();
        }
    }

    public String[] getCustomFields() {
        return this.customFields != null ? (String[])this.customFields.clone() : null;
    }
}

