/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.waldheinz.fs.fat.FatDirectoryEntry;

public abstract class AbstractDirectory {
    public static final int MAX_LABEL_LENGTH = 11;
    private final List<FatDirectoryEntry> entries = new ArrayList<FatDirectoryEntry>();
    private final boolean isRoot;
    private int capacity;

    protected AbstractDirectory(int capacity, boolean isRoot) {
        this.capacity = capacity;
        this.isRoot = isRoot;
    }

    protected abstract void read(ByteBuffer var1) throws IOException;

    public final FatDirectoryEntry getEntry(int idx) {
        return this.entries.get(idx);
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public final void read() throws IOException {
        FatDirectoryEntry e;
        ByteBuffer data = ByteBuffer.allocate(this.capacity * 32);
        this.read(data);
        data.flip();
        for (int i = 0; i < this.capacity && (e = FatDirectoryEntry.read(data)) != null; ++i) {
            if (e.isVolumeLabel()) {
                if (this.isRoot) continue;
                throw new IOException("volume label in non-root directory");
            }
            this.entries.add(e);
        }
    }
}

