/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.Fat;

final class ClusterChain {
    protected final Fat fat;
    private final BlockDevice device;
    private final int clusterSize;
    protected final long dataOffset;
    private long startCluster;

    public ClusterChain(Fat fat, long startCluster) {
        this.fat = fat;
        if (startCluster != 0L) {
            this.fat.testCluster(startCluster);
            if (this.fat.isFreeCluster(startCluster)) {
                throw new IllegalArgumentException("cluster " + startCluster + " is free");
            }
        }
        this.device = fat.getDevice();
        this.dataOffset = fat.getBootSector().getFilesOffset();
        this.startCluster = startCluster;
        this.clusterSize = fat.getBootSector().getBytesPerCluster();
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public Fat getFat() {
        return this.fat;
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    public long getStartCluster() {
        return this.startCluster;
    }

    private long getDevOffset(long cluster, int clusterOffset) {
        return this.dataOffset + (long)clusterOffset + (cluster - 2L) * (long)this.clusterSize;
    }

    public long getLengthOnDisk() {
        if (this.getStartCluster() == 0L) {
            return 0L;
        }
        return this.getChainLength() * this.clusterSize;
    }

    public int getChainLength() {
        if (this.getStartCluster() == 0L) {
            return 0;
        }
        long[] chain = this.getFat().getChain(this.getStartCluster());
        return chain.length;
    }

    public void readData(long offset, ByteBuffer dest) throws IOException {
        int len = dest.remaining();
        if (this.startCluster == 0L && len > 0) {
            throw new EOFException();
        }
        long[] chain = this.getFat().getChain(this.startCluster);
        BlockDevice dev = this.getDevice();
        int chainIdx = (int)(offset / (long)this.clusterSize);
        if (offset % (long)this.clusterSize != 0L) {
            int clusOfs = (int)(offset % (long)this.clusterSize);
            int size = Math.min(len, (int)((long)this.clusterSize - offset % (long)this.clusterSize - 1L));
            dest.limit(dest.position() + size);
            dev.read(this.getDevOffset(chain[chainIdx], clusOfs), dest);
            len -= size;
            ++chainIdx;
        }
        while (len > 0) {
            int size = Math.min(this.clusterSize, len);
            dest.limit(dest.position() + size);
            dev.read(this.getDevOffset(chain[chainIdx], 0), dest);
            len -= size;
            ++chainIdx;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterChain)) {
            return false;
        }
        ClusterChain other = (ClusterChain)obj;
        if (!(this.fat == other.fat || this.fat != null && this.fat.equals(other.fat))) {
            return false;
        }
        return this.startCluster == other.startCluster;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.fat != null ? this.fat.hashCode() : 0);
        hash = 79 * hash + (int)(this.startCluster ^ this.startCluster >>> 32);
        return hash;
    }
}

