/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import org.dbgl.waldheinz.fs.fat.AbstractDirectory;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.BootSector;
import org.dbgl.waldheinz.fs.fat.ClusterChain;
import org.dbgl.waldheinz.fs.fat.ClusterChainDirectory;
import org.dbgl.waldheinz.fs.fat.Fat;
import org.dbgl.waldheinz.fs.fat.Fat16BootSector;
import org.dbgl.waldheinz.fs.fat.Fat16RootDirectory;
import org.dbgl.waldheinz.fs.fat.Fat32BootSector;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectory;
import org.dbgl.waldheinz.fs.fat.FatType;

public final class FatFileSystem {
    private final Fat fat;
    private final BootSector bs;
    private final FatLfnDirectory rootDir;
    private final AbstractDirectory rootDirStore;
    private final FatType fatType;

    public FatFileSystem(BlockDevice device) throws IOException {
        this.bs = BootSector.read(device);
        if (this.bs.getNrFats() <= 0) {
            throw new IOException("boot sector says there are no FATs");
        }
        this.fatType = this.bs.getFatType();
        this.fat = Fat.read(this.bs, 0);
        for (int i = 1; i < this.bs.getNrFats(); ++i) {
            Fat tmpFat = Fat.read(this.bs, i);
            if (this.fat.equals(tmpFat)) continue;
            throw new IOException("FAT " + i + " differs from FAT 0");
        }
        if (this.fatType == FatType.FAT32) {
            Fat32BootSector f32bs = (Fat32BootSector)this.bs;
            ClusterChain rootDirFile = new ClusterChain(this.fat, f32bs.getRootDirFirstCluster());
            this.rootDirStore = ClusterChainDirectory.readRoot(rootDirFile);
        } else {
            this.rootDirStore = Fat16RootDirectory.read((Fat16BootSector)this.bs);
        }
        this.rootDir = new FatLfnDirectory(this.rootDirStore, this.fat);
    }

    public FatLfnDirectory getRoot() {
        return this.rootDir;
    }
}

