/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dbgl.waldheinz.fs.fat.AbstractDirectory;
import org.dbgl.waldheinz.fs.fat.ClusterChain;
import org.dbgl.waldheinz.fs.fat.ClusterChainDirectory;
import org.dbgl.waldheinz.fs.fat.Fat;
import org.dbgl.waldheinz.fs.fat.FatDirectoryEntry;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectoryEntry;
import org.dbgl.waldheinz.fs.fat.ShortName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FatLfnDirectory {
    private final Set<String> usedNames;
    private final Fat fat;
    private final Map<ShortName, FatLfnDirectoryEntry> shortNameIndex;
    private final Map<String, FatLfnDirectoryEntry> longNameIndex;
    private final Map<FatDirectoryEntry, FatLfnDirectory> entryToDirectory;
    final AbstractDirectory dir;

    FatLfnDirectory(AbstractDirectory dir, Fat fat) throws IOException {
        if (dir == null || fat == null) {
            throw new NullPointerException();
        }
        this.fat = fat;
        this.dir = dir;
        this.shortNameIndex = new LinkedHashMap<ShortName, FatLfnDirectoryEntry>();
        this.longNameIndex = new LinkedHashMap<String, FatLfnDirectoryEntry>();
        this.entryToDirectory = new LinkedHashMap<FatDirectoryEntry, FatLfnDirectory>();
        this.usedNames = new HashSet<String>();
        this.parseLfn();
    }

    FatLfnDirectory getDirectory(FatDirectoryEntry entry) throws IOException {
        FatLfnDirectory result = this.entryToDirectory.get(entry);
        if (result == null) {
            ClusterChainDirectory storage = FatLfnDirectory.read(entry, this.fat);
            result = new FatLfnDirectory(storage, this.fat);
            this.entryToDirectory.put(entry, result);
        }
        return result;
    }

    private void checkUniqueName(String name) throws IOException {
        String lowerName = name.toLowerCase();
        if (!this.usedNames.add(lowerName)) {
            throw new IOException("an entry named " + name + " already exists");
        }
    }

    private void parseLfn() throws IOException {
        int i = 0;
        int size = this.dir.getEntryCount();
        while (i < size) {
            while (i < size && this.dir.getEntry(i) == null) {
                ++i;
            }
            if (i >= size) break;
            int offset = i;
            while (this.dir.getEntry(i).isLfnEntry() && ++i < size) {
            }
            if (i >= size) break;
            FatLfnDirectoryEntry current = FatLfnDirectoryEntry.extract(this, offset, ++i - offset);
            if (current.realEntry.isDeleted()) continue;
            this.checkUniqueName(current.getName());
            this.shortNameIndex.put(current.realEntry.getShortName(), current);
            this.longNameIndex.put(current.getName().toLowerCase(), current);
        }
    }

    public Iterator<FatLfnDirectoryEntry> iterator() {
        return new Iterator<FatLfnDirectoryEntry>(){
            final Iterator<FatLfnDirectoryEntry> it;
            {
                this.it = FatLfnDirectory.this.shortNameIndex.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public FatLfnDirectoryEntry next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [size=" + this.shortNameIndex.size() + ", dir=" + this.dir + "]";
    }

    private static ClusterChainDirectory read(FatDirectoryEntry entry, Fat fat) throws IOException {
        if (!entry.isDirectory()) {
            throw new IllegalArgumentException(entry + " is no directory");
        }
        ClusterChain chain = new ClusterChain(fat, entry.getStartCluster());
        ClusterChainDirectory result = new ClusterChainDirectory(chain, false);
        result.read();
        return result;
    }
}

