/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.BrowseSearchEngineDialog;
import org.dbgl.gui.EditMountDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.Wizard;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Mount;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.HotudSearchEngine;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class AddGameWizardDialog
extends Wizard {
    static final List<WebSearchEngine> webSearchEngines = Arrays.asList(MobyGamesSearchEngine.getInstance(), PouetSearchEngine.getInstance(), HotudSearchEngine.getInstance());
    private static final String[] CUST_STRINGS = new String[]{"", "", "", "", "", "", "", ""};
    private Text title;
    private String developer;
    private String publisher;
    private String year;
    private String genre;
    private String notes;
    private String[] link = new String[]{"", "", "", "", "", "", "", ""};
    private String[] linkTitle = new String[]{"", "", "", "", "", "", "", ""};
    private final int[] customInts = new int[]{0, 0};
    private Button doSearch;
    private Button moveImages;
    private Button templateReload;
    private ToolItem engineSelector;
    private Button btnPreinstalledGame;
    private Button btnGameNeedsToBeInstalled;
    private Button btnInstallManual;
    private Button btnPatchManual;
    private Combo main;
    private Combo setup;
    private Text mainText;
    private Text setupText;
    private Text installExe;
    private Text installParameters;
    private Text patchExe;
    private Text patchParameters;
    private Text dstDirectory;
    private Text imagesDstDirectory;
    private org.eclipse.swt.widgets.List mountingpoints;
    private File[] installedFiles;
    private List<File> orgImages;
    private org.eclipse.swt.widgets.List installedFilesList;
    private org.eclipse.swt.widgets.List orgImagesList;
    private Combo template;
    private Combo machine;
    private Combo core;
    private Combo cycles;
    private Database dbase;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private ExpProfile profile;
    private int templateIndex = -1;

    public AddGameWizardDialog(Shell parent, int style) {
        super(parent, style, Settings.getInstance().msg("dialog.addgamewizard.title"), "addgamewizard", false);
    }

    protected boolean init() {
        this.dbase = Database.getInstance();
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            DosboxVersion dbversion = DosboxVersion.findDefault(this.dbversionsList);
            this.templateIndex = Template.indexOfDefault(this.templatesList);
            if (this.templateIndex != -1) {
                List<NativeCommand> nativeCommands = this.dbase.readNativeCommandsList(-1, this.templatesList.get(this.templateIndex).getId());
                this.profile = new ExpProfile(new Conf((File)null, this.templatesList.get(this.templateIndex), dbversion, ps), nativeCommands);
            } else {
                List<NativeCommand> nativeCommands = this.dbase.readNativeCommandsList(-1, -1);
                this.profile = new ExpProfile(new Conf((File)null, (Template)null, dbversion, ps), nativeCommands);
            }
            this.developer = "";
            this.publisher = "";
            this.year = "";
            this.genre = "";
            this.notes = "";
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    protected void onExit() {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory(FileUtils.getTmpInstallFile());
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
    }

    protected int stepSize(boolean up) {
        if (this.btnPreinstalledGame.getSelection()) {
            if (up && this.stepNr == 0 || !up && this.stepNr == 4) {
                return 4;
            }
            if (up && this.stepNr == 4 || !up && this.stepNr == 6) {
                return 2;
            }
        } else if (up && this.stepNr == 3 || !up && this.stepNr == 5) {
            return 2;
        }
        return super.stepSize(up);
    }

    protected boolean isValidInput() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.stepNr == 0) {
            return this.titleEntered();
        }
        if (this.stepNr == 1) {
            return this.installExeEntered();
        }
        if (this.stepNr == 2) {
            return true;
        }
        if (this.stepNr == 3) {
            return this.mainExeEntered();
        }
        if (this.stepNr == 4) {
            return this.mainExeEntered();
        }
        if (this.stepNr == 5) {
            return this.conditionsOkForStep5();
        }
        if (this.stepNr == 6) {
            return true;
        }
        return true;
    }

    protected boolean actionAfterNext() {
        if (this.stepNr == 0) {
            return this.doWebSearch();
        }
        if (this.stepNr == 1) {
            return this.runInstallerAndCheckResults();
        }
        if (this.stepNr == 2) {
            return this.determineMainAndSetup();
        }
        if (this.stepNr == 3) {
            return this.setMain();
        }
        if (this.stepNr == 4) {
            return this.setMain();
        }
        if (this.stepNr == 5) {
            return true;
        }
        if (this.stepNr == 6) {
            return this.createProfile();
        }
        return false;
    }

    protected void doReloadTemplate(int templateIndex) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            Conf templateConf = new Conf(this.templatesList.get(templateIndex), DosboxVersion.findDefault(this.dbversionsList), ps);
            this.profile.getConf().reloadTemplate(templateConf);
            this.selectSettingsByConfiguration(this.profile.getConf());
            this.profile.setNativeCommandsList(this.dbase.readNativeCommandsList(-1, this.templatesList.get(templateIndex).getId()));
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    protected void selectSettingsByConfiguration(Conf conf) {
        SectionsWrapper sections = conf.getSettings();
        this.machine.setText(sections.getValue("dosbox", "machine"));
        this.core.setText(sections.getValue("cpu", "core"));
        this.cycles.setText(sections.getValue("cpu", "cycles"));
    }

    protected void updateConfigurationBySettings(Conf conf) {
        conf.updateValue("dosbox", "machine", this.machine.getText(), true);
        conf.updateValue("cpu", "core", this.core.getText(), true);
        conf.updateValue("cpu", "cycles", this.cycles.getText(), true);
    }

    protected void doAddMount() {
        EditMountDialog addMountDialog = new EditMountDialog(this.shell);
        try {
            addMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(false, this.profile.getConf().nettoMountedDriveLetters()));
        }
        catch (Exception e) {
            // empty catch block
        }
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            this.mountingpoints.setItems(this.profile.getConf().addMount(mount));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(sel));
            String mount = (String)editMountDialog.open();
            if (mount != null) {
                this.mountingpoints.setItems(this.profile.getConf().editMount(sel, mount));
                if (this.mountingpoints.getItemCount() == mounts) {
                    this.mountingpoints.select(sel);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            this.mountingpoints.select(sel);
        }
        if (sel != -1) {
            this.mountingpoints.setItems(this.profile.getConf().removeMount(sel));
            if (this.mountingpoints.getItemCount() == mounts) {
                this.mountingpoints.select(sel);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    private boolean titleEntered() {
        if (this.title.getText().trim().length() <= 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.title"), (Control)this.title);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean doWebSearch() {
        String currTitle;
        if (this.doSearch.getSelection() && (currTitle = this.title.getText()).length() >= 1) {
            WebSearchEngine engine = this.getSelectedSearchEngine();
            try {
                WebProfile thisGame = null;
                List<WebProfile> webGamesList = engine.getEntries(currTitle, this.settings.getSettings().getValues(engine.getSimpleName(), "platform_filter"));
                if (webGamesList.size() >= 1) {
                    BrowseSearchEngineDialog mobyDialog = new BrowseSearchEngineDialog(this.shell);
                    mobyDialog.setProfilesToBrowse(currTitle, webGamesList);
                    mobyDialog.setEngine(engine);
                    Integer idx = (Integer)mobyDialog.open();
                    if (idx != null) {
                        thisGame = webGamesList.get(idx);
                    }
                }
                if (thisGame != null) {
                    WebProfile profExt = engine.getEntryDetailedInformation(thisGame);
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_title")) {
                        this.title.setText(profExt.getTitle());
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_developer")) {
                        this.developer = profExt.getDeveloperName();
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_publisher")) {
                        this.publisher = profExt.getPublisherName();
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_year")) {
                        this.year = profExt.getYear();
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_genre")) {
                        this.genre = profExt.getGenre();
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_link")) {
                        this.link[0] = profExt.getUrl();
                        this.linkTitle[0] = this.settings.msg("dialog.profile.searchengine.link.maininfo", new String[]{engine.getName()});
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_description")) {
                        this.notes = profExt.getNotes();
                    }
                    if (this.settings.getSettings().getBooleanValue(engine.getSimpleName(), "set_rank")) {
                        this.customInts[0] = profExt.getRank();
                    }
                }
            }
            catch (Exception e) {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.retrieveinfosearchengine", new String[]{engine.getName(), currTitle, StringRelatedUtils.toString(e)}), e);
            }
        }
        if (this.btnGameNeedsToBeInstalled.getSelection()) {
            this.profile.getConf().unmountDosboxMounts();
            this.profile.getConf().addMount("mount c \"" + FileUtils.getTmpInstallFile() + "\"");
            this.mountingpoints.setItems(this.profile.getConf().getAutoexec().getMountingpoints());
        }
        return true;
    }

    private boolean installExeEntered() {
        if (this.installExe.getText().trim().length() <= 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.required.installexe"), (Control)this.installExe);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean runInstallerAndCheckResults() {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory(FileUtils.getTmpInstallFile());
            FileUtils.createDir(FileUtils.getTmpInstallFile());
            this.profile.getConf().getAutoexec().setMainExecutable(this.installExe.getText(), this.installParameters.getText());
            FileUtils.doRunInstaller(this.profile, this.profile.getConf(), this.dbversionsList, null, this.btnInstallManual.getSelection());
            this.shell.forceFocus();
            this.shell.forceActive();
            this.orgImages = new ArrayList<File>();
            File[] firstImageMountPath = this.profile.getConf().getFirstImageMountPath();
            if (firstImageMountPath != null) {
                this.orgImages.addAll(Arrays.asList(firstImageMountPath));
            }
            ArrayList<File> additionalImageFiles = new ArrayList<File>();
            for (File file : this.orgImages) {
                File binFile;
                if (!file.getName().toLowerCase().endsWith(FileUtils.CDIMAGES[1]) || (binFile = ISO9660FileSystem.parseCueSheet(file)) == null || !file.getParentFile().equals(binFile.getParentFile())) continue;
                additionalImageFiles.add(binFile);
            }
            this.orgImages.addAll(additionalImageFiles);
            this.installedFiles = FileUtils.getTmpInstallFile().listFiles();
            if (this.installedFiles.length == 0) {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.addgamewizard.error.nofilesinstalled"));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
            return false;
        }
    }

    private boolean determineMainAndSetup() {
        int mainFileIndex;
        if (this.patchExe.getText().trim().length() > 0) {
            try {
                this.profile.getConf().getAutoexec().setMainExecutable(this.patchExe.getText(), this.patchParameters.getText());
                FileUtils.doRunInstaller(this.profile, this.profile.getConf(), this.dbversionsList, null, this.btnPatchManual.getSelection());
                this.shell.forceFocus();
                this.shell.forceActive();
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
                return false;
            }
        }
        this.orgImagesList.removeAll();
        if (this.orgImages != null) {
            for (File file : this.orgImages) {
                this.orgImagesList.add(FileUtils.makeRelativeToDosroot(file).getPath());
            }
        }
        this.orgImagesList.selectAll();
        this.orgImagesList.pack();
        this.orgImagesList.getParent().layout();
        this.installedFilesList.removeAll();
        File gameDir = null;
        for (File file : this.installedFiles) {
            if (file.isDirectory()) {
                this.installedFilesList.add("[ " + FileUtils.makeRelativeToDosroot(file).getPath() + " ]");
                if (gameDir != null) continue;
                gameDir = file;
                continue;
            }
            this.installedFilesList.add(FileUtils.makeRelativeToDosroot(file).getPath());
        }
        this.installedFilesList.selectAll();
        this.installedFilesList.pack();
        this.installedFilesList.getParent().layout();
        this.moveImages.setEnabled(this.profile.getConf().countImageMounts() == 1);
        String imagesDirString = this.settings.getSettings().getValue("directory", "orgimages");
        File imagesSubDir = gameDir != null ? new File(gameDir.getName(), imagesDirString) : new File(imagesDirString);
        this.imagesDstDirectory.setText(imagesSubDir.getPath());
        List<File> executables = FileUtils.getExecutablesInDirRecursive(FileUtils.getTmpInstallFile());
        this.main.removeAll();
        this.setup.removeAll();
        this.setup.add("");
        for (File f : executables) {
            this.main.add(FileUtils.makeRelativeToDosroot(f).getPath());
            this.setup.add(FileUtils.makeRelativeToDosroot(f).getPath());
        }
        if (executables.isEmpty()) {
            this.main.add(this.installExe.getText());
        }
        if ((mainFileIndex = FileUtils.findMostLikelyMainIndex(this.title.getText(), executables)) != -1) {
            this.main.select(mainFileIndex);
        } else {
            this.main.select(0);
        }
        int setupFileIndex = FileUtils.findSetupIndex(executables);
        if (setupFileIndex != -1) {
            this.setup.select(setupFileIndex + 1);
        } else {
            this.setup.select(0);
        }
        this.setup.setEnabled(this.setup.getItemCount() > 1);
        return true;
    }

    private boolean mainExeEntered() {
        if (this.btnPreinstalledGame.getSelection()) {
            if (this.mainText.getText().trim().length() <= 0) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), (Control)this.mainText);
            }
        } else if (this.main.getText().trim().length() <= 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), (Control)this.main);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean setMain() {
        if (this.btnPreinstalledGame.getSelection()) {
            if (this.profile.getConf().getRequiredMount(false, this.mainText.getText()) != null) {
                this.profile.getConf().addRequiredMount(false, this.mainText.getText());
            }
            this.profile.getConf().getAutoexec().setMainExecutable(this.mainText.getText(), "");
        } else {
            if (this.profile.getConf().getRequiredMount(false, this.main.getText()) != null) {
                this.profile.getConf().addRequiredMount(false, this.main.getText());
            }
            this.profile.getConf().getAutoexec().setMainExecutable(this.main.getText(), "");
        }
        return true;
    }

    private boolean conditionsOkForStep5() {
        if (this.btnPreinstalledGame.getSelection()) {
            return true;
        }
        try {
            if (this.installedFilesList.getSelectionCount() > 0) {
                File destDir = new File(this.dstDirectory.getText());
                if (!destDir.isDirectory() && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.addgamewizard.confirm.createdestinationdir", new String[]{destDir.toString()}))) {
                    destDir.mkdirs();
                }
                if (!destDir.isDirectory()) {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.error.destinationdirmissing", new String[]{destDir.toString()}), (Control)this.dstDirectory);
                } else {
                    for (int i = 0; i < this.installedFiles.length; ++i) {
                        File destFile;
                        if (!this.installedFilesList.isSelected(i) || !org.apache.commons.io.FileUtils.directoryContains(destDir, destFile = new File(destDir, this.installedFiles[i].getName()))) continue;
                        GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.error.gamedatadirexists", new String[]{destFile.toString()}), (Control)this.dstDirectory);
                    }
                }
            } else {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.error.gamedatamustbemoved"), (Control)this.installedFilesList);
            }
            return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createProfile() {
        try {
            String setupString;
            String string = setupString = this.btnPreinstalledGame.getSelection() ? this.setupText.getText() : this.setup.getText();
            if (this.installedFilesList.getSelectionCount() > 0) {
                File destDir = new File(this.dstDirectory.getText());
                this.profile.getConf().getAutoexec().migrateTo(FileUtils.getTmpInstallFile(), destDir);
                this.profile.getConf().removeFloppyMounts();
                this.profile.getConf().removeUnnecessaryMounts();
                if (StringUtils.isNotBlank((CharSequence)setupString)) {
                    setupString = FileUtils.makeRelativeTo(FileUtils.canonicalToDosroot(setupString), FileUtils.getTmpInstallFile()).getPath();
                    setupString = FileUtils.makeRelativeToDosroot(new File(destDir, setupString)).getPath();
                }
                for (int i = 0; i < this.installedFiles.length; ++i) {
                    File src = this.installedFiles[i];
                    if (!this.installedFilesList.isSelected(i)) continue;
                    org.apache.commons.io.FileUtils.moveToDirectory(src, destDir, true);
                }
                if (this.moveImages.getSelection()) {
                    File imgDestDir = new File(destDir, this.imagesDstDirectory.getText());
                    FileUtils.createDir(imgDestDir);
                    for (int i = 0; i < this.orgImages.size(); ++i) {
                        File src = this.orgImages.get(i);
                        if (!this.orgImagesList.isSelected(i)) continue;
                        org.apache.commons.io.FileUtils.moveToDirectory(src, imgDestDir, true);
                        this.profile.getConf().getAutoexec().migrateTo(src, new File(imgDestDir, src.getName()));
                    }
                }
            }
            String status = "";
            boolean favorite = false;
            int devId = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), this.developer);
            int publId = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), this.publisher);
            int genId = KeyValuePair.findIdByValue(this.dbase.readGenresList(), this.genre);
            int yrId = KeyValuePair.findIdByValue(this.dbase.readYearsList(), this.year);
            int statId = KeyValuePair.findIdByValue(this.dbase.readStatusList(), status);
            int[] custIDs = new int[]{0, 0, 0, 0};
            for (int i = 0; i < 4; ++i) {
                custIDs[i] = KeyValuePair.findIdByValue(this.dbase.readCustomList(i), "");
            }
            this.dbase.startTransaction();
            int profileId = this.dbase.addOrEditProfile(this.title.getText(), this.developer, this.publisher, this.genre, this.year, status, this.notes, favorite, new String[]{setupString, "", ""}, new String[]{"", "", ""}, devId, publId, genId, yrId, statId, this.profile.getDbversionId(), this.link, this.linkTitle, CUST_STRINGS, this.customInts, custIDs, -1);
            this.dbase.saveNativeCommands(this.profile.getNativeCommandsList(), profileId, -1);
            String confString = FileUtils.constructUniqueConfigFileString(profileId, this.title.getText(), this.profile.getConf().getAutoexec().getCanonicalMainDir());
            String capturesString = FileUtils.constructCapturesDir(profileId);
            FileUtils.createDir(FileUtils.canonicalToData(capturesString));
            this.dbase.updateProfileConf(confString, capturesString, profileId);
            Profile p = new Profile(profileId, this.title.getText(), this.developer, this.publisher, this.genre, this.year, status, this.notes, favorite, new String[]{setupString, "", ""}, new String[]{"", "", ""}, confString, capturesString, this.profile.getDbversionId(), this.link, this.linkTitle, CUST_STRINGS, this.customInts);
            this.updateConfigurationBySettings(this.profile.getConf());
            this.profile.getConf().injectOrUpdateProfile(p);
            this.profile.getConf().save();
            this.dbase.commitTransaction();
            this.result = p;
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
            try {
                this.dbase.rollbackTransaction();
            }
            catch (SQLException se) {
                GeneralPurposeDialogs.warningMessage(this.shell, se);
            }
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
            try {
                this.dbase.rollbackTransaction();
            }
            catch (SQLException se) {
                GeneralPurposeDialogs.warningMessage(this.shell, se);
            }
        }
        finally {
            this.dbase.finishTransaction();
        }
        return true;
    }

    private WebSearchEngine getSearchEngineBySimpleName(String simpleName) {
        for (WebSearchEngine engn : webSearchEngines) {
            if (!engn.getSimpleName().equalsIgnoreCase(simpleName)) continue;
            return engn;
        }
        return null;
    }

    private WebSearchEngine getSelectedSearchEngine() {
        WebSearchEngine engine = null;
        for (WebSearchEngine engn : webSearchEngines) {
            if (!engn.getName().equals(this.doSearch.getData())) continue;
            engine = engn;
        }
        return engine;
    }

    protected void fillPages() {
        this.addStep(this.page0());
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
        this.addStep(this.page5());
        this.addStep(this.page6());
    }

    private Control page0() {
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.addgamewizard.step1"));
        group.setLayout((Layout)new GridLayout(4, false));
        Label titleLabel = new Label((Composite)group, 0);
        titleLabel.setText(this.settings.msg("dialog.profile.title"));
        this.title = new Text((Composite)group, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.title.setFocus();
        WebSearchEngine defaultEngine = this.getSearchEngineBySimpleName(this.settings.getSettings().getValue("gui", "searchengine"));
        if (defaultEngine == null) {
            defaultEngine = webSearchEngines.get(0);
        }
        this.doSearch = new Button((Composite)group, 2);
        this.doSearch.setText(this.settings.msg("dialog.profile.consultsearchengine", new String[]{defaultEngine.getName()}));
        this.doSearch.setData((Object)defaultEngine.getName());
        this.doSearch.setSelection(this.settings.getSettings().getBooleanValue("addgamewizard", "consultsearchengine"));
        this.doSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "consultsearchengine", AddGameWizardDialog.this.doSearch.getSelection());
            }
        });
        final ToolBar toolBar = new ToolBar((Composite)group, 0);
        this.engineSelector = new ToolItem(toolBar, 4);
        this.engineSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), defaultEngine.getIcon()));
        final Menu menu = new Menu((Decorations)this.shell, 8);
        for (final WebSearchEngine engine : webSearchEngines) {
            MenuItem item = new MenuItem(menu, 8);
            item.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), engine.getIcon()));
            item.setText(engine.getName());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem sel = (MenuItem)event.widget;
                    AddGameWizardDialog.this.engineSelector.setImage(sel.getImage());
                    AddGameWizardDialog.this.doSearch.setData((Object)sel.getText());
                    AddGameWizardDialog.this.doSearch.setText(AddGameWizardDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{AddGameWizardDialog.this.doSearch.getData().toString()}));
                    AddGameWizardDialog.this.doSearch.getParent().layout();
                    AddGameWizardDialog.this.settings.getSettings().setValue("gui", "searchengine", engine.getSimpleName());
                }
            });
        }
        this.engineSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = AddGameWizardDialog.this.engineSelector.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    menu.setLocation(pt.x, pt.y);
                    menu.setVisible(true);
                } else {
                    for (int i = 0; i < webSearchEngines.size(); ++i) {
                        if (!webSearchEngines.get(i).getName().equals(AddGameWizardDialog.this.doSearch.getData())) continue;
                        int nextIdx = i + 1;
                        if (nextIdx >= webSearchEngines.size()) {
                            nextIdx = 0;
                        }
                        MenuItem sel = menu.getItem(nextIdx);
                        AddGameWizardDialog.this.engineSelector.setImage(sel.getImage());
                        AddGameWizardDialog.this.doSearch.setData((Object)sel.getText());
                        AddGameWizardDialog.this.doSearch.setText(AddGameWizardDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{AddGameWizardDialog.this.doSearch.getData().toString()}));
                        AddGameWizardDialog.this.doSearch.getParent().layout();
                        AddGameWizardDialog.this.settings.getSettings().setValue("gui", "searchengine", AddGameWizardDialog.this.getSelectedSearchEngine().getSimpleName());
                        break;
                    }
                }
            }
        });
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 0x1000000, true, false, 4, 1);
        gd.verticalIndent = 20;
        composite.setLayoutData((Object)gd);
        Label thisGameLabel = new Label(composite, 0);
        thisGameLabel.setText(this.settings.msg("dialog.addgamewizard.thisgame"));
        this.btnPreinstalledGame = new Button(composite, 16);
        this.btnPreinstalledGame.setText(this.settings.msg("dialog.addgamewizard.preinstalled"));
        this.btnGameNeedsToBeInstalled = new Button(composite, 16);
        this.btnGameNeedsToBeInstalled.setText(this.settings.msg("dialog.addgamewizard.notyetinstalled"));
        boolean requiresInstallation = this.settings.getSettings().getBooleanValue("addgamewizard", "requiresinstallation");
        this.btnPreinstalledGame.setSelection(!requiresInstallation);
        this.btnGameNeedsToBeInstalled.setSelection(requiresInstallation);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "requiresinstallation", event.widget == AddGameWizardDialog.this.btnGameNeedsToBeInstalled);
            }
        };
        this.btnPreinstalledGame.addSelectionListener((SelectionListener)adapter);
        this.btnGameNeedsToBeInstalled.addSelectionListener((SelectionListener)adapter);
        return group;
    }

    private Control page1() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step2"));
        group.setLayout((Layout)new GridLayout());
        Composite installexeComposite = new Composite((Composite)group, 0);
        installexeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        installexeComposite.setLayout((Layout)new GridLayout(3, false));
        Label mainExeLabel = new Label(installexeComposite, 0);
        mainExeLabel.setText(this.settings.msg("dialog.addgamewizard.installexe"));
        this.installExe = new Text(installexeComposite, 2048);
        this.installExe.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton installexeBrowseButton = new BrowseButton(installexeComposite, 0);
        installexeBrowseButton.connect(this.shell, this.installExe, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.INSTALLER, false, null);
        Label parametersLabel = new Label(installexeComposite, 0);
        parametersLabel.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.installParameters = new Text(installexeComposite, 2048);
        this.installParameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label manualLabel = new Label(installexeComposite, 0);
        manualLabel.setText(this.settings.msg("dialog.addgamewizard.manualmode"));
        this.btnInstallManual = new Button(installexeComposite, 32);
        this.btnInstallManual.setText(this.settings.msg("dialog.addgamewizard.manualmodeinfo"));
        this.btnInstallManual.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Group mountGroup = new Group((Composite)group, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.verticalIndent = 20;
        mountGroup.setLayoutData((Object)gd);
        mountGroup.setText(this.settings.msg("dialog.template.mountingoverview"));
        mountGroup.setLayout((Layout)new GridLayout(2, false));
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)mountGroup, 2560);
        this.mountingpoints.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        this.mountingpoints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (AddGameWizardDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    AddGameWizardDialog.this.doAddMount();
                } else {
                    AddGameWizardDialog.this.doEditMount();
                }
            }
        });
        Button addButton = new Button((Composite)mountGroup, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.setText(this.settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.doAddMount();
            }
        });
        Button editButton = new Button((Composite)mountGroup, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText(this.settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.doEditMount();
            }
        });
        Button removeButton = new Button((Composite)mountGroup, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText(this.settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.doRemoveMount();
            }
        });
        VerifyListener addMountListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1) {
                    AddGameWizardDialog.this.addMountIfNoMounts(event.text);
                }
            }
        };
        this.installExe.addVerifyListener(addMountListener);
        return group;
    }

    private void addMountIfNoMounts(String hostFileLocation) {
        this.profile.getConf().unmountDosboxMounts();
        this.profile.getConf().addMount("mount c \"" + FileUtils.getTmpInstallFile() + "\"");
        this.mountingpoints.setItems(this.profile.getConf().addRequiredMountForInstaller(hostFileLocation));
    }

    private Control page2() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step3"));
        group.setLayout((Layout)new GridLayout());
        Composite patchexeComposite = new Composite((Composite)group, 0);
        patchexeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        patchexeComposite.setLayout((Layout)new GridLayout(3, false));
        Label patchExeLabel = new Label(patchexeComposite, 0);
        patchExeLabel.setText(this.settings.msg("dialog.addgamewizard.patcherexe"));
        this.patchExe = new Text(patchexeComposite, 2048);
        this.patchExe.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton patchexeBrowseButton = new BrowseButton(patchexeComposite, 0);
        patchexeBrowseButton.connect(this.shell, this.patchExe, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.INSTALLER, false, null);
        Label parametersLabel = new Label(patchexeComposite, 0);
        parametersLabel.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.patchParameters = new Text(patchexeComposite, 2048);
        this.patchParameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label manualLabel = new Label(patchexeComposite, 0);
        manualLabel.setText(this.settings.msg("dialog.addgamewizard.manualmode"));
        this.btnPatchManual = new Button(patchexeComposite, 32);
        this.btnPatchManual.setText(this.settings.msg("dialog.addgamewizard.manualpatchmodeinfo"));
        this.btnPatchManual.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        return group;
    }

    private Control page3() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step4"));
        group.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label mainExeLabel = new Label(composite, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
        this.main = new Combo(composite, 8);
        this.main.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label setupExeLabel = new Label(composite, 0);
        setupExeLabel.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setup = new Combo(composite, 8);
        this.setup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return group;
    }

    private Control page4() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step4"));
        group.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label mainExeLabel = new Label(composite, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
        this.mainText = new Text(composite, 2048);
        this.mainText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton mainBrowseButton = new BrowseButton(composite, 0);
        mainBrowseButton.connect(this.shell, this.mainText, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        Label setupExeLabel = new Label(composite, 0);
        setupExeLabel.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setupText = new Text(composite, 2048);
        this.setupText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton setupBrowseButton = new BrowseButton(composite, 0);
        setupBrowseButton.connect(this.shell, this.setupText, this.mainText, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        return group;
    }

    private Control page5() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step5"));
        group.setLayout((Layout)new GridLayout());
        Group installedFilesGroup = new Group((Composite)group, 0);
        installedFilesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        installedFilesGroup.setLayout((Layout)new GridLayout(3, false));
        installedFilesGroup.setText(this.settings.msg("dialog.addgamewizard.installedfiles"));
        this.installedFilesList = new org.eclipse.swt.widgets.List((Composite)installedFilesGroup, 2562);
        this.installedFilesList.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label toLabel = new Label((Composite)installedFilesGroup, 0);
        toLabel.setText(this.settings.msg("dialog.migration.to"));
        this.dstDirectory = new Text((Composite)installedFilesGroup, 2048);
        this.dstDirectory.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dstDirectory.setText(FileUtils.getDosRoot());
        BrowseButton fromBrowseButton = new BrowseButton((Composite)installedFilesGroup, 0);
        fromBrowseButton.connect(this.shell, this.dstDirectory, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Group orgImagesGroup = new Group((Composite)group, 0);
        orgImagesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        orgImagesGroup.setLayout((Layout)new GridLayout(3, false));
        orgImagesGroup.setText(this.settings.msg("dialog.addgamewizard.originalimages"));
        this.orgImagesList = new org.eclipse.swt.widgets.List((Composite)orgImagesGroup, 2562);
        this.orgImagesList.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label moveImagesLabel = new Label((Composite)orgImagesGroup, 0);
        moveImagesLabel.setText(this.settings.msg("dialog.addgamewizard.moveimages"));
        this.moveImages = new Button((Composite)orgImagesGroup, 32);
        new Label((Composite)orgImagesGroup, 0);
        Label imagesToLabel = new Label((Composite)orgImagesGroup, 0);
        imagesToLabel.setText(this.settings.msg("dialog.migration.to"));
        this.imagesDstDirectory = new Text((Composite)orgImagesGroup, 2048);
        this.imagesDstDirectory.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)orgImagesGroup, 0);
        this.moveImages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddGameWizardDialog.this.imagesDstDirectory.setEnabled(AddGameWizardDialog.this.moveImages.getSelection());
            }
        });
        this.imagesDstDirectory.setEnabled(this.moveImages.getSelection());
        return group;
    }

    private Control page6() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step6"));
        group.setLayout((Layout)new GridLayout(3, false));
        Label templateLabel = new Label((Composite)group, 0);
        templateLabel.setText(this.settings.msg("dialog.profile.template"));
        this.template = new Combo((Composite)group, 8);
        this.template.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.template.setVisibleItemCount(10);
        for (Template templ : this.templatesList) {
            this.template.add(templ.getTitle());
        }
        if (this.templateIndex != -1) {
            this.template.select(this.templateIndex);
        }
        this.templateReload = new Button((Composite)group, 0);
        this.templateReload.setText(this.settings.msg("dialog.profile.reloadsettings"));
        this.templateReload.setToolTipText(this.settings.msg("dialog.profile.reloadsettings.tooltip"));
        this.templateReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AddGameWizardDialog.this.template.getSelectionIndex() != -1) {
                    AddGameWizardDialog.this.doReloadTemplate(AddGameWizardDialog.this.template.getSelectionIndex());
                }
            }
        });
        Label machineLabel = new Label((Composite)group, 0);
        machineLabel.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo((Composite)group, 8);
        this.machine.setLayoutData((Object)new GridData());
        this.machine.setVisibleItemCount(20);
        this.machine.setToolTipText(this.settings.msg("dialog.template.machine.tooltip"));
        if (this.profile.getConf().getSettings().detectDosboxVersionGeneration() >= 3) {
            this.machine.setItems(this.settings.getSettings().getValues("profile", "machine073"));
        } else {
            this.machine.setItems(this.settings.getSettings().getValues("profile", "machine"));
        }
        new Label((Composite)group, 0);
        Label coreLabel = new Label((Composite)group, 0);
        coreLabel.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo((Composite)group, 8);
        this.core.setLayoutData((Object)new GridData());
        this.core.setToolTipText(this.settings.msg("dialog.template.core.tooltip"));
        this.core.setItems(this.settings.getSettings().getValues("profile", "core"));
        new Label((Composite)group, 0);
        Label cyclesLabel = new Label((Composite)group, 0);
        cyclesLabel.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo((Composite)group, 0);
        this.cycles.setLayoutData((Object)new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        this.cycles.setToolTipText(this.settings.msg("dialog.template.cycles.tooltip"));
        this.cycles.setItems(this.settings.getSettings().getValues("profile", "cycles"));
        new Label((Composite)group, 0);
        this.selectSettingsByConfiguration(this.profile.getConf());
        return group;
    }
}

