/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public final class BrowseArchiveDialog
extends Dialog {
    private String[] fileNames;
    private String file = null;
    private Object result;
    private Shell shell;
    private Settings settings = Settings.getInstance();

    public BrowseArchiveDialog(Shell parent, int style) {
        super(parent, style);
    }

    public BrowseArchiveDialog(Shell parent) {
        this(parent, 0);
    }

    public void setFileToBrowse(String fileToBrowse) {
        this.file = fileToBrowse;
    }

    public Object open() {
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    private boolean init() {
        try {
            this.fileNames = FileUtils.getExecutablesInZipOrIsoOrFat(this.file);
            if (this.fileNames.length <= 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), this.settings.msg("dialog.archivebrowser.notice.noexe"));
                return false;
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), this.settings.msg("dialog.archivebrowser.error.readarchive", new Object[]{this.file, StringRelatedUtils.toString(e)}), e);
            return false;
        }
        return true;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "archivebrowser"));
        this.shell.setText(this.settings.msg("dialog.archivebrowser.title"));
        final List files = new List((Composite)this.shell, 2560);
        files.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        files.setItems(this.fileNames);
        files.setSelection(0);
        files.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                BrowseArchiveDialog.this.doChooseFile(files);
            }
        });
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseArchiveDialog.this.doChooseFile(files);
            }
        });
        okButton.setLayoutData((Object)new GridData(80, -1));
        this.shell.setDefaultButton(okButton);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.setLayoutData((Object)new GridData(80, -1));
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseArchiveDialog.this.result = null;
                BrowseArchiveDialog.this.shell.close();
            }
        });
    }

    private void doChooseFile(List files) {
        if (FileUtils.isArchive(this.file)) {
            this.result = this.file + ':' + File.separatorChar + files.getItem(files.getSelectionIndex());
        } else if (FileUtils.isIsoFile(this.file) || FileUtils.isFatImage(this.file)) {
            this.result = this.file + File.separatorChar + files.getItem(files.getSelectionIndex());
        }
        this.shell.close();
    }
}

