/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class SettingsDialog
extends Dialog {
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("da", "de", "en", "es", "es__Capitalizado", "fr", "it", "ko", "nl", "ru", "sv", "zh", "zh_TW");
    private static int NR_OF_ENGINES = EditProfileDialog.webSearchEngines.size();
    private static final SortedMap<String, Locale> allLocales = new TreeMap<String, Locale>();
    private static final int EDITABLE_COLUMN = 0;
    static final String[] confLocations;
    static final String[] confFilenames;
    static final String[] buttonDisplayOptions;
    private List<Integer> allColumnIDs;
    private Table visible_columns;
    private boolean changedVisColumns = false;
    private TableItem[] visibleColumns;
    private TabItem columnsTabItem;
    private Combo confFilename;
    private Combo confLocation;
    private Combo localeCombo;
    private Combo buttonDisplay;
    private Text port;
    private Text values;
    private Text envValues;
    private Label heightValue;
    private Label columnHeightValue;
    private Scale screenshotsHeight;
    private Scale screenshotsColumnHeight;
    private int previousSelection = -1;
    private Button[] setTitle;
    private Button[] setDev;
    private Button[] setPub;
    private Button[] setYear;
    private Button[] setGenre;
    private Button[] setLink;
    private Button[] setDescr;
    private Button[] setRank;
    private Button[] chooseCoverArt;
    private Button[] allRegionsCoverArt;
    private Button[] chooseScreenshot;
    private Text[] platformFilterValues;
    private Spinner[] maxCoverArt;
    private Spinner[] maxScreenshots;
    private SectionsWrapper conf;
    private org.eclipse.swt.widgets.List options;
    protected Shell shell;
    private Settings settings;

    public SettingsDialog(Shell parent, int style) {
        super(parent, style);
    }

    public SettingsDialog(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.conf = new SectionsWrapper(this.settings.getSettings());
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.changedVisColumns;
    }

    protected void createContents() {
        int i;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "settingsdialog"));
        this.shell.setText(this.settings.msg("dialog.settings.title"));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.settings.tab.general"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        generalTabItem.setControl((Control)composite);
        Group dosboxGroup = new Group(composite, 0);
        dosboxGroup.setText(this.settings.msg("dialog.settings.dosbox"));
        dosboxGroup.setLayout((Layout)new GridLayout(2, false));
        Label showConsoleLabel = new Label((Composite)dosboxGroup, 0);
        showConsoleLabel.setText(this.settings.msg("dialog.settings.hidestatuswindow"));
        final Button console = new Button((Composite)dosboxGroup, 32);
        console.setSelection(this.conf.getBooleanValue("dosbox", "hideconsole"));
        Group sendToGroup = new Group(composite, 0);
        sendToGroup.setText(this.settings.msg("dialog.settings.sendto"));
        sendToGroup.setLayout((Layout)new GridLayout(2, false));
        Label enableCommLabel = new Label((Composite)sendToGroup, 0);
        enableCommLabel.setText(this.settings.msg("dialog.settings.enableport"));
        final Button portEnabled = new Button((Composite)sendToGroup, 32);
        portEnabled.setSelection(this.conf.getBooleanValue("communication", "port_enabled"));
        portEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.port.setEnabled(portEnabled.getSelection());
            }
        });
        Label portnumberLabel = new Label((Composite)sendToGroup, 0);
        portnumberLabel.setText(this.settings.msg("dialog.settings.port"));
        this.port = new Text((Composite)sendToGroup, 2048);
        this.port.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.port.setText(this.conf.getValue("communication", "port"));
        this.port.setEnabled(portEnabled.getSelection());
        Group profileDefGroup = new Group(composite, 0);
        profileDefGroup.setText(this.settings.msg("dialog.settings.profiledefaults"));
        profileDefGroup.setLayout((Layout)new GridLayout(3, false));
        Label configFileLabel = new Label((Composite)profileDefGroup, 0);
        configFileLabel.setText(this.settings.msg("dialog.settings.configfile"));
        this.confLocation = new Combo((Composite)profileDefGroup, 8);
        this.confLocation.setItems(confLocations);
        this.confLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.confLocation.select(this.conf.getIntValue("profiledefaults", "confpath"));
        this.confFilename = new Combo((Composite)profileDefGroup, 8);
        this.confFilename.setItems(confFilenames);
        this.confFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.confFilename.select(this.conf.getIntValue("profiledefaults", "conffile"));
        Group i18nGroup = new Group(composite, 0);
        i18nGroup.setText(this.settings.msg("dialog.settings.i18n"));
        i18nGroup.setLayout((Layout)new GridLayout(2, false));
        Label languageLabel = new Label((Composite)i18nGroup, 0);
        languageLabel.setText(this.settings.msg("dialog.settings.languagecountry"));
        this.localeCombo = new Combo((Composite)i18nGroup, 8);
        Locale locale = new Locale(this.conf.getValue("locale", "language"), this.conf.getValue("locale", "country"), this.conf.getValue("locale", "variant"));
        final TreeMap<String, Locale> locales = new TreeMap<String, Locale>();
        String locString = "";
        ArrayList<String> supportedLanguages = new ArrayList<String>(SUPPORTED_LANGUAGES);
        File[] files = new File("./plugins/i18n").listFiles();
        if (files != null) {
            for (File file : files) {
                String code;
                String name = file.getName();
                if (!name.startsWith("MessagesBundle_") || !name.endsWith(".properties") || (code = name.substring("MessagesBundle_".length(), name.indexOf(".properties"))).length() <= 0) continue;
                supportedLanguages.add(code);
            }
        }
        for (String lang : supportedLanguages) {
            Locale loc = (Locale)allLocales.get(lang);
            String variant = null;
            if (loc == null && StringUtils.countMatches((CharSequence)lang, (CharSequence)"_") == 2) {
                String langWithoutVariant = StringUtils.removeEnd((String)StringUtils.substringBeforeLast((String)lang, (String)"_"), (String)"_");
                variant = StringUtils.substringAfterLast((String)lang, (String)"_");
                loc = (Locale)allLocales.get(langWithoutVariant);
            }
            if (loc == null) continue;
            StringBuffer s = new StringBuffer(loc.getDisplayLanguage(Locale.getDefault()));
            if (loc.getCountry().length() > 0) {
                s.append(" - ").append(loc.getDisplayCountry(Locale.getDefault()));
            }
            if (variant != null) {
                s.append(" (").append(variant).append(')');
                loc = new Locale(loc.getLanguage(), loc.getCountry(), variant);
            }
            locales.put(s.toString(), loc);
            if (!loc.equals(locale)) continue;
            locString = s.toString();
        }
        for (String sloc : locales.keySet()) {
            this.localeCombo.add(sloc);
        }
        this.localeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.localeCombo.setText(locString);
        this.localeCombo.setVisibleItemCount(20);
        this.columnsTabItem = new TabItem(tabFolder, 0);
        this.columnsTabItem.setText(this.settings.msg("dialog.settings.tab.profiletable"));
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        composite2.setLayout((Layout)new BorderLayout(0, 0));
        this.columnsTabItem.setControl((Control)composite2);
        Group visColumnsGroup = new Group(composite2, 0);
        visColumnsGroup.setLayout((Layout)new FillLayout());
        visColumnsGroup.setText(this.settings.msg("dialog.settings.visiblecolunms"));
        this.visible_columns = new Table((Composite)visColumnsGroup, 67616);
        this.visible_columns.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.visible_columns, 0);
        column1.setWidth(350);
        ArrayList<Integer> visibleColumnIDs = new ArrayList<Integer>();
        for (int i2 = 0; i2 < MainWindow.columnNames.length; ++i2) {
            if (!this.conf.getBooleanValue("gui", "column" + (i2 + 1) + "visible")) continue;
            visibleColumnIDs.add(i2);
        }
        ArrayList orderedVisibleColumnIDs = new ArrayList();
        int[] columnOrder = this.conf.getIntValues("gui", "columnorder");
        for (int i3 = 0; i3 < columnOrder.length; ++i3) {
            orderedVisibleColumnIDs.add(visibleColumnIDs.get(columnOrder[i3]));
        }
        ArrayList<Integer> remainingColumnIDs = new ArrayList<Integer>();
        for (i = 0; i < MainWindow.columnNames.length; ++i) {
            if (orderedVisibleColumnIDs.contains(i)) continue;
            remainingColumnIDs.add(i);
        }
        this.allColumnIDs = new ArrayList<Integer>(orderedVisibleColumnIDs);
        this.allColumnIDs.addAll(remainingColumnIDs);
        this.visibleColumns = new TableItem[MainWindow.columnNames.length];
        for (i = 0; i < MainWindow.columnNames.length; ++i) {
            this.visibleColumns[i] = new TableItem(this.visible_columns, 2048);
            this.visibleColumns[i].setText(MainWindow.columnNames[this.allColumnIDs.get(i)]);
            this.visibleColumns[i].setChecked(this.conf.getBooleanValue("gui", "column" + (this.allColumnIDs.get(i) + 1) + "visible"));
        }
        final TableEditor editor = new TableEditor(this.visible_columns);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        this.visible_columns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)event.item) == null) {
                    return;
                }
                int selIdx = item.getParent().getSelectionIndex();
                if (selIdx == -1) {
                    return;
                }
                int idx = (Integer)SettingsDialog.this.allColumnIDs.get(selIdx);
                if (idx < 10 || idx == 20 || idx == 21) {
                    return;
                }
                Text newEditor = new Text((Composite)SettingsDialog.this.visible_columns, 0);
                newEditor.setText(item.getText(0));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent mEvent) {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(0, text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 0);
            }
        });
        Group addProfGroup = new Group(composite2, 0);
        addProfGroup.setLayout((Layout)new GridLayout(2, false));
        addProfGroup.setText(this.settings.msg("dialog.settings.addeditduplicateprofile"));
        addProfGroup.setLayoutData((Object)"South");
        Label autoSortLabel = new Label((Composite)addProfGroup, 0);
        autoSortLabel.setText(this.settings.msg("dialog.settings.autosort"));
        final Button autosort = new Button((Composite)addProfGroup, 32);
        autosort.setSelection(this.conf.getBooleanValue("gui", "autosortonupdate"));
        TabItem dynTabItem = new TabItem(tabFolder, 0);
        dynTabItem.setText(this.settings.msg("dialog.settings.tab.dynamicoptions"));
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new FillLayout());
        dynTabItem.setControl((Control)composite_1);
        Group dynOptionsGroup = new Group(composite_1, 0);
        dynOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        dynOptionsGroup.setText(this.settings.msg("dialog.settings.dynamicoptions"));
        Label optionsLabel = new Label((Composite)dynOptionsGroup, 0);
        optionsLabel.setText(this.settings.msg("dialog.settings.options"));
        Label valuesLabel = new Label((Composite)dynOptionsGroup, 0);
        valuesLabel.setText(this.settings.msg("dialog.settings.values"));
        this.options = new org.eclipse.swt.widgets.List((Composite)dynOptionsGroup, 2560);
        this.options.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.storeValues();
                SettingsDialog.this.previousSelection = SettingsDialog.this.options.getSelectionIndex();
                if (SettingsDialog.this.previousSelection != -1) {
                    SettingsDialog.this.values.setText(SettingsDialog.this.conf.getMultilineValues("profile", SettingsDialog.this.options.getItem(SettingsDialog.this.previousSelection), SettingsDialog.this.values.getLineDelimiter()));
                }
            }
        });
        this.options.setLayoutData((Object)new GridData(4, 4, true, true));
        for (String s : this.conf.getAllItemNames("profile")) {
            this.options.add(s);
        }
        this.values = new Text((Composite)dynOptionsGroup, 2818);
        this.values.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem guiTabItem = new TabItem(tabFolder, 0);
        guiTabItem.setText(this.settings.msg("dialog.settings.tab.gui"));
        final Composite composite1 = new Composite((Composite)tabFolder, 0);
        composite1.setLayout((Layout)new GridLayout(2, false));
        guiTabItem.setControl((Control)composite1);
        Group screenshots = new Group(composite1, 0);
        screenshots.setLayout((Layout)new GridLayout(3, false));
        GridData screenshotsLData = new GridData();
        screenshotsLData.grabExcessHorizontalSpace = true;
        screenshotsLData.horizontalAlignment = 4;
        screenshotsLData.horizontalSpan = 2;
        screenshots.setLayoutData((Object)screenshotsLData);
        screenshots.setText(this.settings.msg("dialog.settings.screenshots"));
        Label heightLabel = new Label((Composite)screenshots, 0);
        heightLabel.setText(this.settings.msg("dialog.settings.height"));
        GridData sshotsHeightData = new GridData();
        sshotsHeightData.grabExcessHorizontalSpace = true;
        sshotsHeightData.horizontalAlignment = 4;
        this.screenshotsHeight = new Scale((Composite)screenshots, 0);
        this.screenshotsHeight.setMaximum(750);
        this.screenshotsHeight.setMinimum(50);
        this.screenshotsHeight.setLayoutData((Object)sshotsHeightData);
        this.screenshotsHeight.setIncrement(25);
        this.screenshotsHeight.setPageIncrement(100);
        this.screenshotsHeight.setSelection(this.conf.getIntValue("gui", "screenshotsheight"));
        this.screenshotsHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SettingsDialog.this.heightValue.setText(SettingsDialog.this.screenshotsHeight.getSelection() + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.heightValue.pack();
            }
        });
        this.heightValue = new Label((Composite)screenshots, 0);
        this.heightValue.setText(this.screenshotsHeight.getSelection() + this.settings.msg("dialog.settings.px"));
        Label displayFilenameLabel = new Label((Composite)screenshots, 0);
        displayFilenameLabel.setText(this.settings.msg("dialog.settings.screenshotsfilename"));
        final Button displayFilename = new Button((Composite)screenshots, 32);
        displayFilename.setSelection(this.conf.getBooleanValue("gui", "screenshotsfilename"));
        Group screenshotsColumn = new Group(composite1, 0);
        screenshotsColumn.setLayout((Layout)new GridLayout(3, false));
        GridData screenshotsCData = new GridData();
        screenshotsCData.grabExcessHorizontalSpace = true;
        screenshotsCData.horizontalAlignment = 4;
        screenshotsCData.horizontalSpan = 2;
        screenshotsColumn.setLayoutData((Object)screenshotsCData);
        screenshotsColumn.setText(this.settings.msg("dialog.settings.screenshotscolumn"));
        Label columnHeightLabel = new Label((Composite)screenshotsColumn, 0);
        columnHeightLabel.setText(this.settings.msg("dialog.settings.height"));
        this.screenshotsColumnHeight = new Scale((Composite)screenshotsColumn, 0);
        this.screenshotsColumnHeight.setMaximum(200);
        this.screenshotsColumnHeight.setMinimum(16);
        GridData sshotsColumnHeightData = new GridData();
        sshotsColumnHeightData.grabExcessHorizontalSpace = true;
        sshotsColumnHeightData.horizontalAlignment = 4;
        this.screenshotsColumnHeight.setLayoutData((Object)sshotsColumnHeightData);
        this.screenshotsColumnHeight.setIncrement(4);
        this.screenshotsColumnHeight.setPageIncrement(16);
        this.screenshotsColumnHeight.setSelection(this.conf.getIntValue("gui", "screenshotscolumnheight"));
        this.screenshotsColumnHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SettingsDialog.this.columnHeightValue.setText(SettingsDialog.this.screenshotsColumnHeight.getSelection() + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.columnHeightValue.pack();
            }
        });
        this.columnHeightValue = new Label((Composite)screenshotsColumn, 0);
        this.columnHeightValue.setText(this.screenshotsColumnHeight.getSelection() + this.settings.msg("dialog.settings.px"));
        Label stretchLabel = new Label((Composite)screenshotsColumn, 0);
        stretchLabel.setText(this.settings.msg("dialog.settings.screenshotscolumnstretch"));
        final Button stretch = new Button((Composite)screenshotsColumn, 32);
        stretch.setSelection(this.conf.getBooleanValue("gui", "screenshotscolumnstretch"));
        new Label((Composite)screenshotsColumn, 0);
        Label keepAspectRatioLabel = new Label((Composite)screenshotsColumn, 0);
        keepAspectRatioLabel.setText(this.settings.msg("dialog.settings.screenshotscolumnkeepaspectratio"));
        final Button keepAspectRatio = new Button((Composite)screenshotsColumn, 32);
        keepAspectRatio.setSelection(this.conf.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"));
        new Label((Composite)screenshotsColumn, 0);
        keepAspectRatio.setEnabled(stretch.getSelection());
        stretch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                keepAspectRatio.setEnabled(stretch.getSelection());
            }
        });
        Group buttonsGroup = new Group(composite1, 0);
        buttonsGroup.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        buttonsGroup.setLayout((Layout)new GridLayout(2, false));
        buttonsGroup.setText(this.settings.msg("dialog.settings.buttons"));
        Label buttonLabel = new Label((Composite)buttonsGroup, 0);
        buttonLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonLabel.setText(this.settings.msg("dialog.settings.display"));
        this.buttonDisplay = new Combo((Composite)buttonsGroup, 8);
        this.buttonDisplay.setItems(buttonDisplayOptions);
        this.buttonDisplay.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonDisplay.select(this.conf.getIntValue("gui", "buttondisplay"));
        final Group notesGroup = new Group(composite1, 0);
        notesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        notesGroup.setLayout((Layout)new GridLayout(2, false));
        notesGroup.setText(this.settings.msg("dialog.profile.notes"));
        Label fontLabel = new Label((Composite)notesGroup, 0);
        fontLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fontLabel.setText(this.settings.msg("dialog.settings.font"));
        final Button fontButton = new Button((Composite)notesGroup, 8);
        fontButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Font f = GeneralPurposeGUI.stringToFont((Device)this.shell.getDisplay(), this.port.getFont(), this.conf.getValues("gui", "notesfont"));
        fontButton.setText(f.getFontData()[0].getName());
        fontButton.setFont(f);
        fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog fd = new FontDialog(SettingsDialog.this.shell, 0);
                fd.setFontList(fontButton.getFont().getFontData());
                FontData newFont = fd.open();
                if (newFont != null) {
                    fontButton.setText(newFont.getName());
                    fontButton.setFont(new Font((Device)SettingsDialog.this.shell.getDisplay(), newFont));
                    notesGroup.setSize(notesGroup.computeSize(-1, -1));
                    composite1.layout();
                }
            }
        });
        TabItem enginesTabItem = new TabItem(tabFolder, 0);
        enginesTabItem.setText(this.settings.msg("dialog.settings.tab.engines"));
        Composite compositeHoldingSubTabs = new Composite((Composite)tabFolder, 0);
        compositeHoldingSubTabs.setLayout((Layout)new FillLayout());
        enginesTabItem.setControl((Control)compositeHoldingSubTabs);
        TabFolder enginesTabFolder = new TabFolder(compositeHoldingSubTabs, 0);
        this.setTitle = new Button[NR_OF_ENGINES];
        this.setDev = new Button[NR_OF_ENGINES];
        this.setPub = new Button[NR_OF_ENGINES];
        this.setYear = new Button[NR_OF_ENGINES];
        this.setGenre = new Button[NR_OF_ENGINES];
        this.setLink = new Button[NR_OF_ENGINES];
        this.setRank = new Button[NR_OF_ENGINES];
        this.setDescr = new Button[NR_OF_ENGINES];
        this.allRegionsCoverArt = new Button[NR_OF_ENGINES];
        this.chooseCoverArt = new Button[NR_OF_ENGINES];
        this.chooseScreenshot = new Button[NR_OF_ENGINES];
        this.maxCoverArt = new Spinner[NR_OF_ENGINES];
        this.maxScreenshots = new Spinner[NR_OF_ENGINES];
        this.platformFilterValues = new Text[NR_OF_ENGINES];
        for (int i4 = 0; i4 < NR_OF_ENGINES; ++i4) {
            WebSearchEngine engine = EditProfileDialog.webSearchEngines.get(i4);
            TabItem engineTabItem = new TabItem(enginesTabFolder, 0);
            engineTabItem.setText(this.settings.msg("dialog.settings.tab." + engine.getSimpleName()));
            Composite composite3 = new Composite((Composite)enginesTabFolder, 0);
            composite3.setLayout((Layout)new GridLayout(1, true));
            engineTabItem.setControl((Control)composite3);
            Group consult = new Group(composite3, 0);
            consult.setLayout((Layout)new GridLayout(2, false));
            GridData consultLData = new GridData();
            consultLData.grabExcessHorizontalSpace = true;
            consultLData.horizontalAlignment = 4;
            consultLData.grabExcessVerticalSpace = true;
            consultLData.verticalAlignment = 4;
            consult.setLayoutData((Object)consultLData);
            consult.setText(this.settings.msg("dialog.settings.consult", new String[]{engine.getName()}));
            Label titleLabel = new Label((Composite)consult, 0);
            titleLabel.setText(this.settings.msg("dialog.settings.settitle"));
            this.setTitle[i4] = new Button((Composite)consult, 32);
            this.setTitle[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_title"));
            Label devLabel = new Label((Composite)consult, 0);
            devLabel.setText(this.settings.msg("dialog.settings.setdeveloper"));
            this.setDev[i4] = new Button((Composite)consult, 32);
            this.setDev[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_developer"));
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("hotud")) {
                Label pubLabel = new Label((Composite)consult, 0);
                pubLabel.setText(this.settings.msg("dialog.settings.setpublisher"));
                this.setPub[i4] = new Button((Composite)consult, 32);
                this.setPub[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_publisher"));
            }
            Label yearLabel = new Label((Composite)consult, 0);
            yearLabel.setText(this.settings.msg("dialog.settings.setyear"));
            this.setYear[i4] = new Button((Composite)consult, 32);
            this.setYear[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_year"));
            Label genreLabel = new Label((Composite)consult, 0);
            genreLabel.setText(this.settings.msg("dialog.settings.setgenre"));
            this.setGenre[i4] = new Button((Composite)consult, 32);
            this.setGenre[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_genre"));
            Label linkLabel = new Label((Composite)consult, 0);
            linkLabel.setText(this.settings.msg("dialog.settings.setlink", new String[]{engine.getName()}));
            this.setLink[i4] = new Button((Composite)consult, 32);
            this.setLink[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_link"));
            Label rankLabel = new Label((Composite)consult, 0);
            rankLabel.setText(this.settings.msg("dialog.settings.setrank", new Object[]{MainWindow.columnNames[18]}));
            this.setRank[i4] = new Button((Composite)consult, 32);
            this.setRank[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_rank"));
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("hotud")) {
                Label descrLabel = new Label((Composite)consult, 0);
                descrLabel.setText(this.settings.msg("dialog.settings.setdescription"));
                this.setDescr[i4] = new Button((Composite)consult, 32);
                this.setDescr[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "set_description"));
            }
            if (engine.getSimpleName().equals("mobygames")) {
                Label chooseCoverArtLabel = new Label((Composite)consult, 0);
                chooseCoverArtLabel.setText(this.settings.msg("dialog.settings.choosecoverart"));
                Composite comp = new Composite((Composite)consult, 0);
                GridLayout layout = new GridLayout(3, false);
                layout.marginWidth = 0;
                comp.setLayout((Layout)layout);
                this.chooseCoverArt[i4] = new Button(comp, 32);
                this.chooseCoverArt[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "choose_coverart"));
                Label allRegionsCoverArtLabel = new Label(comp, 0);
                allRegionsCoverArtLabel.setText(this.settings.msg("dialog.settings.allregionscoverart"));
                GridData gd = new GridData();
                gd.horizontalIndent = 40;
                allRegionsCoverArtLabel.setLayoutData((Object)gd);
                this.allRegionsCoverArt[i4] = new Button(comp, 32);
                this.allRegionsCoverArt[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "force_all_regions_coverart"));
            }
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet")) {
                Label chooseScreenshotLabel = new Label((Composite)consult, 0);
                chooseScreenshotLabel.setText(this.settings.msg("dialog.settings.choosescreenshot"));
                this.chooseScreenshot[i4] = new Button((Composite)consult, 32);
                this.chooseScreenshot[i4].setSelection(this.conf.getBooleanValue(engine.getSimpleName(), "choose_screenshot"));
            }
            if (engine.getSimpleName().equals("mobygames")) {
                Label maxCoverArtLabel = new Label((Composite)consult, 0);
                maxCoverArtLabel.setText(this.settings.msg("dialog.settings.multieditmaxcoverart"));
                this.maxCoverArt[i4] = new Spinner((Composite)consult, 2048);
                this.maxCoverArt[i4].setLayoutData((Object)new GridData(100, -1));
                this.maxCoverArt[i4].setMinimum(0);
                this.maxCoverArt[i4].setMaximum(Integer.MAX_VALUE);
                this.maxCoverArt[i4].setSelection(this.conf.getIntValue(engine.getSimpleName(), "multi_max_coverart"));
            }
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet")) {
                Label maxScreenshotsLabel = new Label((Composite)consult, 0);
                maxScreenshotsLabel.setText(this.settings.msg("dialog.settings.multieditmaxscreenshot"));
                this.maxScreenshots[i4] = new Spinner((Composite)consult, 2048);
                this.maxScreenshots[i4].setLayoutData((Object)new GridData(100, -1));
                this.maxScreenshots[i4].setMinimum(0);
                this.maxScreenshots[i4].setMaximum(Integer.MAX_VALUE);
                this.maxScreenshots[i4].setSelection(this.conf.getIntValue(engine.getSimpleName(), "multi_max_screenshot"));
            }
            Label filterLabel = new Label((Composite)consult, 0);
            filterLabel.setText(this.settings.msg("dialog.settings.platformfilter"));
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet")) {
                this.platformFilterValues[i4] = new Text((Composite)consult, 2818);
                this.platformFilterValues[i4].setLayoutData((Object)new GridData(4, 4, true, true));
                this.platformFilterValues[i4].setText(this.conf.getMultilineValues(engine.getSimpleName(), "platform_filter", this.platformFilterValues[i4].getLineDelimiter()));
                continue;
            }
            this.platformFilterValues[i4] = new Text((Composite)consult, 2048);
            this.platformFilterValues[i4].setLayoutData((Object)new GridData(4, 4, true, false));
            this.platformFilterValues[i4].setText(this.conf.getValue(engine.getSimpleName(), "platform_filter"));
        }
        TabItem envTabItem = new TabItem(tabFolder, 0);
        envTabItem.setText(this.settings.msg("dialog.settings.tab.environment"));
        Composite composite4 = new Composite((Composite)tabFolder, 0);
        composite4.setLayout((Layout)new GridLayout(1, true));
        envTabItem.setControl((Control)composite4);
        Group envGroup = new Group(composite4, 0);
        envGroup.setLayout((Layout)new GridLayout(2, false));
        GridData envLData = new GridData();
        envLData.grabExcessHorizontalSpace = true;
        envLData.horizontalAlignment = 4;
        envLData.grabExcessVerticalSpace = true;
        envLData.verticalAlignment = 4;
        envGroup.setLayoutData((Object)envLData);
        envGroup.setText(this.settings.msg("dialog.settings.environment"));
        Label enableEnvLabel = new Label((Composite)envGroup, 0);
        enableEnvLabel.setText(this.settings.msg("dialog.settings.enableenvironment"));
        final Button enableEnv = new Button((Composite)envGroup, 32);
        enableEnv.setSelection(this.conf.getBooleanValue("environment", "use"));
        enableEnv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.envValues.setEnabled(enableEnv.getSelection());
            }
        });
        Label envLabel = new Label((Composite)envGroup, 0);
        envLabel.setText(this.settings.msg("dialog.settings.environmentvariables"));
        this.envValues = new Text((Composite)envGroup, 2818);
        this.envValues.setLayoutData((Object)new GridData(4, 4, true, true));
        this.envValues.setText(this.conf.getMultilineValues("environment", "value", this.envValues.getLineDelimiter()));
        this.envValues.setEnabled(enableEnv.getSelection());
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new GridLayout(2, true));
        composite_7.setLayoutData((Object)"South");
        Button okButton = new Button(composite_7, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i;
                if (!SettingsDialog.this.isValid()) {
                    return;
                }
                SettingsDialog.this.changedVisColumns = this.haveColumnsBeenChanged();
                if (SettingsDialog.this.changedVisColumns) {
                    SettingsDialog.this.updateColumnSettings();
                }
                SettingsDialog.this.conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                SettingsDialog.this.conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                SettingsDialog.this.conf.setValue("communication", "port", SettingsDialog.this.port.getText());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "confpath", SettingsDialog.this.confLocation.getSelectionIndex());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "conffile", SettingsDialog.this.confFilename.getSelectionIndex());
                SettingsDialog.this.conf.setValue("locale", "language", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getLanguage());
                SettingsDialog.this.conf.setValue("locale", "country", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getCountry());
                SettingsDialog.this.conf.setValue("locale", "variant", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getVariant());
                for (i = 0; i < MainWindow.columnNames.length; ++i) {
                    SettingsDialog.this.conf.setBooleanValue("gui", "column" + (i + 1) + "visible", SettingsDialog.this.visibleColumns[SettingsDialog.this.allColumnIDs.indexOf(i)].getChecked());
                }
                SettingsDialog.this.conf.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
                for (i = 0; i < 10; ++i) {
                    SettingsDialog.this.conf.setValue("gui", "custom" + (i + 1), SettingsDialog.this.visibleColumns[SettingsDialog.this.allColumnIDs.indexOf(i + 10)].getText());
                }
                SettingsDialog.this.conf.setIntValue("gui", "screenshotsheight", SettingsDialog.this.screenshotsHeight.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotsfilename", displayFilename.getSelection());
                SettingsDialog.this.conf.setIntValue("gui", "screenshotscolumnheight", SettingsDialog.this.screenshotsColumnHeight.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotscolumnstretch", stretch.getSelection());
                SettingsDialog.this.conf.setBooleanValue("gui", "screenshotscolumnkeepaspectratio", keepAspectRatio.getSelection());
                Rectangle rec = SettingsDialog.this.shell.getBounds();
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_width", rec.width);
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_height", rec.height);
                SettingsDialog.this.conf.setIntValue("gui", "buttondisplay", SettingsDialog.this.buttonDisplay.getSelectionIndex());
                SettingsDialog.this.conf.setMultilineValues("gui", "notesfont", GeneralPurposeGUI.fontToString((Device)SettingsDialog.this.shell.getDisplay(), fontButton.getFont()), "|");
                for (int i2 = 0; i2 < NR_OF_ENGINES; ++i2) {
                    WebSearchEngine engine = EditProfileDialog.webSearchEngines.get(i2);
                    SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_title", SettingsDialog.this.setTitle[i2].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_developer", SettingsDialog.this.setDev[i2].getSelection());
                    if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("hotud")) {
                        SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_publisher", SettingsDialog.this.setPub[i2].getSelection());
                        SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_description", SettingsDialog.this.setDescr[i2].getSelection());
                    }
                    SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_year", SettingsDialog.this.setYear[i2].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_genre", SettingsDialog.this.setGenre[i2].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_link", SettingsDialog.this.setLink[i2].getSelection());
                    SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "set_rank", SettingsDialog.this.setRank[i2].getSelection());
                    if (engine.getSimpleName().equals("mobygames")) {
                        SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "choose_coverart", SettingsDialog.this.chooseCoverArt[i2].getSelection());
                        SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "force_all_regions_coverart", SettingsDialog.this.allRegionsCoverArt[i2].getSelection());
                        SettingsDialog.this.conf.setIntValue(engine.getSimpleName(), "multi_max_coverart", SettingsDialog.this.maxCoverArt[i2].getSelection());
                    }
                    if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet")) {
                        SettingsDialog.this.conf.setBooleanValue(engine.getSimpleName(), "choose_screenshot", SettingsDialog.this.chooseScreenshot[i2].getSelection());
                        SettingsDialog.this.conf.setIntValue(engine.getSimpleName(), "multi_max_screenshot", SettingsDialog.this.maxScreenshots[i2].getSelection());
                        SettingsDialog.this.conf.setMultilineValues(engine.getSimpleName(), "platform_filter", SettingsDialog.this.platformFilterValues[i2].getText(), SettingsDialog.this.platformFilterValues[i2].getLineDelimiter());
                        continue;
                    }
                    SettingsDialog.this.conf.setValue(engine.getSimpleName(), "platform_filter", SettingsDialog.this.platformFilterValues[i2].getText());
                }
                SettingsDialog.this.conf.setBooleanValue("environment", "use", enableEnv.getSelection());
                SettingsDialog.this.conf.setMultilineValues("environment", "value", SettingsDialog.this.envValues.getText(), SettingsDialog.this.envValues.getLineDelimiter());
                SettingsDialog.this.storeValues();
                SettingsDialog.this.settings.getSettings().injectValuesFrom(SettingsDialog.this.conf);
                SettingsDialog.this.shell.close();
            }

            private boolean haveColumnsBeenChanged() {
                for (int i = 0; i < MainWindow.columnNames.length; ++i) {
                    if (SettingsDialog.this.conf.getBooleanValue("gui", "column" + ((Integer)SettingsDialog.this.allColumnIDs.get(i) + 1) + "visible") == SettingsDialog.this.visibleColumns[i].getChecked() && (!SettingsDialog.this.visibleColumns[i].getChecked() || MainWindow.columnNames[(Integer)SettingsDialog.this.allColumnIDs.get(i)].equals(SettingsDialog.this.visibleColumns[i].getText()))) continue;
                    return true;
                }
                return false;
            }
        });
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData((Object)gridData);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData((Object)gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.shell.close();
            }
        });
    }

    private void storeValues() {
        if (this.previousSelection != -1) {
            this.conf.setMultilineValues("profile", this.options.getItem(this.previousSelection), this.values.getText(), this.values.getLineDelimiter());
        }
    }

    private int countVisibleColumns() {
        int result = 0;
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            ++result;
        }
        return result;
    }

    private int getFirstVisibleColumn() {
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            return i;
        }
        return -1;
    }

    private void updateColumnSettings() {
        int[] sort = this.conf.getIntValues("gui", "sortcolumn");
        boolean[] ascs = this.conf.getBooleanValues("gui", "sortascending");
        ArrayList<Integer> sortColumnIDs = new ArrayList<Integer>(sort.length);
        ArrayList<Boolean> sortColumnAscs = new ArrayList<Boolean>(sort.length);
        for (int i = 0; i < sort.length; ++i) {
            if (!this.visibleColumns[this.allColumnIDs.indexOf(sort[i])].getChecked()) continue;
            sortColumnIDs.add(sort[i]);
            sortColumnAscs.add(ascs[i]);
        }
        if (sortColumnIDs.isEmpty()) {
            sortColumnIDs.add(this.allColumnIDs.get(this.getFirstVisibleColumn()));
            sortColumnAscs.add(true);
        }
        this.conf.setIntValues("gui", "sortcolumn", ArrayUtils.toPrimitive((Integer[])sortColumnIDs.toArray(new Integer[0])));
        this.conf.setBooleanValues("gui", "sortascending", ArrayUtils.toPrimitive((Boolean[])sortColumnAscs.toArray(new Boolean[0])));
        ArrayList<Integer> visColumns = new ArrayList<Integer>();
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (!this.visibleColumns[i].getChecked()) continue;
            visColumns.add(this.allColumnIDs.get(i));
        }
        ArrayList orderedVisColumns = new ArrayList(visColumns);
        Collections.sort(orderedVisColumns);
        ArrayList<Integer> colOrder = new ArrayList<Integer>();
        Iterator i$ = visColumns.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            colOrder.add(orderedVisColumns.indexOf(id));
        }
        this.conf.setValue("gui", "columnorder", StringUtils.join(colOrder, (char)' '));
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.countVisibleColumns() == 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.settings.required.onevisiblecolumn"), (Control)this.visible_columns, this.columnsTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    static {
        for (Locale loc : Locale.getAvailableLocales()) {
            allLocales.put(loc.toString(), loc);
        }
        confLocations = new String[]{Settings.getInstance().msg("dialog.settings.confindbgldir"), Settings.getInstance().msg("dialog.settings.confingamedir")};
        confFilenames = new String[]{Settings.getInstance().msg("dialog.settings.conffilebyid"), Settings.getInstance().msg("dialog.settings.conffilebytitle")};
        buttonDisplayOptions = new String[]{Settings.getInstance().msg("dialog.settings.displaybuttonimageandtext"), Settings.getInstance().msg("dialog.settings.displaybuttontextonly"), Settings.getInstance().msg("dialog.settings.displaybuttonimageonly")};
    }
}

