/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.StringRelatedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSearchEngine {
    protected static final String HTTP_PROTOCOL = "http://";
    protected static final String HTML_HREF_OPEN = " href=\"";
    protected static final String HTML_SRC_OPEN = " src=\"";
    protected static final String HTML_QUOTE = "\"";
    protected static final String HTML_MOBY_OPEN = "</moby ";
    protected static final String HTML_MOBY_CLOSE = "</moby>";
    protected static final String HTML_SPAN_OPEN = "<span ";
    protected static final String HTML_SPAN_CLOSE = "</span>";
    protected static final String HTML_ANCHOR_OPEN = "<a ";
    protected static final String HTML_ANCHOR_CLOSE = "</a>";
    protected static final String HTML_DIV_OPEN = "<div";
    protected static final String HTML_DIV_CLOSE = "</div>";
    protected static final String HTML_BLOCKQUOTE_OPEN = "<blockquote>";
    protected static final String HTML_BLOCKQUOTE_CLOSE = "</blockquote>";
    protected static final String HTML_I_OPEN = "<i>";
    protected static final String HTML_I_CLOSE = "</i>";
    protected static final String HTML_UL_OPEN = "<ul>";
    protected static final String HTML_UL_CLOSE = "</ul>";
    protected static final String HTML_OL_OPEN = "<ol>";
    protected static final String HTML_OL_CLOSE = "</ol>";
    protected static final String HTML_LI_OPEN = "<li>";
    protected static final String HTML_LI_CLOSE = "</li>";
    protected static final String HTML_B_OPEN = "<b>";
    protected static final String HTML_B_CLOSE = "</b>";
    protected static final String HTML_STRONG_OPEN = "<strong>";
    protected static final String HTML_STRONG_CLOSE = "</strong>";
    protected static final String HTML_P_OPEN = "<p>";
    protected static final String HTML_PU_OPEN = "<p ";
    protected static final String HTML_P_CLOSE = "</p>";
    protected static final String HTML_EM_OPEN = "<em>";
    protected static final String HTML_EM_CLOSE = "</em>";
    protected static final String HTML_BR_UNCLOSED = "<br>";
    protected static final String HTML_BR_CLOSED = "<br/>";
    protected static final String HTML_BR_CLOSED_ALT = "<br />";
    protected static final String HTML_TD_OPEN = "<td>";
    protected static final String HTML_TD_CLOSE = "</td>";
    protected static final String HTML_TITLE_OPEN = "<title>";
    protected static final String HTML_TITLE_CLOSE = "</title>";

    public abstract String getIcon();

    public abstract String getName();

    public abstract String getSimpleName();

    public abstract WebProfile getEntryDetailedInformation(WebProfile var1) throws UnknownHostException, IOException;

    public abstract SearchEngineImageInformation[] getEntryImages(WebProfile var1, int var2, int var3, boolean var4) throws IOException;

    public abstract List<WebProfile> getEntries(String var1, String[] var2) throws IOException;

    public static int getEntryFirstExactMatchIndex(String title, List<WebProfile> profs) {
        for (int i = 0; i < profs.size(); ++i) {
            if (!title.equalsIgnoreCase(profs.get(i).getTitle())) continue;
            return i;
        }
        return -1;
    }

    public static int getEntryBestMatchIndex(String search, List<WebProfile> profs) {
        String[] titles = new String[profs.size()];
        for (int i = 0; i < profs.size(); ++i) {
            titles[i] = profs.get(i).getTitle();
        }
        return StringRelatedUtils.findBestMatchIndex(search, titles);
    }

    public static InputStream getInputStream(String url) throws IOException {
        try {
            URL urlConnection = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)urlConnection.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(20000);
            return conn.getInputStream();
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    protected static String getResponseContent(String url, String charsetName) throws IOException {
        try {
            String str;
            BufferedReader in = new BufferedReader(new InputStreamReader(WebSearchEngine.getInputStream(url), charsetName));
            StringBuffer result = new StringBuffer(8192);
            while ((str = in.readLine()) != null) {
                result.append(str);
            }
            in.close();
            return result.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected static String absoluteUrl(String hostName, String url) {
        return url.startsWith(HTTP_PROTOCOL) ? url : HTTP_PROTOCOL + hostName + (url.charAt(0) == '/' ? "" : Character.valueOf('/')) + url;
    }

    protected static String extractNextContent(String htmlChunk, int startIndex, String openTag, String closeTag) {
        int divStartIndex = htmlChunk.indexOf(openTag, startIndex);
        divStartIndex = htmlChunk.indexOf(">", divStartIndex) + 1;
        int divEndIndex = htmlChunk.indexOf(closeTag, divStartIndex);
        return htmlChunk.substring(divStartIndex, divEndIndex);
    }

    protected static String extractNextHrefContent(String htmlChunk, int startIndex) {
        int aStartIndex = htmlChunk.indexOf(HTML_HREF_OPEN, startIndex) + HTML_HREF_OPEN.length();
        int aEndIndex = htmlChunk.indexOf(HTML_QUOTE, aStartIndex);
        return htmlChunk.substring(aStartIndex, aEndIndex);
    }

    protected static int idxNextHrefContent(String htmlChunk, int startIndex) {
        int idx = htmlChunk.indexOf(HTML_ANCHOR_OPEN, startIndex);
        if (idx != -1 && htmlChunk.indexOf(HTML_ANCHOR_CLOSE, idx + HTML_ANCHOR_OPEN.length()) != -1) {
            return idx;
        }
        return -1;
    }

    protected static String extractNextSrcContent(String htmlChunk, int startIndex) {
        int aStartIndex = htmlChunk.indexOf(HTML_SRC_OPEN, startIndex) + HTML_SRC_OPEN.length();
        int aEndIndex = htmlChunk.indexOf(HTML_QUOTE, aStartIndex);
        return htmlChunk.substring(aStartIndex, aEndIndex);
    }

    protected static String removeAllTags(String htmlChunk) {
        String result = WebSearchEngine.removeTag(HTML_DIV_OPEN, HTML_DIV_CLOSE, htmlChunk);
        result = WebSearchEngine.removeTag(HTML_ANCHOR_OPEN, HTML_ANCHOR_CLOSE, result);
        result = WebSearchEngine.removeTag(HTML_MOBY_OPEN, HTML_MOBY_CLOSE, result);
        result = WebSearchEngine.replaceTag(HTML_I_OPEN, HTML_I_CLOSE, "", "", result);
        result = WebSearchEngine.replaceTag(HTML_B_OPEN, HTML_B_CLOSE, "", "", result);
        result = WebSearchEngine.replaceTag(HTML_STRONG_OPEN, HTML_STRONG_CLOSE, "", "", result);
        result = WebSearchEngine.replaceTag(HTML_LI_OPEN, HTML_LI_CLOSE, "", "\n", result);
        result = WebSearchEngine.replaceTag(HTML_EM_OPEN, HTML_EM_CLOSE, "", "", result);
        result = WebSearchEngine.replaceTag(HTML_UL_OPEN, HTML_UL_CLOSE, "\n\n", "\n", result);
        result = WebSearchEngine.replaceTag(HTML_OL_OPEN, HTML_OL_CLOSE, "\n\n", "\n", result);
        result = WebSearchEngine.replaceTag(HTML_BLOCKQUOTE_OPEN, HTML_BLOCKQUOTE_CLOSE, "\n\n", "\n", result);
        result = result.replaceAll("</p>\\s*<p>", "\n\n");
        result = WebSearchEngine.replaceTag(HTML_P_OPEN, HTML_P_CLOSE, "\n", "", result);
        return result;
    }

    protected static String replaceTag(String openTag, String closeTag, String r1, String r2, String htmlChunk) {
        return WebSearchEngine.replaceTag(closeTag, r2, WebSearchEngine.replaceTag(openTag, r1, htmlChunk));
    }

    protected static String replaceTag(String openTag, String r1, String htmlChunk) {
        return htmlChunk.replace(openTag, r1).replace(openTag.toUpperCase(), r1);
    }

    protected static String removeTag(String openTag, String closeTag, String htmlChunk) {
        StringBuffer result = new StringBuffer(htmlChunk);
        int openingIndex = StringUtils.indexOfIgnoreCase((CharSequence)result, (CharSequence)openTag);
        while (openingIndex != -1) {
            result.delete(openingIndex, result.indexOf(">", openingIndex + openTag.length()) + 1);
            int closingIndex = StringUtils.indexOfIgnoreCase((CharSequence)result, (CharSequence)closeTag);
            result.delete(closingIndex, closingIndex + closeTag.length());
            openingIndex = StringUtils.indexOfIgnoreCase((CharSequence)result, (CharSequence)openTag);
        }
        return result.toString();
    }

    protected static String unescapeHtml(String htmlChunk) {
        String result = WebSearchEngine.replaceTag(HTML_BR_UNCLOSED, "\n", htmlChunk);
        result = WebSearchEngine.replaceTag(HTML_BR_CLOSED, "\n", result);
        result = WebSearchEngine.replaceTag(HTML_BR_CLOSED_ALT, "\n", result);
        result = WebSearchEngine.replaceTag("&nbsp;", " ", result);
        return StringEscapeUtils.unescapeHtml4((String)StringUtils.strip((String)result));
    }

    private static boolean isAllowed(WebProfile prof, String[] platforms) {
        boolean allowed = platforms.length == 0;
        for (String p : platforms) {
            if (!prof.getPlatform().equalsIgnoreCase(p)) continue;
            return true;
        }
        return allowed;
    }

    protected static List<WebProfile> filterEntries(String[] platforms, List<WebProfile> allEntries) {
        ArrayList<WebProfile> entries = new ArrayList();
        for (WebProfile prof : allEntries) {
            if (!WebSearchEngine.isAllowed(prof, platforms)) continue;
            entries.add(prof);
        }
        if (entries.isEmpty()) {
            entries = allEntries;
        }
        Collections.sort(entries);
        return entries;
    }
}

