/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dbgl.waldheinz.fs.fat.BlockDevice;

class Sector {
    private final BlockDevice device;
    protected final long offset;
    protected final ByteBuffer buffer;

    protected Sector(BlockDevice device, long offset, int size) {
        this.offset = offset;
        this.device = device;
        this.buffer = ByteBuffer.allocate(size);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected void read() throws IOException {
        this.buffer.rewind();
        this.buffer.limit(this.buffer.capacity());
        this.device.read(this.offset, this.buffer);
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    protected int get16(int offset) {
        return this.buffer.getShort(offset) & 0xFFFF;
    }

    protected long get32(int offset) {
        return this.buffer.getInt(offset);
    }

    protected int get8(int offset) {
        return this.buffer.get(offset) & 0xFF;
    }
}

