/*
 * Decompiled with CFR 0.152.
 */
package exodos;

import exodos.model.GameData;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convert {
    private static final String GAMES_DIR = "games";
    private static final String UTIL_DIR = "util";
    private static final String MEAGRE_DIR = "Meagre";
    private static final String INIFILE_DIR = "IniFile";
    private static final String ABOUT_DIR = "About";
    private static final String EXTRAS_DIR = "Extras";
    private static final String MANUAL_DIR = "Manual";
    private static final String FRONT_DIR = "Front";
    private static final String BACK_DIR = "Back";
    private static final String MEDIA_DIR = "Media";
    private static final String ADVERT_DIR = "Advert";
    private static final String TITLE_DIR = "Title";
    private static final String SCREEN_DIR = "Screen";
    private static final String[] CAP_DIRS = new String[]{"Title", "Screen", "Front", "Back", "Media", "Advert"};
    private static final String GPA_TITLE = "eXoDOS conversion";
    private static final String GPA_NOTES = "";
    private static final String GPA_AUTHOR = "";
    private static final long MAX_PART_SIZE = 0x80000000L;
    private static final String[] CDIMAGES = new String[]{".iso", ".cue", ".bin", ".img", ".gog"};
    private static final Settings settings = Settings.getInstance();
    private static boolean verboseOutput = false;

    public static void main(String[] args) {
        System.out.println("Converts eXoDOS game packages into DBGL GamePackArchives (v0.2)\n");
        if (args.length < 2 || args.length > 5) {
            Convert.displaySyntax();
        }
        File inputDir = new File(args[0]);
        File tmpDir = new File(args[1]);
        boolean analyzeOnly = false;
        boolean keepExtractedMetaData = false;
        if (args.length > 2) {
            for (int i = 2; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-a")) {
                    analyzeOnly = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-k")) {
                    keepExtractedMetaData = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-v")) {
                    verboseOutput = true;
                    continue;
                }
                Convert.displaySyntax();
            }
        }
        File inputGamesZip = Convert.validateParameters(inputDir, tmpDir);
        File gamesDir = new File(inputDir, GAMES_DIR);
        List<DosboxVersion> dbversionsList = null;
        try {
            dbversionsList = Database.getInstance().readDosboxVersionsList();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (analyzeOnly) {
            System.out.println("* Analyze only");
        }
        if (keepExtractedMetaData) {
            System.out.println("* Keeping extracted data after processing");
        }
        if (verboseOutput) {
            System.out.println("* Verbose output");
        }
        File gamesGamesDir = Convert.extractMeagreMetaData(inputGamesZip, tmpDir);
        List<GameData> expProfileList = Convert.analyzeMeagreMetaData(gamesDir, gamesGamesDir, dbversionsList);
        if (!analyzeOnly) {
            Convert.generateGamePackArchives(expProfileList, tmpDir, FilenameUtils.removeExtension(inputGamesZip.getName()), dbversionsList);
        }
        if (!keepExtractedMetaData) {
            Convert.cleanup(gamesGamesDir);
        }
    }

    private static void displaySyntax() {
        System.out.println("Use: Convert <inputexodosdir> <dstdir> [-a] [-v]");
        System.out.println("-a\t\tAnalyze only, don't generate gamepackarchives");
        System.out.println("-k\t\tKeep extracted meta data files after processing");
        System.out.println("-v\t\tVerbose output");
        System.exit(1);
    }

    private static File validateParameters(File inputDir, File tmpDir) {
        File inputGamesZip;
        File utilDir;
        File gamesDir;
        if (!inputDir.exists()) {
            System.out.println("The directory [" + inputDir + "] does not exist, exiting.");
            System.exit(1);
        }
        if (!(gamesDir = new File(inputDir, GAMES_DIR)).exists()) {
            System.out.println("The directory [" + inputDir + "] does not contain the [" + GAMES_DIR + "] directory, exiting.");
            System.exit(1);
        }
        if (!(utilDir = new File(inputDir, UTIL_DIR)).exists()) {
            System.out.println("The directory [" + inputDir + "] does not contain the [" + UTIL_DIR + "] directory, exiting.");
            System.exit(1);
        }
        if (!org.dbgl.util.FileUtils.isExistingFile(inputGamesZip = new File(gamesDir, "GamesSTR.zip"))) {
            inputGamesZip = new File(gamesDir, "GamesSIM.zip");
        }
        if (!org.dbgl.util.FileUtils.isExistingFile(inputGamesZip)) {
            inputGamesZip = new File(gamesDir, "GamesRPG.zip");
        }
        if (!org.dbgl.util.FileUtils.isExistingFile(inputGamesZip)) {
            inputGamesZip = new File(gamesDir, "GamesADV.zip");
        }
        if (!org.dbgl.util.FileUtils.isExistingFile(inputGamesZip)) {
            inputGamesZip = new File(gamesDir, "GamesACT.zip");
        }
        if (!org.dbgl.util.FileUtils.isExistingFile(inputGamesZip)) {
            inputGamesZip = new File(gamesDir, "Games.zip");
        }
        if (!org.dbgl.util.FileUtils.isExistingFile(inputGamesZip)) {
            System.out.println("The file [" + inputGamesZip + "] does not exist, exiting.");
            System.exit(1);
        }
        if (!tmpDir.exists()) {
            System.out.println("The directory [" + tmpDir + "] does not exist, exiting.");
            System.exit(1);
        }
        return inputGamesZip;
    }

    private static File extractMeagreMetaData(File inputGamesZip, File tmpDir) {
        System.out.println();
        System.out.println("===========================================");
        System.out.println(" Phase 1 of 3: Extracting Meagre meta-data");
        System.out.println("===========================================");
        System.out.println("Reading from: [" + inputGamesZip + "]");
        System.out.println("Writing to:   [" + tmpDir + "]");
        try {
            File gamesGamesDir;
            String mainGamesDir = Convert.findMainFolder(inputGamesZip);
            if (mainGamesDir == null) {
                System.out.println("The file [" + inputGamesZip + "] does not seem to have an inner games directory, exiting.");
                System.exit(1);
            }
            if (!(gamesGamesDir = new File(tmpDir, mainGamesDir)).exists()) {
                Convert.unzip(inputGamesZip, tmpDir);
            } else {
                System.out.println("Skipping extraction of [" + inputGamesZip + "] since [" + gamesGamesDir + "] already exists");
            }
            return gamesGamesDir;
        }
        catch (IOException e) {
            System.out.println("The file [" + inputGamesZip + "] did not fully extract into the [" + tmpDir + "] directory, exiting.");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static List<GameData> analyzeMeagreMetaData(File gamesDir, File gamesGamesDir, List<DosboxVersion> dbversionsList) {
        System.out.println();
        System.out.println("==========================================");
        System.out.println(" Phase 2 of 3: Analyzing Meagre meta-data");
        System.out.println("==========================================");
        System.out.println("Reading from: [" + gamesGamesDir + "]");
        PrintStream ps = new PrintStream(System.out);
        ArrayList<GameData> expProfileList = new ArrayList<GameData>();
        File[] gameDirs = gamesGamesDir.listFiles();
        Arrays.sort(gameDirs, new FileIgnoreCaseComparator());
        for (int i = 0; i < gameDirs.length; ++i) {
            File gameDir = gameDirs[i];
            File meagreDir = new File(gameDir, MEAGRE_DIR);
            File iniFileDir = new File(meagreDir, INIFILE_DIR);
            File[] iniFiles = iniFileDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".ini");
                }
            });
            if (iniFiles.length != 1) {
                System.out.println("SKIPPED " + gameDir.getName() + ": Not exactly 1 ini file found (" + iniFiles.length + ")");
                continue;
            }
            File iniFile = iniFiles[0];
            try {
                boolean multipleRootEntries;
                String main;
                List<File> list;
                Conf iniConf = new Conf(iniFile, ps);
                SectionsWrapper ini = iniConf.getSettings();
                String title = ini.getValue("Main", "name");
                String devName = Convert.join(new String[]{ini.getValue("Main", "developer"), ini.getValue("Main", "designer"), ini.getValue("Main", "designer2")}, ", ");
                String publName = ini.getValue("Main", "publisher");
                String genre = Convert.join(new String[]{ini.getValue("Main", "genre"), ini.getValue("Main", "subgenre"), ini.getValue("Main", "subgenre2")}, ", ");
                String year = ini.getValue("Main", "year");
                String status = "";
                String aboutFilename = ini.getValue("Main", "about");
                String notes = StringUtils.isBlank((CharSequence)aboutFilename) ? "" : FileUtils.readFileToString(new File(meagreDir, ABOUT_DIR + File.separatorChar + aboutFilename));
                boolean favorite = false;
                String[] setup = new String[]{"", "", ""};
                String[] setupParams = new String[]{"", "", ""};
                String confPathAndFile = new File(gameDir, "dosbox.conf").getPath();
                String captures = org.dbgl.util.FileUtils.constructCapturesDir(i);
                int dbversionId = 0;
                String[] links = new String[]{ini.getValue("Main", "extralink1"), ini.getValue("Main", "manual"), ini.getValue("Main", "extralink2"), ini.getValue("Main", "extralink3"), ini.getValue("Main", "extralink4"), ini.getValue("Main", "extralink5"), ini.getValue("Main", "extralink6"), ini.getValue("Main", "extralink7")};
                String[] linkTitles = new String[]{ini.getValue("Main", "extra1"), MANUAL_DIR, ini.getValue("Main", "extra2"), ini.getValue("Main", "extra3"), ini.getValue("Main", "extra4"), ini.getValue("Main", "extra5"), ini.getValue("Main", "extra6"), ini.getValue("Main", "extra7")};
                String[] customStrings = new String[]{"", "", "", "", "", "", "", ""};
                int[] customInts = new int[]{0, 0};
                String[] capFilenames = new String[]{ini.getValue("Main", "title01"), ini.getValue("Main", "screen01"), ini.getValue("Main", "front01"), ini.getValue("Main", "back01"), ini.getValue("Main", "media01"), ini.getValue("Main", "adv01")};
                ArrayList<File> capFiles = new ArrayList<File>();
                for (int c = 0; c < capFilenames.length; ++c) {
                    if (!StringUtils.isNotEmpty((CharSequence)capFilenames[c])) continue;
                    File capFile = new File(meagreDir, CAP_DIRS[c] + File.separatorChar + capFilenames[c]);
                    if (org.dbgl.util.FileUtils.isExistingFile(capFile)) {
                        capFiles.add(capFile);
                        continue;
                    }
                    System.out.println("WARNING: " + gameDir.getName() + ": capture [" + capFile + "] not found, skipped");
                }
                ArrayList<File> extraFiles = new ArrayList<File>();
                for (int c = 0; c < links.length; ++c) {
                    String link = links[c];
                    if (!StringUtils.isNotEmpty((CharSequence)link) || link.toLowerCase().startsWith("http")) continue;
                    File extraFile = new File(meagreDir, (c == 1 ? MANUAL_DIR : EXTRAS_DIR) + File.separatorChar + link);
                    if (org.dbgl.util.FileUtils.isExistingFile(extraFile)) {
                        extraFiles.add(extraFile);
                        links[c] = org.dbgl.util.FileUtils.DOSROOT_DIR + gameDir.getName() + File.separatorChar + EXTRAS_DIR + File.separatorChar + extraFile.getName();
                        continue;
                    }
                    System.out.println("WARNING: " + gameDir.getName() + ": linked file [" + extraFile + "] not found, skipped");
                }
                Profile profile = new Profile(i, title, devName, publName, genre, year, status, notes, favorite, setup, setupParams, confPathAndFile, captures, dbversionId, links, linkTitles, customStrings, customInts);
                Conf conf = new Conf(profile, DosboxVersion.findById(dbversionsList, profile.getDbversionId()), ps);
                Autoexec autoexec = conf.getAutoexec();
                if (autoexec.isIncomplete()) {
                    System.out.println("WARNING: " + gameDir.getName() + ": This profile's autoexec section seems incomplete");
                }
                autoexec.migrateToDosroot(org.dbgl.util.FileUtils.canonicalToDosroot(GAMES_DIR), true);
                File zipFile = new File(gamesDir, FilenameUtils.getBaseName(ini.getValue("Main", "executable")) + ".zip");
                if (!org.dbgl.util.FileUtils.isExistingFile(zipFile)) {
                    File installFile;
                    if (verboseOutput) {
                        System.out.println("Zip file " + zipFile + " not found, reverting to Install.bat to determine game zip");
                    }
                    if (org.dbgl.util.FileUtils.isExistingFile(installFile = new File(gameDir, "Install.bat"))) {
                        List<String> lines = FileUtils.readLines(installFile);
                        for (String s : lines) {
                            int secondQuotes;
                            if (!s.startsWith("unzip \"") || (secondQuotes = s.lastIndexOf(34)) == -1) continue;
                            zipFile = new File(gamesDir, s.substring(7, secondQuotes));
                            if (!verboseOutput) break;
                            System.out.println("Zip file " + zipFile + " referenced in Install.bat, using that file instead");
                            break;
                        }
                    }
                }
                if (!Convert.fixupFileLocations(list = Convert.readFilesInZip(zipFile), autoexec) && StringUtils.isNotEmpty((CharSequence)(main = autoexec.getActualMain()))) {
                    System.out.println("WARNING: " + gameDir.getName() + ": Main file [" + main + "] not found inside [" + zipFile + "]");
                }
                if (multipleRootEntries = Convert.isMultipleRootEntries(list)) {
                    autoexec.updateForTargetImportBaseDir(gameDir);
                    if (verboseOutput) {
                        System.out.println("INFO: " + gameDir.getName() + " is moved one directory level deeper");
                    }
                }
                expProfileList.add(new GameData(new ExpProfile(i, conf, new File(gameDir.getName()), null, profile), capFiles, extraFiles, zipFile, multipleRootEntries));
                continue;
            }
            catch (IOException e) {
                System.out.println("SKIPPED " + gameDir.getName() + " " + e.toString());
            }
        }
        Collections.sort(expProfileList);
        System.out.println("Analysis done");
        return expProfileList;
    }

    private static void generateGamePackArchives(List<GameData> expProfileList, File tmpDir, String baseFilename, List<DosboxVersion> dbversionsList) {
        try {
            System.out.println();
            System.out.println("===========================================");
            System.out.println(" Phase 3 of 3: Generating GamePackArchives");
            System.out.println("===========================================");
            while (!expProfileList.isEmpty()) {
                long totalSize = 0L;
                ArrayList<GameData> gpaProfileList = new ArrayList<GameData>();
                boolean reachedMaxSize = false;
                while (!expProfileList.isEmpty() && !reachedMaxSize) {
                    GameData game = expProfileList.get(0);
                    try {
                        long gameSize = Convert.determineSize(game);
                        if (gpaProfileList.isEmpty() || totalSize + gameSize < 0x80000000L) {
                            gpaProfileList.add(game);
                            expProfileList.remove(0);
                            totalSize += gameSize;
                            continue;
                        }
                        reachedMaxSize = true;
                    }
                    catch (IOException e) {
                        System.out.println("skipping " + game.getExpProfile().getTitle() + ", " + e.toString());
                        expProfileList.remove(0);
                    }
                }
                ArrayList<ExpProfile> pList = new ArrayList<ExpProfile>();
                for (GameData game : gpaProfileList) {
                    pList.add(game.getExpProfile());
                }
                File currentOutputGpa = new File(tmpDir, baseFilename + "__" + org.dbgl.util.FileUtils.fileSystemSafe(((GameData)gpaProfileList.get(0)).getExpProfile().getTitle()) + " - " + org.dbgl.util.FileUtils.fileSystemSafe(((GameData)gpaProfileList.get(gpaProfileList.size() - 1)).getExpProfile().getTitle()) + ".dbgl.zip");
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(currentOutputGpa));
                for (GameData game : gpaProfileList) {
                    boolean shouldBeMovedDeeper = false;
                    try {
                        ExpProfile prof = game.getExpProfile();
                        System.out.print("Exporting " + prof.getTitle() + " ");
                        File captures = new File(org.dbgl.util.FileUtils.constructCapturesDir(prof.getId()));
                        try {
                            List<File> capsList = game.getCapturesList();
                            for (int c = 0; c < capsList.size(); ++c) {
                                File srcCapFile = capsList.get(c);
                                org.dbgl.util.FileUtils.zipEntry(srcCapFile, new File(captures, String.valueOf(c) + "_" + srcCapFile.getName()), zos);
                            }
                        }
                        catch (IOException e) {
                            throw new IOException(settings.msg("dialog.export.error.exportcaptures", new Object[]{prof.getTitle(), StringRelatedUtils.toString(e)}), e);
                        }
                        File relativeGameDirInZip = new File(org.dbgl.util.FileUtils.DOSROOT_DIR, String.valueOf(prof.getId()));
                        File relativeExtrasGameDirInZip = new File(new File(relativeGameDirInZip, prof.getGameDir().getPath()), EXTRAS_DIR);
                        try {
                            List<File> extrasList = game.getExtrasList();
                            for (int c = 0; c < extrasList.size(); ++c) {
                                File srcExtraFile = extrasList.get(c);
                                org.dbgl.util.FileUtils.zipEntry(srcExtraFile, new File(relativeExtrasGameDirInZip, srcExtraFile.getName()), zos);
                            }
                            if (shouldBeMovedDeeper) {
                                relativeGameDirInZip = new File(relativeGameDirInZip, prof.getGameDir().getPath());
                            }
                            Convert.copyZipData(game.getZipFile(), relativeGameDirInZip, zos);
                        }
                        catch (IOException e) {
                            throw new IOException(settings.msg("dialog.export.error.exportgamedata", new Object[]{prof.getTitle(), StringRelatedUtils.toString(e)}), e);
                        }
                    }
                    catch (IOException e2) {
                        System.out.println("WARNING: The file [" + game.getZipFile() + "] could not be copied (completely) properly into the [" + currentOutputGpa + "], this game may be corrupt");
                        e2.printStackTrace();
                    }
                }
                Document xmlDoc = XmlUtils.getFullProfilesXML(pList, dbversionsList, GPA_TITLE, "", "", true, false, false, true);
                XmlUtils.domToZipOutputStream(xmlDoc, new File("profiles.xml"), zos);
                zos.close();
                System.out.println("DBGL GamePackArchive " + currentOutputGpa + " succesfully generated.");
            }
            System.out.println("Finished.");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void cleanup(File gamesDir) {
        try {
            FileUtils.deleteDirectory(gamesDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isMultipleRootEntries(List<File> list) {
        int found = 0;
        for (File file : list) {
            if (file.getParentFile() != null) continue;
            ++found;
        }
        return found >= 1;
    }

    private static boolean fixupFileLocations(List<File> list, Autoexec autoexec) {
        File parent2;
        int fatIdx;
        String main = autoexec.getActualMain();
        File mainFile = new File(main);
        int isoIdx = Convert.containsIso(mainFile.getPath());
        if (isoIdx != -1) {
            mainFile = new File(mainFile.getPath().substring(0, isoIdx));
        }
        if ((fatIdx = org.dbgl.util.FileUtils.containsFatImage(mainFile.getPath())) != -1) {
            mainFile = new File(mainFile.getPath().substring(0, fatIdx));
        }
        if (list.contains(mainFile)) {
            return true;
        }
        File newMainFile = Convert.findSuitableExtension(mainFile, list);
        if (newMainFile != null) {
            autoexec.setActualMain(newMainFile);
            if (verboseOutput) {
                System.out.println("Main file [" + mainFile + "] was using wrong file extension, changed to [" + newMainFile.getPath() + "].");
            }
            return true;
        }
        File parent1 = mainFile.getParentFile();
        if (parent1 != null && (parent2 = parent1.getParentFile()) != null) {
            newMainFile = new File(parent2, mainFile.getName());
            if (list.contains(newMainFile)) {
                autoexec.setActualMainPath(parent2);
                if (verboseOutput) {
                    System.out.println("Main file [" + mainFile + "] redirected to parent directory [" + parent2.getPath() + "].");
                }
                return true;
            }
            if ((newMainFile = Convert.findSuitableExtension(newMainFile, list)) != null) {
                autoexec.setActualMain(newMainFile);
                if (verboseOutput) {
                    System.out.println("Main file [" + mainFile + "] was using wrong file extension and dir, changed to [" + newMainFile.getPath() + "].");
                }
                return true;
            }
        }
        return false;
    }

    private static int containsIso(String mountPath) {
        for (String ext : CDIMAGES) {
            int idx = mountPath.toLowerCase().indexOf(ext + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> readFilesInZip(File zipFile) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        ZipFile zfile = null;
        try {
            zfile = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                try {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    result.add(new File(PlatformUtils.archiveToNativePath(name)));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("WARNING: Zip file [" + zipFile + "] contains an entry with problematic characters in its filename");
                }
            }
        }
        finally {
            if (zfile != null) {
                zfile.close();
            }
        }
        return result;
    }

    private static long determineSize(GameData game) throws IOException {
        try {
            long result = FileUtils.sizeOf(game.getZipFile());
            for (File file : game.getExtrasList()) {
                result += FileUtils.sizeOf(file);
            }
            for (File file : game.getCapturesList()) {
                result += FileUtils.sizeOf(file);
            }
            return result += 4096L;
        }
        catch (Exception e) {
            throw new IOException("Could not determine game size " + e.toString());
        }
    }

    private static int sizeInKB(ZipFile zf) throws IOException {
        int kb = 0;
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            try {
                ZipEntry entry = entries.nextElement();
                kb = (int)((long)kb + entry.getSize() / 1024L);
            }
            catch (IllegalArgumentException e) {
                System.out.println("WARNING: Zip file [" + zf.getName() + "] contains an entry with problematic characters in its filename");
            }
        }
        return kb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findMainFolder(File zipFile) throws IOException {
        ZipFile zfile = null;
        try {
            zfile = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                try {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.isDirectory()) continue;
                    String string = entry.getName();
                    return string;
                }
                catch (IllegalArgumentException e) {
                    System.out.println("WARNING: Zip file [" + zipFile + "] contains an entry with problematic characters in its filename");
                }
            }
        }
        finally {
            if (zfile != null) {
                zfile.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(final File zipFile, File dstDir) throws IOException {
        ProgressNotifyable prog = new ProgressNotifyable(){
            private int tot = 0;
            private int prog = 0;

            public void setTotal(int total) {
                this.tot = total;
            }

            public void incrProgress(int progress) {
                this.prog += progress;
                System.out.printf("\rExtracting %s: %3.1f%%", zipFile, (double)this.prog * 100.0 / (double)this.tot);
            }

            public void setProgress(int progress) {
            }
        };
        ZipFile zfile = null;
        try {
            zfile = new ZipFile(zipFile);
            prog.setTotal(Convert.sizeInKB(zfile));
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                try {
                    ZipEntry entry = entries.nextElement();
                    File dstFile = new File(dstDir, entry.getName());
                    org.dbgl.util.FileUtils.extractEntry(zfile, entry, dstFile, prog);
                }
                catch (IllegalArgumentException e) {
                    System.out.println("WARNING: Zip file [" + zipFile + "] contains an entry with problematic characters in its filename");
                }
            }
            System.out.printf("\rExtracting %s: Done  \n", zipFile);
        }
        finally {
            if (zfile != null) {
                zfile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipData(File srcFile, File baseDirectory, ZipOutputStream zos) throws ZipException, IOException {
        ZipFile srcZipFile = null;
        int nr = 0;
        try {
            srcZipFile = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> entries = srcZipFile.entries();
            while (entries.hasMoreElements()) {
                try {
                    ZipEntry srcEntry = entries.nextElement();
                    File dstFilename = new File(baseDirectory, srcEntry.getName());
                    ZipEntry dstEntry = new ZipEntry(PlatformUtils.toArchivePath(dstFilename, srcEntry.isDirectory()));
                    dstEntry.setComment(srcEntry.getComment());
                    dstEntry.setTime(srcEntry.getTime());
                    dstEntry.setExtra(srcEntry.getExtra());
                    zos.putNextEntry(dstEntry);
                    if (!srcEntry.isDirectory()) {
                        IOUtils.copyLarge(srcZipFile.getInputStream(srcEntry), zos);
                    }
                    zos.closeEntry();
                    if (nr++ % 4 != 0) continue;
                    System.out.print(".");
                }
                catch (IllegalArgumentException e) {
                    System.out.println("WARNING: Zip file [" + srcFile + "] contains an entry with problematic characters in its filename");
                }
            }
            System.out.println(" done.");
        }
        finally {
            if (srcZipFile != null) {
                srcZipFile.close();
            }
        }
    }

    private static File findSuitableExtension(File mainFile, List<File> list) {
        for (int i = 0; i < org.dbgl.util.FileUtils.EXECUTABLES.length; ++i) {
            File newMainFile = new File(FilenameUtils.removeExtension(mainFile.getPath()) + org.dbgl.util.FileUtils.EXECUTABLES[i]);
            if (!list.contains(newMainFile)) continue;
            return newMainFile;
        }
        return null;
    }

    public static String join(String[] array, String separator) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String s : array) {
            if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
            if (!first) {
                buf.append(separator);
            }
            buf.append(s);
            first = false;
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileIgnoreCaseComparator
    implements Comparator<File> {
        @Override
        public int compare(File file1, File file2) {
            return file1.getPath().compareToIgnoreCase(file2.getPath());
        }
    }
}

