/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Collections;
import java.util.List;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowseSearchEngineDialog
extends Dialog {
    private String title;
    private List<WebProfile> profs = null;
    private WebSearchEngine engine;
    private Object result;
    private Shell shell;
    private Settings settings = Settings.getInstance();

    public BrowseSearchEngineDialog(Shell parent, int style) {
        super(parent, style);
    }

    public BrowseSearchEngineDialog(Shell parent) {
        this(parent, 0);
    }

    public void setProfilesToBrowse(String title, List<WebProfile> profs) {
        this.title = title;
        this.profs = profs;
    }

    public void setEngine(WebSearchEngine engine) {
        this.engine = engine;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        int i;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "mobygamesbrowser"));
        this.shell.setText(this.settings.msg("dialog.searchenginebrowser.title", new String[]{this.engine.getName()}));
        final Table table = new Table((Composite)this.shell, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int selIndex = table.getSelectionIndex();
                WebProfile selWebProfile = (WebProfile)BrowseSearchEngineDialog.this.profs.get(selIndex);
                TableColumn column = (TableColumn)e.widget;
                int index = (Integer)column.getData();
                switch (index) {
                    case 0: {
                        Collections.sort(BrowseSearchEngineDialog.this.profs, new WebProfile.byTitle());
                        break;
                    }
                    case 1: {
                        Collections.sort(BrowseSearchEngineDialog.this.profs, new WebProfile.byYear());
                        break;
                    }
                    case 2: {
                        Collections.sort(BrowseSearchEngineDialog.this.profs, new WebProfile.byPlatform());
                        break;
                    }
                }
                table.removeAll();
                BrowseSearchEngineDialog.this.populate(table);
                table.setSortColumn(column);
                table.setSortDirection(128);
                for (int i = 0; i < BrowseSearchEngineDialog.this.profs.size(); ++i) {
                    if (selWebProfile != BrowseSearchEngineDialog.this.profs.get(i)) continue;
                    table.setSelection(i);
                    break;
                }
            }
        };
        String[] titles = new String[]{this.settings.msg("dialog.profile.title"), this.settings.msg("dialog.profile.year"), this.settings.msg("dialog.searchenginebrowser.column.platform")};
        for (i = 0; i < titles.length; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setData((Object)i);
            column.addListener(13, sortListener);
            if (i != 0) continue;
            table.setSortColumn(column);
            table.setSortDirection(128);
        }
        this.populate(table);
        for (i = 0; i < titles.length; ++i) {
            table.getColumn(i).pack();
        }
        table.setSelection(WebSearchEngine.getEntryBestMatchIndex(this.title, this.profs));
        table.showSelection();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                BrowseSearchEngineDialog.this.result = table.getSelectionIndex();
                BrowseSearchEngineDialog.this.shell.close();
            }
        });
        Button okButton = new Button((Composite)this.shell, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseSearchEngineDialog.this.result = table.getSelectionIndex();
                BrowseSearchEngineDialog.this.shell.close();
            }
        });
        okButton.setLayoutData((Object)new GridData(80, -1));
        this.shell.setDefaultButton(okButton);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button((Composite)this.shell, 0);
        cancelButton.setLayoutData((Object)new GridData(80, -1));
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowseSearchEngineDialog.this.result = null;
                BrowseSearchEngineDialog.this.shell.close();
            }
        });
    }

    private void populate(Table table) {
        for (WebProfile p : this.profs) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, p.getTitle());
            item.setText(1, p.getYear());
            item.setText(2, p.getPlatform());
        }
    }
}

