/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Collections;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.SearchEngineThread;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditMultiProfileDialog
extends EditProfileDialog {
    private Label profileLabel;
    private ProgressBar progressBar;
    private Text logText;
    private static final int AMOUNT_OF_THREADS = 4;
    private Thread[] mbt = new Thread[4];
    private List<Configurable> profs;
    private WebSearchEngine engine;

    public EditMultiProfileDialog(Shell parent) {
        super(parent);
    }

    public void setData(List<Configurable> profs, WebSearchEngine engine) {
        this.profs = profs;
        this.engine = engine;
    }

    @Override
    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            boolean alldone = true;
            if (this.mbt != null) {
                for (int i = 0; i < 4; ++i) {
                    alldone &= this.mbt[i] != null && !this.mbt[i].isAlive();
                }
            }
            if (alldone) {
                if (this.logText.getCharCount() > 0 && !this.cancelButton.getText().equals(this.settings.msg("button.finish"))) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.multiprofile.reviewlog"));
                    this.profileLabel.setText(this.settings.msg("dialog.multiprofile.reviewlog"));
                    this.profileLabel.pack();
                    this.cancelButton.setText(this.settings.msg("button.finish"));
                    this.progressBar.setSelection(this.progressBar.getMaximum());
                    this.mbt = new Thread[4];
                } else {
                    this.shell.close();
                }
                this.result = "";
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "multiprofiledialog"));
        this.shell.setText(this.settings.msg("dialog.multiprofile.title.edit", new Object[]{this.profs.size()}));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createGeneralTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMultiProfileDialog.this.okButton.setEnabled(false);
                int tasks = EditMultiProfileDialog.this.profs.size();
                if (EditMultiProfileDialog.this.engine != null) {
                    tasks += EditMultiProfileDialog.this.profs.size();
                }
                EditMultiProfileDialog.this.progressBar.setMaximum(tasks);
                int profileNumber = 0;
                for (Configurable cprof : EditMultiProfileDialog.this.profs) {
                    ExpProfile prof = (ExpProfile)cprof;
                    StringBuffer messageLog = new StringBuffer();
                    EditMultiProfileDialog.this.profileLabel.setText(Settings.getInstance().msg("dialog.multiprofile.updating", new Object[]{prof.getTitle()}));
                    EditMultiProfileDialog.this.profileLabel.pack();
                    try {
                        prof.getConf().save();
                        EditMultiProfileDialog.this.dbase.addOrEditProfile(prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getStatus(), prof.getNotes(), prof.isDefault(), prof.getSetup(), prof.getSetupParameters(), prof.getDbversionId(), prof.getLinks(), prof.getLinkTitles(), prof.getCustomStrings(), prof.getCustomInts(), prof.getId());
                    }
                    catch (Exception e) {
                        messageLog.append(StringRelatedUtils.toString(e));
                    }
                    if (messageLog.length() > 0) {
                        EditMultiProfileDialog.this.logText.append(messageLog.append('\n').toString());
                    }
                    EditMultiProfileDialog.this.progressBar.setSelection(++profileNumber);
                }
                if (EditMultiProfileDialog.this.engine != null) {
                    for (int i = 0; i < 4; ++i) {
                        ((EditMultiProfileDialog)EditMultiProfileDialog.this).mbt[i] = new SearchEngineThread(EditMultiProfileDialog.this.engine, Collections.synchronizedList(EditMultiProfileDialog.this.profs), EditMultiProfileDialog.this.logText, EditMultiProfileDialog.this.progressBar, EditMultiProfileDialog.this.profileLabel);
                        EditMultiProfileDialog.this.mbt[i].start();
                    }
                } else {
                    EditMultiProfileDialog.access$502(EditMultiProfileDialog.this, null);
                }
            }
        });
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        generalTabItem.setControl((Control)composite);
        Group progressGroup = new Group(composite, 0);
        progressGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.dfendimport.progress"));
        progressGroup.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)progressGroup, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    static /* synthetic */ Thread[] access$502(EditMultiProfileDialog x0, Thread[] x1) {
        x0.mbt = x1;
        return x1;
    }
}

