/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.AutoSelectCombo;
import org.dbgl.gui.EditMixerDialog;
import org.dbgl.gui.EditMountDialog;
import org.dbgl.gui.EditNativeCommandDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpTemplate;
import org.dbgl.model.Mount;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button switchButton;
    protected Button reloadButton;
    protected Combo priority_active;
    protected Combo priority_inactive;
    protected Button waitonerror;
    protected Button exit;
    protected Text language;
    protected Text captures;
    protected Text config_file;
    protected Combo output;
    protected Combo frameskip;
    protected Combo scaler;
    protected Combo pixelshader;
    protected Button fulldouble;
    protected Button fullscreen;
    protected Combo fullresolution;
    protected Combo windowresolution;
    protected Button aspect;
    protected Combo overscan;
    protected Combo videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Text forcerate;
    protected Button scaler_forced;
    protected Button linewise;
    protected Button char9;
    protected Button multiscan;
    protected Button autofit;
    protected Button cgasnow;
    protected Button splash3dfx;
    protected Text glideport;
    protected Text memsizeKB;
    protected Combo glide;
    protected Combo lfbGlide;
    protected Combo dacMT32;
    protected Combo reverbmodeMT32;
    protected Combo reverbtimeMT32;
    protected Combo reverblevelMT32;
    protected Combo machine;
    protected Combo cpu_type;
    protected Combo core;
    protected Combo cycles;
    protected Combo cycles_up;
    protected Combo cycles_down;
    protected Combo memsize;
    protected Button xms;
    protected Combo ems;
    protected Combo umb;
    protected Combo memalias;
    protected Button nosound;
    protected Combo rate;
    protected Combo blocksize;
    protected Combo prebuffer;
    protected Combo mpu401;
    protected Combo midi_device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo sbtype;
    protected Combo oplrate;
    protected Combo oplmode;
    protected Combo oplemu;
    protected Combo sbbase;
    protected Combo irq;
    protected Combo dma;
    protected Combo hdma;
    protected Combo hardwareaddresssbbase;
    protected Button sbmixer;
    protected Button goldplay;
    protected Button gus;
    protected Button ps1;
    protected Button innova;
    protected Combo gusrate;
    protected Combo gusbase;
    protected Combo gusdma1;
    protected Combo gusdma2;
    protected Combo gusirq1;
    protected Combo gusirq2;
    protected Combo ps1rate;
    protected Combo innovarate;
    protected Combo innovabase;
    protected Combo innovaquality;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy;
    protected Combo tandyrate;
    protected Button disney;
    protected Button swapstereo;
    protected Button swapstereoMT32;
    protected Button loggingMT32;
    protected Button multithreadMT32;
    protected Button int33;
    protected Button biosps2;
    protected Button aux;
    protected Button isapnpbios;
    protected Button ide1;
    protected Button ide2;
    protected Button ide3;
    protected Button ide4;
    protected Button automount;
    protected Spinner partialsMT32;
    protected Spinner files;
    protected Spinner printerdpi;
    protected Spinner printerwidth;
    protected Spinner printerheight;
    protected Spinner printertimeout;
    protected Button usescancodes;
    protected Button dongle;
    protected Button ne2000;
    protected Text mapperfile;
    protected Combo keyboard_layout;
    protected Combo auxdevice;
    protected Combo printeroutput;
    protected Text keyb;
    protected Text printerdocpath;
    protected Text ne2000base;
    protected Text ne2000irq;
    protected Text ne2000macaddress;
    protected Text ne2000realnic;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed;
    protected Button autofire;
    protected Button swap34;
    protected Button buttonwrap;
    protected Text serial1;
    protected Text serial2;
    protected Text serial3;
    protected Text serial4;
    protected Text parallel1;
    protected Text parallel2;
    protected Text parallel3;
    protected Button ipx;
    protected Button printer;
    protected Button printermultipage;
    protected Text ipxnet;
    protected Text[] customCommands;
    protected org.eclipse.swt.widgets.List mountingpoints;
    protected ExpandItem booterExpandItem;
    protected ExpandItem dosExpandItem;
    protected Group memoryGroup;
    protected Group associationGroup;
    protected Group miscGroup;
    protected Group executeGroup;
    protected TabItem infoTabItem;
    protected TabItem generalTabItem;
    protected TabItem mountingTabItem;
    protected Button okButton;
    protected Button cancelButton;
    protected int dbversionIndex = -1;
    protected Shell shell;
    protected List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected List<Configurable> multiProfileList = new ArrayList<Configurable>();
    protected org.eclipse.swt.widgets.List nativeCommands;
    protected Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell parent) {
        super(parent, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            if (this.result == null) {
                this.dbversionIndex = DosboxVersion.indexOfDefault(this.dbversionsList);
                List<NativeCommand> nativeCommands = this.dbase.readNativeCommandsList(-1, -1);
                this.multiProfileList.add(new ExpTemplate(new Conf((Template)null, this.dbversionsList.get(this.dbversionIndex), ps), nativeCommands));
            } else {
                this.dbversionIndex = DosboxVersion.findIndexById(this.dbversionsList, ((Template)this.result).getDbversionId());
                List<NativeCommand> nativeCommands = this.dbase.readNativeCommandsList(-1, ((Template)this.result).getId());
                this.multiProfileList.add(new ExpTemplate(new Conf((Template)this.result, this.dbversionsList.get(this.dbversionIndex), ps), nativeCommands));
            }
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "templatedialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.template.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.template.title.edit", new Object[]{((Template)this.result).getTitle(), ((Template)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createCustomCommandsTab(tabFolder);
        this.createMountingTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    Conf conf = EditTemplateDialog.this.multiProfileList.get(0).getConf();
                    int templateId = EditTemplateDialog.this.dbase.addOrEditTemplate(EditTemplateDialog.this.title.getText(), conf.getDbversion().getId(), EditTemplateDialog.this.defaultButton.getSelection(), EditTemplateDialog.this.result == null ? -1 : ((Template)EditTemplateDialog.this.result).getId());
                    EditTemplateDialog.this.dbase.saveNativeCommands(EditTemplateDialog.this.multiProfileList.get(0).getNativeCommandsList(), -1, templateId);
                    EditTemplateDialog.this.updateConfigurationBySettings(conf);
                    EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), conf.getDbversion().getId(), EditTemplateDialog.this.defaultButton.getSelection());
                    conf.injectOrUpdateTemplate((Template)EditTemplateDialog.this.result);
                    conf.save();
                }
                catch (Exception e) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, e);
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result == null) {
            this.title.setFocus();
        } else {
            this.title.setText(((Template)this.result).getTitle());
            this.defaultButton.setSelection(((Template)this.result).isDefault().booleanValue());
        }
        this.enableSettingsByConfiguration(this.multiProfileList.get(0).getConf().getDosboxSettings());
        this.selectSettingsByConfiguration(this.multiProfileList.get(0).getConf());
    }

    protected void createOkCancelButtons() {
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new GridLayout(2, true));
        composite_7.setLayoutData((Object)"South");
        this.okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        this.cancelButton.setLayoutData((Object)gridData_1);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditTemplateDialog.this.cancelButton.getText().equals(EditTemplateDialog.this.settings.msg("button.cancel"))) {
                    EditTemplateDialog.this.result = null;
                }
                EditTemplateDialog.this.shell.close();
            }
        });
    }

    protected void createMountingTab(TabFolder tabFolder) {
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText(this.settings.msg("dialog.template.tab.mounting"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.mountingTabItem.setControl((Control)composite);
        this.createMountingGroup(composite);
        this.createExecuteGroup(composite);
    }

    protected void createExecuteGroup(final Composite composite) {
        this.executeGroup = new Group(composite, 0);
        this.executeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.executeGroup.setText(this.settings.msg("dialog.template.execute"));
        this.executeGroup.setLayout((Layout)new FillLayout());
        final ExpandBar bar = new ExpandBar((Composite)this.executeGroup, 512);
        Composite booterComposite = new Composite((Composite)bar, 0);
        Composite dosComposite = new Composite((Composite)bar, 0);
        this.createBooterComposite(booterComposite);
        this.createDosComposite(dosComposite);
        this.booterExpandItem = new ExpandItem(bar, 0, 0);
        this.booterExpandItem.setText(this.settings.msg("dialog.template.booter"));
        this.booterExpandItem.setHeight(booterComposite.computeSize((int)-1, (int)-1).y);
        this.booterExpandItem.setControl((Control)booterComposite);
        this.dosExpandItem = new ExpandItem(bar, 0, 1);
        this.dosExpandItem.setText(this.settings.msg("dialog.template.dos"));
        this.dosExpandItem.setHeight(dosComposite.computeSize((int)-1, (int)-1).y);
        this.dosExpandItem.setControl((Control)dosComposite);
        bar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(EditTemplateDialog.this.settings.msg("dialog.template.dos")) ? 0 : 1).setExpanded(true);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        composite.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(EditTemplateDialog.this.settings.msg("dialog.template.dos")) ? 0 : 1).setExpanded(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        composite.layout();
                    }
                });
            }
        });
        if (this.isMultiEdit()) {
            bar.setEnabled(false);
        }
    }

    protected void createBooterComposite(Composite booterComposite) {
        booterComposite.setLayout((Layout)new GridLayout());
        Label image1Label = new Label(booterComposite, 0);
        image1Label.setText(this.settings.msg("dialog.profile.booterimage1"));
    }

    protected void createDosComposite(Composite dosComposite) {
        dosComposite.setLayout((Layout)new GridLayout());
        Label mainExeLabel = new Label(dosComposite, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
    }

    protected void createMountingGroup(Composite composite) {
        Group mountGroup = new Group(composite, 0);
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mountGroup.setText(this.settings.msg("dialog.template.mountingoverview"));
        mountGroup.setLayout((Layout)new GridLayout(2, false));
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)mountGroup, 2560);
        this.mountingpoints.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        this.mountingpoints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddMount();
                } else {
                    EditTemplateDialog.this.doEditMount();
                }
            }
        });
        Button addButton = new Button((Composite)mountGroup, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.setText(this.settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doAddMount();
            }
        });
        Button editButton = new Button((Composite)mountGroup, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText(this.settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doEditMount();
            }
        });
        Button removeButton = new Button((Composite)mountGroup, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText(this.settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doRemoveMount();
            }
        });
        if (this.isMultiEdit()) {
            this.mountingpoints.setEnabled(false);
            addButton.setEnabled(false);
            editButton.setEnabled(false);
            removeButton.setEnabled(false);
        }
    }

    protected void createCustomCommandsTab(TabFolder tabFolder) {
        TabItem customCommandsTabItem = new TabItem(tabFolder, 0);
        customCommandsTabItem.setText(this.settings.msg("dialog.template.tab.customcommands"));
        Composite compositeHoldingSubTabs = new Composite((Composite)tabFolder, 0);
        compositeHoldingSubTabs.setLayout((Layout)new FillLayout());
        customCommandsTabItem.setControl((Control)compositeHoldingSubTabs);
        TabFolder subTabFolder = new TabFolder(compositeHoldingSubTabs, 0);
        TabItem dosboxTabItem = new TabItem(subTabFolder, 0);
        dosboxTabItem.setText(this.settings.msg("dialog.template.tab.dosboxautoexec"));
        Composite dosboxComposite = new Composite((Composite)subTabFolder, 0);
        dosboxComposite.setLayout((Layout)new GridLayout(2, false));
        dosboxTabItem.setControl((Control)dosboxComposite);
        this.customCommands = new Text[Autoexec.SECTIONS];
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            Label filterLabel = new Label(dosboxComposite, 0);
            filterLabel.setText(this.settings.msg("dialog.template.customcommand" + (i + 1)));
            this.customCommands[i] = new Text(dosboxComposite, 2818);
            this.customCommands[i].setLayoutData((Object)new GridData(4, 4, true, true));
        }
        TabItem nativeTabItem = new TabItem(subTabFolder, 0);
        nativeTabItem.setText(this.settings.msg("dialog.template.tab.native"));
        Composite nativeComposite = new Composite((Composite)subTabFolder, 0);
        nativeComposite.setLayout((Layout)new GridLayout(2, false));
        nativeTabItem.setControl((Control)nativeComposite);
        this.nativeCommands = new org.eclipse.swt.widgets.List(nativeComposite, 2816);
        this.nativeCommands.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        this.nativeCommands.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditTemplateDialog.this.nativeCommands.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddNativeCommand();
                } else {
                    EditTemplateDialog.this.doEditNativeCommand();
                }
            }
        });
        Button addButton = new Button(nativeComposite, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.setText(this.settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doAddNativeCommand();
            }
        });
        Button editButton = new Button(nativeComposite, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText(this.settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doEditNativeCommand();
            }
        });
        Button removeButton = new Button(nativeComposite, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText(this.settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doRemoveNativeCommand();
            }
        });
        Button arrowUpButton = new Button(nativeComposite, 132);
        arrowUpButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        arrowUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditTemplateDialog.this.nativeCommands.getSelectionIndex();
                if (sel > 0) {
                    Collections.swap(EditTemplateDialog.this.multiProfileList.get(0).getNativeCommandsList(), sel, sel - 1);
                    EditTemplateDialog.this.updateNativeCommands(sel - 1);
                }
            }
        });
        Button arrowDownButton = new Button(nativeComposite, 1028);
        arrowDownButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        arrowDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditTemplateDialog.this.nativeCommands.getSelectionIndex();
                if (sel >= 0 && sel < EditTemplateDialog.this.nativeCommands.getItemCount() - 1) {
                    Collections.swap(EditTemplateDialog.this.multiProfileList.get(0).getNativeCommandsList(), sel, sel + 1);
                    EditTemplateDialog.this.updateNativeCommands(sel + 1);
                }
            }
        });
        new Label(nativeComposite, 0);
        if (this.isMultiEdit()) {
            this.nativeCommands.setEnabled(false);
            addButton.setEnabled(false);
            editButton.setEnabled(false);
            removeButton.setEnabled(false);
            arrowUpButton.setEnabled(false);
            arrowDownButton.setEnabled(false);
        } else {
            this.updateNativeCommands(-1);
        }
    }

    protected void updateNativeCommands(int sel) {
        this.nativeCommands.removeAll();
        for (NativeCommand cmd : this.multiProfileList.get(0).getNativeCommandsList()) {
            this.nativeCommands.add(cmd.toString());
        }
        this.nativeCommands.select(sel);
    }

    protected void createIOTab(TabFolder tabFolder) {
        TabFolder subTabFolder = this.createRelExpTabs(tabFolder, "dialog.template.tab.io", 3, 3);
        Composite composite_ro = (Composite)subTabFolder.getChildren()[0];
        Composite composite_xo = (Composite)subTabFolder.getChildren()[1];
        Group mouseGroup = new Group(composite_ro, 0);
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mouseGroup.setText(this.settings.msg("dialog.template.mouse"));
        mouseGroup.setLayout((Layout)new GridLayout(2, false));
        Label autolockLabel = new Label((Composite)mouseGroup, 0);
        autolockLabel.setText(this.settings.msg("dialog.template.autolock"));
        this.autolock = new Button((Composite)mouseGroup, 32);
        this.autolock.setToolTipText(this.settings.msg("dialog.template.autolock.tooltip"));
        Label sensitivityLabel = new Label((Composite)mouseGroup, 0);
        sensitivityLabel.setText(this.settings.msg("dialog.template.sensitivity"));
        this.sensitivity = new Combo((Composite)mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getSettings().getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        this.sensitivity.setToolTipText(this.settings.msg("dialog.template.sensitivity.tooltip"));
        Group keyboardGroup = new Group(composite_ro, 0);
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        keyboardGroup.setText(this.settings.msg("dialog.template.keyboard"));
        keyboardGroup.setLayout((Layout)new GridLayout(2, false));
        Label useScancodesLabel = new Label((Composite)keyboardGroup, 0);
        useScancodesLabel.setText(this.settings.msg("dialog.template.usescancodes"));
        this.usescancodes = new Button((Composite)keyboardGroup, 32);
        this.usescancodes.setToolTipText(this.settings.msg("dialog.template.usescancodes.tooltip"));
        Label mapperFileLabel = new Label((Composite)keyboardGroup, 0);
        mapperFileLabel.setText(this.settings.msg("dialog.template.mapperfile"));
        this.mapperfile = new Text((Composite)keyboardGroup, 2048);
        this.mapperfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mapperfile.setToolTipText(this.settings.msg("dialog.template.mapperfile.tooltip"));
        Label layoutLabel = new Label((Composite)keyboardGroup, 0);
        layoutLabel.setText(this.settings.msg("dialog.template.keyboardlayout"));
        this.keyboard_layout = new Combo((Composite)keyboardGroup, 0);
        this.keyboard_layout.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keyboard_layout.setVisibleItemCount(15);
        this.keyboard_layout.setItems(this.settings.getSettings().getValues("profile", "keyboardlayout"));
        this.keyboard_layout.setToolTipText(this.settings.msg("dialog.template.keyboardlayout.tooltip"));
        Label keybLabel = new Label((Composite)keyboardGroup, 0);
        keybLabel.setText(this.settings.msg("dialog.template.keybcommand"));
        this.keyb = new Text((Composite)keyboardGroup, 2048);
        this.keyb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_ro, 0);
        joystickGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        joystickGroup.setText(this.settings.msg("dialog.template.joystick"));
        joystickGroup.setLayout((Layout)new GridLayout(2, false));
        Label typeLabel_1 = new Label((Composite)joystickGroup, 0);
        typeLabel_1.setText(this.settings.msg("dialog.template.joysticktype"));
        this.joysticktype = new Combo((Composite)joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getSettings().getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.joysticktype.setToolTipText(this.settings.msg("dialog.template.joysticktype.tooltip"));
        Label timedLabel = new Label((Composite)joystickGroup, 0);
        timedLabel.setText(this.settings.msg("dialog.template.timedemulation"));
        this.timed = new Button((Composite)joystickGroup, 32);
        this.timed.setToolTipText(this.settings.msg("dialog.template.timedemulation.tooltip"));
        Label autofireLabel = new Label((Composite)joystickGroup, 0);
        autofireLabel.setText(this.settings.msg("dialog.template.autofire"));
        this.autofire = new Button((Composite)joystickGroup, 32);
        this.autofire.setToolTipText(this.settings.msg("dialog.template.autofire.tooltip"));
        Label swapAxes3Label = new Label((Composite)joystickGroup, 0);
        swapAxes3Label.setText(this.settings.msg("dialog.template.swap34"));
        this.swap34 = new Button((Composite)joystickGroup, 32);
        this.swap34.setToolTipText(this.settings.msg("dialog.template.swap34.tooltip"));
        Label buttonWrapLabel = new Label((Composite)joystickGroup, 0);
        buttonWrapLabel.setText(this.settings.msg("dialog.template.buttonwrapping"));
        this.buttonwrap = new Button((Composite)joystickGroup, 32);
        this.buttonwrap.setToolTipText(this.settings.msg("dialog.template.buttonwrapping.tooltip"));
        Group modemGroup = new Group(composite_ro, 0);
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText(this.settings.msg("dialog.template.modem"));
        modemGroup.setLayout((Layout)new GridLayout(2, false));
        Label serial1Label = new Label((Composite)modemGroup, 0);
        serial1Label.setText(this.settings.msg("dialog.template.serial1"));
        this.serial1 = new Text((Composite)modemGroup, 2048);
        this.serial1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial1.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial2Label = new Label((Composite)modemGroup, 0);
        serial2Label.setText(this.settings.msg("dialog.template.serial2"));
        this.serial2 = new Text((Composite)modemGroup, 2048);
        this.serial2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial2.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial3Label = new Label((Composite)modemGroup, 0);
        serial3Label.setText(this.settings.msg("dialog.template.serial3"));
        this.serial3 = new Text((Composite)modemGroup, 2048);
        this.serial3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial3.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial4Label = new Label((Composite)modemGroup, 0);
        serial4Label.setText(this.settings.msg("dialog.template.serial4"));
        this.serial4 = new Text((Composite)modemGroup, 2048);
        this.serial4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial4.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Group networkGroup = new Group(composite_ro, 0);
        networkGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        networkGroup.setText(this.settings.msg("dialog.template.network"));
        networkGroup.setLayout((Layout)new GridLayout(2, false));
        Label ipxLabel = new Label((Composite)networkGroup, 0);
        ipxLabel.setText(this.settings.msg("dialog.template.enableipx"));
        this.ipx = new Button((Composite)networkGroup, 32);
        this.ipx.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.ipxnet.setEnabled(EditTemplateDialog.this.ipx.getSelection());
            }
        });
        this.ipx.setToolTipText(this.settings.msg("dialog.template.enableipx.tooltip"));
        Label ipxnetCommandLabel = new Label((Composite)networkGroup, 0);
        ipxnetCommandLabel.setText(this.settings.msg("dialog.template.ipxnetcommand"));
        ipxnetCommandLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.ipxnet = new Text((Composite)networkGroup, 2048);
        this.ipxnet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group mouseExpGroup = new Group(composite_xo, 0);
        mouseExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mouseExpGroup.setText(this.settings.msg("dialog.template.mouse"));
        mouseExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label int33Label = new Label((Composite)mouseExpGroup, 0);
        int33Label.setText(this.settings.msg("dialog.template.int33"));
        this.int33 = new Button((Composite)mouseExpGroup, 32);
        Label biosps2Label = new Label((Composite)mouseExpGroup, 0);
        biosps2Label.setText(this.settings.msg("dialog.template.biosps2"));
        this.biosps2 = new Button((Composite)mouseExpGroup, 32);
        Label auxLabel = new Label((Composite)mouseExpGroup, 0);
        auxLabel.setText(this.settings.msg("dialog.template.aux"));
        this.aux = new Button((Composite)mouseExpGroup, 32);
        Label auxdeviceLabel = new Label((Composite)mouseExpGroup, 0);
        auxdeviceLabel.setText(this.settings.msg("dialog.template.auxdevice"));
        this.auxdevice = new Combo((Composite)mouseExpGroup, 8);
        this.auxdevice.setItems(this.settings.getSettings().getValues("profile", "auxdevice"));
        Group miscExpGroup = new Group(composite_xo, 0);
        miscExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        miscExpGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        miscExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label filesLabel = new Label((Composite)miscExpGroup, 0);
        filesLabel.setText(this.settings.msg("dialog.template.files"));
        this.files = new Spinner((Composite)miscExpGroup, 2048);
        this.files.setMinimum(8);
        this.files.setMaximum(255);
        Label isapnpbiosLabel = new Label((Composite)miscExpGroup, 0);
        isapnpbiosLabel.setText(this.settings.msg("dialog.template.isapnpbios"));
        this.isapnpbios = new Button((Composite)miscExpGroup, 32);
        Label ide1Label = new Label((Composite)miscExpGroup, 0);
        ide1Label.setText(this.settings.msg("dialog.template.ide1"));
        this.ide1 = new Button((Composite)miscExpGroup, 32);
        Label ide2Label = new Label((Composite)miscExpGroup, 0);
        ide2Label.setText(this.settings.msg("dialog.template.ide2"));
        this.ide2 = new Button((Composite)miscExpGroup, 32);
        Label ide3Label = new Label((Composite)miscExpGroup, 0);
        ide3Label.setText(this.settings.msg("dialog.template.ide3"));
        this.ide3 = new Button((Composite)miscExpGroup, 32);
        Label ide4Label = new Label((Composite)miscExpGroup, 0);
        ide4Label.setText(this.settings.msg("dialog.template.ide4"));
        this.ide4 = new Button((Composite)miscExpGroup, 32);
        Label automountLabel = new Label((Composite)miscExpGroup, 0);
        automountLabel.setText(this.settings.msg("dialog.template.automount"));
        this.automount = new Button((Composite)miscExpGroup, 32);
        Group printerExpGroup = new Group(composite_xo, 0);
        printerExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        printerExpGroup.setText(this.settings.msg("dialog.template.printer"));
        printerExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label printerLabel = new Label((Composite)printerExpGroup, 0);
        printerLabel.setText(this.settings.msg("dialog.template.printerenable"));
        this.printer = new Button((Composite)printerExpGroup, 32);
        Label printerdpiLabel = new Label((Composite)printerExpGroup, 0);
        printerdpiLabel.setText(this.settings.msg("dialog.template.printerdpi"));
        this.printerdpi = new Spinner((Composite)printerExpGroup, 2048);
        this.printerdpi.setMinimum(0);
        this.printerdpi.setMaximum(Short.MAX_VALUE);
        Label printerwidthLabel = new Label((Composite)printerExpGroup, 0);
        printerwidthLabel.setText(this.settings.msg("dialog.template.printerwidth"));
        this.printerwidth = new Spinner((Composite)printerExpGroup, 2048);
        this.printerwidth.setMinimum(0);
        this.printerwidth.setMaximum(Short.MAX_VALUE);
        Label printerheightLabel = new Label((Composite)printerExpGroup, 0);
        printerheightLabel.setText(this.settings.msg("dialog.template.printerheight"));
        this.printerheight = new Spinner((Composite)printerExpGroup, 2048);
        this.printerheight.setMinimum(0);
        this.printerheight.setMaximum(Short.MAX_VALUE);
        Label printeroutputLabel = new Label((Composite)printerExpGroup, 0);
        printeroutputLabel.setText(this.settings.msg("dialog.template.printeroutput"));
        this.printeroutput = new Combo((Composite)printerExpGroup, 8);
        this.printeroutput.setItems(this.settings.getSettings().getValues("profile", "printeroutput"));
        Label printermultipageLabel = new Label((Composite)printerExpGroup, 0);
        printermultipageLabel.setText(this.settings.msg("dialog.template.printermultipage"));
        this.printermultipage = new Button((Composite)printerExpGroup, 32);
        Label printerdocpathLabel = new Label((Composite)printerExpGroup, 0);
        printerdocpathLabel.setText(this.settings.msg("dialog.template.printerdocpath"));
        this.printerdocpath = new Text((Composite)printerExpGroup, 2048);
        this.printerdocpath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label printertimeoutLabel = new Label((Composite)printerExpGroup, 0);
        printertimeoutLabel.setText(this.settings.msg("dialog.template.printertimeout"));
        this.printertimeout = new Spinner((Composite)printerExpGroup, 2048);
        this.printertimeout.setMinimum(0);
        this.printertimeout.setMaximum(Short.MAX_VALUE);
        Group parallelExpGroup = new Group(composite_xo, 0);
        parallelExpGroup.setText(this.settings.msg("dialog.template.parallel"));
        parallelExpGroup.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        parallelExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label parallel1Label = new Label((Composite)parallelExpGroup, 0);
        parallel1Label.setText(this.settings.msg("dialog.template.parallel1"));
        this.parallel1 = new Text((Composite)parallelExpGroup, 2048);
        this.parallel1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label parallel2Label = new Label((Composite)parallelExpGroup, 0);
        parallel2Label.setText(this.settings.msg("dialog.template.parallel2"));
        this.parallel2 = new Text((Composite)parallelExpGroup, 2048);
        this.parallel2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label parallel3Label = new Label((Composite)parallelExpGroup, 0);
        parallel3Label.setText(this.settings.msg("dialog.template.parallel3"));
        this.parallel3 = new Text((Composite)parallelExpGroup, 2048);
        this.parallel3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label dongleLabel = new Label((Composite)parallelExpGroup, 0);
        dongleLabel.setText(this.settings.msg("dialog.template.dongle"));
        this.dongle = new Button((Composite)parallelExpGroup, 32);
        Group ne2000ExpGroup = new Group(composite_xo, 0);
        ne2000ExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        ne2000ExpGroup.setText(this.settings.msg("dialog.template.ne2000"));
        ne2000ExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label ne2000Label = new Label((Composite)ne2000ExpGroup, 0);
        ne2000Label.setText(this.settings.msg("dialog.template.ne2000enable"));
        this.ne2000 = new Button((Composite)ne2000ExpGroup, 32);
        Label ne2000baseLabel = new Label((Composite)ne2000ExpGroup, 0);
        ne2000baseLabel.setText(this.settings.msg("dialog.template.ne2000base"));
        this.ne2000base = new Text((Composite)ne2000ExpGroup, 2048);
        this.ne2000base.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label ne2000irqLabel = new Label((Composite)ne2000ExpGroup, 0);
        ne2000irqLabel.setText(this.settings.msg("dialog.template.ne2000irq"));
        this.ne2000irq = new Text((Composite)ne2000ExpGroup, 2048);
        this.ne2000irq.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label ne2000macaddressLabel = new Label((Composite)ne2000ExpGroup, 0);
        ne2000macaddressLabel.setText(this.settings.msg("dialog.template.ne2000macaddress"));
        this.ne2000macaddress = new Text((Composite)ne2000ExpGroup, 2048);
        this.ne2000macaddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label ne2000realnicLabel = new Label((Composite)ne2000ExpGroup, 0);
        ne2000realnicLabel.setText(this.settings.msg("dialog.template.ne2000realnic"));
        this.ne2000realnic = new Text((Composite)ne2000ExpGroup, 2048);
        this.ne2000realnic.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createAudioTab(TabFolder tabFolder) {
        TabFolder subTabFolder = this.createRelExpTabs(tabFolder, "dialog.template.tab.audio", 3, 3);
        Composite composite_ro = (Composite)subTabFolder.getChildren()[0];
        Composite composite_xo = (Composite)subTabFolder.getChildren()[1];
        Group generalGroup = new Group(composite_ro, 0);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        generalGroup.setLayout((Layout)new GridLayout(2, false));
        generalGroup.setText(this.settings.msg("dialog.template.general"));
        Label silentModeLabel = new Label((Composite)generalGroup, 0);
        silentModeLabel.setText(this.settings.msg("dialog.template.silentmode"));
        this.nosound = new Button((Composite)generalGroup, 32);
        this.nosound.setToolTipText(this.settings.msg("dialog.template.silentmode.tooltip"));
        Label sampleRateLabel = new Label((Composite)generalGroup, 0);
        sampleRateLabel.setText(this.settings.msg("dialog.template.samplerate"));
        this.rate = new Combo((Composite)generalGroup, 8);
        this.rate.setVisibleItemCount(10);
        this.rate.setItems(this.settings.getSettings().getValues("profile", "rate"));
        this.rate.setLayoutData((Object)new GridData());
        this.rate.setToolTipText(this.settings.msg("dialog.template.samplerate.tooltip"));
        Label blockSizeLabel = new Label((Composite)generalGroup, 0);
        blockSizeLabel.setText(this.settings.msg("dialog.template.blocksize"));
        this.blocksize = new Combo((Composite)generalGroup, 8);
        this.blocksize.setItems(this.settings.getSettings().getValues("profile", "blocksize"));
        this.blocksize.setLayoutData((Object)new GridData());
        this.blocksize.setToolTipText(this.settings.msg("dialog.template.blocksize.tooltip"));
        Label prebufferLabel = new Label((Composite)generalGroup, 0);
        prebufferLabel.setText(this.settings.msg("dialog.template.prebuffer"));
        this.prebuffer = new Combo((Composite)generalGroup, 0);
        this.prebuffer.setItems(this.settings.getSettings().getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData((Object)new GridData(70, -1));
        this.prebuffer.setToolTipText(this.settings.msg("dialog.template.prebuffer.tooltip"));
        Label mpu401Label = new Label((Composite)generalGroup, 0);
        mpu401Label.setText(this.settings.msg("dialog.template.mpu401"));
        this.mpu401 = new Combo((Composite)generalGroup, 8);
        this.mpu401.setItems(this.settings.getSettings().getValues("profile", "mpu401"));
        this.mpu401.setLayoutData((Object)new GridData());
        this.mpu401.setToolTipText(this.settings.msg("dialog.template.mpu401.tooltip"));
        Label midiDeviceLabel = new Label((Composite)generalGroup, 0);
        midiDeviceLabel.setText(this.settings.msg("dialog.template.mididevice"));
        this.midi_device = new Combo((Composite)generalGroup, 8);
        this.midi_device.setVisibleItemCount(10);
        this.midi_device.setItems(this.settings.getSettings().getValues("profile", "device"));
        this.midi_device.setLayoutData((Object)new GridData());
        this.midi_device.setToolTipText(this.settings.msg("dialog.template.mididevice.tooltip"));
        Label configLabel = new Label((Composite)generalGroup, 0);
        configLabel.setText(this.settings.msg("dialog.template.midiconfig"));
        this.midi_config = new Text((Composite)generalGroup, 2048);
        this.midi_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.midi_config.setToolTipText(this.settings.msg("dialog.template.midiconfig.tooltip"));
        Label mixerConfigLabel = new Label((Composite)generalGroup, 0);
        mixerConfigLabel.setText(this.settings.msg("dialog.template.mixercommand"));
        Composite mixerSettings = new Composite((Composite)generalGroup, 0);
        mixerSettings.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout filler = new GridLayout();
        filler.numColumns = 2;
        filler.horizontalSpacing = 2;
        filler.marginWidth = 0;
        mixerSettings.setLayout((Layout)filler);
        this.mixer_config = new Text(mixerSettings, 18436);
        GridData mixerConfigGridData = new GridData(4, 0x1000000, true, false);
        mixerConfigGridData.widthHint = 66;
        this.mixer_config.setLayoutData((Object)mixerConfigGridData);
        Button mixerConfig = new Button(mixerSettings, 0);
        mixerConfig.setText("...");
        mixerConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog dialog = new EditMixerDialog(EditTemplateDialog.this.shell);
                dialog.setMixerCommand(EditTemplateDialog.this.mixer_config.getText());
                String command = (String)dialog.open();
                if (command != null) {
                    EditTemplateDialog.this.mixer_config.setText(command);
                }
            }
        });
        Group soundblasterGroup = new Group(composite_ro, 0);
        soundblasterGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        soundblasterGroup.setText(this.settings.msg("dialog.template.soundblaster"));
        soundblasterGroup.setLayout((Layout)new GridLayout(2, false));
        Label typeLabel = new Label((Composite)soundblasterGroup, 0);
        typeLabel.setText(this.settings.msg("dialog.template.sbtype"));
        this.sbtype = new Combo((Composite)soundblasterGroup, 8);
        this.sbtype.setVisibleItemCount(10);
        this.sbtype.setItems(this.settings.getSettings().getValues("profile", "sbtype"));
        this.sbtype.setLayoutData((Object)new GridData());
        this.sbtype.setToolTipText(this.settings.msg("dialog.template.sbtype.tooltip"));
        Label oplRateLabel = new Label((Composite)soundblasterGroup, 0);
        oplRateLabel.setText(this.settings.msg("dialog.template.sboplrate"));
        this.oplrate = new Combo((Composite)soundblasterGroup, 8);
        this.oplrate.setVisibleItemCount(10);
        this.oplrate.setItems(this.settings.getSettings().getValues("profile", "oplrate"));
        this.oplrate.setLayoutData((Object)new GridData());
        this.oplrate.setToolTipText(this.settings.msg("dialog.template.sboplrate.tooltip"));
        Label oplModeLabel = new Label((Composite)soundblasterGroup, 0);
        oplModeLabel.setLayoutData((Object)new GridData());
        oplModeLabel.setText(this.settings.msg("dialog.template.sboplmode"));
        this.oplmode = new Combo((Composite)soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getSettings().getValues("profile", "oplmode"));
        this.oplmode.setLayoutData((Object)new GridData());
        this.oplmode.setToolTipText(this.settings.msg("dialog.template.sboplmode.tooltip"));
        Label oplEmuLabel = new Label((Composite)soundblasterGroup, 0);
        oplEmuLabel.setLayoutData((Object)new GridData());
        oplEmuLabel.setText(this.settings.msg("dialog.template.sboplemu"));
        this.oplemu = new Combo((Composite)soundblasterGroup, 8);
        this.oplemu.setItems(this.settings.getSettings().getValues("profile", "oplemu"));
        this.oplemu.setLayoutData((Object)new GridData());
        this.oplemu.setToolTipText(this.settings.msg("dialog.template.sboplemu.tooltip"));
        Label addressLabel = new Label((Composite)soundblasterGroup, 0);
        addressLabel.setText(this.settings.msg("dialog.template.sbaddress"));
        this.sbbase = new Combo((Composite)soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getSettings().getValues("profile", "sbbase"));
        this.sbbase.setLayoutData((Object)new GridData());
        this.sbbase.setToolTipText(this.settings.msg("dialog.template.sbaddress.tooltip"));
        Label irqLabel = new Label((Composite)soundblasterGroup, 0);
        irqLabel.setText(this.settings.msg("dialog.template.sbirq"));
        this.irq = new Combo((Composite)soundblasterGroup, 8);
        this.irq.setItems(this.settings.getSettings().getValues("profile", "irq"));
        this.irq.setLayoutData((Object)new GridData());
        this.irq.setToolTipText(this.settings.msg("dialog.template.sbirq.tooltip"));
        Label dmaLabel = new Label((Composite)soundblasterGroup, 0);
        dmaLabel.setText(this.settings.msg("dialog.template.sbdma"));
        this.dma = new Combo((Composite)soundblasterGroup, 8);
        this.dma.setItems(this.settings.getSettings().getValues("profile", "dma"));
        this.dma.setLayoutData((Object)new GridData());
        this.dma.setToolTipText(this.settings.msg("dialog.template.sbdma.tooltip"));
        Label hdmaLabel = new Label((Composite)soundblasterGroup, 0);
        hdmaLabel.setLayoutData((Object)new GridData());
        hdmaLabel.setText(this.settings.msg("dialog.template.sbhdma"));
        this.hdma = new Combo((Composite)soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getSettings().getValues("profile", "hdma"));
        this.hdma.setLayoutData((Object)new GridData());
        this.hdma.setToolTipText(this.settings.msg("dialog.template.sbhdma.tooltip"));
        Label mixerLabel = new Label((Composite)soundblasterGroup, 0);
        mixerLabel.setText(this.settings.msg("dialog.template.mixer"));
        this.sbmixer = new Button((Composite)soundblasterGroup, 32);
        this.sbmixer.setToolTipText(this.settings.msg("dialog.template.mixer.tooltip"));
        Group gusGroup = new Group(composite_ro, 0);
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        gusGroup.setText(this.settings.msg("dialog.template.gravisultrasound"));
        gusGroup.setLayout((Layout)new GridLayout(2, false));
        Label enableLabel_1 = new Label((Composite)gusGroup, 0);
        enableLabel_1.setLayoutData((Object)new GridData());
        enableLabel_1.setText(this.settings.msg("dialog.template.enablegus"));
        this.gus = new Button((Composite)gusGroup, 32);
        this.gus.setLayoutData((Object)new GridData());
        this.gus.setToolTipText(this.settings.msg("dialog.template.enablegus.tooltip"));
        Label sampleRateLabel_2 = new Label((Composite)gusGroup, 0);
        sampleRateLabel_2.setText(this.settings.msg("dialog.template.gusrate"));
        this.gusrate = new Combo((Composite)gusGroup, 8);
        this.gusrate.setVisibleItemCount(10);
        this.gusrate.setItems(this.settings.getSettings().getValues("profile", "gusrate"));
        this.gusrate.setLayoutData((Object)new GridData());
        this.gusrate.setToolTipText(this.settings.msg("dialog.template.gusrate.tooltip"));
        Label addressLabel_1 = new Label((Composite)gusGroup, 0);
        addressLabel_1.setText(this.settings.msg("dialog.template.gusaddress"));
        this.gusbase = new Combo((Composite)gusGroup, 8);
        this.gusbase.setItems(this.settings.getSettings().getValues("profile", "gusbase"));
        this.gusbase.setLayoutData((Object)new GridData());
        this.gusbase.setToolTipText(this.settings.msg("dialog.template.gusaddress.tooltip"));
        Label irqLabel_1 = new Label((Composite)gusGroup, 0);
        irqLabel_1.setText(this.settings.msg("dialog.template.gusirq1"));
        this.gusirq1 = new Combo((Composite)gusGroup, 8);
        this.gusirq1.setItems(this.settings.getSettings().getValues("profile", "irq1"));
        this.gusirq1.setLayoutData((Object)new GridData());
        this.gusirq1.setToolTipText(this.settings.msg("dialog.template.gusirq1.tooltip"));
        Label irq2Label = new Label((Composite)gusGroup, 0);
        irq2Label.setText(this.settings.msg("dialog.template.gusirq2"));
        this.gusirq2 = new Combo((Composite)gusGroup, 8);
        this.gusirq2.setItems(this.settings.getSettings().getValues("profile", "irq2"));
        this.gusirq2.setLayoutData((Object)new GridData());
        Label dmaLabel_1 = new Label((Composite)gusGroup, 0);
        dmaLabel_1.setText(this.settings.msg("dialog.template.gusdma1"));
        this.gusdma1 = new Combo((Composite)gusGroup, 8);
        this.gusdma1.setItems(this.settings.getSettings().getValues("profile", "dma1"));
        this.gusdma1.setLayoutData((Object)new GridData());
        this.gusdma1.setToolTipText(this.settings.msg("dialog.template.gusdma1.tooltip"));
        Label hdmaLabel_1 = new Label((Composite)gusGroup, 0);
        hdmaLabel_1.setLayoutData((Object)new GridData());
        hdmaLabel_1.setText(this.settings.msg("dialog.template.gusdma2"));
        this.gusdma2 = new Combo((Composite)gusGroup, 8);
        this.gusdma2.setItems(this.settings.getSettings().getValues("profile", "dma2"));
        this.gusdma2.setLayoutData((Object)new GridData());
        Label ultradirLabel = new Label((Composite)gusGroup, 0);
        ultradirLabel.setText(this.settings.msg("dialog.template.ultradir"));
        this.ultradir = new Text((Composite)gusGroup, 2048);
        this.ultradir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ultradir.setToolTipText(this.settings.msg("dialog.template.ultradir.tooltip"));
        Group speakerGroup = new Group(composite_ro, 0);
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        speakerGroup.setText(this.settings.msg("dialog.template.pcspeaker"));
        speakerGroup.setLayout((Layout)new GridLayout(2, false));
        Label enableLabel = new Label((Composite)speakerGroup, 0);
        enableLabel.setText(this.settings.msg("dialog.template.enablepcspeaker"));
        this.pcspeaker = new Button((Composite)speakerGroup, 32);
        this.pcspeaker.setToolTipText(this.settings.msg("dialog.template.enablepcspeaker.tooltip"));
        Label sampleRateLabel_1 = new Label((Composite)speakerGroup, 0);
        sampleRateLabel_1.setText(this.settings.msg("dialog.template.pcrate"));
        this.pcrate = new Combo((Composite)speakerGroup, 8);
        this.pcrate.setVisibleItemCount(10);
        this.pcrate.setItems(this.settings.getSettings().getValues("profile", "pcrate"));
        this.pcrate.setLayoutData((Object)new GridData());
        this.pcrate.setToolTipText(this.settings.msg("dialog.template.pcrate.tooltip"));
        Group tandyGroup = new Group(composite_ro, 0);
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        tandyGroup.setText(this.settings.msg("dialog.template.tandy"));
        tandyGroup.setLayout((Layout)new GridLayout(2, false));
        Label enableLabel_2 = new Label((Composite)tandyGroup, 0);
        enableLabel_2.setText(this.settings.msg("dialog.template.enabletandy"));
        this.tandy = new Combo((Composite)tandyGroup, 8);
        this.tandy.setItems(this.settings.getSettings().getValues("profile", "tandy"));
        this.tandy.setLayoutData((Object)new GridData());
        this.tandy.setToolTipText(this.settings.msg("dialog.template.enabletandy.tooltip"));
        Label sampleLabel2 = new Label((Composite)tandyGroup, 0);
        sampleLabel2.setText(this.settings.msg("dialog.template.tandyrate"));
        this.tandyrate = new Combo((Composite)tandyGroup, 8);
        this.tandyrate.setVisibleItemCount(10);
        this.tandyrate.setItems(this.settings.getSettings().getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData((Object)new GridData());
        this.tandyrate.setToolTipText(this.settings.msg("dialog.template.tandyrate.tooltip"));
        Group disneyGroup = new Group(composite_ro, 0);
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        disneyGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        disneyGroup.setLayout((Layout)new GridLayout(2, false));
        Label enableLabel_3 = new Label((Composite)disneyGroup, 0);
        enableLabel_3.setText(this.settings.msg("dialog.template.enablesoundsource"));
        this.disney = new Button((Composite)disneyGroup, 32);
        this.disney.setToolTipText(this.settings.msg("dialog.template.enablesoundsource.tooltip"));
        Group generalExpGroup = new Group(composite_xo, 0);
        generalExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        generalExpGroup.setLayout((Layout)new GridLayout(2, false));
        generalExpGroup.setText(this.settings.msg("dialog.template.general"));
        Label swapstereoLabel = new Label((Composite)generalExpGroup, 0);
        swapstereoLabel.setText(this.settings.msg("dialog.template.swapstereo"));
        this.swapstereo = new Button((Composite)generalExpGroup, 32);
        Group soundblasterExpGroup = new Group(composite_xo, 0);
        soundblasterExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        soundblasterExpGroup.setText(this.settings.msg("dialog.template.soundblaster"));
        soundblasterExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label hardwareaddressLabel = new Label((Composite)soundblasterExpGroup, 0);
        hardwareaddressLabel.setText(this.settings.msg("dialog.template.hardwaresbaddress"));
        this.hardwareaddresssbbase = new Combo((Composite)soundblasterExpGroup, 8);
        this.hardwareaddresssbbase.setItems(this.settings.getSettings().getValues("profile", "hardwaresbbase"));
        Label goldplayLabel = new Label((Composite)soundblasterExpGroup, 0);
        goldplayLabel.setText(this.settings.msg("dialog.template.goldplay"));
        this.goldplay = new Button((Composite)soundblasterExpGroup, 32);
        Group mt32ExpGroup = new Group(composite_xo, 0);
        mt32ExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mt32ExpGroup.setText(this.settings.msg("dialog.template.mt32"));
        mt32ExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label swapstereoMT32Label = new Label((Composite)mt32ExpGroup, 0);
        swapstereoMT32Label.setText(this.settings.msg("dialog.template.swapstereo"));
        this.swapstereoMT32 = new Button((Composite)mt32ExpGroup, 32);
        Label loggingMT32Label = new Label((Composite)mt32ExpGroup, 0);
        loggingMT32Label.setText(this.settings.msg("dialog.template.mt32.verboselogging"));
        this.loggingMT32 = new Button((Composite)mt32ExpGroup, 32);
        Label multithreadMT32Label = new Label((Composite)mt32ExpGroup, 0);
        multithreadMT32Label.setText(this.settings.msg("dialog.template.mt32.multithread"));
        this.multithreadMT32 = new Button((Composite)mt32ExpGroup, 32);
        Label dacLabel = new Label((Composite)mt32ExpGroup, 0);
        dacLabel.setText(this.settings.msg("dialog.template.mt32.dac"));
        this.dacMT32 = new Combo((Composite)mt32ExpGroup, 8);
        this.dacMT32.setItems(this.settings.getSettings().getValues("profile", "mt32dac"));
        Label reverbmodeLabel = new Label((Composite)mt32ExpGroup, 0);
        reverbmodeLabel.setText(this.settings.msg("dialog.template.mt32.reverbmode"));
        this.reverbmodeMT32 = new Combo((Composite)mt32ExpGroup, 8);
        this.reverbmodeMT32.setItems(this.settings.getSettings().getValues("profile", "mt32reverbmode"));
        Label reverbtimeLabel = new Label((Composite)mt32ExpGroup, 0);
        reverbtimeLabel.setText(this.settings.msg("dialog.template.mt32.reverbtime"));
        this.reverbtimeMT32 = new Combo((Composite)mt32ExpGroup, 8);
        this.reverbtimeMT32.setItems(this.settings.getSettings().getValues("profile", "mt32reverbtime"));
        Label reverblevelLabel = new Label((Composite)mt32ExpGroup, 0);
        reverblevelLabel.setText(this.settings.msg("dialog.template.mt32.reverblevel"));
        this.reverblevelMT32 = new Combo((Composite)mt32ExpGroup, 8);
        this.reverblevelMT32.setItems(this.settings.getSettings().getValues("profile", "mt32reverblevel"));
        Label partialsLabel = new Label((Composite)mt32ExpGroup, 0);
        partialsLabel.setText(this.settings.msg("dialog.template.mt32.partials"));
        this.partialsMT32 = new Spinner((Composite)mt32ExpGroup, 2048);
        this.partialsMT32.setMinimum(0);
        this.partialsMT32.setMaximum(256);
        new Label(composite_xo, 0);
        Group ps1ExpGroup = new Group(composite_xo, 0);
        ps1ExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        ps1ExpGroup.setText(this.settings.msg("dialog.template.ps1"));
        ps1ExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label enablePS1Label = new Label((Composite)ps1ExpGroup, 0);
        enablePS1Label.setText(this.settings.msg("dialog.template.ps1enable"));
        this.ps1 = new Button((Composite)ps1ExpGroup, 32);
        Label sampleRatePS1Label = new Label((Composite)ps1ExpGroup, 0);
        sampleRatePS1Label.setText(this.settings.msg("dialog.template.ps1rate"));
        this.ps1rate = new Combo((Composite)ps1ExpGroup, 8);
        this.ps1rate.setItems(this.settings.getSettings().getValues("profile", "ps1rate"));
        Group innovaExpGroup = new Group(composite_xo, 0);
        innovaExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        innovaExpGroup.setText(this.settings.msg("dialog.template.innova"));
        innovaExpGroup.setLayout((Layout)new GridLayout(2, false));
        Label enableInnovaLabel = new Label((Composite)innovaExpGroup, 0);
        enableInnovaLabel.setText(this.settings.msg("dialog.template.innovaenable"));
        this.innova = new Button((Composite)innovaExpGroup, 32);
        Label sampleRateInnovaLabel = new Label((Composite)innovaExpGroup, 0);
        sampleRateInnovaLabel.setText(this.settings.msg("dialog.template.innovarate"));
        this.innovarate = new Combo((Composite)innovaExpGroup, 8);
        this.innovarate.setItems(this.settings.getSettings().getValues("profile", "innovarate"));
        Label sidbaseLabel = new Label((Composite)innovaExpGroup, 0);
        sidbaseLabel.setText(this.settings.msg("dialog.template.innovaaddress"));
        this.innovabase = new Combo((Composite)innovaExpGroup, 8);
        this.innovabase.setItems(this.settings.getSettings().getValues("profile", "innovabase"));
        Label sidqualityLabel = new Label((Composite)innovaExpGroup, 0);
        sidqualityLabel.setText(this.settings.msg("dialog.template.innovaquality"));
        this.innovaquality = new Combo((Composite)innovaExpGroup, 8);
        this.innovaquality.setItems(this.settings.getSettings().getValues("profile", "innovaquality"));
    }

    protected void createMachineTab(TabFolder tabFolder) {
        TabFolder subTabFolder = this.createRelExpTabs(tabFolder, "dialog.template.tab.machine", 1, 1);
        Composite composite_ro = (Composite)subTabFolder.getChildren()[0];
        Composite composite_xo = (Composite)subTabFolder.getChildren()[1];
        Group cpuGroup = new Group(composite_ro, 0);
        cpuGroup.setText(this.settings.msg("dialog.template.cpu"));
        cpuGroup.setLayout((Layout)new GridLayout(6, false));
        Label machineLabel = new Label((Composite)cpuGroup, 0);
        machineLabel.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo((Composite)cpuGroup, 8);
        this.machine.setLayoutData((Object)new GridData());
        this.machine.setVisibleItemCount(20);
        this.machine.setToolTipText(this.settings.msg("dialog.template.machine.tooltip"));
        Label cputypeLabel = new Label((Composite)cpuGroup, 0);
        cputypeLabel.setText(this.settings.msg("dialog.template.cputype"));
        this.cpu_type = new Combo((Composite)cpuGroup, 8);
        this.cpu_type.setItems(this.settings.getSettings().getValues("profile", "cputype"));
        this.cpu_type.setLayoutData((Object)new GridData());
        this.cpu_type.setVisibleItemCount(10);
        this.cpu_type.setToolTipText(this.settings.msg("dialog.template.cputype.tooltip"));
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label coreLabel = new Label((Composite)cpuGroup, 0);
        coreLabel.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo((Composite)cpuGroup, 8);
        this.core.setItems(this.settings.getSettings().getValues("profile", "core"));
        this.core.setLayoutData((Object)new GridData());
        this.core.setToolTipText(this.settings.msg("dialog.template.core.tooltip"));
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label cyclesLabel = new Label((Composite)cpuGroup, 0);
        cyclesLabel.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo((Composite)cpuGroup, 0);
        this.cycles.setItems(this.settings.getSettings().getValues("profile", "cycles"));
        this.cycles.setLayoutData((Object)new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        this.cycles.setToolTipText(this.settings.msg("dialog.template.cycles.tooltip"));
        Label upLabel = new Label((Composite)cpuGroup, 0);
        upLabel.setLayoutData((Object)new GridData());
        upLabel.setText(this.settings.msg("dialog.template.up"));
        this.cycles_up = new Combo((Composite)cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getSettings().getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData((Object)new GridData(75, -1));
        this.cycles_up.setToolTipText(this.settings.msg("dialog.template.up.tooltip"));
        Label downLabel = new Label((Composite)cpuGroup, 0);
        downLabel.setLayoutData((Object)new GridData());
        downLabel.setText(this.settings.msg("dialog.template.down"));
        this.cycles_down = new Combo((Composite)cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getSettings().getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData((Object)new GridData(75, -1));
        this.cycles_down.setToolTipText(this.settings.msg("dialog.template.down.tooltip"));
        this.memoryGroup = new Group(composite_ro, 0);
        this.memoryGroup.setText(this.settings.msg("dialog.template.memory"));
        this.memoryGroup.setLayout((Layout)new GridLayout(4, false));
        Label sizeLabel = new Label((Composite)this.memoryGroup, 0);
        sizeLabel.setText(this.settings.msg("dialog.template.memorysize"));
        this.memsize = new Combo((Composite)this.memoryGroup, 8);
        this.memsize.setItems(this.settings.getSettings().getValues("profile", "memsize"));
        this.memsize.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.memsize.setToolTipText(this.settings.msg("dialog.template.memorysize.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label xmsLabel = new Label((Composite)this.memoryGroup, 0);
        xmsLabel.setText(this.settings.msg("dialog.template.xms"));
        this.xms = new Button((Composite)this.memoryGroup, 32);
        this.xms.setToolTipText(this.settings.msg("dialog.template.xms.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label emsLabel = new Label((Composite)this.memoryGroup, 0);
        emsLabel.setText(this.settings.msg("dialog.template.ems"));
        this.ems = new Combo((Composite)this.memoryGroup, 8);
        this.ems.setItems(this.settings.getSettings().getValues("profile", "ems"));
        this.ems.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ems.setToolTipText(this.settings.msg("dialog.template.ems.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label umbLabel = new Label((Composite)this.memoryGroup, 0);
        umbLabel.setText(this.settings.msg("dialog.template.umb"));
        this.umb = new Combo((Composite)this.memoryGroup, 8);
        this.umb.setItems(this.settings.getSettings().getValues("profile", "umb"));
        this.umb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.umb.setToolTipText(this.settings.msg("dialog.template.umb.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Group expMemoryGroup = new Group(composite_xo, 0);
        expMemoryGroup.setText(this.settings.msg("dialog.template.memory"));
        expMemoryGroup.setLayout((Layout)new GridLayout(2, false));
        Label sizeKBLabel = new Label((Composite)expMemoryGroup, 0);
        sizeKBLabel.setText(this.settings.msg("dialog.template.memorysizekb"));
        this.memsizeKB = new Text((Composite)expMemoryGroup, 2048);
        this.memsizeKB.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label aliasLabel = new Label((Composite)expMemoryGroup, 0);
        aliasLabel.setText(this.settings.msg("dialog.template.memalias"));
        this.memalias = new Combo((Composite)expMemoryGroup, 0);
        this.memalias.setItems(this.settings.getSettings().getValues("profile", "memalias"));
        this.memalias.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected TabFolder createRelExpTabs(TabFolder tabFolder, String titleKey, int col1, int col2) {
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText(this.settings.msg(titleKey));
        Composite compositeHoldingSubTabs = new Composite((Composite)tabFolder, 0);
        compositeHoldingSubTabs.setLayout((Layout)new FillLayout());
        displayTabItem.setControl((Control)compositeHoldingSubTabs);
        TabFolder subTabFolder = new TabFolder(compositeHoldingSubTabs, 0);
        TabItem releaseOptionsTabItem = new TabItem(subTabFolder, 0);
        releaseOptionsTabItem.setText(this.settings.msg("dialog.template.tab.releaseoptions"));
        TabItem experimentalOptionsTabItem = new TabItem(subTabFolder, 0);
        experimentalOptionsTabItem.setText(this.settings.msg("dialog.template.tab.experimentaloptions"));
        Composite relComp = new Composite((Composite)subTabFolder, 0);
        relComp.setLayout((Layout)new GridLayout(col1, false));
        releaseOptionsTabItem.setControl((Control)relComp);
        Composite expComp = new Composite((Composite)subTabFolder, 0);
        expComp.setLayout((Layout)new GridLayout(col2, false));
        experimentalOptionsTabItem.setControl((Control)expComp);
        return subTabFolder;
    }

    protected void createDisplayTab(TabFolder tabFolder) {
        TabFolder subTabFolder = this.createRelExpTabs(tabFolder, "dialog.template.tab.display", 1, 2);
        Composite composite_ro = (Composite)subTabFolder.getChildren()[0];
        Composite composite_xo = (Composite)subTabFolder.getChildren()[1];
        Group groupRelease = new Group(composite_ro, 0);
        groupRelease.setLayoutData((Object)new GridData(1, 1, false, false));
        groupRelease.setLayout((Layout)new GridLayout(4, false));
        groupRelease.setText(this.settings.msg("dialog.template.general"));
        Label outputLabel = new Label((Composite)groupRelease, 0);
        outputLabel.setText(this.settings.msg("dialog.template.output"));
        this.output = new Combo((Composite)groupRelease, 8);
        this.output.setItems(this.settings.getSettings().getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.output.setToolTipText(this.settings.msg("dialog.template.output.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Label frameskipLabel = new Label((Composite)groupRelease, 0);
        frameskipLabel.setText(this.settings.msg("dialog.template.frameskip"));
        this.frameskip = new Combo((Composite)groupRelease, 8);
        this.frameskip.setItems(this.settings.getSettings().getValues("profile", "frameskip"));
        this.frameskip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.frameskip.setToolTipText(this.settings.msg("dialog.template.frameskip.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Label scalerLabel = new Label((Composite)groupRelease, 0);
        scalerLabel.setText(this.settings.msg("dialog.template.scaler"));
        this.scaler = new Combo((Composite)groupRelease, 8);
        this.scaler.setItems(this.settings.getSettings().getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scaler.setToolTipText(this.settings.msg("dialog.template.scaler.tooltip"));
        Label forcedLabel = new Label((Composite)groupRelease, 0);
        forcedLabel.setText(this.settings.msg("dialog.template.scalerforced"));
        this.scaler_forced = new Button((Composite)groupRelease, 32);
        this.scaler_forced.setToolTipText(this.settings.msg("dialog.template.scalerforced.tooltip"));
        Label resolutionLabel = new Label((Composite)groupRelease, 0);
        resolutionLabel.setText(this.settings.msg("dialog.template.fullscreenresolution"));
        this.fullresolution = new Combo((Composite)groupRelease, 8);
        this.fullresolution.setItems(this.settings.getSettings().getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        this.fullresolution.setToolTipText(this.settings.msg("dialog.template.fullscreenresolution.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Label windowResLabel = new Label((Composite)groupRelease, 0);
        windowResLabel.setText(this.settings.msg("dialog.template.windowresolution"));
        this.windowresolution = new Combo((Composite)groupRelease, 8);
        this.windowresolution.setItems(this.settings.getSettings().getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        this.windowresolution.setToolTipText(this.settings.msg("dialog.template.windowresolution.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Label fullscreenLabel = new Label((Composite)groupRelease, 0);
        fullscreenLabel.setText(this.settings.msg("dialog.template.fullscreen"));
        this.fullscreen = new Button((Composite)groupRelease, 32);
        this.fullscreen.setToolTipText(this.settings.msg("dialog.template.fullscreen.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Label doubleBuffLabel = new Label((Composite)groupRelease, 0);
        doubleBuffLabel.setText(this.settings.msg("dialog.template.doublebuffering"));
        this.fulldouble = new Button((Composite)groupRelease, 32);
        this.fulldouble.setToolTipText(this.settings.msg("dialog.template.doublebuffering.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Label aspectLabel = new Label((Composite)groupRelease, 0);
        aspectLabel.setText(this.settings.msg("dialog.template.aspectcorrection"));
        this.aspect = new Button((Composite)groupRelease, 32);
        this.aspect.setToolTipText(this.settings.msg("dialog.template.aspectcorrection.tooltip"));
        new Label((Composite)groupRelease, 0);
        new Label((Composite)groupRelease, 0);
        Group groupExpGeneral = new Group(composite_xo, 0);
        groupExpGeneral.setLayoutData((Object)new GridData(1, 1, false, false));
        groupExpGeneral.setLayout((Layout)new GridLayout(2, false));
        groupExpGeneral.setText(this.settings.msg("dialog.template.general"));
        Label autofitLabel = new Label((Composite)groupExpGeneral, 0);
        autofitLabel.setText(this.settings.msg("dialog.template.autofit"));
        this.autofit = new Button((Composite)groupExpGeneral, 32);
        Label pixelshaderLabel = new Label((Composite)groupExpGeneral, 0);
        pixelshaderLabel.setLayoutData((Object)new GridData());
        pixelshaderLabel.setText(this.settings.msg("dialog.template.pixelshader"));
        this.pixelshader = new Combo((Composite)groupExpGeneral, 0);
        this.pixelshader.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(20);
        String[] shaders = FileUtils.getShaders();
        if (shaders != null && shaders.length > 0) {
            this.pixelshader.setItems(shaders);
            this.pixelshader.add("none", 0);
        } else {
            this.pixelshader.setItems(this.settings.getSettings().getValues("profile", "pixelshader"));
        }
        Label linewiseLabel = new Label((Composite)groupExpGeneral, 0);
        linewiseLabel.setText(this.settings.msg("dialog.template.linewise"));
        this.linewise = new Button((Composite)groupExpGeneral, 32);
        Label char9Label = new Label((Composite)groupExpGeneral, 0);
        char9Label.setText(this.settings.msg("dialog.template.char9"));
        this.char9 = new Button((Composite)groupExpGeneral, 32);
        Label multiscanLabel = new Label((Composite)groupExpGeneral, 0);
        multiscanLabel.setText(this.settings.msg("dialog.template.multiscan"));
        this.multiscan = new Button((Composite)groupExpGeneral, 32);
        Label cgasnowLabel = new Label((Composite)groupExpGeneral, 0);
        cgasnowLabel.setText(this.settings.msg("dialog.template.cgasnow"));
        this.cgasnow = new Button((Composite)groupExpGeneral, 32);
        Label overscanLabel = new Label((Composite)groupExpGeneral, 0);
        overscanLabel.setText(this.settings.msg("dialog.template.overscan"));
        this.overscan = new Combo((Composite)groupExpGeneral, 0);
        this.overscan.setItems(this.settings.getSettings().getValues("profile", "overscan"));
        this.overscan.setLayoutData((Object)new GridData(25, -1));
        Label vsyncModeLabel = new Label((Composite)groupExpGeneral, 0);
        vsyncModeLabel.setText(this.settings.msg("dialog.template.vsyncmode"));
        this.vsyncmode = new Combo((Composite)groupExpGeneral, 8);
        this.vsyncmode.setItems(this.settings.getSettings().getValues("profile", "vsyncmode"));
        Label vsyncRateLabel = new Label((Composite)groupExpGeneral, 0);
        vsyncRateLabel.setLayoutData((Object)new GridData());
        vsyncRateLabel.setText(this.settings.msg("dialog.template.vsyncrate"));
        this.vsyncrate = new Text((Composite)groupExpGeneral, 2048);
        this.vsyncrate.setLayoutData((Object)new GridData(25, -1));
        Label forceRateLabel = new Label((Composite)groupExpGeneral, 0);
        forceRateLabel.setLayoutData((Object)new GridData());
        forceRateLabel.setText(this.settings.msg("dialog.template.forcerate"));
        this.forcerate = new Text((Composite)groupExpGeneral, 2048);
        this.forcerate.setLayoutData((Object)new GridData(25, -1));
        Label videoRamLabel = new Label((Composite)groupExpGeneral, 0);
        videoRamLabel.setText(this.settings.msg("dialog.template.videoram"));
        this.videoram = new Combo((Composite)groupExpGeneral, 8);
        this.videoram.setItems(this.settings.getSettings().getValues("profile", "vmemsize"));
        this.videoram.setLayoutData((Object)new GridData(25, -1));
        Group groupExpGlide = new Group(composite_xo, 0);
        groupExpGlide.setLayoutData((Object)new GridData(1, 1, false, false));
        groupExpGlide.setLayout((Layout)new GridLayout(2, false));
        groupExpGlide.setText(this.settings.msg("dialog.template.glide"));
        Label glideLabel = new Label((Composite)groupExpGlide, 0);
        glideLabel.setText(this.settings.msg("dialog.template.glide"));
        this.glide = new Combo((Composite)groupExpGlide, 8);
        this.glide.setItems(this.settings.getSettings().getValues("profile", "glide"));
        this.glide.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        Label glidePortLabel = new Label((Composite)groupExpGlide, 0);
        glidePortLabel.setText(this.settings.msg("dialog.template.glideport"));
        this.glideport = new Text((Composite)groupExpGlide, 2048);
        this.glideport.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lfbGlideLabel = new Label((Composite)groupExpGlide, 0);
        lfbGlideLabel.setText(this.settings.msg("dialog.template.lfbglide"));
        this.lfbGlide = new Combo((Composite)groupExpGlide, 8);
        this.lfbGlide.setItems(this.settings.getSettings().getValues("profile", "lfbglide"));
        this.lfbGlide.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label splashLabel = new Label((Composite)groupExpGlide, 0);
        splashLabel.setText(this.settings.msg("dialog.template.splash3dfx"));
        this.splash3dfx = new Button((Composite)groupExpGlide, 32);
    }

    protected void createGeneralTab(TabFolder tabFolder) {
        this.generalTabItem = new TabItem(tabFolder, 0);
        this.generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new GridLayout());
        this.generalTabItem.setControl((Control)composite_1);
        this.associationGroup = new Group(composite_1, 0);
        this.associationGroup.setText(this.settings.msg("dialog.template.association"));
        this.associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.associationGroup.setLayout((Layout)new GridLayout(5, false));
        Label dbversionLabel = new Label((Composite)this.associationGroup, 0);
        dbversionLabel.setText(this.settings.msg("dialog.template.dosboxversion"));
        this.dbversion = new Combo((Composite)this.associationGroup, 8);
        this.dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(20);
        this.setButton = new Button((Composite)this.associationGroup, 0);
        this.setButton.setText(this.settings.msg("dialog.template.set"));
        this.setButton.setToolTipText(this.settings.msg("dialog.template.set.tooltip"));
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.SET);
            }
        });
        this.switchButton = new Button((Composite)this.associationGroup, 0);
        this.switchButton.setText(this.settings.msg("dialog.template.switch"));
        this.switchButton.setToolTipText(this.settings.msg("dialog.template.switch.tooltip"));
        this.switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.SWITCH);
            }
        });
        this.dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.setButton.setEnabled(true);
                EditTemplateDialog.this.switchButton.setEnabled(true);
            }
        });
        this.reloadButton = new Button((Composite)this.associationGroup, 0);
        this.reloadButton.setText(this.settings.msg("dialog.template.reloadsettings"));
        this.reloadButton.setToolTipText(this.settings.msg("dialog.template.reloadsettings.tooltip"));
        this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.RELOAD);
            }
        });
        this.miscGroup = new Group(composite_1, 0);
        this.miscGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        this.miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.miscGroup.setLayout((Layout)new GridLayout(3, false));
        new Label((Composite)this.miscGroup, 0);
        Label activeLabel = new Label((Composite)this.miscGroup, 0);
        activeLabel.setText(this.settings.msg("dialog.template.active"));
        Label inactiveLabel = new Label((Composite)this.miscGroup, 0);
        inactiveLabel.setText(this.settings.msg("dialog.template.inactive"));
        Label priorityLabel = new Label((Composite)this.miscGroup, 0);
        priorityLabel.setText(this.settings.msg("dialog.template.priority"));
        this.priority_active = new Combo((Composite)this.miscGroup, 8);
        this.priority_active.setItems(this.settings.getSettings().getValues("profile", "priority_active"));
        this.priority_active.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_active.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        this.priority_inactive = new Combo((Composite)this.miscGroup, 8);
        this.priority_inactive.setItems(this.settings.getSettings().getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_inactive.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        Label waitOnErrorLabel = new Label((Composite)this.miscGroup, 0);
        waitOnErrorLabel.setText(this.settings.msg("dialog.template.waitonerror"));
        this.waitonerror = new Button((Composite)this.miscGroup, 32);
        this.waitonerror.setToolTipText(this.settings.msg("dialog.template.waitonerror.tooltip"));
        new Label((Composite)this.miscGroup, 0);
        Label exitLabel = new Label((Composite)this.miscGroup, 0);
        exitLabel.setText(this.settings.msg("dialog.template.exitafterwards"));
        this.exit = new Button((Composite)this.miscGroup, 32);
        new Label((Composite)this.miscGroup, 0);
        Label languageFileLabel = new Label((Composite)this.miscGroup, 0);
        languageFileLabel.setLayoutData((Object)new GridData());
        languageFileLabel.setText(this.settings.msg("dialog.template.languagefile"));
        this.language = new Text((Composite)this.miscGroup, 2048);
        this.language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.language.setToolTipText(this.settings.msg("dialog.template.languagefile.tooltip"));
        Label capturesLabel = new Label((Composite)this.miscGroup, 0);
        capturesLabel.setLayoutData((Object)new GridData());
        capturesLabel.setText(this.settings.msg("dialog.template.captures"));
        this.captures = new Text((Composite)this.miscGroup, 2048);
        this.captures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
        this.captures.setToolTipText(this.settings.msg("dialog.template.captures.tooltip"));
        Label configFileLabel = new Label((Composite)this.miscGroup, 0);
        configFileLabel.setText(this.settings.msg("dialog.profile.configfile"));
        this.config_file = new Text((Composite)this.miscGroup, 2048);
        this.config_file.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.config_file.setEditable(false);
        this.config_file.setText(this.result instanceof Template ? FileUtils.constructCanonicalTemplateFileLocation(((Template)this.result).getId()).getPath() : SettingsDialog.confFilenames[0]);
    }

    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.template.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.template.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(this.settings.msg("dialog.template.default"));
        this.defaultButton = new Button(composite, 32);
    }

    protected void selectSettingsByConfiguration(Conf conf) {
        SectionsWrapper sections = conf.getSettings();
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "priority", (Control)this.priority_active, (Control)this.priority_inactive);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "waitonerror", (Control)this.waitonerror);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "language", (Control)this.language);
        EditTemplateDialog.setFieldIfEnabled(this.settings.msg("dialog.profile.automatic"), false, (Control)this.captures);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "output", (Control)this.output);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "frameskip", (Control)this.frameskip);
        if (sections.isConflictingValue("render", "scaler")) {
            EditTemplateDialog.setFieldIfEnabled(sections, "render", "scaler", (Control)this.scaler);
            EditTemplateDialog.setFieldIfEnabled(null, true, (Control)this.scaler_forced);
        } else {
            String value = sections.getValue("render", "scaler");
            if (value.endsWith(" forced")) {
                EditTemplateDialog.setFieldIfEnabled(value.substring(0, value.length() - 7), false, (Control)this.scaler);
                EditTemplateDialog.setFieldIfEnabled(String.valueOf(true), false, (Control)this.scaler_forced);
            } else {
                EditTemplateDialog.setFieldIfEnabled(value, false, (Control)this.scaler);
                EditTemplateDialog.setFieldIfEnabled(String.valueOf(false), false, (Control)this.scaler_forced);
            }
        }
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "fullscreen", (Control)this.fullscreen);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "fulldouble", (Control)this.fulldouble);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "fullresolution", (Control)this.fullresolution);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "windowresolution", (Control)this.windowresolution);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "aspect", (Control)this.aspect);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "machine", (Control)this.machine);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "core", (Control)this.core);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cycles", (Control)this.cycles);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cycleup", (Control)this.cycles_up);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cycledown", (Control)this.cycles_down);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "memsize", (Control)this.memsize);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "xms", (Control)this.xms);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "ems", (Control)this.ems);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "umb", (Control)this.umb);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "nosound", (Control)this.nosound);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "rate", (Control)this.rate);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "blocksize", (Control)this.blocksize);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "prebuffer", (Control)this.prebuffer);
        if (sections.hasValue("midi", "intelligent")) {
            if (sections.isConflictingValue("midi", "mpu401") || sections.isConflictingValue("midi", "intelligent")) {
                EditTemplateDialog.setFieldIfEnabled(null, true, (Control)this.mpu401);
            } else {
                EditTemplateDialog.setFieldIfEnabled(sections.getBooleanValue("midi", "mpu401") ? (sections.getBooleanValue("midi", "intelligent") ? "intelligent" : "uart") : "none", false, (Control)this.mpu401);
            }
        } else {
            EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mpu401", (Control)this.mpu401);
        }
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "device", "mididevice", (Control)this.midi_device);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "config", "midiconfig", (Control)this.midi_config);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "type", "sbtype", (Control)this.sbtype);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "oplmode", (Control)this.oplmode);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "oplrate", (Control)this.oplrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "oplemu", (Control)this.oplemu);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "base", "sbbase", (Control)this.sbbase);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "irq", (Control)this.irq);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "dma", (Control)this.dma);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "hdma", (Control)this.hdma);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "mixer", "sbmixer", (Control)this.sbmixer);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "gus", (Control)this.gus);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "rate", "gusrate", (Control)this.gusrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "base", "gusbase", (Control)this.gusbase);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "irq1", "gusirq", (Control)this.gusirq1);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "irq2", "gusirq", (Control)this.gusirq2);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "dma1", "gusdma", (Control)this.gusdma1);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "dma2", "gusdma", (Control)this.gusdma2);
        EditTemplateDialog.setFieldIfEnabled(sections, "gus", "ultradir", (Control)this.ultradir);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "pcspeaker", (Control)this.pcspeaker);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "pcrate", (Control)this.pcrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "tandy", (Control)this.tandy);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "tandyrate", (Control)this.tandyrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "disney", (Control)this.disney);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "autolock", (Control)this.autolock);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "sensitivity", (Control)this.sensitivity);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "usescancodes", (Control)this.usescancodes);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "mapperfile", (Control)this.mapperfile);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "keyboardlayout", (Control)this.keyboard_layout);
        if (sections.hasValue("joystick", "joysticktype")) {
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "joysticktype", (Control)this.joysticktype);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "timed", (Control)this.timed);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "autofire", (Control)this.autofire);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "swap34", (Control)this.swap34);
            EditTemplateDialog.setFieldIfEnabled(sections, "joystick", "buttonwrap", (Control)this.buttonwrap);
        } else {
            EditTemplateDialog.setFieldIfEnabled(sections, "bios", "joysticktype", (Control)this.joysticktype);
        }
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial1", (Control)this.serial1);
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial2", (Control)this.serial2);
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial3", (Control)this.serial3);
        EditTemplateDialog.setFieldIfEnabled(sections, "serial", "serial4", (Control)this.serial4);
        EditTemplateDialog.setFieldIfEnabled(sections, "ipx", "ipx", (Control)this.ipx);
        this.ipxnet.setEnabled(this.ipx.getSelection());
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "autofit", (Control)this.autofit);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "linewise", (Control)this.linewise);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "char9", (Control)this.char9);
        EditTemplateDialog.setFieldIfEnabled(sections, "render", "multiscan", (Control)this.multiscan);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "cgasnow", (Control)this.cgasnow);
        EditTemplateDialog.setFieldIfEnabled(sections, "sdl", "overscan", (Control)this.overscan);
        EditTemplateDialog.setFieldIfEnabled(sections, "vsync", "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.setFieldIfEnabled(sections, "vsync", "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "forcerate", (Control)this.forcerate);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "vmemsize", (Control)this.videoram);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "glide", (Control)this.glide);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "lfb", (Control)this.lfbGlide);
        EditTemplateDialog.setFieldIfEnabled(sections, "glide", "splash", (Control)this.splash3dfx);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "memsizekb", (Control)this.memsizeKB);
        EditTemplateDialog.setFieldIfEnabled(sections, "dosbox", "memalias", (Control)this.memalias);
        EditTemplateDialog.setFieldIfEnabled(sections, "mixer", "swapstereo", (Control)this.swapstereo);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "hardwarebase", (Control)this.hardwareaddresssbbase);
        EditTemplateDialog.setFieldIfEnabled(sections, "sblaster", "goldplay", (Control)this.goldplay);
        EditTemplateDialog.setOnOffFieldIfEnabled(sections, "midi", "mt32.reverse.stereo", (Control)this.swapstereoMT32);
        EditTemplateDialog.setOnOffFieldIfEnabled(sections, "midi", "mt32.verbose", (Control)this.loggingMT32);
        EditTemplateDialog.setOnOffFieldIfEnabled(sections, "midi", "mt32.thread", (Control)this.multithreadMT32);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mt32.dac", (Control)this.dacMT32);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mt32.reverb.mode", (Control)this.reverbmodeMT32);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mt32.reverb.time", (Control)this.reverbtimeMT32);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mt32.reverb.level", (Control)this.reverblevelMT32);
        EditTemplateDialog.setFieldIfEnabled(sections, "midi", "mt32.partials", (Control)this.partialsMT32);
        EditTemplateDialog.setOnOffFieldIfEnabled(sections, "speaker", "ps1audio", (Control)this.ps1);
        EditTemplateDialog.setFieldIfEnabled(sections, "speaker", "ps1audiorate", (Control)this.ps1rate);
        EditTemplateDialog.setFieldIfEnabled(sections, "innova", "innova", (Control)this.innova);
        EditTemplateDialog.setFieldIfEnabled(sections, "innova", "samplerate", (Control)this.innovarate);
        EditTemplateDialog.setFieldIfEnabled(sections, "innova", "sidbase", (Control)this.innovabase);
        EditTemplateDialog.setFieldIfEnabled(sections, "innova", "quality", (Control)this.innovaquality);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "int33", (Control)this.int33);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "biosps2", (Control)this.biosps2);
        EditTemplateDialog.setFieldIfEnabled(sections, "keyboard", "aux", (Control)this.aux);
        EditTemplateDialog.setFieldIfEnabled(sections, "keyboard", "auxdevice", (Control)this.auxdevice);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "files", (Control)this.files);
        EditTemplateDialog.setFieldIfEnabled(sections, "cpu", "isapnpbios", (Control)this.isapnpbios);
        EditTemplateDialog.setFieldIfEnabled(sections, "ide, primary", "enable", (Control)this.ide1);
        EditTemplateDialog.setFieldIfEnabled(sections, "ide, secondary", "enable", (Control)this.ide2);
        EditTemplateDialog.setFieldIfEnabled(sections, "ide, tertiary", "enable", (Control)this.ide3);
        EditTemplateDialog.setFieldIfEnabled(sections, "ide, quaternary", "enable", (Control)this.ide4);
        EditTemplateDialog.setFieldIfEnabled(sections, "dos", "automount", (Control)this.automount);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "printer", (Control)this.printer);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "dpi", (Control)this.printerdpi);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "width", (Control)this.printerwidth);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "height", (Control)this.printerheight);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "printoutput", (Control)this.printeroutput);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "multipage", (Control)this.printermultipage);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "docpath", (Control)this.printerdocpath);
        EditTemplateDialog.setFieldIfEnabled(sections, "printer", "timeout", (Control)this.printertimeout);
        EditTemplateDialog.setFieldIfEnabled(sections, "parallel", "parallel1", (Control)this.parallel1);
        EditTemplateDialog.setFieldIfEnabled(sections, "parallel", "parallel2", (Control)this.parallel2);
        EditTemplateDialog.setFieldIfEnabled(sections, "parallel", "parallel3", (Control)this.parallel3);
        EditTemplateDialog.setFieldIfEnabled(sections, "parallel", "dongle", (Control)this.dongle);
        EditTemplateDialog.setFieldIfEnabled(sections, "ne2000", "ne2000", (Control)this.ne2000);
        EditTemplateDialog.setFieldIfEnabled(sections, "ne2000", "nicbase", (Control)this.ne2000base);
        EditTemplateDialog.setFieldIfEnabled(sections, "ne2000", "nicirq", (Control)this.ne2000irq);
        EditTemplateDialog.setFieldIfEnabled(sections, "ne2000", "macaddr", (Control)this.ne2000macaddress);
        EditTemplateDialog.setFieldIfEnabled(sections, "ne2000", "realnic", (Control)this.ne2000realnic);
        EditTemplateDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isExit()), Conf.isConflictingValue(conf.getAutoexec().isExit()), (Control)this.exit);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getMixer(), Conf.isConflictingValue(conf.getAutoexec().getMixer()), (Control)this.mixer_config);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getKeyb(), Conf.isConflictingValue(conf.getAutoexec().getKeyb()), (Control)this.keyb);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getIpxnet(), Conf.isConflictingValue(conf.getAutoexec().getIpxnet()), (Control)this.ipxnet);
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            EditTemplateDialog.setFieldIfEnabled(StringRelatedUtils.stringToTextArea(conf.getAutoexec().getCustomSection(i), this.customCommands[i].getLineDelimiter(), PlatformUtils.EOLN), Conf.isConflictingValue(conf.getAutoexec().getCustomSection(i)), (Control)this.customCommands[i]);
        }
        if (!this.isMultiEdit()) {
            this.mountingpoints.setItems(conf.getAutoexec().getMountingpoints());
            this.dosExpandItem.setExpanded(!conf.getAutoexec().isBooter());
            this.booterExpandItem.setExpanded(conf.getAutoexec().isBooter());
        }
    }

    protected void updateConfigurationBySettings(Conf conf) {
        boolean singleEdit = !this.isMultiEdit();
        conf.updateValue("sdl", "priority", this.priority_active.getText() + "," + this.priority_inactive.getText(), singleEdit || (Boolean)this.priority_active.getData() != false || (Boolean)this.priority_inactive.getData() != false);
        conf.updateValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()), singleEdit || (Boolean)this.waitonerror.getData() != false);
        conf.updateValue("dosbox", "language", this.language.getText(), singleEdit || (Boolean)this.language.getData() != false);
        conf.updateValue("sdl", "output", this.output.getText(), singleEdit || (Boolean)this.output.getData() != false);
        conf.updateValue("render", "frameskip", this.frameskip.getText(), singleEdit || (Boolean)this.frameskip.getData() != false);
        conf.updateScalerValue(this.scaler.getText(), this.scaler_forced.getSelection(), singleEdit || (Boolean)this.scaler.getData() != false || (Boolean)this.scaler_forced.getData() != false);
        conf.updateValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()), singleEdit || (Boolean)this.fullscreen.getData() != false);
        conf.updateValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()), singleEdit || (Boolean)this.fulldouble.getData() != false);
        conf.updateValue("sdl", "fullresolution", this.fullresolution.getText(), singleEdit || (Boolean)this.fullresolution.getData() != false);
        conf.updateValue("sdl", "windowresolution", this.windowresolution.getText(), singleEdit || (Boolean)this.windowresolution.getData() != false);
        conf.updateValue("render", "aspect", String.valueOf(this.aspect.getSelection()), singleEdit || (Boolean)this.aspect.getData() != false);
        conf.updateValue("dosbox", "machine", this.machine.getText(), singleEdit || (Boolean)this.machine.getData() != false);
        conf.updateValue("cpu", "cputype", this.cpu_type.getText(), singleEdit || (Boolean)this.cpu_type.getData() != false);
        conf.updateValue("cpu", "core", this.core.getText(), singleEdit || (Boolean)this.core.getData() != false);
        conf.updateValue("cpu", "cycles", this.cycles.getText(), singleEdit || (Boolean)this.cycles.getData() != false);
        conf.updateValue("cpu", "cycleup", this.cycles_up.getText(), singleEdit || (Boolean)this.cycles_up.getData() != false);
        conf.updateValue("cpu", "cycledown", this.cycles_down.getText(), singleEdit || (Boolean)this.cycles_down.getData() != false);
        conf.updateValue("dosbox", "memsize", this.memsize.getText(), singleEdit || (Boolean)this.memsize.getData() != false);
        conf.updateValue("dos", "xms", String.valueOf(this.xms.getSelection()), singleEdit || (Boolean)this.xms.getData() != false);
        conf.updateValue("dos", "ems", this.ems.getText(), singleEdit || (Boolean)this.ems.getData() != false);
        conf.updateValue("dos", "umb", this.umb.getText(), singleEdit || (Boolean)this.umb.getData() != false);
        conf.updateValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()), singleEdit || (Boolean)this.nosound.getData() != false);
        conf.updateValue("mixer", "rate", this.rate.getText(), singleEdit || (Boolean)this.rate.getData() != false);
        conf.updateValue("mixer", "blocksize", this.blocksize.getText(), singleEdit || (Boolean)this.blocksize.getData() != false);
        conf.updateValue("mixer", "prebuffer", this.prebuffer.getText(), singleEdit || (Boolean)this.prebuffer.getData() != false);
        conf.updateMidiValue(this.mpu401.getText(), singleEdit || (Boolean)this.mpu401.getData() != false);
        conf.updateValue("midi", "device", "mididevice", this.midi_device.getText(), singleEdit || (Boolean)this.midi_device.getData() != false);
        conf.updateValue("midi", "config", "midiconfig", this.midi_config.getText(), singleEdit || (Boolean)this.midi_config.getData() != false);
        conf.updateValue("sblaster", "type", "sbtype", this.sbtype.getText(), singleEdit || (Boolean)this.sbtype.getData() != false);
        conf.updateValue("sblaster", "oplmode", this.oplmode.getText(), singleEdit || (Boolean)this.oplmode.getData() != false);
        conf.updateValue("sblaster", "oplrate", this.oplrate.getText(), singleEdit || (Boolean)this.oplrate.getData() != false);
        conf.updateValue("sblaster", "oplemu", this.oplemu.getText(), singleEdit || (Boolean)this.oplemu.getData() != false);
        conf.updateValue("sblaster", "base", "sbbase", this.sbbase.getText(), singleEdit || (Boolean)this.sbbase.getData() != false);
        conf.updateValue("sblaster", "irq", this.irq.getText(), singleEdit || (Boolean)this.irq.getData() != false);
        conf.updateValue("sblaster", "dma", this.dma.getText(), singleEdit || (Boolean)this.dma.getData() != false);
        conf.updateValue("sblaster", "hdma", this.hdma.getText(), singleEdit || (Boolean)this.hdma.getData() != false);
        conf.updateValue("sblaster", "mixer", "sbmixer", String.valueOf(this.sbmixer.getSelection()), singleEdit || (Boolean)this.sbmixer.getData() != false);
        conf.updateValue("gus", "gus", String.valueOf(this.gus.getSelection()), singleEdit || (Boolean)this.gus.getData() != false);
        conf.updateValue("gus", "rate", "gusrate", this.gusrate.getText(), singleEdit || (Boolean)this.gusrate.getData() != false);
        conf.updateValue("gus", "base", "gusbase", this.gusbase.getText(), singleEdit || (Boolean)this.gusbase.getData() != false);
        conf.updateValue("gus", "irq1", "gusirq", this.gusirq1.getText(), singleEdit || (Boolean)this.gusirq1.getData() != false);
        conf.updateValue("gus", "irq2", this.gusirq2.getText(), singleEdit || (Boolean)this.gusirq2.getData() != false);
        conf.updateValue("gus", "dma1", "gusdma", this.gusdma1.getText(), singleEdit || (Boolean)this.gusdma1.getData() != false);
        conf.updateValue("gus", "dma2", this.gusdma2.getText(), singleEdit || (Boolean)this.gusdma2.getData() != false);
        conf.updateValue("gus", "ultradir", this.ultradir.getText(), singleEdit || (Boolean)this.ultradir.getData() != false);
        conf.updateValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()), singleEdit || (Boolean)this.pcspeaker.getData() != false);
        conf.updateValue("speaker", "pcrate", this.pcrate.getText(), singleEdit || (Boolean)this.pcrate.getData() != false);
        conf.updateValue("speaker", "tandy", this.tandy.getText(), singleEdit || (Boolean)this.tandy.getData() != false);
        conf.updateValue("speaker", "tandyrate", this.tandyrate.getText(), singleEdit || (Boolean)this.tandyrate.getData() != false);
        conf.updateValue("speaker", "disney", String.valueOf(this.disney.getSelection()), singleEdit || (Boolean)this.disney.getData() != false);
        conf.updateValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()), singleEdit || (Boolean)this.autolock.getData() != false);
        conf.updateValue("sdl", "sensitivity", this.sensitivity.getText(), singleEdit || (Boolean)this.sensitivity.getData() != false);
        conf.updateValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()), singleEdit || (Boolean)this.usescancodes.getData() != false);
        conf.updateValue("sdl", "mapperfile", this.mapperfile.getText(), singleEdit || (Boolean)this.mapperfile.getData() != false);
        conf.updateValue("dos", "keyboardlayout", this.keyboard_layout.getText(), singleEdit || (Boolean)this.keyboard_layout.getData() != false);
        conf.updateJoystickValue(this.joysticktype.getText(), this.timed.getSelection(), this.autofire.getSelection(), this.swap34.getSelection(), this.buttonwrap.getSelection(), singleEdit || (Boolean)this.joysticktype.getData() != false, singleEdit || (Boolean)this.timed.getData() != false, singleEdit || (Boolean)this.autofire.getData() != false, singleEdit || (Boolean)this.swap34.getData() != false, singleEdit || (Boolean)this.buttonwrap.getData() != false);
        conf.updateValue("serial", "serial1", this.serial1.getText(), singleEdit || (Boolean)this.serial1.getData() != false);
        conf.updateValue("serial", "serial2", this.serial2.getText(), singleEdit || (Boolean)this.serial2.getData() != false);
        conf.updateValue("serial", "serial3", this.serial3.getText(), singleEdit || (Boolean)this.serial3.getData() != false);
        conf.updateValue("serial", "serial4", this.serial4.getText(), singleEdit || (Boolean)this.serial4.getData() != false);
        conf.updateValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()), singleEdit || (Boolean)this.ipx.getData() != false);
        conf.updateValue("render", "autofit", String.valueOf(this.autofit.getSelection()), singleEdit || (Boolean)this.autofit.getData() != false);
        conf.updateValue("sdl", "pixelshader", this.pixelshader.getText(), singleEdit || (Boolean)this.pixelshader.getData() != false);
        conf.updateValue("render", "linewise", String.valueOf(this.linewise.getSelection()), singleEdit || (Boolean)this.linewise.getData() != false);
        conf.updateValue("render", "char9", String.valueOf(this.char9.getSelection()), singleEdit || (Boolean)this.char9.getData() != false);
        conf.updateValue("render", "multiscan", String.valueOf(this.multiscan.getSelection()), singleEdit || (Boolean)this.multiscan.getData() != false);
        conf.updateValue("cpu", "cgasnow", String.valueOf(this.cgasnow.getSelection()), singleEdit || (Boolean)this.cgasnow.getData() != false);
        conf.updateValue("sdl", "overscan", this.overscan.getText(), singleEdit || (Boolean)this.overscan.getData() != false);
        conf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText(), singleEdit || (Boolean)this.vsyncmode.getData() != false);
        conf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText(), singleEdit || (Boolean)this.vsyncrate.getData() != false);
        conf.updateValue("cpu", "forcerate", this.forcerate.getText(), singleEdit || (Boolean)this.forcerate.getData() != false);
        conf.updateValue("dosbox", "vmemsize", this.videoram.getText(), singleEdit || (Boolean)this.videoram.getData() != false);
        conf.updateValue("glide", "glide", this.glide.getText(), singleEdit || (Boolean)this.glide.getData() != false);
        conf.updateValue("glide", "port", "grport", this.glideport.getText(), singleEdit || (Boolean)this.glideport.getData() != false);
        conf.updateValue("glide", "lfb", this.lfbGlide.getText(), singleEdit || (Boolean)this.lfbGlide.getData() != false);
        conf.updateValue("glide", "splash", String.valueOf(this.splash3dfx.getSelection()), singleEdit || (Boolean)this.splash3dfx.getData() != false);
        conf.updateValue("dosbox", "memsizekb", this.memsizeKB.getText(), singleEdit || (Boolean)this.memsizeKB.getData() != false);
        conf.updateValue("dosbox", "memalias", this.memalias.getText(), singleEdit || (Boolean)this.memalias.getData() != false);
        conf.updateValue("mixer", "swapstereo", String.valueOf(this.swapstereo.getSelection()), singleEdit || (Boolean)this.swapstereo.getData() != false);
        conf.updateValue("sblaster", "hardwarebase", this.hardwareaddresssbbase.getText(), singleEdit || (Boolean)this.hardwareaddresssbbase.getData() != false);
        conf.updateValue("sblaster", "goldplay", String.valueOf(this.goldplay.getSelection()), singleEdit || (Boolean)this.goldplay.getData() != false);
        conf.updateValue("midi", "mt32.reverse.stereo", StringRelatedUtils.onOffValue(this.swapstereoMT32.getSelection()), singleEdit || (Boolean)this.swapstereoMT32.getData() != false);
        conf.updateValue("midi", "mt32.verbose", StringRelatedUtils.onOffValue(this.loggingMT32.getSelection()), singleEdit || (Boolean)this.loggingMT32.getData() != false);
        conf.updateValue("midi", "mt32.thread", StringRelatedUtils.onOffValue(this.multithreadMT32.getSelection()), singleEdit || (Boolean)this.multithreadMT32.getData() != false);
        conf.updateValue("midi", "mt32.dac", this.dacMT32.getText(), singleEdit || (Boolean)this.dacMT32.getData() != false);
        conf.updateValue("midi", "mt32.reverb.mode", this.reverbmodeMT32.getText(), singleEdit || (Boolean)this.reverbmodeMT32.getData() != false);
        conf.updateValue("midi", "mt32.reverb.time", this.reverbtimeMT32.getText(), singleEdit || (Boolean)this.reverbtimeMT32.getData() != false);
        conf.updateValue("midi", "mt32.reverb.level", this.reverblevelMT32.getText(), singleEdit || (Boolean)this.reverblevelMT32.getData() != false);
        conf.updateValue("midi", "mt32.partials", this.partialsMT32.getText(), singleEdit || (Boolean)this.partialsMT32.getData() != false);
        conf.updateValue("speaker", "ps1audio", StringRelatedUtils.onOffValue(this.ps1.getSelection()), singleEdit || (Boolean)this.ps1.getData() != false);
        conf.updateValue("speaker", "ps1audiorate", this.ps1rate.getText(), singleEdit || (Boolean)this.ps1rate.getData() != false);
        conf.updateValue("innova", "innova", String.valueOf(this.innova.getSelection()), singleEdit || (Boolean)this.innova.getData() != false);
        conf.updateValue("innova", "samplerate", this.innovarate.getText(), singleEdit || (Boolean)this.innovarate.getData() != false);
        conf.updateValue("innova", "sidbase", this.innovabase.getText(), singleEdit || (Boolean)this.innovabase.getData() != false);
        conf.updateValue("innova", "quality", this.innovaquality.getText(), singleEdit || (Boolean)this.innovaquality.getData() != false);
        conf.updateValue("dos", "int33", String.valueOf(this.int33.getSelection()), singleEdit || (Boolean)this.int33.getData() != false);
        conf.updateValue("dos", "biosps2", String.valueOf(this.biosps2.getSelection()), singleEdit || (Boolean)this.biosps2.getData() != false);
        conf.updateValue("keyboard", "aux", String.valueOf(this.aux.getSelection()), singleEdit || (Boolean)this.aux.getData() != false);
        conf.updateValue("keyboard", "auxdevice", this.auxdevice.getText(), singleEdit || (Boolean)this.auxdevice.getData() != false);
        conf.updateValue("dos", "files", this.files.getText(), singleEdit || (Boolean)this.files.getData() != false);
        conf.updateValue("cpu", "isapnpbios", String.valueOf(this.isapnpbios.getSelection()), singleEdit || (Boolean)this.isapnpbios.getData() != false);
        conf.updateValue("ide, primary", "enable", String.valueOf(this.ide1.getSelection()), singleEdit || (Boolean)this.ide1.getData() != false);
        conf.updateValue("ide, secondary", "enable", String.valueOf(this.ide2.getSelection()), singleEdit || (Boolean)this.ide2.getData() != false);
        conf.updateValue("ide, tertiary", "enable", String.valueOf(this.ide3.getSelection()), singleEdit || (Boolean)this.ide3.getData() != false);
        conf.updateValue("ide, quaternary", "enable", String.valueOf(this.ide4.getSelection()), singleEdit || (Boolean)this.ide4.getData() != false);
        conf.updateValue("dos", "automount", String.valueOf(this.automount.getSelection()), singleEdit || (Boolean)this.automount.getData() != false);
        conf.updateValue("printer", "printer", String.valueOf(this.printer.getSelection()), singleEdit || (Boolean)this.printer.getData() != false);
        conf.updateValue("printer", "dpi", this.printerdpi.getText(), singleEdit || (Boolean)this.printerdpi.getData() != false);
        conf.updateValue("printer", "width", this.printerwidth.getText(), singleEdit || (Boolean)this.printerwidth.getData() != false);
        conf.updateValue("printer", "height", this.printerheight.getText(), singleEdit || (Boolean)this.printerheight.getData() != false);
        conf.updateValue("printer", "printoutput", this.printeroutput.getText(), singleEdit || (Boolean)this.printeroutput.getData() != false);
        conf.updateValue("printer", "multipage", String.valueOf(this.printermultipage.getSelection()), singleEdit || (Boolean)this.printermultipage.getData() != false);
        conf.updateValue("printer", "docpath", this.printerdocpath.getText(), singleEdit || (Boolean)this.printerdocpath.getData() != false);
        conf.updateValue("printer", "timeout", this.printertimeout.getText(), singleEdit || (Boolean)this.printertimeout.getData() != false);
        conf.updateValue("parallel", "parallel1", this.parallel1.getText(), singleEdit || (Boolean)this.parallel1.getData() != false);
        conf.updateValue("parallel", "parallel2", this.parallel2.getText(), singleEdit || (Boolean)this.parallel2.getData() != false);
        conf.updateValue("parallel", "parallel3", this.parallel3.getText(), singleEdit || (Boolean)this.parallel3.getData() != false);
        conf.updateValue("parallel", "dongle", String.valueOf(this.dongle.getSelection()), singleEdit || (Boolean)this.dongle.getData() != false);
        conf.updateValue("ne2000", "ne2000", String.valueOf(this.ne2000.getSelection()), singleEdit || (Boolean)this.ne2000.getData() != false);
        conf.updateValue("ne2000", "nicbase", this.ne2000base.getText(), singleEdit || (Boolean)this.ne2000base.getData() != false);
        conf.updateValue("ne2000", "nicirq", this.ne2000irq.getText(), singleEdit || (Boolean)this.ne2000irq.getData() != false);
        conf.updateValue("ne2000", "macaddr", this.ne2000macaddress.getText(), singleEdit || (Boolean)this.ne2000macaddress.getData() != false);
        conf.updateValue("ne2000", "realnic", this.ne2000realnic.getText(), singleEdit || (Boolean)this.ne2000realnic.getData() != false);
        if (singleEdit) {
            String[] customSections = new String[this.customCommands.length];
            for (int i = 0; i < this.customCommands.length; ++i) {
                customSections[i] = StringRelatedUtils.textAreaToString(this.customCommands[i].getText(), this.customCommands[i].getLineDelimiter(), PlatformUtils.EOLN);
            }
            conf.setAutoexecSettingsForTemplate(this.exit.getSelection(), this.mixer_config.getText(), this.keyb.getText(), this.ipx.getSelection() ? this.ipxnet.getText() : "", this.booterExpandItem.getExpanded(), customSections);
        }
    }

    protected void doAddNativeCommand() {
        EditNativeCommandDialog cmdDialog = new EditNativeCommandDialog(this.shell);
        NativeCommand cmd = (NativeCommand)cmdDialog.open();
        if (cmd != null) {
            int nr = this.nativeCommands.getSelectionIndex() + 1;
            this.multiProfileList.get(0).getNativeCommandsList().add(nr, cmd);
            this.updateNativeCommands(nr);
        }
    }

    protected void doEditNativeCommand() {
        NativeCommand cmd;
        int sel = this.nativeCommands.getSelectionIndex();
        if (sel != -1 && (cmd = this.multiProfileList.get(0).getNativeCommandsList().get(sel)).getCommand() != null) {
            EditNativeCommandDialog cmdDialog = new EditNativeCommandDialog(this.shell);
            cmdDialog.setCommand(cmd);
            cmd = (NativeCommand)cmdDialog.open();
            if (cmd != null) {
                this.multiProfileList.get(0).getNativeCommandsList().set(sel, cmd);
                this.updateNativeCommands(sel);
            }
        }
    }

    protected void doRemoveNativeCommand() {
        NativeCommand cmd;
        int sel = this.nativeCommands.getSelectionIndex();
        if (sel != -1 && (cmd = this.multiProfileList.get(0).getNativeCommandsList().get(sel)).getCommand() != null) {
            this.multiProfileList.get(0).getNativeCommandsList().remove(sel);
            this.updateNativeCommands(Math.min(sel, this.nativeCommands.getItemCount() - 1));
        }
    }

    protected void doAddMount() {
        EditMountDialog addMountDialog = new EditMountDialog(this.shell);
        try {
            addMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(this.booterExpandItem.getExpanded(), this.multiProfileList.get(0).getConf().nettoMountedDriveLetters()));
        }
        catch (Exception e) {
            // empty catch block
        }
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().addMount(mount));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(sel));
            String mount = (String)editMountDialog.open();
            if (mount != null) {
                this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().editMount(sel, mount));
                if (this.mountingpoints.getItemCount() == mounts) {
                    this.mountingpoints.select(sel);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            this.mountingpoints.select(sel);
        }
        if (sel != -1) {
            this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().removeMount(sel));
            if (this.mountingpoints.getItemCount() == mounts) {
                this.mountingpoints.select(sel);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void updateItems(String[] items, boolean available, Combo combo) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(combo.getItems()));
        if (available) {
            for (String s : items) {
                if (l.contains(s)) continue;
                l.add(s);
            }
        } else {
            for (String s : items) {
                if (!l.contains(s)) continue;
                l.remove(s);
            }
        }
        combo.setItems(l.toArray(new String[0]));
    }

    protected void enableSettingsByConfiguration(SectionsWrapper conf) {
        this.setButton.setEnabled(false);
        this.switchButton.setEnabled(false);
        Object[] otherValues = null;
        if (conf != null) {
            otherValues = conf.hasValue("cpu", "cputype") ? this.settings.getSettings().getValues("profile", "machine073") : this.settings.getSettings().getValues("profile", "machine");
            this.updateItems(new String[]{"desktop"}, conf.hasFullResolutionDesktopSupport(), this.fullresolution);
            this.updateItems(new String[]{"openglhq", "direct3d"}, conf.hasOutputDirect3DSupport(), this.output);
            this.updateItems(new String[]{"cga_mono", "svga_s3_full", "amstrad"}, conf.hasAmstradSupport(), this.machine);
            this.updateItems(new String[]{"hardware2x", "hardware3x"}, conf.hasHardwareScalerSupport(), this.scaler);
            this.updateItems(new String[]{"mt32", "synth", "timidity"}, conf.hasMT32Support(), this.midi_device);
            this.updateItems(new String[]{"sb16vibra"}, conf.hasSoundBlaster16VibraSupport(), this.sbtype);
            this.updateItems(new String[]{"hardware", "hardwaregb"}, conf.hasHardwareOPLSupport(), this.oplmode);
            this.updateItems(new String[]{"486", "pentium", "pentium_mmx"}, conf.hasAdditionalCPUTypesSupport(), this.cpu_type);
        } else {
            otherValues = this.settings.getSettings().getCommonValues("profile", "machine073", "machine");
        }
        if (!Arrays.equals(this.machine.getItems(), otherValues)) {
            Object obj = this.machine.getData();
            this.machine.setItems((String[])otherValues);
            this.machine.setData(obj);
        }
        EditTemplateDialog.enableDisableControl(conf, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.enableDisableControl(conf, "dos", "umb", (Control)this.umb);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "windowresolution", (Control)this.windowresolution);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "usescancodes", (Control)this.usescancodes);
        EditTemplateDialog.enableDisableControl(conf, "sblaster", "oplemu", (Control)this.oplemu);
        EditTemplateDialog.enableDisableControl(conf, "gus", "irq2", (Control)this.gusirq2);
        EditTemplateDialog.enableDisableControl(conf, "gus", "dma2", (Control)this.gusdma2);
        EditTemplateDialog.enableDisableControl(conf, "speaker", "tandy", (Control)this.tandy);
        EditTemplateDialog.enableDisableControl(conf, "bios", "joysticktype", "joystick", "joysticktype", (Control)this.joysticktype);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "timed", (Control)this.timed);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "autofire", (Control)this.autofire);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "swap34", (Control)this.swap34);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "buttonwrap", (Control)this.buttonwrap);
        EditTemplateDialog.enableDisableControl(conf, "dos", "keyboardlayout", (Control)this.keyboard_layout);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial1", (Control)this.serial1);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial2", (Control)this.serial2);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial3", (Control)this.serial3);
        EditTemplateDialog.enableDisableControl(conf, "serial", "serial4", (Control)this.serial4);
        EditTemplateDialog.enableDisableControl(conf, "render", "autofit", (Control)this.autofit);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.enableDisableControl(conf, "render", "linewise", (Control)this.linewise);
        EditTemplateDialog.enableDisableControl(conf, "render", "char9", (Control)this.char9);
        EditTemplateDialog.enableDisableControl(conf, "render", "multiscan", (Control)this.multiscan);
        EditTemplateDialog.enableDisableControl(conf, "cpu", "cgasnow", (Control)this.cgasnow);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "overscan", (Control)this.overscan);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.enableDisableControl(conf, "cpu", "forcerate", (Control)this.forcerate);
        EditTemplateDialog.enableDisableControl(conf, "dosbox", "vmemsize", (Control)this.videoram);
        EditTemplateDialog.enableDisableControl(conf, "glide", "glide", (Control)this.glide);
        EditTemplateDialog.enableDisableControl(conf, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.enableDisableControl(conf, "glide", "lfb", (Control)this.lfbGlide);
        EditTemplateDialog.enableDisableControl(conf, "glide", "splash", (Control)this.splash3dfx);
        EditTemplateDialog.enableDisableControl(conf, "dosbox", "memsizekb", (Control)this.memsizeKB);
        EditTemplateDialog.enableDisableControl(conf, "dosbox", "memalias", (Control)this.memalias);
        EditTemplateDialog.enableDisableControl(conf, "mixer", "swapstereo", (Control)this.swapstereo);
        EditTemplateDialog.enableDisableControl(conf, "sblaster", "hardwarebase", (Control)this.hardwareaddresssbbase);
        EditTemplateDialog.enableDisableControl(conf, "sblaster", "goldplay", (Control)this.goldplay);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.reverse.stereo", (Control)this.swapstereoMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.verbose", (Control)this.loggingMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.thread", (Control)this.multithreadMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.dac", (Control)this.dacMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.reverb.mode", (Control)this.reverbmodeMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.reverb.time", (Control)this.reverbtimeMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.reverb.level", (Control)this.reverblevelMT32);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32.partials", (Control)this.partialsMT32);
        EditTemplateDialog.enableDisableControl(conf, "speaker", "ps1audio", (Control)this.ps1);
        EditTemplateDialog.enableDisableControl(conf, "speaker", "ps1audiorate", (Control)this.ps1rate);
        EditTemplateDialog.enableDisableControl(conf, "innova", "innova", (Control)this.innova);
        EditTemplateDialog.enableDisableControl(conf, "innova", "samplerate", (Control)this.innovarate);
        EditTemplateDialog.enableDisableControl(conf, "innova", "sidbase", (Control)this.innovabase);
        EditTemplateDialog.enableDisableControl(conf, "innova", "quality", (Control)this.innovaquality);
        EditTemplateDialog.enableDisableControl(conf, "dos", "int33", (Control)this.int33);
        EditTemplateDialog.enableDisableControl(conf, "dos", "biosps2", (Control)this.biosps2);
        EditTemplateDialog.enableDisableControl(conf, "keyboard", "aux", (Control)this.aux);
        EditTemplateDialog.enableDisableControl(conf, "keyboard", "auxdevice", (Control)this.auxdevice);
        EditTemplateDialog.enableDisableControl(conf, "dos", "files", (Control)this.files);
        EditTemplateDialog.enableDisableControl(conf, "cpu", "isapnpbios", (Control)this.isapnpbios);
        EditTemplateDialog.enableDisableControl(conf, "ide, primary", "enable", (Control)this.ide1);
        EditTemplateDialog.enableDisableControl(conf, "ide, secondary", "enable", (Control)this.ide2);
        EditTemplateDialog.enableDisableControl(conf, "ide, tertiary", "enable", (Control)this.ide3);
        EditTemplateDialog.enableDisableControl(conf, "ide, quaternary", "enable", (Control)this.ide4);
        EditTemplateDialog.enableDisableControl(conf, "dos", "automount", (Control)this.automount);
        EditTemplateDialog.enableDisableControl(conf, "printer", "printer", (Control)this.printer);
        EditTemplateDialog.enableDisableControl(conf, "printer", "dpi", (Control)this.printerdpi);
        EditTemplateDialog.enableDisableControl(conf, "printer", "width", (Control)this.printerwidth);
        EditTemplateDialog.enableDisableControl(conf, "printer", "height", (Control)this.printerheight);
        EditTemplateDialog.enableDisableControl(conf, "printer", "printoutput", (Control)this.printeroutput);
        EditTemplateDialog.enableDisableControl(conf, "printer", "multipage", (Control)this.printermultipage);
        EditTemplateDialog.enableDisableControl(conf, "printer", "docpath", (Control)this.printerdocpath);
        EditTemplateDialog.enableDisableControl(conf, "printer", "timeout", (Control)this.printertimeout);
        EditTemplateDialog.enableDisableControl(conf, "parallel", "parallel1", (Control)this.parallel1);
        EditTemplateDialog.enableDisableControl(conf, "parallel", "parallel2", (Control)this.parallel2);
        EditTemplateDialog.enableDisableControl(conf, "parallel", "parallel3", (Control)this.parallel3);
        EditTemplateDialog.enableDisableControl(conf, "parallel", "dongle", (Control)this.dongle);
        EditTemplateDialog.enableDisableControl(conf, "ne2000", "ne2000", (Control)this.ne2000);
        EditTemplateDialog.enableDisableControl(conf, "ne2000", "nicbase", (Control)this.ne2000base);
        EditTemplateDialog.enableDisableControl(conf, "ne2000", "nicirq", (Control)this.ne2000irq);
        EditTemplateDialog.enableDisableControl(conf, "ne2000", "macaddr", (Control)this.ne2000macaddress);
        EditTemplateDialog.enableDisableControl(conf, "ne2000", "realnic", (Control)this.ne2000realnic);
    }

    protected void doPerformDosboxConfAction(DosboxConfAction action) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            this.updateConfigurationBySettings(this.multiProfileList.get(0).getConf());
            Conf newDosboxVersion = new Conf(this.dbversionsList.get(this.dbversion.getSelectionIndex()), ps);
            if (action == DosboxConfAction.SET) {
                this.multiProfileList.get(0).getConf().setToDosboxVersion(newDosboxVersion);
            } else if (action == DosboxConfAction.SWITCH) {
                this.multiProfileList.get(0).getConf().switchToDosboxVersion(newDosboxVersion);
            } else if (action == DosboxConfAction.RELOAD) {
                this.multiProfileList.get(0).getConf().reloadDosboxVersion(newDosboxVersion);
            }
            this.enableSettingsByConfiguration(this.multiProfileList.get(0).getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(this.multiProfileList.get(0).getConf());
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), bos.toString());
                bos.reset();
            }
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
        }
    }

    protected static void enableDisableControl(SectionsWrapper dbConf, String oldSection, String oldItem, String newSection, String newItem, Control control) {
        control.setEnabled(dbConf != null && (dbConf.hasValue(newSection, newItem) || dbConf.hasValue(oldSection, oldItem)));
    }

    protected static void enableDisableControl(SectionsWrapper dbConf, String section, String oldItem, String newItem, Control control) {
        control.setEnabled(dbConf != null && (dbConf.hasValue(section, newItem) || dbConf.hasValue(section, oldItem)));
    }

    protected static void enableDisableControl(SectionsWrapper dbConf, String section, String item, Control control) {
        control.setEnabled(dbConf != null && dbConf.hasValue(section, item));
    }

    protected static void highlight(Control control, int foreGroundColor) {
        Control[] children = control.getParent().getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != control) continue;
            if (i > 0) {
                Control target = null;
                if (children[i - 1] instanceof Label) {
                    target = children[i - 1];
                } else if (i + 1 == children.length - 1) {
                    target = children[i + 1];
                } else if (i - 1 > 0 && children[i - 2] instanceof Label) {
                    target = children[i - 2];
                }
                if (target == null) continue;
                target.setForeground(control.getDisplay().getSystemColor(foreGroundColor));
                continue;
            }
            EditTemplateDialog.highlight((Control)control.getParent(), foreGroundColor);
        }
    }

    protected static void setFieldIfEnabled(String value, boolean isConflictingValue, AutoSelectCombo combo) {
        if (isConflictingValue) {
            EditTemplateDialog.highlight(combo.getControl(), 4);
        } else if (!combo.getText().equals(value)) {
            combo.setText(value);
        }
    }

    protected static void setFieldIfEnabled(String value, boolean isConflictingValue, Control control) {
        EditTemplateDialog.setFieldIfEnabled(value, isConflictingValue, control, false);
    }

    protected static void setFieldIfEnabled(String value, boolean isConflictingValue, Control control, boolean isOnOff) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else if (!((Text)control).getText().equals(value)) {
                    ((Text)control).setText(value);
                }
            } else if (control instanceof Combo) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else if (!((Combo)control).getText().equals(value)) {
                    ((Combo)control).setText(value);
                }
            } else if (control instanceof Button) {
                if (isConflictingValue) {
                    ((Button)control).setSelection(true);
                    ((Button)control).setGrayed(true);
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    boolean newValue;
                    boolean bl = newValue = isOnOff ? "on".equalsIgnoreCase(value) : Boolean.valueOf(value).booleanValue();
                    if (((Button)control).getSelection() != newValue || ((Button)control).getGrayed()) {
                        ((Button)control).setSelection(newValue);
                        ((Button)control).notifyListeners(13, new Event());
                    }
                }
            } else if (control instanceof Scale) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    Integer newValue = Integer.valueOf(value);
                    if (((Scale)control).getSelection() != newValue.intValue()) {
                        ((Scale)control).setSelection(newValue.intValue());
                    }
                }
            } else if (control instanceof Spinner) {
                if (isConflictingValue) {
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    Integer newValue = Integer.valueOf(value);
                    if (((Spinner)control).getSelection() != newValue.intValue()) {
                        ((Spinner)control).setSelection(newValue.intValue());
                    }
                }
            }
        }
    }

    protected static void setFieldIfEnabled(SectionsWrapper conf, String section, String item, Control control) {
        EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control);
    }

    protected static void setOnOffFieldIfEnabled(SectionsWrapper conf, String section, String item, Control control) {
        EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control, true);
    }

    protected static void setFieldIfEnabled(SectionsWrapper conf, String section, String item, Control control1, Control control2) {
        if (conf.isConflictingValue(section, item)) {
            EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control1);
            EditTemplateDialog.setFieldIfEnabled(conf.getValue(section, item), conf.isConflictingValue(section, item), control2);
        } else {
            String value = conf.getValue(section, item);
            String[] seperatedValues = value.split(",");
            if (seperatedValues != null && seperatedValues.length >= 2) {
                EditTemplateDialog.setFieldIfEnabled(seperatedValues[0], false, control1);
                EditTemplateDialog.setFieldIfEnabled(seperatedValues[1], false, control2);
            }
        }
    }

    protected static void setFieldIfEnabled(SectionsWrapper conf, String section, String oldItem, String newItem, Control control) {
        if (conf.hasValue(section, newItem)) {
            EditTemplateDialog.setFieldIfEnabled(conf, section, newItem, control);
        } else {
            EditTemplateDialog.setFieldIfEnabled(conf, section, oldItem, control);
        }
    }

    protected boolean isMultiEdit() {
        return this.multiProfileList.size() > 1;
    }

    protected String fetch(Text t) {
        return (Boolean)t.getData() != false ? t.getText() : null;
    }

    protected String fetch(Combo t) {
        return (Boolean)t.getData() != false ? t.getText() : null;
    }

    protected String fetch(AutoSelectCombo t) {
        return (Boolean)t.getData() != false ? t.getText() : null;
    }

    protected Boolean fetch(Button t) {
        return (Boolean)t.getData() != false ? Boolean.valueOf(t.getSelection()) : null;
    }

    protected int fetch(Scale t) {
        return (Boolean)t.getData() != false ? t.getSelection() : -1;
    }

    protected int fetch(Spinner t) {
        return (Boolean)t.getData() != false ? t.getSelection() : -1;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.title"), (Control)this.title, this.infoTabItem);
        }
        if (this.setButton.isEnabled()) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.dosboxassociation"), (Control)this.setButton, this.generalTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DosboxConfAction {
        SET,
        SWITCH,
        RELOAD,
        RELOAD_TEMPLATE;

    }
}

