/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.List;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosboxVersion
extends KeyTitleDefault
implements Comparable<DosboxVersion> {
    public static final String[] SUPP_RELEASES = new String[]{"0.63", "0.65", "0.70", "0.71", "0.72", "0.73", "0.74"};
    private final String path;
    private final String conf;
    private final boolean multiConfig;
    private final boolean usingCurses;
    private final String parameters;
    private final String version;

    public DosboxVersion(int id, String title, String path, String conf, boolean multiConfig, boolean usingCurses, boolean isDefault, String parameters, String version) {
        super(id, title, isDefault);
        this.path = PlatformUtils.pathToNativePath(path);
        this.conf = PlatformUtils.pathToNativePath(conf);
        this.multiConfig = multiConfig;
        this.usingCurses = usingCurses;
        this.parameters = parameters;
        this.version = version;
    }

    public boolean isMultiConfig() {
        return this.multiConfig;
    }

    public boolean isUsingCurses() {
        return this.usingCurses;
    }

    public String getPath() {
        return this.path;
    }

    public File getCanonicalExecutable() {
        return FileUtils.constructCanonicalDBExeLocation(this.path);
    }

    public String getConf() {
        return this.conf;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToDosbox(this.conf);
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getVersion() {
        return this.version;
    }

    public int findBestMatchId(List<DosboxVersion> dbversionsList) {
        for (DosboxVersion dbv : dbversionsList) {
            if (this.distance(dbv) != 0 || !this.getTitle().equals(dbv.getTitle())) continue;
            return dbv.getId();
        }
        DosboxVersion theDefault = DosboxVersion.findDefault(dbversionsList);
        if (this.distance(theDefault) == 0) {
            return theDefault.getId();
        }
        int result = dbversionsList.get(0).getId();
        int distance = this.distance(dbversionsList.get(0));
        for (DosboxVersion dbv : dbversionsList) {
            if (this.distance(dbv) >= distance) continue;
            result = dbv.getId();
            distance = this.distance(dbv);
        }
        return result;
    }

    private int getVersionInt() {
        return Integer.valueOf(this.version.substring(2));
    }

    private int distance(DosboxVersion ver) {
        return Math.abs(ver.getVersionInt() - this.getVersionInt());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DosboxVersion otherDBVersion = (DosboxVersion)obj;
        return this.getVersionInt() == otherDBVersion.getVersionInt() && this.getTitle().equals(otherDBVersion.getTitle());
    }

    @Override
    public int compareTo(DosboxVersion arg0) {
        int ver2;
        DosboxVersion comp = arg0;
        int ver1 = this.getVersionInt();
        if (ver1 != (ver2 = comp.getVersionInt())) {
            return ver1 - ver2;
        }
        return this.getTitle().compareTo(comp.getTitle());
    }
}

