/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpProfile
extends Profile
implements Configurable {
    private Conf conf;
    private File baseDir;
    private File gameDir;
    private String importedFullConfig;
    private String importedIncrConfig;
    private String mapperfile;
    private List<NativeCommand> nativeCommandsList;
    private int importedId;

    public ExpProfile(Conf conf, List<NativeCommand> nativeCommands) {
        super(null, false);
        this.conf = conf;
        this.nativeCommandsList = nativeCommands;
        this.baseDir = null;
        this.gameDir = null;
        this.dbversionId = conf.getDbversion().getId();
    }

    public ExpProfile(int id, Conf conf, File gDir, List<NativeCommand> nativeCommands, Profile prof) {
        super(id, prof.getConfPathAndFile(), prof.getCaptures(), prof);
        this.conf = conf;
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = gDir;
        this.nativeCommandsList = nativeCommands;
    }

    public ExpProfile(Element n, int dbversionIndex, boolean nativecommandsAvailable, String packageVersion) {
        super(XmlUtils.getTextValue(n, "title"), Boolean.valueOf(XmlUtils.getTextValue(XmlUtils.getNode(n, "meta-info"), "favorite")));
        this.importedId = Integer.valueOf(XmlUtils.getTextValue(n, "id"));
        this.confPathAndFile = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(n, "config-file"), "raw"));
        this.captures = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(n, "captures"), "raw"));
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = new File(PlatformUtils.pathToNativePath(XmlUtils.getTextValue(XmlUtils.getNode(n, "game-dir"), "raw")));
        if (packageVersion.equals("1.0")) {
            this.setup = new String[]{PlatformUtils.pathToNativePath(XmlUtils.getTextValue(n, "setup")), "", ""};
            this.setupParams = new String[]{XmlUtils.getTextValue(n, "setup-parameters"), "", ""};
        } else {
            this.setup = new String[]{PlatformUtils.pathToNativePath(XmlUtils.getTextValue(n, "setup")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(n, "altexe1")), PlatformUtils.pathToNativePath(XmlUtils.getTextValue(n, "altexe2"))};
            this.setupParams = new String[]{XmlUtils.getTextValue(n, "setup-parameters"), XmlUtils.getTextValue(n, "altexe1-parameters"), XmlUtils.getTextValue(n, "altexe2-parameters")};
            Element map = XmlUtils.getNode(n, "keymapper-file");
            if (map != null) {
                this.mapperfile = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(map, "raw"));
            }
        }
        Element metainfo = XmlUtils.getNode(n, "meta-info");
        this.developerName = XmlUtils.getTextValue(metainfo, "developer");
        this.publisherName = XmlUtils.getTextValue(metainfo, "publisher");
        this.year = XmlUtils.getTextValue(metainfo, "year");
        this.genre = XmlUtils.getTextValue(metainfo, "genre");
        this.status = XmlUtils.getTextValue(metainfo, "status");
        this.notes = XmlUtils.getTextValue(metainfo, "notes");
        this.customString = new String[]{XmlUtils.getTextValue(metainfo, "custom1"), XmlUtils.getTextValue(metainfo, "custom2"), XmlUtils.getTextValue(metainfo, "custom3"), XmlUtils.getTextValue(metainfo, "custom4"), XmlUtils.getTextValue(metainfo, "custom5"), XmlUtils.getTextValue(metainfo, "custom6"), XmlUtils.getTextValue(metainfo, "custom7"), XmlUtils.getTextValue(metainfo, "custom8")};
        this.customInt = new int[]{Integer.valueOf(XmlUtils.getTextValue(metainfo, "custom9")), Integer.valueOf(XmlUtils.getTextValue(metainfo, "custom10"))};
        this.link = new String[8];
        this.linkTitle = new String[8];
        for (int i = 0; i < 8; ++i) {
            if (packageVersion.equals("1.0") && i >= 4) {
                this.link[i] = "";
                this.linkTitle[i] = "";
                continue;
            }
            Element link = XmlUtils.getNode(metainfo, "link" + (i + 1));
            this.link[i] = PlatformUtils.pathToNativePath(XmlUtils.getTextValue(link, "raw"));
            this.linkTitle[i] = XmlUtils.getTextValue(link, "title");
        }
        this.importedFullConfig = XmlUtils.getTextValue(n, "full-configuration");
        this.importedIncrConfig = XmlUtils.getTextValue(n, "incremental-configuration");
        this.dbversionId = dbversionIndex;
        if (nativecommandsAvailable) {
            this.nativeCommandsList = new ArrayList<NativeCommand>();
            Element nativecommands = XmlUtils.getNode(n, "native-commands");
            if (nativecommands != null) {
                NodeList cmds = nativecommands.getChildNodes();
                for (int i = 0; i < cmds.getLength(); ++i) {
                    Node node = cmds.item(i);
                    if (!(node instanceof Element)) continue;
                    Element cmd = (Element)cmds.item(i);
                    String cwd = XmlUtils.getTextValue(cmd, "cwd");
                    String command = XmlUtils.getTextValue(cmd, "command");
                    this.nativeCommandsList.add(new NativeCommand(new File(command), XmlUtils.getTextValue(cmd, "parameters"), cwd == null ? null : new File(cwd), Boolean.valueOf(XmlUtils.getTextValue(cmd, "waitfor")), Integer.valueOf(XmlUtils.getTextValue(cmd, "ordernr"))));
                }
            }
            NativeCommand.insertDosboxCommand(this.nativeCommandsList);
        }
    }

    public ExpProfile(ExpProfile p1, ExpProfile p2, Conf conf) {
        super(p1, p2);
        this.conf = conf;
    }

    public ExpProfile(ExpProfile p1, Profile p2) {
        super(p1, p2, false);
        this.conf = p1.conf;
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public int getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int importedId) {
        this.importedId = importedId;
    }

    public String getCapturesExport() {
        return FileUtils.constructCapturesDir(this.getId());
    }

    public String getMapperExport() {
        return FileUtils.constructMapperFile(this.getId());
    }

    public String getMapperfile() {
        return this.mapperfile;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setGameDir(File gameDir) {
        this.gameDir = gameDir;
    }

    public String getImportedFullConfig() {
        return this.importedFullConfig;
    }

    public String getImportedIncrConfig() {
        return this.importedIncrConfig;
    }

    @Override
    public Conf getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        int i;
        boolean listExport = this.conf == null;
        Element profEmt = xmldoc.createElement("profile");
        XmlUtils.addCDataElement(xmldoc, profEmt, "title", this.getTitle());
        XmlUtils.addElement(xmldoc, profEmt, "id", String.valueOf(this.getId()));
        Element captures = xmldoc.createElement("captures");
        XmlUtils.addElement(xmldoc, captures, "raw", this.getCapturesExport());
        if (listExport) {
            XmlUtils.addElement(xmldoc, captures, "url", this.getCapturesAsUrl());
        }
        profEmt.appendChild(captures);
        Element config = xmldoc.createElement("config-file");
        XmlUtils.addElement(xmldoc, config, "raw", FileUtils.makeRelativeToData(new File(this.getConfPathAndFile())).getPath());
        if (listExport) {
            XmlUtils.addElement(xmldoc, config, "url", this.getConfFileAsUrl());
        }
        profEmt.appendChild(config);
        if (this.conf != null && this.conf.getCustomMapperFile() != null) {
            Element map = xmldoc.createElement("keymapper-file");
            XmlUtils.addElement(xmldoc, map, "raw", this.getMapperExport());
            profEmt.appendChild(map);
        }
        if (this.gameDir != null) {
            Element gamedir = xmldoc.createElement("game-dir");
            XmlUtils.addElement(xmldoc, gamedir, "raw", PlatformUtils.toDosboxPath(this.gameDir.getPath()));
            profEmt.appendChild(gamedir);
        }
        XmlUtils.addElement(xmldoc, profEmt, "setup", this.getSetup(0));
        XmlUtils.addElement(xmldoc, profEmt, "altexe1", this.getSetup(1));
        XmlUtils.addElement(xmldoc, profEmt, "altexe2", this.getSetup(2));
        XmlUtils.addElement(xmldoc, profEmt, "setup-parameters", this.getSetupParameters(0));
        XmlUtils.addElement(xmldoc, profEmt, "altexe1-parameters", this.getSetupParameters(1));
        XmlUtils.addElement(xmldoc, profEmt, "altexe2-parameters", this.getSetupParameters(2));
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addCDataElement(xmldoc, meta, "developer", this.getDeveloperName());
        XmlUtils.addCDataElement(xmldoc, meta, "publisher", this.getPublisherName());
        XmlUtils.addCDataElement(xmldoc, meta, "year", this.getYear());
        XmlUtils.addCDataElement(xmldoc, meta, "genre", this.getGenre());
        XmlUtils.addCDataElement(xmldoc, meta, "status", this.getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(this.isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", XmlUtils.cleanEolnForXml(this.getNotes()));
        for (i = 0; i < 8; ++i) {
            XmlUtils.addCDataElement(xmldoc, meta, "custom" + (i + 1), this.getCustomString(i));
        }
        for (i = 0; i < 2; ++i) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(this.getCustomInt(i)));
        }
        for (i = 0; i < 8; ++i) {
            Element link = xmldoc.createElement("link" + (i + 1));
            XmlUtils.addElement(xmldoc, link, "raw", this.getLink(i));
            if (listExport) {
                XmlUtils.addElement(xmldoc, link, "url", this.getLinkAsUrl(i));
            }
            XmlUtils.addCDataElement(xmldoc, link, "title", this.getLinkTitle(i));
            meta.appendChild(link);
        }
        profEmt.appendChild(meta);
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "full-configuration", XmlUtils.cleanEolnForXml(this.conf.toFullConfString(false)));
        }
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "incremental-configuration", XmlUtils.cleanEolnForXml(this.conf.toIncrConfString(false)));
        }
        DosboxVersion dbv = DosboxVersion.findById(dbversionsList, this.getDbversionId());
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addCDataElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        profEmt.appendChild(dosbox);
        if (this.nativeCommandsList != null && this.nativeCommandsList.size() > 1) {
            Element nativecommands = xmldoc.createElement("native-commands");
            for (NativeCommand cmd : this.nativeCommandsList) {
                if (cmd.getCommand() == null) continue;
                Element nativecommand = xmldoc.createElement("native-command");
                XmlUtils.addElement(xmldoc, nativecommand, "command", cmd.getCommand().getPath());
                XmlUtils.addElement(xmldoc, nativecommand, "parameters", cmd.getParameters());
                XmlUtils.addElement(xmldoc, nativecommand, "cwd", cmd.getCwd().getPath());
                XmlUtils.addElement(xmldoc, nativecommand, "waitfor", String.valueOf(cmd.isWaitFor()));
                XmlUtils.addElement(xmldoc, nativecommand, "ordernr", String.valueOf(cmd.getOrderNr()));
                nativecommands.appendChild(nativecommand);
            }
            profEmt.appendChild(nativecommands);
        }
        return profEmt;
    }

    @Override
    public List<NativeCommand> getNativeCommandsList() {
        return this.nativeCommandsList;
    }

    @Override
    public void setNativeCommandsList(List<NativeCommand> nativeCommandsList) {
        this.nativeCommandsList = nativeCommandsList;
    }
}

