/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.net.MalformedURLException;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

public class Profile
extends KeyTitleDefault {
    protected String developerName;
    protected String publisherName;
    protected String genre;
    protected String year;
    protected String status;
    protected String notes;
    protected String confPathAndFile;
    protected String captures;
    protected int dbversionId;
    protected String[] setup;
    protected String[] setupParams;
    protected String[] link;
    protected String[] linkTitle;
    protected String[] customString;
    protected int[] customInt;

    protected Profile(String title, boolean favorite) {
        super(-1, title, favorite);
    }

    public Profile(int id, String title, String devName, String publName, String genre, String year, String status, String notes, Boolean favorite, String[] setup, String[] setupParams, String confPathAndFile, String captures, int dbversionId, String[] links, String[] linkTitles, String[] customStrings, int[] customInts) {
        super(id, title, favorite);
        int i;
        this.developerName = devName;
        this.publisherName = publName;
        this.genre = genre;
        this.year = year;
        this.status = status;
        this.notes = notes;
        this.setup = new String[setup.length];
        for (i = 0; i < setup.length; ++i) {
            this.setup[i] = PlatformUtils.pathToNativePath(setup[i]);
        }
        this.setupParams = (String[])setupParams.clone();
        this.confPathAndFile = PlatformUtils.pathToNativePath(confPathAndFile);
        this.captures = PlatformUtils.pathToNativePath(captures);
        this.dbversionId = dbversionId;
        this.link = new String[links.length];
        for (i = 0; i < links.length; ++i) {
            this.link[i] = PlatformUtils.pathToNativePath(links[i]);
        }
        this.linkTitle = (String[])linkTitles.clone();
        this.customString = (String[])customStrings.clone();
        this.customInt = (int[])customInts.clone();
    }

    public Profile(int id, String confFile, String captures, Profile prof) {
        this(id, prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getStatus(), prof.getNotes(), prof.isDefault(), prof.getSetup(), prof.getSetupParameters(), confFile, captures, prof.getDbversionId(), prof.getLinks(), prof.getLinkTitles(), prof.getCustomStrings(), prof.getCustomInts());
    }

    private static String test(String s1, String s2) {
        return s1.equals(s2) ? s1 : "CONFLICTING_SETTING";
    }

    private static Boolean test(Boolean b1, Boolean b2) {
        return b1 == b2 ? b1 : Conf.CONFLICTING_BOOL_SETTING;
    }

    private static int test(int i1, int i2) {
        return i1 == i2 ? i1 : Integer.MIN_VALUE;
    }

    private static String[] test(String[] s1, String[] s2) {
        String[] result = new String[s1.length];
        for (int i = 0; i < s1.length; ++i) {
            result[i] = Profile.test(s1[i], s2[i]);
        }
        return result;
    }

    private static int[] test(int[] i1, int[] i2) {
        int[] result = new int[i1.length];
        for (int i = 0; i < i1.length; ++i) {
            result[i] = Profile.test(i1[i], i2[i]);
        }
        return result;
    }

    private static String either(String s1, String s2) {
        return s2 == null ? s1 : s2;
    }

    private static Boolean either(Boolean b1, Boolean b2) {
        return b2 == null ? b1 : b2;
    }

    private static int either(int i1, int i2) {
        return i2 == -1 ? i1 : i2;
    }

    private static String[] either(String[] s1, String[] s2) {
        String[] result = new String[s1.length];
        for (int i = 0; i < s1.length; ++i) {
            result[i] = Profile.either(s1[i], s2[i]);
        }
        return result;
    }

    private static int[] either(int[] i1, int[] i2) {
        int[] result = new int[i1.length];
        for (int i = 0; i < i1.length; ++i) {
            result[i] = Profile.either(i1[i], i2[i]);
        }
        return result;
    }

    public Profile(Profile prof1, Profile prof2) {
        this(-1, Profile.test(prof1.getTitle(), prof2.getTitle()), Profile.test(prof1.getDeveloperName(), prof2.getDeveloperName()), Profile.test(prof1.getPublisherName(), prof2.getPublisherName()), Profile.test(prof1.getGenre(), prof2.getGenre()), Profile.test(prof1.getYear(), prof2.getYear()), Profile.test(prof1.getStatus(), prof2.getStatus()), Profile.test(prof1.getNotes(), prof2.getNotes()), Profile.test(prof1.isDefault(), prof2.isDefault()), Profile.test(prof1.getSetup(), prof2.getSetup()), Profile.test(prof1.getSetupParameters(), prof2.getSetupParameters()), Profile.test(prof1.getConfPathAndFile(), prof2.getConfPathAndFile()), Profile.test(prof1.getCaptures(), prof2.getCaptures()), Profile.test(prof1.getDbversionId(), prof2.getDbversionId()), Profile.test(prof1.getLinks(), prof2.getLinks()), Profile.test(prof1.getLinkTitles(), prof2.getLinkTitles()), Profile.test(prof1.getCustomStrings(), prof2.getCustomStrings()), Profile.test(prof1.getCustomInts(), prof2.getCustomInts()));
    }

    public Profile(Profile prof1, Profile prof2, boolean bogus) {
        this(prof1.getId(), Profile.either(prof1.getTitle(), prof2.getTitle()), Profile.either(prof1.getDeveloperName(), prof2.getDeveloperName()), Profile.either(prof1.getPublisherName(), prof2.getPublisherName()), Profile.either(prof1.getGenre(), prof2.getGenre()), Profile.either(prof1.getYear(), prof2.getYear()), Profile.either(prof1.getStatus(), prof2.getStatus()), Profile.either(prof1.getNotes(), prof2.getNotes()), Profile.either(prof1.isDefault(), prof2.isDefault()), Profile.either(prof1.getSetup(), prof2.getSetup()), Profile.either(prof1.getSetupParameters(), prof2.getSetupParameters()), Profile.either(prof1.getConfPathAndFile(), prof2.getConfPathAndFile()), Profile.either(prof1.getCaptures(), prof2.getCaptures()), Profile.either(prof1.getDbversionId(), prof2.getDbversionId()), Profile.either(prof1.getLinks(), prof2.getLinks()), Profile.either(prof1.getLinkTitles(), prof2.getLinkTitles()), Profile.either(prof1.getCustomStrings(), prof2.getCustomStrings()), Profile.either(prof1.getCustomInts(), prof2.getCustomInts()));
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getYear() {
        return this.year;
    }

    public int getDbversionId() {
        return this.dbversionId;
    }

    public boolean hasSetup(int index) {
        return !"".equals(this.setup[index]);
    }

    public String hasSetupString() {
        return this.hasSetup(0) ? Settings.getInstance().msg("general.yes") : Settings.getInstance().msg("general.no");
    }

    public String[] getLinks() {
        return (String[])this.link.clone();
    }

    public String getLink(int index) {
        return this.link[index];
    }

    public String getLinkTitle(int index) {
        return this.linkTitle[index];
    }

    public String[] getLinkTitles() {
        return (String[])this.linkTitle.clone();
    }

    public String getLinkAsUrl(int index) {
        String res = this.link[index];
        if (res != null && res.length() > 0 && res.indexOf("://") == -1) {
            try {
                res = FileUtils.getUrlFromFile(FileUtils.canonicalToData(res));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return res;
    }

    public String getNotes() {
        return this.notes;
    }

    public String[] getSetup() {
        return (String[])this.setup.clone();
    }

    public String[] getSetupParameters() {
        return (String[])this.setupParams.clone();
    }

    public String getSetup(int index) {
        return this.setup[index];
    }

    public String getSetupParameters(int index) {
        return this.setupParams[index];
    }

    public String getStatus() {
        return this.status;
    }

    public String getConfPathAndFile() {
        return this.confPathAndFile;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToData(this.confPathAndFile);
    }

    public String getConfFileAsUrl() {
        try {
            return FileUtils.getUrlFromFile(this.getCanonicalConfFile());
        }
        catch (MalformedURLException e1) {
            return this.getCanonicalConfFile().getPath();
        }
    }

    public String getCaptures() {
        return this.captures;
    }

    public File getCanonicalCaptures() {
        return FileUtils.canonicalToData(this.captures);
    }

    public String getCapturesAsUrl() {
        try {
            return FileUtils.getUrlFromFile(this.getCanonicalCaptures());
        }
        catch (MalformedURLException e1) {
            return this.getCanonicalCaptures().getPath();
        }
    }

    public String getCustomString(int index) {
        return this.customString[index];
    }

    public String[] getCustomStrings() {
        return (String[])this.customString.clone();
    }

    public int getCustomInt(int index) {
        return this.customInt[index];
    }

    public int[] getCustomInts() {
        return (int[])this.customInt.clone();
    }
}

