/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

public class ThumbInfo {
    private String captures;
    private File canonicalCaptures;
    private File[] files;
    private String mainThumb;
    private boolean updated;

    public ThumbInfo(String captures) {
        this.captures = captures;
    }

    private void prepareInfo() {
        if (this.canonicalCaptures == null) {
            this.canonicalCaptures = FileUtils.canonicalToData(this.captures);
            this.updated = true;
        }
        if (this.files == null) {
            ArrayList<File> filesList = new ArrayList<File>();
            File[] allFiles = this.canonicalCaptures.listFiles();
            if (allFiles != null && allFiles.length > 0) {
                if (PlatformUtils.IS_LINUX) {
                    Arrays.sort(allFiles, new FileUtils.FileComparator());
                }
                for (File f : allFiles) {
                    if (!FileUtils.isPicture(f.getName())) continue;
                    filesList.add(f);
                }
            }
            this.files = filesList.toArray(new File[filesList.size()]);
            this.updated = true;
        }
    }

    public String getMainThumb() {
        this.prepareInfo();
        if (this.mainThumb == null) {
            if (this.files.length == 0) {
                return null;
            }
            this.mainThumb = this.files[0].getPath();
            this.updated = true;
        }
        return this.mainThumb;
    }

    public File[] getAllThumbs() {
        this.prepareInfo();
        return this.files;
    }

    public void resetCachedInfo() {
        this.files = null;
        this.mainThumb = null;
    }

    public boolean isUpdated() {
        boolean isUpdated = this.updated;
        this.updated = false;
        return isUpdated;
    }
}

