/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.Mount;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Autoexec {
    private static final String[] CUSTOM_SECTION_MARKERS = new String[]{"@REM START", "@REM /START", "@REM PRE-LAUNCH", "@REM /PRE-LAUNCH", "@REM POST-LAUNCH", "@REM /POST-LAUNCH", "@REM FINISH", "@REM /FINISH"};
    public static final int SECTIONS = CUSTOM_SECTION_MARKERS.length / 2;
    List<Mount> mountingpoints;
    Boolean loadfix;
    Boolean loadhigh;
    int loadfixValue;
    String main;
    String img1;
    String img2;
    String img3;
    Boolean exit;
    String params;
    String mixer;
    String keyb;
    String ipxnet;
    Boolean pause;
    String[] customSections;

    Autoexec() {
        this.init();
    }

    Autoexec(Autoexec other) {
        this.mountingpoints = new ArrayList<Mount>();
        for (Mount m : other.mountingpoints) {
            this.mountingpoints.add(new Mount(m));
        }
        this.loadfix = other.loadfix;
        this.loadhigh = other.loadhigh;
        this.loadfixValue = other.loadfixValue;
        this.main = other.main;
        this.img1 = other.img1;
        this.img2 = other.img2;
        this.img3 = other.img3;
        this.exit = other.exit;
        this.params = other.params;
        this.mixer = other.mixer;
        this.keyb = other.keyb;
        this.ipxnet = other.ipxnet;
        this.pause = other.pause;
        this.customSections = new String[SECTIONS];
        for (int i = 0; i < SECTIONS; ++i) {
            this.customSections[i] = other.customSections[i];
        }
    }

    void init() {
        this.mountingpoints = new ArrayList<Mount>();
        this.loadfix = false;
        this.loadhigh = false;
        this.loadfixValue = 0;
        this.main = "";
        this.img1 = "";
        this.img2 = "";
        this.img3 = "";
        this.exit = false;
        this.params = "";
        this.mixer = "";
        this.keyb = "";
        this.ipxnet = "";
        this.pause = false;
        this.customSections = new String[SECTIONS];
        for (int i = 0; i < SECTIONS; ++i) {
            this.customSections[i] = "";
        }
    }

    static List<Mount> getUniqueMountingpoints(Autoexec base, Autoexec ext) {
        int start;
        ArrayList<Mount> result = new ArrayList<Mount>();
        for (int i = start = base == null ? 0 : base.mountingpoints.size(); i < ext.mountingpoints.size(); ++i) {
            result.add(new Mount(ext.mountingpoints.get(i)));
        }
        return result;
    }

    void parseLines(List<String> orgLines) {
        char driveletter = '\u0000';
        String remainder = "";
        String executable = "";
        String image1 = "";
        String image2 = "";
        String image3 = "";
        int exeIndex = -1;
        String customEchos = "";
        ArrayList<String> leftOvers = new ArrayList<String>();
        int customSection = -1;
        block2: for (String orgLine : orgLines) {
            orgLine = orgLine.trim();
            for (int i = 0; i < SECTIONS; ++i) {
                if (!orgLine.startsWith(CUSTOM_SECTION_MARKERS[i * 2])) continue;
                customSection = i;
                continue block2;
            }
            if (customSection > -1) {
                if (orgLine.startsWith(CUSTOM_SECTION_MARKERS[customSection * 2 + 1])) {
                    customSection = -1;
                    continue;
                }
                int n = customSection;
                this.customSections[n] = this.customSections[n] + orgLine + PlatformUtils.EOLN;
                continue;
            }
            while (orgLine.startsWith("@")) {
                orgLine = orgLine.substring(1);
            }
            String line = (orgLine = orgLine.trim()).toLowerCase();
            if (line.startsWith("loadhigh ") || line.startsWith("lh ")) {
                this.loadhigh = true;
                int firstSpace = line.indexOf(32);
                orgLine = StringUtils.stripStart((String)orgLine.substring(firstSpace), (String)" ");
                line = orgLine.toLowerCase();
            }
            if (line.startsWith("loadfix")) {
                if (!this.loadfix.booleanValue()) {
                    this.loadfixValue = 64;
                    this.loadfix = true;
                }
                if (StringUtils.isEmpty((CharSequence)(line = (orgLine = StringUtils.stripStart((String)orgLine.substring(7), (String)" ")).toLowerCase())) || line.startsWith("-f")) continue;
                if (line.startsWith("-")) {
                    int endIndex = line.indexOf(32);
                    if (endIndex == -1) {
                        endIndex = line.length();
                    }
                    try {
                        this.loadfixValue = Integer.parseInt(line.substring(1, endIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    orgLine = StringUtils.stripStart((String)orgLine.substring(endIndex), (String)" ");
                    line = orgLine.toLowerCase();
                }
            }
            if (StringUtils.isEmpty((CharSequence)line)) continue;
            if (line.startsWith("mount") || line.startsWith("imgmount")) {
                this.addMount(orgLine);
                continue;
            }
            if (line.endsWith(":") && line.length() == 2 || line.endsWith(":\\") && line.length() == 3) {
                driveletter = Character.toUpperCase(line.charAt(0));
                remainder = "";
                continue;
            }
            if (line.startsWith("cd\\")) {
                if (driveletter == '\u0000') continue;
                String add = PlatformUtils.toNativePath(orgLine).substring(2);
                if (add.startsWith("\\")) {
                    remainder = add;
                    continue;
                }
                remainder = new File(remainder, add).getPath();
                continue;
            }
            if (line.startsWith("cd ")) {
                if (driveletter == '\u0000') continue;
                String add = PlatformUtils.toNativePath(orgLine).substring(3);
                if (add.startsWith("\\")) {
                    remainder = add;
                    continue;
                }
                remainder = new File(remainder, add).getPath();
                continue;
            }
            if (line.startsWith("keyb ") || line.startsWith("keyb.com ")) {
                this.keyb = orgLine.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith("mixer ") || line.startsWith("mixer.com ")) {
                this.mixer = orgLine.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith("ipxnet ") || line.startsWith("ipxnet.com ")) {
                this.ipxnet = orgLine.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.equals("pause")) {
                this.pause = true;
                continue;
            }
            exeIndex = StringUtils.indexOfAny((CharSequence)line, (CharSequence[])FileUtils.EXECUTABLES);
            if (exeIndex != -1) {
                int spaceAfterIndex;
                executable = orgLine;
                int spaceBeforeIndex = executable.lastIndexOf(32, exeIndex);
                if (spaceBeforeIndex != -1) {
                    executable = executable.substring(spaceBeforeIndex + 1);
                }
                if ((spaceAfterIndex = executable.indexOf(32)) == -1) continue;
                this.params = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
                executable = executable.substring(0, spaceAfterIndex);
                continue;
            }
            if (line.startsWith("boot ")) {
                int emulatedDriveLetterIndex = line.indexOf(" -l ");
                if (emulatedDriveLetterIndex != -1) {
                    orgLine = orgLine.substring(0, emulatedDriveLetterIndex);
                    line = orgLine.toLowerCase();
                }
                boolean quotes = true;
                int firstQuoteIndex = line.indexOf(34);
                int secondQuoteIndex = line.lastIndexOf(34);
                if (firstQuoteIndex == -1 && secondQuoteIndex == -1) {
                    quotes = false;
                    firstQuoteIndex = line.indexOf(32, 4);
                    secondQuoteIndex = line.length();
                }
                if (secondQuoteIndex == -1 || firstQuoteIndex == secondQuoteIndex) {
                    secondQuoteIndex = line.length();
                }
                if (firstQuoteIndex != -1 && secondQuoteIndex > firstQuoteIndex) {
                    String bootLocation = PlatformUtils.toNativePath(orgLine.substring(firstQuoteIndex + 1, secondQuoteIndex));
                    String[] booters = StringRelatedUtils.mountToStringArray(bootLocation, quotes);
                    if (booters != null) {
                        if (booters.length >= 1) {
                            image1 = booters[0];
                        }
                        if (booters.length >= 2) {
                            image2 = booters[1];
                        }
                        if (booters.length >= 3) {
                            image3 = booters[2];
                        }
                    }
                } else {
                    String firstFloppyImageMount = this.findFirstFloppyImagePath();
                    if (firstFloppyImageMount != null) {
                        image1 = firstFloppyImageMount;
                    }
                }
                if (!"\\file".equals(image1)) continue;
                this.img1 = "file";
                continue;
            }
            if (line.equals("exit") || line.startsWith("exit ")) {
                this.exit = true;
                continue;
            }
            if (line.equals("echo off")) continue;
            if (line.equals("echo") || line.startsWith("echo ") || line.startsWith("echo.")) {
                customEchos = customEchos + orgLine + PlatformUtils.EOLN;
                continue;
            }
            if (line.startsWith(":") || line.equals("cd") || line.equals("cls") || line.startsWith("cls ") || line.startsWith("cls\\") || line.equals("rem") || line.startsWith("rem ") || line.startsWith("goto ") || line.startsWith("if errorlevel ")) continue;
            leftOvers.add(orgLine);
        }
        if (StringUtils.isNotEmpty((CharSequence)customEchos)) {
            this.customSections[1] = this.customSections[1] + "@echo off" + PlatformUtils.EOLN + customEchos;
            this.customSections[1] = this.customSections[1] + "pause" + PlatformUtils.EOLN;
        }
        if (executable.equals("") && !leftOvers.isEmpty()) {
            for (int i = 0; i < leftOvers.size(); ++i) {
                executable = ((String)leftOvers.get(i)).trim();
                if (i == leftOvers.size() - 1) {
                    int spaceAfterIndex;
                    boolean isCalledBatch = executable.toLowerCase().startsWith("call ");
                    if (isCalledBatch) {
                        executable = executable.substring(5);
                    }
                    if ((spaceAfterIndex = executable.indexOf(32)) != -1) {
                        this.params = executable.substring(spaceAfterIndex + 1);
                        executable = executable.substring(0, spaceAfterIndex);
                    }
                    executable = executable + (isCalledBatch ? FileUtils.EXECUTABLES[2] : FileUtils.EXECUTABLES[0]);
                    continue;
                }
                this.customSections[1] = this.customSections[1] + executable + PlatformUtils.EOLN;
            }
        }
        for (Mount mount : this.mountingpoints) {
            char mount_drive = mount.getDriveletter();
            String mountPath = mount.getHostPathAsString();
            if (this.driveMatches(executable, mount_drive, driveletter)) {
                this.main = this.splitInThree(executable, mountPath, remainder);
                continue;
            }
            if (this.driveMatches(image1, mount_drive, driveletter)) {
                this.img1 = this.splitInThree(image1, mountPath, remainder);
                continue;
            }
            if (this.driveMatches(image2, mount_drive, driveletter)) {
                this.img2 = this.splitInThree(image2, mountPath, remainder);
                continue;
            }
            if (!this.driveMatches(image3, mount_drive, driveletter)) continue;
            this.img3 = this.splitInThree(image3, mountPath, remainder);
        }
        if (this.exit == null) {
            this.exit = false;
        }
    }

    private String findFirstFloppyImagePath() {
        for (Mount m : this.mountingpoints) {
            if (m.getMountingType() != Mount.MountingType.IMAGE || !m.getMountAs().equals("floppy")) continue;
            return m.getPathAsString();
        }
        return null;
    }

    private boolean driveMatches(String main, char mount_drive, char driveletter) {
        if (StringUtils.isEmpty((CharSequence)main)) {
            return false;
        }
        if (main.length() > 2 && main.charAt(1) == ':') {
            return Character.toUpperCase(main.charAt(0)) == mount_drive;
        }
        return driveletter == mount_drive;
    }

    private String splitInThree(String main, String mountPath, String remainder) {
        String[] result = new String[]{null, null};
        if (main.length() > 2 && main.charAt(1) == ':') {
            main = main.substring(2);
        }
        File f1 = new File(main);
        String parent = f1.getParent();
        File mountPathFile = new File(mountPath);
        result[0] = main.charAt(0) == '\\' ? (parent == null ? mountPath : new File(mountPathFile, parent).getPath()) : (parent == null ? new File(mountPathFile, remainder).getPath() : new File(new File(mountPathFile, remainder), parent).getPath());
        result[1] = f1.getName();
        if (remainder.indexOf(126) > 0) {
            String s = FileUtils.makeRelativeToDosroot(new File(result[0], result[1])).getPath();
            if (s.startsWith("./") || s.startsWith(".\\")) {
                s = s.substring(2);
            }
            return s;
        }
        return FileUtils.sanitizeToDosroot(new File(result[0], result[1]).getPath());
    }

    public String toString() {
        return this.toString(null, false);
    }

    public String toString(Autoexec base, Boolean prepareOnly) {
        String[] dosboxLocation;
        StringBuffer result = new StringBuffer();
        this.insertCustomSection(result, 0);
        if (!("".equals(this.keyb) || base != null && base.keyb.equals(this.keyb))) {
            result.append("keyb.com ").append(this.keyb).append(PlatformUtils.EOLN);
        }
        if (!("".equals(this.ipxnet) || base != null && base.ipxnet.equals(this.ipxnet))) {
            result.append("ipxnet.com ").append(this.ipxnet).append(PlatformUtils.EOLN);
        }
        List<Mount> mnts = null;
        if (base == null) {
            mnts = this.mountingpoints;
        } else {
            mnts = new ArrayList<Mount>();
            for (int i = 0; i < this.mountingpoints.size(); ++i) {
                if (i < base.mountingpoints.size() && this.mountingpoints.get(i).equals(base.mountingpoints.get(i))) continue;
                mnts.add(this.mountingpoints.get(i));
            }
        }
        for (Mount mount : mnts) {
            result.append(mount.toString()).append(PlatformUtils.EOLN);
        }
        if (!("".equals(this.mixer) || base != null && base.mixer.equals(this.mixer))) {
            result.append("mixer.com ").append(this.mixer).append(PlatformUtils.EOLN);
        }
        if (!"".equals(this.main)) {
            dosboxLocation = this.convertToDosboxPath(this.main);
            result.append(dosboxLocation[0] + PlatformUtils.EOLN);
            result.append("cd \\" + dosboxLocation[1] + PlatformUtils.EOLN);
            if (this.loadfix.booleanValue()) {
                result.append("loadfix -").append(this.loadfixValue > 0 ? this.loadfixValue : 64).append(PlatformUtils.EOLN);
            }
            this.insertCustomSection(result, 1);
            if (!prepareOnly.booleanValue()) {
                if (this.loadhigh.booleanValue()) {
                    result.append("loadhigh ");
                }
                if (dosboxLocation[2].toLowerCase().endsWith(FileUtils.EXECUTABLES[2])) {
                    result.append("call ");
                }
                result.append(dosboxLocation[2]);
                if (!"".equals(this.params)) {
                    result.append(' ').append(this.params);
                }
                result.append(PlatformUtils.EOLN);
                this.insertCustomSection(result, 2);
            }
        } else if (!"".equals(this.img1)) {
            if (this.loadfix.booleanValue()) {
                result.append("loadfix -").append(this.loadfixValue > 0 ? this.loadfixValue : 64).append(PlatformUtils.EOLN);
            }
            this.insertCustomSection(result, 1);
            if (!prepareOnly.booleanValue()) {
                dosboxLocation = this.convertToDosboxPath(this.img1);
                result.append("boot ").append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                if (!dosboxLocation[1].equals("")) {
                    result.append('\\');
                }
                result.append(dosboxLocation[2]);
                if (!"".equals(this.img2)) {
                    dosboxLocation = this.convertToDosboxPath(this.img2);
                    result.append(' ').append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                    if (!dosboxLocation[1].equals("")) {
                        result.append('\\');
                    }
                    result.append(dosboxLocation[2]);
                }
                if (!"".equals(this.img3)) {
                    dosboxLocation = this.convertToDosboxPath(this.img3);
                    result.append(' ').append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                    if (!dosboxLocation[1].equals("")) {
                        result.append('\\');
                    }
                    result.append(dosboxLocation[2]);
                }
                result.append(PlatformUtils.EOLN);
                this.insertCustomSection(result, 2);
            }
        } else {
            this.insertCustomSection(result, 1);
            this.insertCustomSection(result, 2);
        }
        if (!prepareOnly.booleanValue()) {
            if (this.loadfix.booleanValue()) {
                result.append("loadfix -f").append(PlatformUtils.EOLN);
            }
            this.insertCustomSection(result, 3);
            if (this.pause.booleanValue()) {
                result.append("pause").append(PlatformUtils.EOLN);
            }
            if (this.exit.booleanValue()) {
                result.append("exit").append(PlatformUtils.EOLN);
            }
        }
        if (result.length() > 0) {
            result.insert(0, "[autoexec]" + PlatformUtils.EOLN);
        }
        return result.toString();
    }

    private void insertCustomSection(StringBuffer sb, int sectionNr) {
        if (StringUtils.isNotEmpty((CharSequence)this.customSections[sectionNr])) {
            sb.append(CUSTOM_SECTION_MARKERS[sectionNr * 2 + 0]).append(PlatformUtils.EOLN);
            sb.append(StringUtils.chomp((String)this.customSections[sectionNr])).append(PlatformUtils.EOLN);
            sb.append(CUSTOM_SECTION_MARKERS[sectionNr * 2 + 1]).append(PlatformUtils.EOLN);
        }
    }

    String[] convertToDosboxPath(String hostFileLocation) {
        File hostFile = new File(hostFileLocation);
        String[] result = new String[]{"", "", hostFile.getName()};
        int maxLengthMount = 0;
        for (Mount mount : this.mountingpoints) {
            File dosboxDir = mount.canBeUsedFor(hostFile);
            if (dosboxDir == null || mount.getPathAsString().length() <= maxLengthMount) continue;
            result[0] = mount.getDriveletter() + ":";
            result[1] = dosboxDir.getParent() == null ? "" : dosboxDir.getParent();
            maxLengthMount = mount.getPathAsString().length();
        }
        result[1] = PlatformUtils.toDosboxPath(result[1]);
        return result;
    }

    void addMount(String mount) {
        block4: {
            try {
                Mount mnt = new Mount(mount);
                if (mnt.isUnmounted()) {
                    for (Mount m : this.mountingpoints) {
                        if (m.getDriveletter() != mnt.getDriveletter()) continue;
                        m.toggleMount();
                        break block4;
                    }
                    break block4;
                }
                this.mountingpoints.add(mnt);
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
    }

    public void setMainExecutable(String main, String params) {
        this.main = main;
        this.params = params;
    }

    public File getCanonicalMainDir() {
        if (this.isBooter()) {
            return FileUtils.getCanMainFile(new File(this.img1)).getParentFile();
        }
        return FileUtils.getCanMainFile(new File(this.main)).getParentFile();
    }

    public String getActualMain() {
        return this.isBooter() ? this.img1 : this.main;
    }

    public void setActualMainPath(File mainParentFile) {
        if (this.isBooter()) {
            this.img1 = new File(mainParentFile, new File(this.img1).getName()).getPath();
            if (StringUtils.isNotEmpty((CharSequence)this.img2)) {
                this.img2 = new File(mainParentFile, new File(this.img2).getName()).getPath();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.img3)) {
                this.img3 = new File(mainParentFile, new File(this.img3).getName()).getPath();
            }
        } else {
            this.main = new File(mainParentFile, new File(this.main).getName()).getPath();
        }
    }

    public void setActualMain(File mainFile) {
        if (this.isBooter()) {
            this.img1 = mainFile.getPath();
        } else {
            this.main = mainFile.getPath();
        }
    }

    public void migrateToDosroot(File fromPath, boolean prefixDosroot) {
        for (Mount mount : this.mountingpoints) {
            mount.migrateToDosroot(fromPath, prefixDosroot);
        }
        if (this.isBooter()) {
            String newImg3;
            String newImg2;
            String newImg1 = FileUtils.makeRelativeTo(prefixDosroot ? FileUtils.canonicalToDosroot(this.img1) : new File(this.img1), fromPath).getPath();
            if (this.convertToDosboxPath(newImg1)[0].length() > 0) {
                this.img1 = newImg1;
            }
            if (this.convertToDosboxPath(newImg2 = FileUtils.makeRelativeTo(prefixDosroot ? FileUtils.canonicalToDosroot(this.img2) : new File(this.img2), fromPath).getPath())[0].length() > 0) {
                this.img2 = newImg2;
            }
            if (this.convertToDosboxPath(newImg3 = FileUtils.makeRelativeTo(prefixDosroot ? FileUtils.canonicalToDosroot(this.img3) : new File(this.img3), fromPath).getPath())[0].length() > 0) {
                this.img3 = newImg3;
            }
        } else {
            String newMain = FileUtils.makeRelativeTo(prefixDosroot ? FileUtils.canonicalToDosroot(this.main) : new File(this.main), fromPath).getPath();
            if (this.convertToDosboxPath(newMain)[0].length() > 0) {
                this.main = newMain;
            }
        }
    }

    public void migrateMountsTo(File fromPath, File toPath) {
        for (Mount mount : this.mountingpoints) {
            mount.migrateTo(fromPath, toPath);
        }
    }

    public void migrateTo(File fromPath, File toPath) {
        this.migrateMountsTo(fromPath, toPath);
        String newMain = FileUtils.makeRelativeTo(FileUtils.canonicalToDosroot(this.main), fromPath).getPath();
        if (!new File(newMain).isAbsolute() && this.convertToDosboxPath(newMain = FileUtils.makeRelativeToDosroot(new File(toPath, newMain)).getPath())[0].length() > 0) {
            this.main = newMain;
        }
    }

    public void updateForTargetImportBaseDir(File baseDir) {
        for (Mount mount : this.mountingpoints) {
            mount.updateForTargetImportBaseDir(baseDir);
        }
        if (this.isBooter()) {
            this.img1 = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.img1)).getPath();
            if (StringUtils.isNotBlank((CharSequence)this.img2)) {
                this.img2 = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.img2)).getPath();
            }
            if (StringUtils.isNotBlank((CharSequence)this.img3)) {
                this.img3 = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.img3)).getPath();
            }
        } else {
            this.main = FileUtils.prefixAndSanitizeToDosroot(baseDir, new File(this.main)).getPath();
        }
    }

    void updateMountingPoints(Autoexec base, List<Mount> additionalMounts) {
        this.mountingpoints = new ArrayList<Mount>();
        for (Mount m : base.mountingpoints) {
            this.mountingpoints.add(new Mount(m));
        }
        for (Mount m : additionalMounts) {
            this.mountingpoints.add(new Mount(m));
        }
    }

    public boolean isIncomplete() {
        if (this.img1.length() == 0 && this.main.length() == 0) {
            return true;
        }
        return this.isBooter() ? this.convertToDosboxPath(this.img1)[0].length() == 0 : this.convertToDosboxPath(this.main)[0].length() == 0;
    }

    public Boolean isExit() {
        return this.exit;
    }

    public boolean isBooter() {
        return this.img1.length() > 0;
    }

    public Boolean isLoadfix() {
        return this.loadfix;
    }

    public Boolean isLoadhigh() {
        return this.loadhigh;
    }

    public int getLoadfixValue() {
        return this.loadfixValue;
    }

    public String getMixer() {
        return this.mixer;
    }

    public String getKeyb() {
        return this.keyb;
    }

    public String getIpxnet() {
        return this.ipxnet;
    }

    public String getImg1() {
        if ("file".equals(this.img1)) {
            return "";
        }
        return this.img1;
    }

    public String getImg2() {
        return this.img2;
    }

    public String getImg3() {
        return this.img3;
    }

    public String getMain() {
        return this.main;
    }

    public String getMainParameters() {
        return this.params;
    }

    public String[] getMountingpoints() {
        String[] result = new String[this.mountingpoints.size()];
        int mountIndex = 0;
        for (Mount mount : this.mountingpoints) {
            result[mountIndex++] = mount.toString(true);
        }
        return result;
    }

    public String getCustomSection(int i) {
        return this.customSections[i];
    }

    static Autoexec createCombination(Autoexec a1, Autoexec a2) {
        Autoexec result = new Autoexec();
        result.mountingpoints = new ArrayList<Mount>();
        for (Mount m1 : a1.mountingpoints) {
            for (Mount m2 : a2.mountingpoints) {
                if (!m1.toString(false).equals(m2.toString(false))) continue;
                result.mountingpoints.add(new Mount(m1));
            }
        }
        result.loadfix = a1.loadfix != Conf.CONFLICTING_BOOL_SETTING && a2.loadfix != Conf.CONFLICTING_BOOL_SETTING && a1.loadfix.equals(a2.loadfix) ? a1.loadfix : Conf.CONFLICTING_BOOL_SETTING;
        result.loadfixValue = a1.loadfixValue == a2.loadfixValue ? a1.loadfixValue : Integer.MIN_VALUE;
        result.main = a1.main.equals(a2.main) ? a1.main : "CONFLICTING_SETTING";
        result.img1 = a1.img1.equals(a2.img1) ? a1.img1 : "CONFLICTING_SETTING";
        result.img2 = a1.img2.equals(a2.img2) ? a1.img2 : "CONFLICTING_SETTING";
        result.img3 = a1.img3.equals(a2.img3) ? a1.img3 : "CONFLICTING_SETTING";
        result.exit = a1.exit != Conf.CONFLICTING_BOOL_SETTING && a2.exit != Conf.CONFLICTING_BOOL_SETTING && a1.exit.equals(a2.exit) ? a1.exit : Conf.CONFLICTING_BOOL_SETTING;
        result.params = a1.params.equals(a2.params) ? a1.params : "CONFLICTING_SETTING";
        result.mixer = a1.mixer.equals(a2.mixer) ? a1.mixer : "CONFLICTING_SETTING";
        result.keyb = a1.keyb.equals(a2.keyb) ? a1.keyb : "CONFLICTING_SETTING";
        result.ipxnet = a1.ipxnet.equals(a2.ipxnet) ? a1.ipxnet : "CONFLICTING_SETTING";
        result.pause = a1.pause != Conf.CONFLICTING_BOOL_SETTING && a2.pause != Conf.CONFLICTING_BOOL_SETTING && a1.pause.equals(a2.pause) ? a1.pause : Conf.CONFLICTING_BOOL_SETTING;
        for (int i = 0; i < a1.customSections.length; ++i) {
            result.customSections[i] = a1.customSections[i].equals(a2.customSections[i]) ? a1.customSections[i] : "CONFLICTING_SETTING";
        }
        return result;
    }

    Map<Character, Mount> nettoMounts() {
        return this.nettoMounts(new LinkedHashMap<Character, Mount>());
    }

    Map<Character, Mount> nettoMounts(Map<Character, Mount> existingMap) {
        LinkedHashMap<Character, Mount> map = new LinkedHashMap<Character, Mount>();
        for (Map.Entry<Character, Mount> entry : existingMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        for (Mount m : this.mountingpoints) {
            if (map.containsKey(Character.valueOf(m.getDriveletter()))) {
                if (!m.isUnmounted()) continue;
                map.remove(Character.valueOf(m.getDriveletter()));
                continue;
            }
            if (m.isUnmounted()) continue;
            map.put(Character.valueOf(m.getDriveletter()), m);
        }
        return map;
    }

    void removeFloppyMounts() {
        Iterator<Mount> it = this.mountingpoints.iterator();
        while (it.hasNext()) {
            if (!it.next().getMountAs().equals("floppy")) continue;
            it.remove();
        }
    }

    void setUnmountsFor(Autoexec dosboxAutoexec) {
        Map<Character, Mount> dbMap = dosboxAutoexec.nettoMounts();
        ArrayList<Mount> result = new ArrayList<Mount>();
        for (Map.Entry<Character, Mount> entry : dbMap.entrySet()) {
            Mount u = new Mount(entry.getValue());
            u.toggleMount();
            result.add(u);
        }
        this.mountingpoints = result;
    }

    void removeUnnecessaryMounts(Autoexec dosboxAutoexec) {
        Mount mnt;
        Map<Character, Mount> dbMap = dosboxAutoexec.nettoMounts();
        Map<Character, Mount> fullMap = this.nettoMounts(dbMap);
        ArrayList<Mount> result = new ArrayList<Mount>();
        for (Map.Entry<Character, Mount> entry : dbMap.entrySet()) {
            Mount umnt;
            mnt = entry.getValue();
            if (!fullMap.containsKey(entry.getKey())) {
                umnt = new Mount(mnt);
                umnt.toggleMount();
                result.add(umnt);
                continue;
            }
            if (mnt.toString().equals(fullMap.get(entry.getKey()).toString())) {
                result.add(mnt);
                continue;
            }
            umnt = new Mount(mnt);
            umnt.toggleMount();
            result.add(umnt);
            Mount m = new Mount(fullMap.get(entry.getKey()));
            result.add(m);
        }
        for (Map.Entry<Character, Mount> entry : fullMap.entrySet()) {
            mnt = entry.getValue();
            if (dbMap.containsKey(entry.getKey())) continue;
            result.add(mnt);
        }
        this.mountingpoints = result;
    }
}

