/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.exception.InvalidHostfileException;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Mount;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conf {
    public static final String CONFLICTING_STRING_SETTING = "CONFLICTING_SETTING";
    public static final int CONFLICTING_INT_SETTING = Integer.MIN_VALUE;
    public static final Boolean CONFLICTING_BOOL_SETTING = null;
    private ConfType confType = null;
    private PrintStream warningsLog = null;
    private File extendedFile = null;
    private DosboxVersion dbversion = null;
    private SectionsWrapper dosboxSections = null;
    private Autoexec dosboxAutoexec = null;
    private SectionsWrapper extendedSections = null;
    private Autoexec extendedAutoexec = null;

    protected Conf() {
    }

    public Conf(Conf other) {
        this.confType = other.confType;
        this.warningsLog = other.warningsLog;
        this.extendedFile = other.extendedFile;
        this.dbversion = other.dbversion;
        this.dosboxSections = new SectionsWrapper(other.dosboxSections);
        this.dosboxAutoexec = new Autoexec(other.dosboxAutoexec);
        this.extendedSections = new SectionsWrapper(other.extendedSections);
        this.extendedAutoexec = new Autoexec(other.extendedAutoexec);
    }

    private void initBaseData(ConfType type, PrintStream ps, File extFile) {
        this.confType = type;
        this.warningsLog = ps;
        this.extendedFile = extFile;
    }

    private void initDosboxData(DosboxVersion db) throws IOException {
        this.dbversion = db;
        this.dosboxSections = new SectionsWrapper();
        this.dosboxAutoexec = new Autoexec();
        Conf.parseInto(this.dosboxSections, this.dosboxAutoexec, new FileReader(db.getCanonicalConfFile()), db.getCanonicalConfFile().getPath(), this.warningsLog);
    }

    public Conf(Template template, DosboxVersion db, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.TEMPLATE, ps, template == null ? null : FileUtils.constructCanonicalTemplateFileLocation(template.getId()));
        this.initDosboxData(db);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        if (template == null) {
            this.extendedAutoexec.exit = true;
        } else {
            Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
        }
    }

    public Conf(Template template, File file, DosboxVersion db, PrintStream ps) throws IOException {
        this(template, db, ps);
        this.extendedFile = file;
        this.extendedAutoexec.img1 = "";
        this.extendedAutoexec.exit = false;
    }

    public Conf(Profile profile, DosboxVersion db, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.PROFILE, ps, profile.getCanonicalConfFile());
        this.initDosboxData(db);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
    }

    public Conf(File existingConfFile, Template template, DosboxVersion db, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.PROFILE, ps, null);
        this.initDosboxData(db);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        if (existingConfFile != null) {
            Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(existingConfFile), existingConfFile.getPath(), this.warningsLog);
        } else if (template != null) {
            File templateFile = FileUtils.constructCanonicalTemplateFileLocation(template.getId());
            Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(templateFile), templateFile.getPath(), this.warningsLog);
        } else {
            this.extendedAutoexec.exit = true;
        }
    }

    public Conf(File orgConfFile, String title, int profileId, DosboxVersion db, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.PROFILE, ps, orgConfFile);
        this.initDosboxData(db);
        this.extendedSections = new SectionsWrapper();
        this.extendedAutoexec = new Autoexec();
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
        this.extendedAutoexec.removeUnnecessaryMounts(this.dosboxAutoexec);
        this.extendedFile = FileUtils.canonicalToData(FileUtils.constructUniqueConfigFileString(profileId, title, this.extendedAutoexec.getCanonicalMainDir()));
    }

    public Conf(String fullConf, String incrConf, boolean importFullSettings, String importFilename, ExpProfile prof, int profileId, DosboxVersion db, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.PROFILE, ps, null);
        this.initDosboxData(db);
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new StringReader(importFullSettings ? fullConf : incrConf), importFilename, this.warningsLog);
        this.extendedFile = FileUtils.canonicalToData(FileUtils.constructUniqueConfigFileString(profileId, prof.getTitle(), this.extendedAutoexec.getCanonicalMainDir()));
        File baseDir = prof.getBaseDir();
        this.extendedAutoexec.updateForTargetImportBaseDir(baseDir);
        SectionsWrapper fullSecs = new SectionsWrapper();
        Autoexec fullAutoexec = new Autoexec();
        Conf.parseInto(fullSecs, fullAutoexec, new StringReader(fullConf), importFilename, this.warningsLog);
        this.extendedSections.alterToDosboxVersionGeneration(this.dosboxSections, fullSecs.detectDosboxVersionGeneration(), this.dosboxSections.detectDosboxVersionGeneration());
    }

    public Conf(Profile profile, String setup, String setupParameters, File file, DosboxVersion db, PrintStream ps) throws IOException {
        this(profile, db, ps);
        this.extendedFile = file;
        if (setup != null && setupParameters != null) {
            this.extendedAutoexec.setMainExecutable(setup, setupParameters);
        }
    }

    public Conf(Conf org, File file) throws IOException {
        this(org);
        this.extendedFile = file;
        this.extendedAutoexec.pause = true;
        this.extendedAutoexec.exit = true;
    }

    Conf(SectionsWrapper sec, File file, PrintStream ps) {
        this.initBaseData(ConfType.SETTINGS, ps, file);
        this.extendedSections = new SectionsWrapper(sec);
        if (this.extendedFile.isFile() && this.extendedFile.canRead()) {
            try {
                Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public Conf(File file, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.SINGULAR, ps, file);
        this.extendedSections = new SectionsWrapper();
        Conf.parseInto(this.extendedSections, this.extendedAutoexec, new FileReader(this.extendedFile), this.extendedFile.getPath(), this.warningsLog);
    }

    public Conf(DosboxVersion db, PrintStream ps) throws IOException {
        this.initBaseData(ConfType.SINGULAR, ps, null);
        this.initDosboxData(db);
    }

    public void injectOrUpdateProfile(Profile profile) throws IOException {
        this.extendedFile = profile.getCanonicalConfFile();
        this.extendedSections.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(profile.getId()));
    }

    public void injectOrUpdateTemplate(Template template) throws IOException {
        this.extendedFile = FileUtils.constructCanonicalTemplateFileLocation(template.getId());
    }

    public static Conf extractDBVersionConf(Conf profileConf) {
        Conf result = new Conf();
        result.initBaseData(ConfType.SINGULAR, profileConf.warningsLog, null);
        result.dbversion = profileConf.dbversion;
        result.dosboxSections = profileConf.dosboxSections;
        result.dosboxAutoexec = profileConf.dosboxAutoexec;
        return result;
    }

    public Conf(Conf conf1, Conf conf2, boolean sameDosboxVersion) {
        this.confType = conf1.confType;
        this.warningsLog = conf1.warningsLog;
        if (sameDosboxVersion) {
            this.dbversion = conf1.dbversion;
            this.dosboxSections = conf1.dosboxSections;
            this.dosboxAutoexec = conf1.dosboxAutoexec;
        }
        this.extendedSections = SectionsWrapper.createCombination(conf1.extendedSections, conf2.extendedSections);
        this.extendedAutoexec = Autoexec.createCombination(conf1.extendedAutoexec, conf2.extendedAutoexec);
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(Boolean prepareOnly) throws IOException {
        BufferedWriter configData = new BufferedWriter(new FileWriter(this.extendedFile));
        configData.write(this.toString(prepareOnly));
        configData.close();
    }

    public File getConfFile() {
        return this.extendedFile;
    }

    public SectionsWrapper getDosboxSettings() {
        return this.dosboxSections;
    }

    public SectionsWrapper getSettings() {
        return this.extendedSections;
    }

    public Autoexec getAutoexec() {
        return this.extendedAutoexec;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(Boolean prepareOnly) {
        if (this.confType == ConfType.SETTINGS) {
            return this.extendedSections.toString();
        }
        if (this.confType == ConfType.PROFILE) {
            if (this.dbversion == null || !this.dbversion.isMultiConfig()) {
                return this.toFullConfString(prepareOnly);
            }
            return this.toIncrConfString(prepareOnly);
        }
        if (this.confType == ConfType.TEMPLATE) {
            return this.toIncrConfString(prepareOnly);
        }
        return "";
    }

    public String toFullConfString(Boolean prepareOnly) {
        return this.extendedSections.toString() + this.extendedAutoexec.toString(null, prepareOnly);
    }

    public String toIncrConfString(Boolean prepareOnly) {
        return new SectionsWrapper(this.dosboxSections, this.extendedSections).toString() + this.extendedAutoexec.toString(this.dosboxAutoexec, prepareOnly);
    }

    public void unmountDosboxMounts() {
        this.extendedAutoexec.setUnmountsFor(this.dosboxAutoexec);
    }

    public void removeFloppyMounts() {
        this.extendedAutoexec.removeFloppyMounts();
    }

    public void removeUnnecessaryMounts() {
        this.extendedAutoexec.removeUnnecessaryMounts(this.dosboxAutoexec);
    }

    public void updateValue(String sectionTitle, String sectionItem, String value, boolean condition) {
        if (condition) {
            this.extendedSections.updateValue(sectionTitle, sectionItem, value);
        }
    }

    public void updateValue(String section, String oldItem, String newItem, String value, boolean condition) {
        if (condition && this.dbversion != null && this.dosboxSections != null) {
            if (this.dosboxSections.hasValue(section, newItem)) {
                this.extendedSections.updateValue(section, newItem, value);
            } else {
                this.extendedSections.updateValue(section, oldItem, value);
            }
        }
    }

    public void updateScalerValue(String scalerType, boolean forced, boolean condition) {
        if (condition && this.dbversion != null && this.dosboxSections != null && !scalerType.equals("")) {
            String newValue = scalerType;
            if (forced && !scalerType.endsWith("forced")) {
                newValue = newValue + " forced";
            }
            this.extendedSections.updateValue("render", "scaler", newValue);
        }
    }

    public void updateMidiValue(String value, boolean condition) {
        if (condition && this.dbversion != null && this.dosboxSections != null) {
            if (this.dosboxSections.hasValue("midi", "intelligent")) {
                this.extendedSections.updateValue("midi", "mpu401", String.valueOf(!value.equalsIgnoreCase("none")));
                if (value.equalsIgnoreCase("none")) {
                    this.extendedSections.updateValue("midi", "intelligent", String.valueOf(true));
                } else {
                    this.extendedSections.updateValue("midi", "intelligent", String.valueOf(value.equalsIgnoreCase("intelligent")));
                }
            } else {
                this.extendedSections.updateValue("midi", "mpu401", value);
            }
        }
    }

    public void updateJoystickValue(String joystickType, boolean timed, boolean autofire, boolean swap34, boolean buttonwrap, boolean c1, boolean c2, boolean c3, boolean c4, boolean c5) {
        if (this.dbversion != null && this.dosboxSections != null) {
            if (this.dosboxSections.hasValue("joystick", "joysticktype")) {
                this.updateValue("joystick", "joysticktype", joystickType, c1);
                this.updateValue("joystick", "timed", String.valueOf(timed), c2);
                this.updateValue("joystick", "autofire", String.valueOf(autofire), c3);
                this.updateValue("joystick", "swap34", String.valueOf(swap34), c4);
                this.updateValue("joystick", "buttonwrap", String.valueOf(buttonwrap), c5);
            } else {
                this.updateValue("bios", "joysticktype", joystickType, c1);
            }
        }
    }

    public void setAutoexecSettingsForTemplate(Boolean exit, String mixer, String keyb, String ipxnet, Boolean booter, String[] customSections) {
        this.extendedAutoexec.exit = exit;
        this.extendedAutoexec.mixer = mixer;
        this.extendedAutoexec.keyb = keyb;
        this.extendedAutoexec.ipxnet = ipxnet;
        this.extendedAutoexec.img1 = booter != false ? "file" : "";
        this.extendedAutoexec.customSections = customSections;
    }

    public void setAutoexecSettingsForProfile(Boolean loadhigh, Boolean loadfix, String loadfixValue, String main, String params, String img1, String img2, String img3) {
        this.extendedAutoexec.main = main;
        this.extendedAutoexec.params = params;
        this.extendedAutoexec.loadhigh = loadhigh;
        this.extendedAutoexec.loadfix = loadfix;
        try {
            this.extendedAutoexec.loadfixValue = Integer.parseInt(loadfixValue);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.extendedAutoexec.img1 = img1;
        this.extendedAutoexec.img2 = img2;
        this.extendedAutoexec.img3 = img3;
    }

    public void setAutoexecSettingsForProfileMultiEdit(Boolean loadhigh, Boolean loadfix, String loadfixValue, Boolean exit, String mixer, String keyb, String ipxnet, String[] customSections) {
        if (loadhigh != null) {
            this.extendedAutoexec.loadhigh = loadhigh;
        }
        if (loadfix != null) {
            this.extendedAutoexec.loadfix = loadfix;
        }
        try {
            if (loadfixValue != null) {
                this.extendedAutoexec.loadfixValue = Integer.parseInt(loadfixValue);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (exit != null) {
            this.extendedAutoexec.exit = exit;
        }
        if (mixer != null) {
            this.extendedAutoexec.mixer = mixer;
        }
        if (keyb != null) {
            this.extendedAutoexec.keyb = keyb;
        }
        if (ipxnet != null) {
            this.extendedAutoexec.ipxnet = ipxnet;
        }
        for (int i = 0; i < customSections.length; ++i) {
            if (customSections[i] == null) continue;
            this.extendedAutoexec.customSections[i] = customSections[i];
        }
    }

    public void alterToDosboxVersionGeneration(Conf dosboxConf) {
        this.dbversion = dosboxConf.dbversion;
        this.extendedSections.alterToDosboxVersionGeneration(dosboxConf.dosboxSections);
    }

    public void setToDosboxVersion(Conf dosboxConf) {
        if (this.dbversion != null && this.dbversion.getId() == dosboxConf.getDbversion().getId()) {
            return;
        }
        List<Mount> uniqueMounts = Autoexec.getUniqueMountingpoints(this.dosboxAutoexec, this.extendedAutoexec);
        this.dbversion = dosboxConf.dbversion;
        this.dosboxSections = dosboxConf.dosboxSections;
        this.dosboxAutoexec = dosboxConf.dosboxAutoexec;
        this.extendedSections.alterToDosboxVersionGeneration(dosboxConf.dosboxSections);
        this.extendedAutoexec.updateMountingPoints(this.dosboxAutoexec, uniqueMounts);
    }

    public void switchToDosboxVersion(Conf dosboxConf) {
        if (this.dbversion != null && this.dbversion.getId() == dosboxConf.getDbversion().getId()) {
            return;
        }
        List<Mount> uniqueMounts = Autoexec.getUniqueMountingpoints(this.dosboxAutoexec, this.extendedAutoexec);
        this.dbversion = dosboxConf.dbversion;
        this.dosboxAutoexec = dosboxConf.dosboxAutoexec;
        this.extendedSections.switchToDosboxVersionGeneration(this.dosboxSections, dosboxConf.dosboxSections);
        this.extendedAutoexec.updateMountingPoints(this.dosboxAutoexec, uniqueMounts);
        this.dosboxSections = dosboxConf.dosboxSections;
    }

    public void reloadDosboxVersion(Conf dosboxConf) {
        List<Mount> uniqueMounts = Autoexec.getUniqueMountingpoints(this.dosboxAutoexec, this.extendedAutoexec);
        Boolean exit = this.extendedAutoexec.exit;
        String main = this.extendedAutoexec.main;
        String params = this.extendedAutoexec.params;
        String img1 = this.extendedAutoexec.img1;
        String img2 = this.extendedAutoexec.img2;
        String img3 = this.extendedAutoexec.img3;
        this.dbversion = dosboxConf.dbversion;
        this.dosboxSections = dosboxConf.dosboxSections;
        this.dosboxAutoexec = dosboxConf.dosboxAutoexec;
        this.extendedSections = new SectionsWrapper(this.dosboxSections);
        this.extendedAutoexec = new Autoexec(this.dosboxAutoexec);
        this.extendedAutoexec.updateMountingPoints(this.dosboxAutoexec, uniqueMounts);
        this.extendedAutoexec.exit = exit;
        this.extendedAutoexec.main = main;
        this.extendedAutoexec.params = params;
        this.extendedAutoexec.img1 = img1;
        this.extendedAutoexec.img2 = img2;
        this.extendedAutoexec.img3 = img3;
    }

    public void reloadTemplate(Conf templateConf) {
        Autoexec orgMounts = new Autoexec(this.extendedAutoexec);
        String main = this.extendedAutoexec.main;
        String params = this.extendedAutoexec.params;
        String img1 = this.extendedAutoexec.img1;
        String img2 = this.extendedAutoexec.img2;
        String img3 = this.extendedAutoexec.img3;
        this.dbversion = templateConf.dbversion;
        this.dosboxSections = templateConf.dosboxSections;
        this.dosboxAutoexec = templateConf.dosboxAutoexec;
        this.extendedSections = templateConf.extendedSections;
        this.extendedAutoexec = templateConf.extendedAutoexec;
        this.extendedAutoexec.main = main;
        this.extendedAutoexec.params = params;
        if (StringUtils.isNotEmpty((CharSequence)img1)) {
            this.extendedAutoexec.img1 = img1;
            this.extendedAutoexec.img2 = img2;
            this.extendedAutoexec.img3 = img3;
        }
        if (orgMounts.mountingpoints.size() > 0) {
            this.extendedAutoexec.mountingpoints = orgMounts.mountingpoints;
        }
    }

    public String[] addMount(String mount) {
        this.extendedAutoexec.addMount(mount);
        return this.extendedAutoexec.getMountingpoints();
    }

    public String[] editMount(int index, String mount) {
        if (index < this.dosboxAutoexec.mountingpoints.size()) {
            Mount mnt = this.extendedAutoexec.mountingpoints.get(index);
            if (!mnt.isUnmounted()) {
                mnt.toggleMount();
            }
            this.extendedAutoexec.addMount(mount);
        } else {
            try {
                this.extendedAutoexec.mountingpoints.set(index, new Mount(mount));
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
        return this.extendedAutoexec.getMountingpoints();
    }

    public String[] removeMount(int index) {
        if (index < this.dosboxAutoexec.mountingpoints.size()) {
            this.extendedAutoexec.mountingpoints.get(index).toggleMount();
        } else {
            this.extendedAutoexec.mountingpoints.remove(index);
        }
        return this.extendedAutoexec.getMountingpoints();
    }

    private Map<Character, Mount> nettoMounts() {
        return this.extendedAutoexec.nettoMounts(this.dosboxAutoexec.nettoMounts());
    }

    public Set<Character> nettoMountedDriveLetters() {
        return this.nettoMounts().keySet();
    }

    public String getRequiredMount(boolean booter, String main) {
        if (this.extendedAutoexec.convertToDosboxPath(main)[0].length() > 0) {
            return null;
        }
        try {
            return new Mount(booter, main, this.nettoMountedDriveLetters()).getPathAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] addRequiredMount(boolean booter, String main) {
        try {
            if (FileUtils.containsIso(main) != -1) {
                Mount tmp = new Mount(booter, ".", this.nettoMountedDriveLetters());
                if (tmp.getDriveletter() == 'C') {
                    this.addMount(tmp.toString());
                }
                return this.addMount(new Mount(booter, main, this.nettoMountedDriveLetters()).toString());
            }
            return this.addMount(new Mount(booter, main, this.nettoMountedDriveLetters()).toString());
        }
        catch (InvalidHostfileException e) {
            return this.extendedAutoexec.getMountingpoints();
        }
        catch (DrivelettersExhaustedException e) {
            return this.extendedAutoexec.getMountingpoints();
        }
    }

    public String[] addRequiredMountForInstaller(String main) {
        try {
            File[] extraFilesToMount = FileUtils.findFileSequence(FileUtils.getCanMainFile(new File(main)));
            if (extraFilesToMount.length > 1) {
                return this.addMount(new Mount(main, this.nettoMountedDriveLetters(), extraFilesToMount).toString());
            }
            return this.addMount(new Mount(main, this.nettoMountedDriveLetters(), null).toString());
        }
        catch (InvalidHostfileException e) {
            return this.extendedAutoexec.getMountingpoints();
        }
        catch (DrivelettersExhaustedException e) {
            return this.extendedAutoexec.getMountingpoints();
        }
    }

    public DosboxVersion getDbversion() {
        return this.dbversion;
    }

    public static boolean isConflictingValue(String s) {
        return s.equals(CONFLICTING_STRING_SETTING);
    }

    public static boolean isConflictingValue(int i) {
        return i == Integer.MIN_VALUE;
    }

    public static boolean isConflictingValue(Boolean b) {
        return b == CONFLICTING_BOOL_SETTING;
    }

    public File getCustomMapperFile() {
        if (this.confType == ConfType.PROFILE) {
            File mapper;
            String dbMapperfile = this.dosboxSections.getValue("sdl", "mapperfile");
            String customMapperfile = this.extendedSections.getValue("sdl", "mapperfile");
            if (this.extendedSections.hasValue("sdl", "mapperfile") && !customMapperfile.equals(dbMapperfile) && FileUtils.isExistingFile(mapper = new File(this.extendedFile.getParentFile(), customMapperfile))) {
                return mapper;
            }
        }
        return null;
    }

    private static void parseInto(SectionsWrapper sections, Autoexec autoexec, Reader reader, String filename, PrintStream warningsLog) throws IOException {
        String textLine;
        Settings settings = Settings.getInstance();
        BufferedReader configData = new BufferedReader(reader);
        int lineNumber = 1;
        String currSectionTitle = null;
        boolean lastItemHadMissingSection = false;
        ArrayList<String> autoexecLines = new ArrayList<String>();
        while ((textLine = configData.readLine()) != null) {
            if ((textLine = textLine.trim()).length() > 0 && textLine.charAt(0) != '#') {
                if (textLine.charAt(0) == '[') {
                    int start = textLine.indexOf(91);
                    int end = textLine.lastIndexOf(93);
                    if (end == -1) {
                        warningsLog.println(settings.msg("general.error.parseconf", new Object[]{filename, lineNumber, textLine}));
                    } else {
                        currSectionTitle = textLine.substring(start + 1, end);
                    }
                } else if (currSectionTitle == null) {
                    if (!lastItemHadMissingSection) {
                        warningsLog.println(settings.msg("general.error.sectionmissing", new Object[]{filename, lineNumber, textLine}));
                    }
                    lastItemHadMissingSection = true;
                } else {
                    if ("autoexec".equals(currSectionTitle)) {
                        autoexecLines.add(textLine);
                    } else {
                        int end = textLine.indexOf(61);
                        if (end == -1) {
                            warningsLog.println(settings.msg("general.error.parseconf", new Object[]{filename, lineNumber, textLine}));
                        } else {
                            String name = textLine.substring(0, end).trim();
                            String value = textLine.substring(end + 1).trim();
                            sections.setValue(currSectionTitle, name.toLowerCase(), value);
                        }
                    }
                    lastItemHadMissingSection = false;
                }
            }
            ++lineNumber;
        }
        configData.close();
        if (autoexecLines.size() > 0) {
            autoexec.parseLines(autoexecLines);
        }
    }

    public boolean hasDifferentBaseMountsThan(Conf conf) {
        return !Arrays.equals(this.dosboxAutoexec.getMountingpoints(), conf.dosboxAutoexec.getMountingpoints());
    }

    public int countImageMounts() {
        int result = 0;
        for (Mount m : this.extendedAutoexec.mountingpoints) {
            if (m.getMountingType() != Mount.MountingType.IMAGE || m.isUnmounted()) continue;
            ++result;
        }
        return result;
    }

    public File[] getFirstImageMountPath() {
        for (Mount m : this.extendedAutoexec.mountingpoints) {
            if (m.getMountingType() != Mount.MountingType.IMAGE || m.isUnmounted()) continue;
            return m.getPath();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfType {
        PROFILE,
        TEMPLATE,
        SINGULAR,
        SETTINGS;

    }
}

