/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringRelatedUtils {
    public static String[] textAreaToStringArray(String contents, String del) {
        return StringUtils.splitByWholeSeparator((String)StringUtils.strip((String)contents, (String)del), (String)del);
    }

    public static String textAreaToString(String contents, String del, String eoln) {
        return StringUtils.replace((String)StringUtils.strip((String)contents, (String)del), (String)del, (String)eoln);
    }

    public static String stringToTextArea(String string, String del, String eoln) {
        return StringUtils.replace((String)string, (String)eoln, (String)del);
    }

    public static String[] mountToStringArray(String paths, boolean quotes) {
        return quotes ? StringUtils.splitByWholeSeparator((String)paths, (String)"\" \"") : StringUtils.split((String)paths, (char)' ');
    }

    public static String join(int[] values) {
        return StringUtils.replaceChars((String)Arrays.toString(values), (String)"[,]", (String)"");
    }

    public static String join(boolean[] values) {
        return StringUtils.replaceChars((String)Arrays.toString(values), (String)"[,]", (String)"");
    }

    public static int findBestMatchIndex(String search, String[] titles) {
        if (titles == null || titles.length == 0) {
            return -1;
        }
        String s = search.toLowerCase();
        int minDistance = Integer.MAX_VALUE;
        int result = 0;
        for (int i = 0; i < titles.length; ++i) {
            int distance;
            String title = FilenameUtils.removeExtension(titles[i].toLowerCase());
            int n = distance = i == 0 ? StringUtils.getLevenshteinDistance((CharSequence)s, (CharSequence)title) : StringUtils.getLevenshteinDistance((CharSequence)s, (CharSequence)title, (int)(minDistance - 1));
            if (distance == 0) {
                return i;
            }
            if (distance == -1) continue;
            minDistance = distance;
            result = i;
        }
        return result;
    }

    public static String stringArrayToString(String[] values, String delimiter) {
        if (values == null || values.length <= 0) {
            return "";
        }
        return StringUtils.join((Object[])values, (String)delimiter) + delimiter;
    }

    public static Map<String, String> stringArrayToMap(String[] list) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String entry : list) {
            String[] pair = entry.split("=");
            if (pair.length != 2) continue;
            String key = pair[0].trim();
            String value = pair[1].trim();
            if (key.length() <= 0 || value.length() <= 0) continue;
            result.put(key, value);
        }
        return result;
    }

    public static int[] stringToIntArray(String input) {
        if (input.length() <= 0) {
            return new int[0];
        }
        String[] values = input.split(" ");
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                result[i] = Integer.parseInt(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                result[i] = -1;
            }
        }
        return result;
    }

    public static boolean[] stringToBooleanArray(String input) {
        if (input.length() <= 0) {
            return new boolean[0];
        }
        String[] values = input.split(" ");
        boolean[] result = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Boolean.parseBoolean(values[i]);
        }
        return result;
    }

    public static String onOffValue(boolean b) {
        return b ? "on" : "off";
    }

    public static String toString(Exception exception) {
        return exception.getMessage() != null ? exception.getMessage() : exception.toString();
    }
}

