/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.PlatformUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static final String XML_FORMAT_VERSION = "1.2";
    public static final SimpleDateFormat datetimeFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public static Element addElement(Document dom, Element el, String name, String value) {
        Element newElement = dom.createElement(name);
        newElement.appendChild(dom.createTextNode(value));
        el.appendChild(newElement);
        return el;
    }

    public static Element addCDataElement(Document dom, Element el, String name, String value) {
        Element newElement = dom.createElement(name);
        newElement.appendChild(dom.createCDATASection(value));
        el.appendChild(newElement);
        return el;
    }

    public static void saveDomSource(DOMSource source, File target, File xslt) throws TransformerException, IOException {
        TransformerFactory transFact = TransformerFactory.newInstance();
        transFact.setAttribute("indent-number", 2);
        Transformer trans = xslt == null ? transFact.newTransformer() : transFact.newTransformer(new StreamSource(xslt));
        trans.setOutputProperty("indent", "yes");
        FileOutputStream fos = new FileOutputStream(target);
        trans.transform(source, new StreamResult(new OutputStreamWriter((OutputStream)fos, "UTF-8")));
        fos.close();
    }

    public static void domToZipOutputStream(Document doc, File zipFileEntry, ZipOutputStream zipOutputStream) throws IOException, TransformerException {
        ZipEntry anEntry = new ZipEntry(PlatformUtils.toArchivePath(zipFileEntry, false));
        zipOutputStream.putNextEntry(anEntry);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        tfactory.setAttribute("indent-number", 2);
        Transformer transformer = tfactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8")));
        zipOutputStream.closeEntry();
    }

    public static Document getProfilesXML(List<Profile> profs, List<DosboxVersion> dbversions) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmldoc = builder.newDocument();
        Element root = xmldoc.createElement("document");
        root.appendChild(XmlUtils.getExportElement(xmldoc, Settings.getInstance().msg("exportlist.title"), "", "", false, false, false, false));
        for (Profile profile : profs) {
            root.appendChild(new ExpProfile(profile.getId(), null, null, null, profile).getXml(xmldoc, dbversions));
        }
        xmldoc.appendChild(root);
        return xmldoc;
    }

    public static Document getFullProfilesXML(List<ExpProfile> profs, List<DosboxVersion> dbversions, String title, String notes, String author, boolean captures, boolean mapperfiles, boolean nativecommands, boolean gameData) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmldoc = builder.newDocument();
        Element root = xmldoc.createElement("document");
        root.appendChild(XmlUtils.getExportElement(xmldoc, title, notes, author, captures, mapperfiles, nativecommands, gameData));
        for (ExpProfile profile : profs) {
            root.appendChild(profile.getXml(xmldoc, dbversions));
        }
        xmldoc.appendChild(root);
        return xmldoc;
    }

    private static Element getExportElement(Document xmldoc, String title, String notes, String author, boolean captures, boolean mapperfiles, boolean nativecommands, boolean gameData) {
        Element export = xmldoc.createElement("export");
        XmlUtils.addElement(xmldoc, export, "format-version", XML_FORMAT_VERSION);
        XmlUtils.addCDataElement(xmldoc, export, "title", title);
        XmlUtils.addCDataElement(xmldoc, export, "author", author);
        XmlUtils.addCDataElement(xmldoc, export, "notes", XmlUtils.cleanEolnForXml(notes));
        XmlUtils.addCDataElement(xmldoc, export, "creationdatetime", datetimeFormatter.format(new Date()));
        XmlUtils.addCDataElement(xmldoc, export, "generator-title", "DOSBox Game Launcher");
        XmlUtils.addElement(xmldoc, export, "generator-version", "0.76");
        XmlUtils.addElement(xmldoc, export, "captures-available", String.valueOf(captures));
        XmlUtils.addElement(xmldoc, export, "keymapperfiles-available", String.valueOf(mapperfiles));
        XmlUtils.addElement(xmldoc, export, "nativecommands-available", String.valueOf(nativecommands));
        XmlUtils.addElement(xmldoc, export, "gamedata-available", String.valueOf(gameData));
        Settings settings = Settings.getInstance();
        for (int i = 0; i < 10; ++i) {
            String s = settings.getSettings().getValue("gui", "custom" + (i + 1));
            XmlUtils.addCDataElement(xmldoc, export, "custom" + (i + 1), s);
        }
        return export;
    }

    public static String cleanEolnForXml(String s) {
        return s.replaceAll("\\r", "");
    }

    public static String getTextValue(Element element, String tagName) {
        Element n = XmlUtils.getNode(element, tagName);
        if (n != null) {
            Node child = n.getFirstChild();
            return child == null ? "" : child.getNodeValue();
        }
        return null;
    }

    public static Element getNode(Element element, String tagName) {
        NodeList nodelist = element.getElementsByTagName(tagName);
        if (nodelist != null && nodelist.getLength() > 0) {
            return (Element)nodelist.item(0);
        }
        return null;
    }
}

