/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.util.Arrays;
import org.dbgl.loopy.util.LittleEndian;

final class ShortName {
    private final char[] name;

    public ShortName(byte[] data) {
        char[] nameArr = new char[8];
        for (int i = 0; i < nameArr.length; ++i) {
            nameArr[i] = (char)LittleEndian.getUInt8(data, i);
        }
        if (LittleEndian.getUInt8(data, 0) == 5) {
            nameArr[0] = 229;
        }
        char[] extArr = new char[3];
        for (int i = 0; i < extArr.length; ++i) {
            extArr[i] = (char)LittleEndian.getUInt8(data, 8 + i);
        }
        this.name = ShortName.toCharArray(new String(nameArr).trim(), new String(extArr).trim());
    }

    private static char[] toCharArray(String name, String ext) {
        ShortName.checkValidName(name);
        ShortName.checkValidExt(ext);
        char[] result = new char[11];
        Arrays.fill(result, ' ');
        System.arraycopy(name.toCharArray(), 0, result, 0, name.length());
        System.arraycopy(ext.toCharArray(), 0, result, 8, ext.length());
        return result;
    }

    public String asSimpleString() {
        return new String(this.name).trim();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.asSimpleString() + "]";
    }

    private static void checkValidName(String name) {
        ShortName.checkString(name, "name", 1, 8);
    }

    private static void checkValidExt(String ext) {
        ShortName.checkString(ext, "extension", 0, 3);
    }

    private static void checkString(String str, String strType, int minLength, int maxLength) {
        if (str == null) {
            throw new IllegalArgumentException(strType + " is null");
        }
        if (str.length() < minLength) {
            throw new IllegalArgumentException(strType + " must have at least " + minLength + " characters: " + str);
        }
        if (str.length() > maxLength) {
            throw new IllegalArgumentException(strType + " has more than " + maxLength + " characters: " + str);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortName)) {
            return false;
        }
        ShortName other = (ShortName)obj;
        return Arrays.equals(this.name, other.name);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name);
    }
}

