/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.DFendImportThread;
import org.dbgl.util.DFendReloadedImportThread;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class DFendImportDialog
extends Dialog {
    private ExpandItem orginalExpandItem;
    private ExpandItem reloadedExpandItem;
    private Text location;
    private Text dfrLocation;
    private Text dfrConfsLocation;
    private Text logText;
    private DosboxVersion defaultDbversion;
    private UIThread importThread;
    private Button cancelButton;
    private Label profileLabel;
    private Shell shell;
    private Settings settings;

    public DFendImportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public DFendImportDialog(Shell parent) {
        this(parent, 0);
    }

    public void setDefaultDosboxVersion(DosboxVersion dbversion) {
        this.defaultDbversion = dbversion;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.importThread != null && !this.importThread.isAlive() && !this.cancelButton.getText().equals(this.settings.msg("button.finish"))) {
                if (this.importThread.isEverythingOk()) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.dfendimport.notice.importok"));
                } else {
                    GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.dfendimport.error.problem"));
                }
                this.profileLabel.setText(this.settings.msg("dialog.dfendimport.reviewlog"));
                this.profileLabel.pack();
                this.cancelButton.setText(this.settings.msg("button.finish"));
                this.cancelButton.setEnabled(true);
                this.shell.setDefaultButton(this.cancelButton);
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.importThread;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "dfendimportdialog"));
        this.shell.setText(this.settings.msg("dialog.dfendimport.title"));
        Group optionsGroup = new Group((Composite)this.shell, 0);
        optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        optionsGroup.setText(this.settings.msg("dialog.dfendimport.options"));
        optionsGroup.setLayout((Layout)new GridLayout(3, false));
        final ExpandBar bar = new ExpandBar((Composite)optionsGroup, 512);
        bar.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite originalComposite = new Composite((Composite)bar, 0);
        originalComposite.setLayout((Layout)new GridLayout(3, false));
        Composite reloadedComposite = new Composite((Composite)bar, 0);
        reloadedComposite.setLayout((Layout)new GridLayout(3, false));
        Label dfendLocLabel = new Label(originalComposite, 0);
        dfendLocLabel.setText(this.settings.msg("dialog.dfendimport.dfendpath"));
        this.location = new Text(originalComposite, 2048);
        this.location.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.location.setText(PlatformUtils.DFEND_PATH + "Profiles.dat");
        final BrowseButton browseButton = new BrowseButton(originalComposite, 0);
        browseButton.connect(this.shell, this.location, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DFEND, false, null);
        Label cleanUpLabel = new Label(originalComposite, 0);
        cleanUpLabel.setText(this.settings.msg("dialog.dfendimport.cleanup"));
        final Button cleanup = new Button(originalComposite, 32);
        cleanup.setText(this.settings.msg("dialog.dfendimport.removesections"));
        cleanup.setSelection(true);
        new Label(originalComposite, 0);
        Label dfendreloadedLocLabel = new Label(reloadedComposite, 0);
        dfendreloadedLocLabel.setText(this.settings.msg("dialog.dfendimport.reloaded.path"));
        this.dfrLocation = new Text(reloadedComposite, 2048);
        this.dfrLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dfrLocation.setText(PlatformUtils.DFEND_RELOADED_PATH.getPath());
        BrowseButton dfrBrowseButton = new BrowseButton(reloadedComposite, 0);
        dfrBrowseButton.connect(this.shell, this.dfrLocation, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Label dfendreloadedConfsLocLabel = new Label(reloadedComposite, 0);
        dfendreloadedConfsLocLabel.setText(this.settings.msg("dialog.dfendimport.reloaded.exportedconfspath"));
        this.dfrConfsLocation = new Text(reloadedComposite, 2048);
        this.dfrConfsLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton dfrConfsBrowseButton = new BrowseButton(reloadedComposite, 0);
        dfrConfsBrowseButton.connect(this.shell, this.dfrConfsLocation, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Label dfrCleanUpLabel = new Label(reloadedComposite, 0);
        dfrCleanUpLabel.setText(this.settings.msg("dialog.dfendimport.cleanup"));
        final Button dfrCleanup = new Button(reloadedComposite, 32);
        dfrCleanup.setText(this.settings.msg("dialog.dfendimport.reloaded.removesections"));
        new Label(reloadedComposite, 0);
        this.orginalExpandItem = new ExpandItem(bar, 0, 0);
        this.orginalExpandItem.setText(this.settings.msg("dialog.dfendimport.original.title"));
        this.orginalExpandItem.setHeight(originalComposite.computeSize((int)-1, (int)-1).y);
        this.orginalExpandItem.setControl((Control)originalComposite);
        this.reloadedExpandItem = new ExpandItem(bar, 0, 1);
        this.reloadedExpandItem.setText(this.settings.msg("dialog.dfendimport.reloaded.title"));
        this.reloadedExpandItem.setHeight(reloadedComposite.computeSize((int)-1, (int)-1).y);
        this.reloadedExpandItem.setControl((Control)reloadedComposite);
        this.reloadedExpandItem.setExpanded(true);
        bar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(DFendImportDialog.this.settings.msg("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(true);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        DFendImportDialog.this.shell.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                bar.getItem(((ExpandItem)e.item).getText().equals(DFendImportDialog.this.settings.msg("dialog.dfendimport.reloaded.title")) ? 0 : 1).setExpanded(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        DFendImportDialog.this.shell.layout();
                    }
                });
            }
        });
        final Button startImportButton = new Button((Composite)optionsGroup, 0);
        this.shell.setDefaultButton(startImportButton);
        startImportButton.setLayoutData((Object)new GridData(120, -1));
        startImportButton.setText(this.settings.msg("dialog.dfendimport.startimport"));
        this.cancelButton = new Button((Composite)optionsGroup, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DFendImportDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(80, -1));
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        new Label((Composite)optionsGroup, 0);
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        progressGroup.setText(this.settings.msg("dialog.dfendimport.progress"));
        progressGroup.setLayout((Layout)new GridLayout());
        final ProgressBar progressBar = new ProgressBar((Composite)progressGroup, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        startImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (!DFendImportDialog.this.isValid()) {
                        return;
                    }
                    if (DFendImportDialog.this.orginalExpandItem.getExpanded()) {
                        DFendImportDialog.this.importThread = new DFendImportThread(DFendImportDialog.this.logText, progressBar, DFendImportDialog.this.profileLabel, new File(DFendImportDialog.this.location.getText()), cleanup.getSelection(), DFendImportDialog.this.defaultDbversion);
                    } else {
                        DFendImportDialog.this.importThread = new DFendReloadedImportThread(DFendImportDialog.this.logText, progressBar, DFendImportDialog.this.profileLabel, new File(DFendImportDialog.this.dfrLocation.getText()), new File(DFendImportDialog.this.dfrConfsLocation.getText()), dfrCleanup.getSelection(), DFendImportDialog.this.defaultDbversion);
                    }
                    DFendImportDialog.this.location.setEnabled(false);
                    DFendImportDialog.this.dfrLocation.setEnabled(false);
                    DFendImportDialog.this.dfrConfsLocation.setEnabled(false);
                    browseButton.setEnabled(false);
                    cleanup.setEnabled(false);
                    startImportButton.setEnabled(false);
                    DFendImportDialog.this.cancelButton.setEnabled(false);
                    DFendImportDialog.this.importThread.start();
                }
                catch (Exception e) {
                    GeneralPurposeDialogs.warningMessage(DFendImportDialog.this.shell, e);
                    DFendImportDialog.this.importThread = null;
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.orginalExpandItem.getExpanded()) {
            if (StringUtils.isBlank((CharSequence)this.location.getText())) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dfendimport.required.location"), (Control)this.location);
            }
        } else {
            if (StringUtils.isBlank((CharSequence)this.dfrLocation.getText())) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dfendimport.reloaded.required.location"), (Control)this.dfrLocation);
            }
            if (StringUtils.isBlank((CharSequence)this.dfrConfsLocation.getText())) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.dfendimport.reloaded.required.confslocation"), (Control)this.dfrConfsLocation);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

