/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.MainWindow;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Filter;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditFilterDialog
extends Dialog {
    private static final String EMPTY_FIELD = "[ ]";
    private Text filter;
    private Text title;
    private String prevTitle;
    private Set<Integer> selectedProfileIds;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private Database dbase;
    private Object result;
    private Shell shell;
    private Settings settings;

    public EditFilterDialog(Shell parent) {
        super(parent, 0);
    }

    public void setFilter(Filter filter) {
        this.result = filter;
    }

    public void setIds(Set<Integer> selectedProfileIds) {
        this.selectedProfileIds = selectedProfileIds;
    }

    public Object open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "filterdialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.filter.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.filter.title.edit", new Object[]{((Filter)this.result).getTitle(), ((Filter)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem infoTabItem = new TabItem(tabFolder, 0);
        infoTabItem.setText(this.settings.msg("dialog.filter.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.filter.title"));
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
        sashForm.setLayout((Layout)new FillLayout());
        Composite leftComposite = new Composite((Composite)sashForm, 0);
        GridLayout gl1 = new GridLayout(1, false);
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        leftComposite.setLayout((Layout)gl1);
        this.title = new Text(leftComposite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Tree tree = new Tree((Composite)sashForm, 2080);
        tree.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        sashForm.setWeights(new int[]{60, 40});
        try {
            this.profilesList = this.dbase.readProfilesList("", "");
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        for (int i = 0; i < MainWindow.columnNames.length; ++i) {
            if (i == 20) continue;
            TreeItem item = new TreeItem(tree, 0);
            item.setText(MainWindow.columnNames[i]);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class TreeNodeItem
            implements Comparable<TreeNodeItem> {
                String value;
                String subQuery;
                String likeQuery;

                public TreeNodeItem(String v, String q, String l) {
                    this.value = StringUtils.isEmpty((CharSequence)v) ? EditFilterDialog.EMPTY_FIELD : v;
                    this.subQuery = q;
                    this.likeQuery = l;
                }

                @Override
                public int compareTo(TreeNodeItem o) {
                    int eq2;
                    int eq1 = this.value.equals(EditFilterDialog.EMPTY_FIELD) ? 1 : 0;
                    int n = eq2 = o.value.equals(EditFilterDialog.EMPTY_FIELD) ? 1 : 0;
                    if (eq1 + eq2 > 0) {
                        return eq2 - eq1;
                    }
                    return this.value.compareToIgnoreCase(o.value);
                }
            }
            TreeSet<TreeNodeItem> values = new TreeSet<TreeNodeItem>();
            switch (i) {
                case 0: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.getTitle(), "GAM.TITLE='" + p.getTitle() + "'", "GAM.TITLE"));
                    }
                    break;
                }
                case 1: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.hasSetupString(), p.hasSetup(0) ? "GAM.SETUP<>''" : "(GAM.SETUP IS NULL OR GAM.SETUP='')", null));
                    }
                    break;
                }
                case 2: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.getDeveloperName(), "DEV.NAME='" + p.getDeveloperName() + "'", "DEV.NAME"));
                    }
                    break;
                }
                case 3: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.getPublisherName(), "PUBL.NAME='" + p.getPublisherName() + "'", "PUBL.NAME"));
                    }
                    break;
                }
                case 4: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.getGenre(), "GEN.NAME='" + p.getGenre() + "'", "GEN.NAME"));
                    }
                    break;
                }
                case 5: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.getYear(), "YR.YEAR='" + p.getYear() + "'", null));
                    }
                    break;
                }
                case 6: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.getStatus(), "STAT.STAT='" + p.getStatus() + "'", "STAT.STAT"));
                    }
                    break;
                }
                case 7: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(p.isDefaultString(), "GAM.FAVORITE=" + p.isDefault(), null));
                    }
                    break;
                }
                case 8: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(String.valueOf(p.getId()), "GAM.ID=" + p.getId(), null));
                    }
                    break;
                }
                case 9: {
                    for (Profile p : this.profilesList) {
                        values.add(new TreeNodeItem(String.valueOf(p.getDbversionId()), "GAM.DBVERSION_ID=" + p.getDbversionId(), null));
                    }
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    for (Profile p : this.profilesList) {
                        int idx = i - 10;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomString(idx)), "CUST" + (idx + 1) + ".VALUE='" + p.getCustomString(idx) + "'", "CUST" + (idx + 1) + ".VALUE"));
                    }
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    for (Profile p : this.profilesList) {
                        int idx = i - 10;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomString(idx)), "GAM.CUSTOM" + (idx + 1) + "='" + p.getCustomString(idx) + "'", "GAM.CUSTOM" + (idx + 1)));
                    }
                    break;
                }
                case 18: 
                case 19: {
                    for (Profile p : this.profilesList) {
                        int idx = i - 10 - 8;
                        values.add(new TreeNodeItem(String.valueOf(p.getCustomInt(idx)), "GAM.CUSTOM" + (idx + 9) + "=" + p.getCustomInt(idx), null));
                    }
                    break;
                }
                case 21: {
                    for (Profile p : this.profilesList) {
                        String dbversionTitle = DosboxVersion.findById(this.dbversionsList, p.getDbversionId()).getTitle();
                        values.add(new TreeNodeItem(dbversionTitle, "GAM.DBVERSION_ID=" + p.getDbversionId(), null));
                    }
                    break;
                }
            }
            for (TreeNodeItem v : values) {
                String sentence;
                String[] words;
                TreeItem valueItem = new TreeItem(item, 0);
                valueItem.setText(v.value);
                valueItem.setData((Object)v.subQuery);
                valueItem.setGrayed(true);
                if (v.likeQuery == null || (words = (sentence = v.value.replaceAll("\\p{Punct}", " ")).split("\\s+")).length <= 1) continue;
                for (String w : words) {
                    TreeItem likeItem = new TreeItem(valueItem, 0);
                    likeItem.setText(w);
                    likeItem.setData((Object)("UPPER(" + v.likeQuery + ") LIKE '%" + w.toUpperCase() + "%'"));
                }
            }
        }
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem tItem = (TreeItem)event.item;
                    int depth = EditFilterDialog.this.depth(tItem);
                    if (depth == 0) {
                        if (tItem.getChecked()) {
                            if (tItem.getGrayed() || EditFilterDialog.this.getAllCheckedItems(tItem).isEmpty()) {
                                tItem.setChecked(false);
                            }
                        } else if (tItem.getGrayed()) {
                            tItem.setGrayed(false);
                        } else {
                            tItem.setGrayed(true);
                            tItem.setChecked(true);
                        }
                    } else if (depth == 1) {
                        TreeItem parent;
                        parent.setChecked(!EditFilterDialog.this.getAllCheckedItems(parent = tItem.getParentItem()).isEmpty());
                    } else {
                        TreeItem parent;
                        if (tItem.getChecked()) {
                            if (tItem.getGrayed()) {
                                tItem.setChecked(false);
                            }
                        } else if (tItem.getGrayed()) {
                            tItem.setGrayed(false);
                        } else {
                            tItem.setGrayed(true);
                            tItem.setChecked(true);
                        }
                        parent.setChecked(!EditFilterDialog.this.getAllCheckedItems(parent = tItem.getParentItem().getParentItem()).isEmpty());
                    }
                }
            }
        });
        tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ArrayList<String> rootQueriesAnd = new ArrayList<String>();
                ArrayList<String> rootQueriesOr = new ArrayList<String>();
                String generatedTitle = null;
                for (TreeItem rootItem : tree.getItems()) {
                    if (!rootItem.getChecked()) continue;
                    ArrayList<String> subQueriesAnd = new ArrayList<String>();
                    ArrayList<String> subQueriesOr = new ArrayList<String>();
                    for (TreeItem item : EditFilterDialog.this.getAllCheckedItems(rootItem)) {
                        TreeItem parent = item.getParentItem();
                        TreeItem parentOfParent = null;
                        if (parent == null) continue;
                        if (generatedTitle == null) {
                            parentOfParent = parent.getParentItem();
                            generatedTitle = parentOfParent != null ? parentOfParent.getText() + ": " + item.getText() : parent.getText() + ": " + item.getText();
                        } else if (!generatedTitle.endsWith("...")) {
                            generatedTitle = generatedTitle + "...";
                        }
                        if (item.getGrayed()) {
                            subQueriesOr.add((String)item.getData());
                            continue;
                        }
                        subQueriesAnd.add((String)item.getData());
                    }
                    String resultAnd = StringUtils.join(subQueriesAnd, (String)"\n\tAND ");
                    String resultOr = StringUtils.join(subQueriesOr, (String)"\n\tOR ");
                    boolean and = StringUtils.isNotBlank((CharSequence)resultAnd);
                    boolean or = StringUtils.isNotBlank((CharSequence)resultOr);
                    String result = null;
                    if (and && or) {
                        result = "(" + resultAnd + ")\nAND\n(" + resultOr + ")";
                    } else if (and) {
                        result = resultAnd;
                    } else if (or) {
                        result = resultOr;
                    }
                    if (rootItem.getGrayed()) {
                        rootQueriesOr.add("(" + result + ")");
                        continue;
                    }
                    rootQueriesAnd.add("(" + result + ")");
                }
                String resultAnd = StringUtils.join(rootQueriesAnd, (String)"\nAND\n");
                String resultOr = StringUtils.join(rootQueriesOr, (String)"\nOR\n");
                boolean and = StringUtils.isNotBlank((CharSequence)resultAnd);
                boolean or = StringUtils.isNotBlank((CharSequence)resultOr);
                String result = null;
                if (and && or) {
                    result = "(" + resultAnd + ")\nAND\n(" + resultOr + ")";
                } else if (and) {
                    result = resultAnd;
                } else if (or) {
                    result = resultOr;
                }
                if (StringUtils.isNotBlank(generatedTitle)) {
                    EditFilterDialog.this.title.setText(generatedTitle);
                }
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    EditFilterDialog.this.filter.setText(result);
                }
            }
        });
        Label filterLabel = new Label(composite, 0);
        filterLabel.setText(this.settings.msg("dialog.filter.filter"));
        this.filter = new Text(leftComposite, 2818);
        this.filter.setLayoutData((Object)new GridData(4, 4, true, true));
        Label resultLabel = new Label(composite, 0);
        resultLabel.setText(this.settings.msg("dialog.filter.result"));
        final Text results = new Text(composite, 2056);
        results.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new GridLayout(2, true));
        composite_7.setLayoutData((Object)"South");
        final Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        okButton.setLayoutData((Object)gridData);
        okButton.setText(this.settings.msg("button.ok"));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditFilterDialog.this.isValid()) {
                    return;
                }
                try {
                    int filterId = EditFilterDialog.this.dbase.addOrEditFilter(EditFilterDialog.this.title.getText(), EditFilterDialog.this.filter.getText(), EditFilterDialog.this.result == null ? -1 : ((Filter)EditFilterDialog.this.result).getId());
                    EditFilterDialog.this.result = new Filter(filterId, EditFilterDialog.this.title.getText(), EditFilterDialog.this.filter.getText());
                }
                catch (SQLException e) {
                    GeneralPurposeDialogs.warningMessage(EditFilterDialog.this.shell, e);
                }
                EditFilterDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        cancelButton.setLayoutData((Object)gridData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditFilterDialog.this.result = null;
                EditFilterDialog.this.shell.close();
            }
        });
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (EditFilterDialog.this.filter.getText().equals("") || EditFilterDialog.this.filter.getText().equals("UPPER(GAM.TITLE) LIKE '%" + EditFilterDialog.this.prevTitle.toUpperCase() + "%'")) {
                    if (EditFilterDialog.this.title.getText().length() == 0) {
                        EditFilterDialog.this.filter.setText("");
                    } else {
                        EditFilterDialog.this.filter.setText("UPPER(GAM.TITLE) LIKE '%" + EditFilterDialog.this.title.getText().toUpperCase() + "%'");
                    }
                }
                EditFilterDialog.this.prevTitle = EditFilterDialog.this.title.getText();
            }
        });
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    List<Profile> tmpList = EditFilterDialog.this.dbase.readProfilesList("", EditFilterDialog.this.filter.getText());
                    results.setText(EditFilterDialog.this.settings.msg("dialog.filter.notice.results", new Object[]{tmpList.size()}));
                    okButton.setEnabled(true);
                }
                catch (SQLException e) {
                    results.setText(EditFilterDialog.this.settings.msg("dialog.filter.error.invalidcondition"));
                    okButton.setEnabled(false);
                }
            }
        });
        if (this.result != null) {
            this.title.setText(((Filter)this.result).getTitle());
            this.filter.setText(((Filter)this.result).getFilter());
        } else {
            this.prevTitle = "";
            if (this.selectedProfileIds != null) {
                this.filter.setText("GAM.ID IN (" + StringUtils.join(this.selectedProfileIds, (char)',') + ")");
            }
        }
        this.title.setFocus();
    }

    private int depth(TreeItem item) {
        int result = 0;
        while ((item = item.getParentItem()) != null) {
            ++result;
        }
        return result;
    }

    private List<TreeItem> getAllCheckedItems(TreeItem treeItem) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        for (TreeItem item : treeItem.getItems()) {
            if (item.getChecked()) {
                result.add(item);
            }
            result.addAll(this.getAllCheckedItems(item));
        }
        return result;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.filter.required.title"), (Control)this.title);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

