/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GalleryItemRenderer
extends AbstractGalleryItemRenderer {
    private static final int lineWidth = 2;
    private static final int selectionRadius = 8;
    private static final String ELLIPSIS = "...";
    private final Color foregroundColor = Display.getDefault().getSystemColor(24);
    private final Color backgroundColor = Display.getDefault().getSystemColor(25);
    private final Color selectionForegroundColor = Display.getDefault().getSystemColor(27);
    private final Color selectionBackgroundColor = Display.getDefault().getSystemColor(26);
    private final String truncPosition;

    public GalleryItemRenderer(String truncPosition) {
        this.truncPosition = truncPosition;
    }

    public void draw(GC gc, GalleryItem item, int index, int x, int y, int width, int height) {
        Image _drawImage;
        gc.setFont(this.getFont(item));
        int fontHeight = gc.getFontMetrics().getHeight();
        boolean drawBackground = this.selected;
        Color drawBackgroundColor = null;
        if (!drawBackground && item.getBackground(true) != null && !RendererHelper.isColorsEquals((Color)(drawBackgroundColor = this.getBackground(item)), (Color)this.backgroundColor)) {
            drawBackground = true;
        }
        if (drawBackground) {
            if (this.selected) {
                gc.setBackground(this.selectionBackgroundColor);
                gc.setForeground(this.selectionBackgroundColor);
            } else if (drawBackgroundColor != null) {
                gc.setBackground(drawBackgroundColor);
            }
            gc.setLineStyle(3);
            gc.setLineWidth(2);
            gc.drawRoundRectangle(x + 1, y + 1, width - 2, height - 2, 8, 8);
            gc.fillRoundRectangle(x + 1, y + height - fontHeight - 1 - 1, width - 2, fontHeight + 1, 8, 8);
        }
        if ((_drawImage = item.getImage()) != null) {
            Rectangle itemImageBounds = _drawImage.getBounds();
            int xShift = RendererHelper.getShift((int)(width - 4), (int)itemImageBounds.width);
            gc.drawImage(_drawImage, x + 2 + xShift, y + 2);
            this.drawAllOverlays(gc, item, x, y, new Point(itemImageBounds.width, itemImageBounds.height), xShift, 2);
        }
        if (this.selected) {
            gc.setForeground(this.selectionForegroundColor);
            gc.setBackground(this.selectionBackgroundColor);
        } else {
            gc.setBackground(drawBackgroundColor != null ? drawBackgroundColor : this.backgroundColor);
            Color _drawForegroundColor = this.getForeground(item);
            gc.setForeground(_drawForegroundColor != null ? _drawForegroundColor : this.foregroundColor);
        }
        String text = this.truncPosition.equalsIgnoreCase("end") ? GalleryItemRenderer.createLabelTruncAtEnd(item.getText(), gc, width - 8) : RendererHelper.createLabel((String)item.getText(), (GC)gc, (int)(width - 8));
        int textWidth = gc.textExtent((String)text).x;
        int textxShift = RendererHelper.getShift((int)width, (int)textWidth);
        gc.drawText(text, x + textxShift, y + height - fontHeight - 2, true);
    }

    public void dispose() {
    }

    public static String createLabelTruncAtEnd(String text, GC gc, int width) {
        int w;
        int extent;
        if (text != null && (extent = gc.textExtent((String)text).x) > width && width > (w = gc.textExtent((String)ELLIPSIS).x)) {
            int l = text.length();
            while (extent > width) {
                extent = gc.textExtent((String)text.substring((int)0, (int)(--l))).x + w;
            }
            return text.substring(0, l) + ELLIPSIS;
        }
        return text;
    }
}

