/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.MyRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.ProgressDialog;
import org.dbgl.gui.Wizard;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.ImportThread;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.SevenzipExtractSingleFileCallback;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDialog
extends Wizard {
    private Text confLogText;
    private Text logText;
    private Text title;
    private Text author;
    private Text notes;
    private Button settingsOnly;
    private Button fullGames;
    private Button fullSettingsButton;
    private Button incrementalSettingsButton;
    private Button importCapturesButton;
    private Button importMapperfilesButton;
    private Button importNativeCommandsButton;
    private Button useOrgConf;
    private Button createNewConf;
    private Button customValues;
    private Button customFields;
    private Table profilesTable;
    private Table impDbVersionsList;
    private org.eclipse.swt.widgets.List myDbVersionsList;
    private ProgressBar progressBar;
    private Label profileLabel;
    private File archive;
    private List<DosboxVersion> dbversionsList;
    private StringBuffer messageLog;
    private String packageVersion;
    private String packageTitle;
    private String packageAuthor;
    private String packageNotes;
    private String creationApp;
    private String creationAppVersion;
    private String[] customFieldTitles;
    private Date creationDate;
    private boolean capturesAvailable = false;
    private boolean mapperfilesAvailable = false;
    private boolean nativecommandsAvailable = false;
    private boolean gamedataAvailable = false;
    private List<ExpProfile> profs;
    private SortedSet<DosboxVersion> dbSet;
    private List<Integer> dbmapping;

    public ImportDialog(Shell parent, List<DosboxVersion> dbList, File archive) {
        super(parent, 0, Settings.getInstance().msg("dialog.import.title"), "import", true);
        this.dbversionsList = dbList;
        this.archive = archive;
    }

    @Override
    protected boolean actionAfterNext() {
        if (this.stepNr == 2) {
            this.refillImportedDBVersionsList();
        } else if (this.stepNr == 4) {
            try {
                int i;
                for (i = 0; i < this.profs.size(); ++i) {
                    for (int j = 0; j < i; ++j) {
                        ExpProfile pI = this.profs.get(i);
                        ExpProfile pJ = this.profs.get(j);
                        if (!pI.getGameDir().equals(pJ.getGameDir())) continue;
                        pI.setImportedId(pJ.getImportedId());
                    }
                }
                for (i = this.profs.size() - 1; i >= 0; --i) {
                    TableItem it = this.profilesTable.getItem(i);
                    if (it.getChecked()) {
                        ExpProfile p = this.profs.get(i);
                        p.setDbversionId(ImportDialog.getMappedDosboxVersionId(this.dbSet, this.dbmapping, p.getDbversionId()));
                        continue;
                    }
                    this.profs.remove(i);
                }
                this.extensiveJobThread = new ImportThread(this.logText, this.progressBar, this.profileLabel, this.profs, this.archive, this.importCapturesButton.getSelection(), this.importMapperfilesButton.getSelection(), this.importNativeCommandsButton.getSelection(), this.useOrgConf.getSelection(), this.fullGames.getSelection(), this.fullSettingsButton.getSelection(), this.customValues.getSelection(), this.customFields.getSelection() ? this.customFieldTitles : null);
            }
            catch (IOException ex) {
                GeneralPurposeDialogs.warningMessage(this.shell, ex);
                this.extensiveJobThread = null;
            }
            catch (SQLException ex) {
                GeneralPurposeDialogs.warningMessage(this.shell, ex);
                this.extensiveJobThread = null;
            }
        } else if (this.stepNr == 5) {
            if (this.extensiveJobThread.isEverythingOk()) {
                GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.import.notice.importok"));
            } else {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.import.error.problem"));
            }
            this.profileLabel.setText(this.settings.msg("dialog.export.reviewlog"));
            this.profileLabel.pack();
        }
        return true;
    }

    @Override
    protected boolean init() {
        Settings settings = Settings.getInstance();
        this.messageLog = new StringBuffer();
        try {
            this.profs = new ArrayList<ExpProfile>();
            this.dbSet = new TreeSet<DosboxVersion>();
            Document doc = this.getProfilesXmlDocFromZip();
            if (doc == null) {
                throw new ZipException(settings.msg("dialog.import.error.gamepackarchivemissingprofilesxml"));
            }
            XPathFactory xfactory = XPathFactory.newInstance();
            XPath xPath = xfactory.newXPath();
            this.packageVersion = xPath.evaluate("/document/export/format-version", doc);
            this.packageTitle = xPath.evaluate("/document/export/title", doc);
            this.packageAuthor = xPath.evaluate("/document/export/author", doc);
            this.packageNotes = xPath.evaluate("/document/export/notes", doc);
            this.customFieldTitles = new String[10];
            for (int i = 0; i < 10; ++i) {
                this.customFieldTitles[i] = xPath.evaluate("/document/export/custom" + (i + 1), doc);
            }
            this.creationApp = xPath.evaluate("/document/export/generator-title", doc);
            this.creationAppVersion = xPath.evaluate("/document/export/generator-version", doc);
            this.creationDate = XmlUtils.datetimeFormatter.parse(xPath.evaluate("/document/export/creationdatetime", doc));
            this.capturesAvailable = Boolean.valueOf(xPath.evaluate("/document/export/captures-available", doc));
            this.mapperfilesAvailable = this.packageVersion.equals("1.0") ? false : Boolean.valueOf(xPath.evaluate("/document/export/keymapperfiles-available", doc));
            this.nativecommandsAvailable = this.packageVersion.equals("1.0") || this.packageVersion.equals("1.1") ? false : Boolean.valueOf(xPath.evaluate("/document/export/nativecommands-available", doc));
            this.gamedataAvailable = Boolean.valueOf(xPath.evaluate("/document/export/gamedata-available", doc));
            NodeList profNodes = (NodeList)xPath.evaluate("/document/profile", doc, XPathConstants.NODESET);
            for (int i = 0; i < profNodes.getLength(); ++i) {
                Element profileNode = (Element)profNodes.item(i);
                Element dosbox = XmlUtils.getNode(profileNode, "dosbox");
                DosboxVersion d = new DosboxVersion(i, XmlUtils.getTextValue(dosbox, "title"), "", "", true, false, false, "", XmlUtils.getTextValue(dosbox, "version"));
                this.dbSet.add(d);
                this.profs.add(new ExpProfile(profileNode, ImportDialog.getDosboxVersionId(d, this.dbSet), this.nativecommandsAvailable, this.packageVersion));
            }
        }
        catch (ZipException e) {
            this.messageLog.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            this.messageLog.append(settings.msg("dialog.import.error.profilesxmlinvalidformat", new Object[]{e.toString()})).append('\n');
            e.printStackTrace();
        }
        catch (SAXException e) {
            this.messageLog.append(settings.msg("dialog.import.error.profilesxmlinvalidformat", new Object[]{e.toString()})).append('\n');
            e.printStackTrace();
        }
        catch (IOException e) {
            this.messageLog.append(settings.msg("general.error.openfile", new Object[]{this.archive})).append('\n').append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            this.messageLog.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        catch (ParseException e) {
            this.messageLog.append(e.toString()).append('\n');
            e.printStackTrace();
        }
        if (this.messageLog.length() == 0) {
            this.messageLog.append(settings.msg("dialog.import.notice.importinformation", new Object[]{this.packageVersion, this.creationDate, this.creationApp, this.creationAppVersion})).append('\n');
        }
        return true;
    }

    public Document getProfilesXmlDocFromZip() throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        String archive = this.archive.getPath();
        Document doc = null;
        if (archive.toLowerCase().endsWith(FileUtils.ARCHIVES[0])) {
            ZipFile zf = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("profiles.xml")) continue;
                doc = builder.parse(zf.getInputStream(entry));
                break;
            }
            zf.close();
            return doc;
        }
        if (archive.toLowerCase().endsWith(FileUtils.ARCHIVES[1])) {
            final Handler zArchive = new Handler();
            MyRandomAccessFile istream = new MyRandomAccessFile(archive, "r");
            if (zArchive.Open(istream) != 0) {
                throw new IOException(Settings.getInstance().msg("general.error.opensevenzip", new Object[]{archive}));
            }
            final ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < zArchive.size(); ++i) {
                SevenZipEntry entry = zArchive.getEntry(i);
                if (entry.isDirectory() || !entry.getName().equalsIgnoreCase("profiles.xml")) continue;
                ProgressDialog prog = new ProgressDialog(this.getParent(), this.settings.msg("dialog.import.notice.processing7zip"));
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Extract
                extends Thread {
                    private int entryId;
                    private SevenzipExtractSingleFileCallback extractCallback;
                    private IOException exception;

                    Extract(int entryId, ProgressNotifyable prog) {
                        this.entryId = entryId;
                        this.extractCallback = new SevenzipExtractSingleFileCallback(prog, out);
                        this.exception = null;
                    }

                    @Override
                    public void run() {
                        try {
                            zArchive.Extract(new int[]{this.entryId}, 1, 0, this.extractCallback);
                        }
                        catch (IOException e) {
                            this.exception = e;
                        }
                    }

                    public IOException getIOException() {
                        return this.exception;
                    }
                }
                Extract extract = new Extract(i, prog);
                prog.setThread(extract);
                prog.open();
                if (extract.getIOException() != null) {
                    zArchive.close();
                    out.close();
                    throw extract.getIOException();
                }
                doc = builder.parse(new ByteArrayInputStream(out.toByteArray()));
                break;
            }
            zArchive.close();
            out.close();
            return doc;
        }
        return null;
    }

    @Override
    protected void onExit() {
        this.result = this.extensiveJobThread != null && ((ImportThread)this.extensiveJobThread).getCustomFields() != null;
    }

    @Override
    protected boolean isValidInput() {
        if (this.stepNr == 2) {
            return this.conditionsForStep3Ok();
        }
        return true;
    }

    private boolean conditionsForStep3Ok() {
        GeneralPurposeDialogs.initErrorDialog();
        this.atLeastOneProfileSelected();
        if (this.fullGames.getSelection()) {
            this.gameDirExists();
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void atLeastOneProfileSelected() {
        for (TableItem item : this.profilesTable.getItems()) {
            if (!item.getChecked()) continue;
            return;
        }
        GeneralPurposeDialogs.addError(this.settings.msg("dialog.import.required.oneprofiletoimport"), (Control)this.profilesTable);
    }

    private void gameDirExists() {
        for (TableItem item : this.profilesTable.getItems()) {
            File f;
            if (!item.getChecked() || !(f = FileUtils.canonicalToDosroot(new File(item.getText(1), item.getText(2)).getPath())).exists()) continue;
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.import.error.gamedatadirexists", new Object[]{f}), (Control)this.profilesTable);
        }
    }

    private void refillImportedDBVersionsList() {
        int idx = 0;
        for (DosboxVersion dbversion : this.dbSet) {
            int dbid = dbversion.getId();
            TableItem ti = this.impDbVersionsList.getItem(idx);
            Display d = this.shell.getDisplay();
            Color c = this.isUsed(dbid) ? null : d.getSystemColor(15);
            ti.setForeground(c);
            ++idx;
        }
    }

    private boolean isUsed(int dbVersionId) {
        for (int i = 0; i < this.profs.size(); ++i) {
            TableItem item = this.profilesTable.getItem(i);
            int dbid = this.profs.get(i).getDbversionId();
            if (!item.getChecked() || dbVersionId != dbid) continue;
            return true;
        }
        return false;
    }

    public static int getMappedDosboxVersionId(Set<DosboxVersion> dbSet, List<Integer> dbmapping, int id) {
        int index = 0;
        for (DosboxVersion ver : dbSet) {
            if (ver.getId() == id) {
                return dbmapping.get(index);
            }
            ++index;
        }
        return -1;
    }

    public static int getDosboxVersionId(DosboxVersion dbversion, Set<DosboxVersion> dbSet) {
        for (DosboxVersion d : dbSet) {
            if (d.compareTo(dbversion) != 0) continue;
            return d.getId();
        }
        return -1;
    }

    @Override
    protected void fillPages() {
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
        this.addStep(this.page5());
    }

    private Control page1() {
        Group group1 = new Group((Composite)this.shell, 0);
        group1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group1.setText(this.settings.msg("dialog.import.step1"));
        group1.setLayout((Layout)new GridLayout(2, false));
        Label titleLabel = new Label((Composite)group1, 0);
        titleLabel.setText(this.settings.msg("dialog.export.exporttitle"));
        this.title = new Text((Composite)group1, 2048);
        this.title.setLayoutData((Object)new GridData(4, 4, true, false));
        this.title.setEditable(false);
        Label authorLabel = new Label((Composite)group1, 0);
        authorLabel.setText(this.settings.msg("dialog.export.author"));
        this.author = new Text((Composite)group1, 2048);
        this.author.setLayoutData((Object)new GridData(4, 4, true, false));
        this.author.setEditable(false);
        Label notesLabel = new Label((Composite)group1, 0);
        notesLabel.setText(this.settings.msg("dialog.export.notes"));
        this.notes = new Text((Composite)group1, 2890);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 40;
        this.notes.setLayoutData((Object)gridData);
        Label logLabel = new Label((Composite)group1, 0);
        logLabel.setText(this.settings.msg("dialog.export.log"));
        this.confLogText = new Text((Composite)group1, 2890);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumHeight = 40;
        this.confLogText.setLayoutData((Object)gridData2);
        if (this.packageTitle != null) {
            this.title.setText(this.packageTitle);
        }
        if (this.packageAuthor != null) {
            this.author.setText(this.packageAuthor);
        }
        if (this.packageNotes != null) {
            this.notes.setText(this.packageNotes);
        }
        this.confLogText.setText(this.messageLog.toString());
        return group1;
    }

    private Control page2() {
        Group page2 = new Group((Composite)this.shell, 0);
        page2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        page2.setText(this.settings.msg("dialog.import.step2"));
        page2.setLayout((Layout)new GridLayout(2, false));
        Label importLabel = new Label((Composite)page2, 0);
        importLabel.setText(this.settings.msg("dialog.import.import"));
        Group group1 = new Group((Composite)page2, 0);
        group1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group1.setLayout((Layout)new GridLayout());
        this.settingsOnly = new Button((Composite)group1, 16);
        this.settingsOnly.setText(this.settings.msg("dialog.export.export.profiles"));
        this.fullGames = new Button((Composite)group1, 16);
        this.fullGames.setText(this.settings.msg("dialog.export.export.games"));
        new Label((Composite)page2, 0);
        Group group2 = new Group((Composite)page2, 0);
        group2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group2.setLayout((Layout)new GridLayout());
        this.incrementalSettingsButton = new Button((Composite)group2, 16);
        this.incrementalSettingsButton.setText(this.settings.msg("dialog.import.import.incrconf"));
        this.fullSettingsButton = new Button((Composite)group2, 16);
        this.fullSettingsButton.setText(this.settings.msg("dialog.import.import.fullconf"));
        this.incrementalSettingsButton.setSelection(true);
        new Label((Composite)page2, 0);
        Group group3 = new Group((Composite)page2, 0);
        group3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group3.setLayout((Layout)new GridLayout());
        this.importCapturesButton = new Button((Composite)group3, 32);
        this.importCapturesButton.setText(this.settings.msg("dialog.template.captures"));
        this.importMapperfilesButton = new Button((Composite)group3, 32);
        this.importMapperfilesButton.setText(this.settings.msg("dialog.template.mapperfile"));
        this.importNativeCommandsButton = new Button((Composite)group3, 32);
        this.importNativeCommandsButton.setText(this.settings.msg("dialog.export.nativecommands"));
        new Label((Composite)page2, 0);
        Group group5 = new Group((Composite)page2, 0);
        group5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group5.setLayout((Layout)new GridLayout());
        this.customValues = new Button((Composite)group5, 32);
        this.customValues.setText(this.settings.msg("dialog.import.import.customvalues"));
        this.customValues.setSelection(true);
        this.customFields = new Button((Composite)group5, 32);
        this.customFields.setText(this.settings.msg("dialog.import.import.customfields"));
        Label confFileLabel = new Label((Composite)page2, 0);
        confFileLabel.setText(this.settings.msg("dialog.main.profile.view.conf"));
        Group group4 = new Group((Composite)page2, 0);
        group4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group4.setLayout((Layout)new GridLayout());
        this.useOrgConf = new Button((Composite)group4, 16);
        this.useOrgConf.setText(this.settings.msg("dialog.import.useorgconf"));
        this.createNewConf = new Button((Composite)group4, 16);
        this.createNewConf.setText(this.settings.msg("dialog.import.createnewconf"));
        if (this.gamedataAvailable) {
            this.fullGames.setSelection(true);
        } else {
            this.fullGames.setEnabled(false);
            this.settingsOnly.setSelection(true);
        }
        if (this.settings.getSettings().getIntValue("profiledefaults", "confpath") == 1) {
            this.useOrgConf.setSelection(true);
        } else {
            this.useOrgConf.setEnabled(false);
            this.createNewConf.setEnabled(false);
        }
        if (this.capturesAvailable) {
            this.importCapturesButton.setSelection(true);
        } else {
            this.importCapturesButton.setEnabled(false);
        }
        if (this.mapperfilesAvailable) {
            this.importMapperfilesButton.setSelection(true);
        } else {
            this.importMapperfilesButton.setEnabled(false);
        }
        this.importNativeCommandsButton.setEnabled(this.nativecommandsAvailable);
        return page2;
    }

    private Control page3() {
        Group profilesGroup = new Group((Composite)this.shell, 0);
        profilesGroup.setText(this.settings.msg("dialog.import.step3"));
        profilesGroup.setLayout((Layout)new GridLayout(2, false));
        this.profilesTable = new Table((Composite)profilesGroup, 67616);
        this.profilesTable.setHeaderVisible(true);
        GridData gridData_1 = new GridData(4, 4, true, true, 1, 2);
        gridData_1.heightHint = 80;
        this.profilesTable.setLayoutData((Object)gridData_1);
        this.profilesTable.setLinesVisible(true);
        TableColumn title = new TableColumn(this.profilesTable, 0);
        title.setWidth(260);
        title.setText(this.settings.msg("dialog.main.profiles.column.title"));
        TableColumn basedir = new TableColumn(this.profilesTable, 0);
        basedir.setWidth(100);
        basedir.setText(this.settings.msg("dialog.import.column.basedir"));
        TableColumn subdir = new TableColumn(this.profilesTable, 0);
        subdir.setWidth(120);
        subdir.setText(this.settings.msg("dialog.export.column.gamedir"));
        Button allButton = new Button((Composite)profilesGroup, 0);
        GridData gridData = new GridData(4, 128, true, false);
        allButton.setLayoutData((Object)gridData);
        allButton.setText(this.settings.msg("button.all"));
        allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable.getItems()) {
                    item.setChecked(true);
                }
            }
        });
        Button noneButton = new Button((Composite)profilesGroup, 0);
        GridData gridDataNone = new GridData(4, 1024, true, false);
        noneButton.setLayoutData((Object)gridDataNone);
        noneButton.setText(this.settings.msg("button.none"));
        noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable.getItems()) {
                    item.setChecked(false);
                }
            }
        });
        Composite buttonsGroup = new Composite((Composite)profilesGroup, 0);
        buttonsGroup.setLayout((Layout)new RowLayout());
        Button setBaseDirButton = new Button(buttonsGroup, 0);
        setBaseDirButton.setText(this.settings.msg("button.setbasedir"));
        setBaseDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportDialog.this.shell);
                dialog.setFilterPath(FileUtils.canonicalToDosroot(".").getPath());
                String result = dialog.open();
                if (result != null) {
                    File newBaseDir = FileUtils.makeRelativeToDosroot(new File(result));
                    for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                        TableItem item = ImportDialog.this.profilesTable.getItem(i);
                        if (!item.getChecked()) continue;
                        ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(newBaseDir);
                        item.setText(1, newBaseDir.getPath());
                    }
                }
            }
        });
        Button addGameTitleToBaseDirButton = new Button(buttonsGroup, 0);
        addGameTitleToBaseDirButton.setText(this.settings.msg("button.addgametitletobasedir"));
        addGameTitleToBaseDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                    TableItem item = ImportDialog.this.profilesTable.getItem(i);
                    if (!item.getChecked()) continue;
                    String gameTitle = item.getText(0).replaceAll("[^a-zA-Z_0-9()]", "");
                    if (item.getText(1).endsWith(gameTitle)) continue;
                    File newFile = new File(item.getText(1), gameTitle);
                    ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(newFile);
                    item.setText(1, newFile.getPath());
                }
            }
        });
        Button removeGameTitleFromBaseDirButton = new Button(buttonsGroup, 0);
        removeGameTitleFromBaseDirButton.setText(this.settings.msg("button.removegametitlefrombasedir"));
        removeGameTitleFromBaseDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (int i = 0; i < ImportDialog.this.profilesTable.getItems().length; ++i) {
                    TableItem item = ImportDialog.this.profilesTable.getItem(i);
                    if (!item.getChecked()) continue;
                    String gameTitle = item.getText(0).replaceAll("[^a-zA-Z_0-9()]", "");
                    if (!item.getText(1).endsWith(gameTitle)) continue;
                    File newFile = new File(item.getText(1)).getParentFile();
                    ((ExpProfile)ImportDialog.this.profs.get(i)).setBaseDir(newFile);
                    item.setText(1, newFile.getPath());
                }
            }
        });
        this.profilesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                int idx = ImportDialog.this.profilesTable.getSelectionIndex();
                ExpProfile prof = (ExpProfile)ImportDialog.this.profs.get(idx);
                DirectoryDialog dialog = new DirectoryDialog(ImportDialog.this.shell);
                dialog.setFilterPath(FileUtils.canonicalToDosroot(prof.getBaseDir().getPath()).getPath());
                String result = dialog.open();
                if (result != null) {
                    File newBaseDir = FileUtils.makeRelativeToDosroot(new File(result));
                    prof.setBaseDir(newBaseDir);
                    ImportDialog.this.profilesTable.getSelection()[0].setText(1, newBaseDir.getPath());
                }
            }
        });
        for (ExpProfile prof : this.profs) {
            TableItem item = new TableItem(this.profilesTable, 0);
            item.setText(prof.getTitle());
            item.setText(1, prof.getBaseDir().getPath());
            item.setText(2, prof.getGameDir().getPath());
            item.setChecked(true);
        }
        return profilesGroup;
    }

    private Control page4() {
        Group dosboxVersionsGroup = new Group((Composite)this.shell, 0);
        dosboxVersionsGroup.setLayout((Layout)new GridLayout(3, false));
        dosboxVersionsGroup.setText(this.settings.msg("dialog.import.step4"));
        dosboxVersionsGroup.setLayoutData((Object)"North");
        Label importedVersionsLabel = new Label((Composite)dosboxVersionsGroup, 0);
        importedVersionsLabel.setText(this.settings.msg("dialog.import.dosboxversioninimport"));
        Label label_2 = new Label((Composite)dosboxVersionsGroup, 2);
        label_2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        Label configuredVersionsLabel = new Label((Composite)dosboxVersionsGroup, 0);
        configuredVersionsLabel.setText(this.settings.msg("dialog.import.dosboxversioninstalled"));
        this.impDbVersionsList = new Table((Composite)dosboxVersionsGroup, 67584);
        this.impDbVersionsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.impDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int impIdx = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                int mappedId = (Integer)ImportDialog.this.dbmapping.get(impIdx);
                int myIdx = DosboxVersion.findIndexById(ImportDialog.this.dbversionsList, mappedId);
                ImportDialog.this.myDbVersionsList.select(myIdx);
            }
        });
        this.myDbVersionsList = new org.eclipse.swt.widgets.List((Composite)dosboxVersionsGroup, 2816);
        this.myDbVersionsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.myDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                if (idx != -1) {
                    int myIdx = ImportDialog.this.myDbVersionsList.getSelectionIndex();
                    ImportDialog.this.dbmapping.set(idx, ((DosboxVersion)ImportDialog.this.dbversionsList.get(myIdx)).getId());
                }
            }
        });
        for (DosboxVersion ver : this.dbversionsList) {
            this.myDbVersionsList.add(ver.getTitle() + " (" + ver.getVersion() + ")");
        }
        this.dbmapping = new ArrayList<Integer>();
        for (DosboxVersion dbversion : this.dbSet) {
            TableItem item = new TableItem(this.impDbVersionsList, 0);
            item.setText(dbversion.getTitle() + " (" + dbversion.getVersion() + ")");
            this.dbmapping.add(dbversion.findBestMatchId(this.dbversionsList));
        }
        return dosboxVersionsGroup;
    }

    private Control page5() {
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setText(this.settings.msg("dialog.import.step5"));
        progressGroup.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)progressGroup, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.profileLabel.setText(this.settings.msg("dialog.import.start"));
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        return progressGroup;
    }
}

