/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.dbgl.gui.MainWindow;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.eclipse.swt.SWT;

public class Launcher {
    public static void main(String[] args) {
        String dbglLibPath;
        File libDir;
        System.out.print("Launching DBGL using " + PlatformUtils.JVM_ARCH + "-Bit VM " + PlatformUtils.JVM_VERSION + " on " + PlatformUtils.OS_NAME + " v" + PlatformUtils.OS_VERSION + PlatformUtils.OS_ARCH + ", " + "HSQL Database Engine" + " " + "1.8.1.3");
        File homeDir = new File(System.getProperty("user.home")).getAbsoluteFile();
        if (System.getProperty("swt.library.path") == null && homeDir.isDirectory() && !PlatformUtils.isDirectoryWritable(homeDir) && (libDir = new File(dbglLibPath = "lib").getAbsoluteFile()).isDirectory() && PlatformUtils.isDirectoryWritable(libDir)) {
            System.out.print(", user.home '" + homeDir + "' appears unwritable - switched swt.library.path to '" + dbglLibPath + "'");
            System.setProperty("swt.library.path", dbglLibPath);
        }
        Launcher.loadSWT();
        System.out.println(", SWT v" + SWT.getVersion() + SWT.getPlatform());
        new MainWindow().open();
    }

    public static void loadSWT() {
        try {
            File file = null;
            if (PlatformUtils.IS_WINDOWS) {
                file = new File("lib/swtwin32.jar");
                if (PlatformUtils.JVM_ARCH.equals("64")) {
                    file = new File("lib/swtwin64.jar");
                }
            } else if (PlatformUtils.IS_OSX) {
                file = new File("lib/swtmac32.jar");
                if (PlatformUtils.JVM_ARCH.equals("64")) {
                    file = new File("lib/swtmac64.jar");
                } else if (PlatformUtils.OS_ARCH.startsWith("ppc")) {
                    file = new File("lib/swtmaccb.jar");
                }
            } else if (PlatformUtils.IS_LINUX) {
                file = new File("lib/swtlin32.jar");
                if (PlatformUtils.JVM_ARCH.equals("64")) {
                    file = new File("lib/swtlin64.jar");
                }
            }
            if (file == null || !FileUtils.isExistingFile(file)) {
                file = new File("lib/swt.jar");
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)ClassLoader.getSystemClassLoader(), file.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

