/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.connect.Messaging;
import org.dbgl.db.Database;
import org.dbgl.gui.AboutDialog;
import org.dbgl.gui.AddGameWizardDialog;
import org.dbgl.gui.DFendImportDialog;
import org.dbgl.gui.DeleteProfilesDialog;
import org.dbgl.gui.EditDosboxVersionDialog;
import org.dbgl.gui.EditFilterDialog;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.EditTemplateDialog;
import org.dbgl.gui.ExportDialog;
import org.dbgl.gui.ExportListDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.ImportDialog;
import org.dbgl.gui.MigrateDialog;
import org.dbgl.gui.ProfileLoader;
import org.dbgl.gui.ProfilesList;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.Thumb;
import org.dbgl.interfaces.ReOrderable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpTemplate;
import org.dbgl.model.Filter;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.OrderingVector;
import org.dbgl.model.Profile;
import org.dbgl.model.SearchResult;
import org.dbgl.model.Template;
import org.dbgl.model.ThumbInfo;
import org.dbgl.model.ViewType;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainWindow
implements ReOrderable {
    public static final String PROGRAM_VERSION;
    public static final String PROGRAM_NAME_FULL = "DOSBox Game Launcher";
    public static final int RO_COLUMN_NAMES = 10;
    public static final int EDIT_COLUMN_NAMES = 10;
    private static final String[] ICOS_DBGL;
    static String[] columnNames;
    private Display display;
    private Shell shell;
    private OrderingVector orderingVector = null;
    private String filterClause = null;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private List<Filter> filtersList;
    private Database dbase = null;
    private Settings settings = null;
    private SectionsWrapper ssettings = null;
    private File currentThumbFile = null;
    private int thumbHeight;
    private ToolItem displayNotes;
    private ToolItem displayScreenshots;
    private int[] columnIds;
    private ProfilesList profile_table;
    private Table dbversion_table;
    private Table template_table;
    private CTabFolder filterFolder;
    private ToolItem setupToolItem;
    private ToolItem viewSelector;
    private Text notesField;
    private Composite thumbsToolBar;
    private Menu menu_thumb;
    private Link[] link;
    private Menu viewProfileSubMenu;
    private Menu viewDosboxSubMenu;
    private Menu viewTemplateSubMenu;
    private final SelectionAdapter addProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doAddProfile();
        }
    };
    private final SelectionAdapter editProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doEditProfile();
        }
    };
    private final SelectionAdapter removeProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRemoveProfile();
        }
    };
    private final SelectionAdapter setupProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRunProfile(0, false);
        }
    };
    private final SelectionAdapter addWizardAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doStartGameWizard();
        }
    };
    private final SelectionAdapter runProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRunProfile(-1, false);
        }
    };
    private final SelectionAdapter prepareProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doRunProfile(-1, true);
        }
    };
    private final SelectionAdapter selectProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.displayProfileInformation(false);
        }
    };
    private final SelectionAdapter duplicateProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doDuplicateProfile();
        }
    };
    private final SelectionAdapter toggleProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doToggleFavoriteProfile();
        }
    };
    private final SelectionAdapter shortcutProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doCreateShortcut();
        }
    };
    private final SelectionAdapter openProfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            int index = MainWindow.this.profile_table.getSelectionIndex();
            if (index != -1) {
                Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                try {
                    Conf c = new Conf(prof, (DosboxVersion)DosboxVersion.findById(MainWindow.this.dbversionsList, prof.getDbversionId()), System.err);
                    PlatformUtils.openDirForViewing(c.getAutoexec().getCanonicalMainDir());
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, e);
                }
            }
        }
    };
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent event) {
            MainWindow.this.doRunProfile(-1, false);
        }
    };
    private final MouseAdapter filterMouseAdapter = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent event) {
            MainWindow.this.doEditFilter();
        }
    };
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 127 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 114) {
                MainWindow.this.doRemoveProfile();
            } else if (event.keyCode == 0x1000009 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 110) {
                MainWindow.this.doAddProfile();
            } else if (event.keyCode == 0x100000B) {
                MainWindow.this.doEditProfile(true);
            } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 109) {
                MainWindow.this.doToggleFavoriteProfile();
            } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 100) {
                MainWindow.this.doDuplicateProfile();
            } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 97) {
                MainWindow.this.profile_table.selectAll();
            } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 102) {
                MainWindow.this.doAddFilter();
            } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 99) {
                MainWindow.this.doViewProfileConf();
            } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 119) {
                MainWindow.this.doStartGameWizard();
            }
        }
    };
    private final TraverseListener travListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent event) {
            if (event.stateMask == SWT.MOD1 && event.detail == 4) {
                MainWindow.this.doEditProfile();
            } else if (event.stateMask == 131072 && event.detail == 4) {
                MainWindow.this.doRunProfile(0, false);
            } else if (event.detail == 4) {
                MainWindow.this.doRunProfile(-1, false);
            }
        }
    };
    private final SelectionAdapter dfendAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doDFendImport();
        }
    };
    private final SelectionAdapter migrateAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doMigrate();
        }
    };
    private final SelectionAdapter locateDosboxAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doLocateDosbox(true);
        }
    };
    private final SelectionAdapter exportListAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doExportProfilesList();
        }
    };
    private final SelectionAdapter importConfAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doImportConfigfile();
        }
    };
    private final SelectionAdapter exportTemplatesAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doExportTemplates();
        }
    };
    private final SelectionAdapter importDefaultTemplatesAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doImportDefaultTemplates(true);
        }
    };
    private final SelectionAdapter exportAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doExportProfiles();
        }
    };
    private final SelectionAdapter importAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doImportProfiles();
        }
    };
    private final SelectionAdapter cleanupAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            try {
                if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.databasecleanup"))) {
                    int itemsRemoved = MainWindow.this.dbase.cleanup();
                    GeneralPurposeDialogs.infoMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.notice.databasecleanupok", new Object[]{itemsRemoved}));
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, e);
            }
        }
    };
    private final SelectionAdapter settingsAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doOpenSettingsDialog();
        }
    };
    private final SelectionAdapter exitAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.shell.close();
        }
    };
    private final SelectionAdapter addFilterAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doAddFilter();
        }
    };
    private final SelectionAdapter editFilterAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doEditFilter();
        }
    };
    private final SelectionAdapter openAboutAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MainWindow.this.doOpenAbout();
        }
    };

    public void open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.ssettings = this.settings.getSettings();
        if (PlatformUtils.IS_OSX) {
            Display.setAppName((String)"DBGL");
            Display.setAppVersion((String)PROGRAM_VERSION);
        }
        this.display = Display.getDefault();
        this.createContents();
        if (Database.isInitializedNewDatabase()) {
            this.doLocateDosbox(false);
            if (this.dbversionsList.size() > 0) {
                this.doImportDefaultTemplates(false);
            }
        }
        Messaging mess = null;
        if (this.ssettings.getBooleanValue("communication", "port_enabled")) {
            mess = new Messaging(this.ssettings.getIntValue("communication", "port"), this);
            mess.start();
        }
        this.shell.open();
        this.shell.layout();
        this.profile_table.setSelection(this.ssettings.getIntValue("gui", "selectedprofile"));
        this.displayProfileInformation(false);
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        SWTImageManager.dispose();
        this.display.dispose();
        if (mess != null) {
            mess.close();
        }
        try {
            this.settings.save();
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        try {
            this.dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createContents() {
        this.initColumnIds();
        this.orderingVector = new OrderingVector(this.ssettings.getIntValues("gui", "sortcolumn"), this.ssettings.getBooleanValues("gui", "sortascending"));
        this.shell = new Shell();
        this.shell.setImages(SWTImageManager.getResourceImages(this.display, ICOS_DBGL));
        try {
            List<Profile> invalidProfiles = this.dbase.findInvalidProfiles();
            if (invalidProfiles.size() > 0) {
                ArrayList<String> titles = new ArrayList<String>();
                for (Profile p : invalidProfiles) {
                    titles.add(p.getTitle());
                }
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removeinvalidprofiles", new Object[]{invalidProfiles.size(), StringUtils.join(titles, (String)", ")}))) {
                    for (Profile prof : invalidProfiles) {
                        this.dbase.removeProfile(prof.getId());
                    }
                }
            }
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.filtersList = this.dbase.readFiltersList();
            this.filtersList.add(0, new Filter(-1, this.settings.msg("dialog.main.allprofiles"), null));
            this.filterClause = this.filtersList.get(this.ssettings.getIntValue("gui", "filtertab")).getFilter();
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                boolean isMaximized = MainWindow.this.shell.getMaximized();
                if (!isMaximized) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.ssettings.setIntValue("gui", "width", rec.width);
                    MainWindow.this.ssettings.setIntValue("gui", "height", rec.height);
                    MainWindow.this.ssettings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.ssettings.setIntValue("gui", "y", rec.y);
                }
                MainWindow.this.ssettings.setBooleanValue("gui", "maximized", isMaximized);
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent event) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.ssettings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.ssettings.setIntValue("gui", "y", rec.y);
                }
            }
        });
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setLocation(this.ssettings.getIntValue("gui", "x"), this.ssettings.getIntValue("gui", "y"));
        if (this.ssettings.getBooleanValue("gui", "maximized")) {
            this.shell.setMaximized(true);
        } else {
            this.shell.setSize(this.ssettings.getIntValue("gui", "width"), this.ssettings.getIntValue("gui", "height"));
        }
        this.shell.setText(this.settings.msg("main.title", new Object[]{PROGRAM_VERSION}));
        this.createFileMenu();
        final TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createProfilesTab(tabFolder);
        this.createDosboxVersionsTab(tabFolder);
        this.createTemplatesTab(tabFolder);
        this.shell.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellClosed(ShellEvent arg0) {
            }

            public void shellActivated(ShellEvent arg0) {
                if (tabFolder.getSelectionIndex() == 0) {
                    MainWindow.this.profile_table.setFocus();
                    MainWindow.this.displayProfileInformation(true);
                }
            }
        });
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        for (DosboxVersion dbversion : this.dbversionsList) {
            this.addDosboxVersionToTable(dbversion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setFocus();
    }

    @Override
    public void doReorder(int columnId, int dir) {
        Set<Integer> selectedProfiles = this.getSelectedProfileIds();
        try {
            this.orderingVector.addOrdering(this.columnIds[columnId], dir == 128);
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        for (int i = 0; i < this.profilesList.size(); ++i) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
        }
        this.profile_table.setSelection(this.getIndicesByIds(selectedProfiles));
        this.ssettings.setIntValues("gui", "sortcolumn", this.orderingVector.getColumns());
        this.ssettings.setBooleanValues("gui", "sortascending", this.orderingVector.getAscendings());
    }

    private void displayLinks(String[] p_link, String[] p_linkTitle) {
        for (int i = 0; i < this.link.length; ++i) {
            if (p_link[i] == null || "".equals(p_link[i])) {
                this.link[i].setText("");
                this.link[i].setToolTipText(null);
                ((GridData)this.link[i].getLayoutData()).exclude = true;
                this.link[i].pack();
                continue;
            }
            String url = p_link[i];
            String tag = p_link[i];
            if (url.indexOf("://") == -1) {
                url = "file://" + FileUtils.canonicalToData(url).getPath();
                tag = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(tag)).getPath();
            }
            if (p_linkTitle[i] != null && !"".equals(p_linkTitle[i])) {
                tag = p_linkTitle[i];
            }
            StringBuffer text = new StringBuffer("<a href=\"").append(url).append("\">").append(tag).append("</a>");
            this.link[i].setText(text.toString());
            this.link[i].setToolTipText(url);
            ((GridData)this.link[i].getLayoutData()).exclude = false;
        }
        this.link[0].getParent().layout();
        this.link[0].getParent().getParent().layout();
    }

    private void displayScreenshots(Profile prof, ProfilesList.ProfilesListItem profilesListItem, boolean forceRefresh) {
        for (Control c : this.thumbsToolBar.getChildren()) {
            c.setMenu(null);
            c.dispose();
        }
        this.thumbsToolBar.pack();
        if (prof != null) {
            File[] files;
            ThumbInfo thumbInfo = (ThumbInfo)profilesListItem.getData();
            if (forceRefresh) {
                thumbInfo.resetCachedInfo();
            }
            for (File file : files = thumbInfo.getAllThumbs()) {
                String label = file.getName().toLowerCase();
                label = this.ssettings.getBooleanValue("gui", "screenshotsfilename") ? ' ' + label.substring(0, label.lastIndexOf(46)) + ' ' : null;
                final Button buttonItem = new Button(this.thumbsToolBar, 0x800000);
                buttonItem.setToolTipText(file.getPath());
                buttonItem.setImage(SWTImageManager.getResizedImage(this.display, this.thumbHeight, file.getPath(), label));
                buttonItem.pack();
                buttonItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Thumb thumbDialog = new Thumb(MainWindow.this.shell);
                        thumbDialog.setThumb(buttonItem.getToolTipText());
                        thumbDialog.open();
                    }
                });
                buttonItem.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent arg0) {
                        MainWindow.this.currentThumbFile = new File(buttonItem.getToolTipText());
                    }
                });
                buttonItem.setMenu(this.menu_thumb);
            }
            if (!forceRefresh && thumbInfo.isUpdated()) {
                profilesListItem.setData(thumbInfo);
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getChildren().length != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        this.doAddProfile(null);
    }

    private void doAddProfile(String filename) {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        if (filename == null || FileUtils.isBooterImage(filename) || FileUtils.isExecutable(filename) || FileUtils.isConfFile(filename)) {
            EditProfileDialog addProfileDialog = new EditProfileDialog(this.shell);
            if (filename != null) {
                addProfileDialog.sendToProfile(filename);
            }
            this.updateWithAddedProfile((Profile)addProfileDialog.open());
        } else if (FileUtils.isArchive(filename)) {
            ImportDialog importDialog = new ImportDialog(this.shell, this.dbversionsList, new File(filename));
            Boolean updateCustomFields = (Boolean)importDialog.open();
            if (updateCustomFields != null) {
                if (updateCustomFields.booleanValue()) {
                    this.rebuildProfilesTable();
                } else {
                    this.updateProfilesList(this.getSelectedProfileIds());
                }
                this.displayProfileInformation(true);
            }
        } else {
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.cannotimportunknownfile"));
        }
    }

    public void addProfile(final String file) {
        this.display.syncExec(new Runnable(){

            public void run() {
                MainWindow.this.doAddProfile(file);
            }
        });
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog addVersionDialog = new EditDosboxVersionDialog(this.shell, DosboxVersion.findDefault(this.dbversionsList) == null);
        DosboxVersion dbversion = (DosboxVersion)addVersionDialog.open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditTemplateDialog addTemplateDialog = new EditTemplateDialog(this.shell);
        Template template = (Template)addTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doAddFilter() {
        Filter filter;
        EditFilterDialog addFilterDialog = new EditFilterDialog(this.shell);
        if (this.profile_table.getSelectionCount() > 1) {
            addFilterDialog.setIds(this.getSelectedProfileIds());
        }
        if ((filter = (Filter)addFilterDialog.open()) != null) {
            this.filtersList.add(filter);
            this.addFilterTab(filter).setControl(this.profile_table.getControl());
            this.filterFolder.setSelection(this.filterFolder.getItemCount() - 1);
            this.updateProfilesAfterTabAction();
        }
    }

    private void doToggleFavoriteProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile = this.profilesList.get(index);
            try {
                this.dbase.toggleFavorite(profile.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
            profile.toggleDefault();
            this.profilesList.set(index, profile);
            this.setTableItem(this.profile_table.getItem(index), profile);
        }
    }

    private void doToggleDefaultVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            DosboxVersion ver = this.dbversionsList.get(index);
            ver.toggleDefault();
            try {
                this.dbase.addOrEditDosboxVersion(ver.getTitle(), ver.getPath(), ver.getConf(), ver.isMultiConfig(), ver.isUsingCurses(), ver.isDefault(), ver.getParameters(), ver.getVersion(), ver.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
            this.updateDosboxVersionList(ver);
        }
    }

    private void doToggleDefaultTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template temp = this.templatesList.get(index);
            temp.toggleDefault();
            try {
                this.dbase.addOrEditTemplate(temp.getTitle(), temp.getDbversionId(), temp.isDefault(), temp.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
            this.updateTemplateList(temp);
        }
    }

    private void doEditProfile() {
        this.doEditProfile(false);
    }

    private void doEditProfile(boolean focusTitle) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            if (this.profile_table.getSelectionCount() > 1) {
                ProfileLoader pLoader = new ProfileLoader(this.shell, this.getSelectedProfiles(), true);
                if (pLoader.open() != null) {
                    EditProfileDialog editMultiProfileDialog = new EditProfileDialog(this.shell);
                    editMultiProfileDialog.setConfigurables(pLoader.getResultAsConfigurables());
                    editMultiProfileDialog.setMultiProfileCombined(pLoader.getMultiProfileCombined());
                    if (editMultiProfileDialog.open() != null) {
                        this.updateProfilesList(this.getSelectedProfileIds());
                        this.displayProfileInformation(false);
                    }
                }
            } else {
                Profile profile;
                EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
                editProfileDialog.setProfile(this.profilesList.get(index));
                if (focusTitle) {
                    editProfileDialog.focusTitle();
                }
                if ((profile = (Profile)editProfileDialog.open()) != null) {
                    boolean quickUpdate = true;
                    if (this.ssettings.getBooleanValue("gui", "autosortonupdate") || this.filterFolder.getSelectionIndex() > 0) {
                        try {
                            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
                            if (index != Profile.findIndexById(this.profilesList, profile.getId())) {
                                quickUpdate = false;
                            }
                        }
                        catch (SQLException e) {
                            GeneralPurposeDialogs.warningMessage(this.shell, e);
                        }
                    }
                    if (quickUpdate) {
                        this.profilesList.set(index, profile);
                        this.setTableItem(this.profile_table.getItem(index), profile);
                    } else {
                        this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
                    }
                    this.displayProfileInformation(false);
                }
            }
        }
    }

    private void doDuplicateProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile orgProf = this.profilesList.get(index);
            this.updateWithAddedProfile(EditProfileDialog.duplicateProfile(orgProf, this.dbversionsList, this.dbase, this.shell));
        }
    }

    private void doDuplicateTemplate() {
        Template orgTemplate;
        Template newTemplate;
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && (newTemplate = EditProfileDialog.duplicateTemplate(orgTemplate = this.templatesList.get(index), this.dbversionsList, this.dbase, this.shell)) != null) {
            this.updateTemplateList(newTemplate);
        }
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.ssettings.getBooleanValue("gui", "autosortonupdate") || this.filterFolder.getSelectionIndex() > 0) {
                this.updateProfilesList(new HashSet<Integer>(Arrays.asList(profile.getId())));
            } else {
                this.profilesList.add(profile);
                this.addProfileToTable(profile);
                this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
                this.profile_table.setFocus();
            }
            this.displayProfileInformation(false);
        }
    }

    private void doEditDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            EditDosboxVersionDialog editVersionDialog = new EditDosboxVersionDialog(this.shell, false);
            editVersionDialog.setDosboxVersion(this.dbversionsList.get(index));
            DosboxVersion dbversion = (DosboxVersion)editVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void doEditFilter() {
        int index = this.filterFolder.getSelectionIndex();
        if (index > 0) {
            EditFilterDialog editFilterDialog = new EditFilterDialog(this.shell);
            editFilterDialog.setFilter(this.filtersList.get(index));
            Filter filter = (Filter)editFilterDialog.open();
            if (filter != null) {
                this.filtersList.set(index, filter);
                this.filterFolder.getSelection().setText("    " + filter.getTitle() + "    ");
                this.updateProfilesAfterTabAction();
            }
        }
    }

    private void updateProfilesList(Set<Integer> profileIds) {
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause(), this.filterClause);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        this.profile_table.setRedraw(false);
        this.profile_table.removeAll();
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        this.profile_table.setSelection(this.getIndicesByIds(profileIds));
        this.profile_table.setRedraw(true);
        this.profile_table.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        this.dbversion_table.removeAll();
        for (DosboxVersion version : this.dbversionsList) {
            this.addDosboxVersionToTable(version);
        }
        this.dbversion_table.setSelection(DosboxVersion.findIndexById(this.dbversionsList, dbversion.getId()));
        this.dbversion_table.setFocus();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e);
        }
        this.template_table.removeAll();
        for (Template temp : this.templatesList) {
            this.addTemplateToTable(temp);
        }
        this.template_table.setSelection(Template.findIndexById(this.templatesList, template.getId()));
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            EditTemplateDialog editTemplDialog = new EditTemplateDialog(this.shell);
            editTemplDialog.setTemplate(this.templatesList.get(index));
            Template template = (Template)editTemplDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            DeleteProfilesDialog dpDialog = new DeleteProfilesDialog(this.shell);
            dpDialog.setProfilesToBeDeleted(this.getSelectedProfiles(), this.dbversionsList);
            if (dpDialog.open() != null) {
                int[] idxs = this.profile_table.getSelectionIndices();
                Arrays.sort(idxs);
                for (int i = idxs.length - 1; i >= 0; --i) {
                    this.profile_table.remove(idxs[i]);
                    this.profilesList.remove(idxs[i]);
                }
                if (idxs[0] > 0) {
                    this.profile_table.setSelection(idxs[0] - 1);
                }
                this.displayProfileInformation(false);
            }
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removedosboxversion"))) {
            try {
                this.dbase.removeDosboxVersion(this.dbversionsList.get(index).getId());
                this.dbversion_table.remove(index);
                this.dbversionsList.remove(index);
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplate"))) {
            int templateId = this.templatesList.get(index).getId();
            try {
                this.dbase.startTransaction();
                this.dbase.removeNativeCommands(-1, templateId);
                this.dbase.removeTemplate(templateId);
                this.dbase.commitTransaction();
                this.template_table.remove(index);
                this.templatesList.remove(index);
                File conffile = FileUtils.constructCanonicalTemplateFileLocation(templateId);
                if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removetemplateconf", new Object[]{conffile}))) {
                    FileUtils.removeFile(conffile);
                }
            }
            catch (SQLException e) {
                try {
                    this.dbase.rollbackTransaction();
                }
                catch (SQLException se) {
                    GeneralPurposeDialogs.warningMessage(this.shell, se);
                }
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
            finally {
                this.dbase.finishTransaction();
            }
        }
    }

    private void addProfileToTable(Profile prof) {
        ProfilesList profilesList = this.profile_table;
        profilesList.getClass();
        ProfilesList.ProfilesListItem newItemTableItem = new ProfilesList.ProfilesListItem(profilesList, this.profile_table);
        this.setTableItem(newItemTableItem, prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        TableItem newItemTableItem = new TableItem(this.dbversion_table, 2048);
        this.setTableItem(newItemTableItem, dbversion);
    }

    private void addTemplateToTable(Template template) {
        TableItem newItemTableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(newItemTableItem, template);
    }

    private void setTableItem(ProfilesList.ProfilesListItem newItemTableItem, Profile prof) {
        for (int i = 0; i < this.columnIds.length; ++i) {
            String value;
            switch (this.columnIds[i]) {
                case 0: {
                    value = prof.getTitle();
                    break;
                }
                case 1: {
                    value = prof.hasSetupString();
                    break;
                }
                case 2: {
                    value = prof.getDeveloperName();
                    break;
                }
                case 3: {
                    value = prof.getPublisherName();
                    break;
                }
                case 4: {
                    value = prof.getGenre();
                    break;
                }
                case 5: {
                    value = prof.getYear();
                    break;
                }
                case 6: {
                    value = prof.getStatus();
                    break;
                }
                case 7: {
                    value = prof.isDefaultString();
                    break;
                }
                case 8: {
                    value = String.valueOf(prof.getId());
                    break;
                }
                case 9: {
                    value = String.valueOf(prof.getDbversionId());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    value = prof.getCustomString(this.columnIds[i] - 10);
                    break;
                }
                case 18: {
                    value = prof.getCustomInt(0) + " %";
                    break;
                }
                case 19: {
                    value = String.valueOf(prof.getCustomInt(1));
                    break;
                }
                case 21: {
                    value = DosboxVersion.findById(this.dbversionsList, prof.getDbversionId()).getTitle();
                    break;
                }
                default: {
                    value = "";
                }
            }
            if (this.columnIds[i] == 20) continue;
            newItemTableItem.setText(i, this.columnIds[i], value);
        }
        newItemTableItem.setData(new ThumbInfo(prof.getCaptures()));
    }

    private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getVersion());
        newItemTableItem.setText(2, dbversion.getPath());
        newItemTableItem.setText(3, dbversion.isDefaultString());
        newItemTableItem.setText(4, String.valueOf(dbversion.getId()));
    }

    private void setTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefaultString());
        newItemTableItem.setText(2, String.valueOf(template.getId()));
    }

    private void doRunProfile(int setup, boolean prepareOnly) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            if (setup == -1 || prof.hasSetup(setup)) {
                try {
                    List<NativeCommand> cmds = this.dbase.readNativeCommandsList(prof.getId(), -1);
                    FileUtils.doRunProfile(prof, this.dbversionsList, MainWindow.getEnv(this.ssettings), setup, prepareOnly, cmds, this.display);
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell, e);
                }
                catch (SQLException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell, e);
                }
            }
        }
    }

    private void doRunDosbox() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            try {
                FileUtils.doRunDosbox(this.dbversionsList.get(index), MainWindow.getEnv(this.ssettings));
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
        }
    }

    private void doRunTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template template = this.templatesList.get(index);
            try {
                List<NativeCommand> cmds = this.dbase.readNativeCommandsList(-1, template.getId());
                FileUtils.doRunTemplate(template, this.dbversionsList, MainWindow.getEnv(this.ssettings), cmds, this.display);
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
        }
    }

    private DosboxVersion checkDefaultDBVersion() {
        DosboxVersion dbv = DosboxVersion.findDefault(this.dbversionsList);
        if (dbv == null) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.required.defaultdosboxversion"));
        }
        return dbv;
    }

    private void doDFendImport() {
        DosboxVersion defaultDbversion = this.checkDefaultDBVersion();
        if (defaultDbversion == null) {
            return;
        }
        if (this.ssettings.getIntValue("profiledefaults", "confpath") == 1) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.dfendimportconflocation", new Object[]{SettingsDialog.confLocations[0]}));
        }
        DFendImportDialog importDialog = new DFendImportDialog(this.shell);
        importDialog.setDefaultDosboxVersion(defaultDbversion);
        if (importDialog.open() != null) {
            this.updateProfilesList(this.getSelectedProfileIds());
            this.displayProfileInformation(true);
        }
    }

    private void doMigrate() {
        GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.premigration"));
        String from = (String)new MigrateDialog(this.shell).open();
        if (from != null) {
            this.updateProfilesList(this.getSelectedProfileIds());
            this.displayProfileInformation(true);
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.main.notice.postmigration", new Object[]{from, FileUtils.getDosRoot()}));
        }
    }

    private void doLocateDosbox(boolean interactive) {
        SearchResult result = PlatformUtils.findDosbox();
        if (result.result == SearchResult.ResultType.NOTFOUND) {
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.locatedosbox.notice.notfound"));
            return;
        }
        if (result.result == SearchResult.ResultType.COMPLETE && !interactive) {
            try {
                int dbversionId = this.dbase.addOrEditDosboxVersion(result.dosbox.getTitle(), result.dosbox.getPath(), result.dosbox.getConf(), result.dosbox.isMultiConfig(), result.dosbox.isUsingCurses(), result.dosbox.isDefault(), result.dosbox.getParameters(), result.dosbox.getVersion(), result.dosbox.getId());
                DosboxVersion newDbversion = new DosboxVersion(dbversionId, result.dosbox.getTitle(), result.dosbox.getPath(), result.dosbox.getConf(), result.dosbox.isMultiConfig(), result.dosbox.isUsingCurses(), result.dosbox.isDefault(), result.dosbox.getParameters(), result.dosbox.getVersion());
                this.updateDosboxVersionList(newDbversion);
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
        } else {
            EditDosboxVersionDialog addVersionDialog = new EditDosboxVersionDialog(this.shell, DosboxVersion.findDefault(this.dbversionsList) == null);
            addVersionDialog.setDosboxVersion(result.dosbox);
            DosboxVersion dbversion = (DosboxVersion)addVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void displayProfileInformation(boolean forceRefresh) {
        int index = this.profile_table.getSelectionIndex();
        if (index == -1) {
            if (this.displayScreenshots.getSelection()) {
                this.displayScreenshots(null, null, forceRefresh);
            }
            if (this.displayNotes.getSelection()) {
                this.notesField.setText("");
                this.displayLinks(new String[]{null, null, null, null, null, null, null, null}, new String[]{null, null, null, null, null, null, null, null});
            }
            this.updateViewProfileSubmenu(null);
            this.setupToolItem.setEnabled(false);
        } else {
            this.ssettings.setIntValue("gui", "selectedprofile", index);
            Profile prof = this.profilesList.get(index);
            if (this.displayScreenshots.getSelection()) {
                this.displayScreenshots(prof, this.profile_table.getItem(index), forceRefresh);
            }
            if (forceRefresh) {
                this.profile_table.redraw();
            }
            if (this.displayNotes.getSelection()) {
                this.notesField.setText(prof.getNotes());
                this.displayLinks(prof.getLinks(), prof.getLinkTitles());
            }
            this.updateViewProfileSubmenu(prof);
            this.setupToolItem.setEnabled(prof.hasSetup(0));
        }
    }

    private void doRemoveThumb() {
        if (GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.main.confirm.removethumb", new Object[]{this.currentThumbFile}))) {
            FileUtils.removeFile(this.currentThumbFile);
            this.displayProfileInformation(true);
        }
        this.currentThumbFile = null;
    }

    private void doCreateShortcut() {
        int[] selectedProfiles = this.profile_table.getSelectionIndices();
        for (int i = 0; i < selectedProfiles.length; ++i) {
            try {
                PlatformUtils.createShortcut(this.profilesList.get(selectedProfiles[i]), this.dbversionsList);
                continue;
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e);
            }
        }
    }

    private void addDBColumn(String title, int colIndex) {
        final String width = "column2_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.dbversion_table, 0);
        column.setWidth(this.ssettings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.ssettings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void addTemplateColumn(String title, int colIndex) {
        final String width = "column3_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.template_table, 0);
        column.setWidth(this.ssettings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.ssettings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void doOpenSettingsDialog() {
        SettingsDialog sDialog = new SettingsDialog(this.shell);
        if (((Boolean)sDialog.open()).booleanValue()) {
            this.rebuildProfilesTable();
        }
        this.notesField.setFont(GeneralPurposeGUI.stringToFont((Device)this.display, this.notesField.getFont(), this.ssettings.getValues("gui", "notesfont")));
    }

    private void rebuildProfilesTable() {
        Set<Integer> selectedProfiles = this.getSelectedProfileIds();
        this.initColumnIds();
        this.disposeProfilesList();
        this.constructProfilesList();
        this.updateProfilesList(selectedProfiles);
    }

    private void doImportConfigfile() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{this.settings.msg("filetype.conf"), this.settings.msg("filetype.exe") + ", " + this.settings.msg("filetype.booterimage"), "*"});
        dialog.setFilterExtensions(new String[]{"*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private void doExportTemplates() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            ArrayList<ExpTemplate> expTemplateList = new ArrayList<ExpTemplate>();
            for (Template template : this.templatesList) {
                Conf conf = new Conf(template, DosboxVersion.findById(this.dbversionsList, template.getDbversionId()), ps);
                expTemplateList.add(new ExpTemplate(-1, conf, template));
            }
            DOMSource doc = new DOMSource(XmlUtils.getFullTemplatesXML(expTemplateList, this.dbversionsList, "DBGL default templates", "", "rcblanke"));
            XmlUtils.saveDomSource(doc, FileUtils.getDefaultTemplatesXmlFile(), null);
            if (bos.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.shell, bos.toString());
                bos.reset();
            }
        }
        catch (Exception e) {
            GeneralPurposeDialogs.fatalMessage(this.shell, e.toString(), e);
        }
    }

    private void doImportDefaultTemplates(boolean interactive) {
        if (!interactive || GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.importdefaulttemplates.confirm.start"))) {
            try {
                if (this.checkDefaultDBVersion() == null) {
                    return;
                }
                File defaultXml = FileUtils.getDefaultTemplatesXmlFile();
                if (!FileUtils.isExistingFile(defaultXml)) {
                    throw new IOException(this.settings.msg("general.error.openfile", new Object[]{defaultXml}));
                }
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(defaultXml);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String packageVersion = xPath.evaluate("/document/export/format-version", doc);
                String packageTitle = xPath.evaluate("/document/export/title", doc);
                String packageAuthor = xPath.evaluate("/document/export/author", doc);
                String packageNotes = xPath.evaluate("/document/export/notes", doc);
                String creationApp = xPath.evaluate("/document/export/generator-title", doc);
                String creationAppVersion = xPath.evaluate("/document/export/generator-version", doc);
                Date creationDate = XmlUtils.datetimeFormatter.parse(xPath.evaluate("/document/export/creationdatetime", doc));
                System.out.println(this.settings.msg("dialog.import.importing", new Object[]{StringUtils.join((Object[])new String[]{packageTitle, packageVersion, packageAuthor, packageNotes, creationApp, creationAppVersion, creationDate.toString()}, (char)' ')}));
                NodeList templateNodes = (NodeList)xPath.evaluate("/document/template", doc, XPathConstants.NODESET);
                ArrayList<ExpTemplate> templates = new ArrayList<ExpTemplate>();
                TreeSet<DosboxVersion> dbSet = new TreeSet<DosboxVersion>();
                for (int i = 0; i < templateNodes.getLength(); ++i) {
                    Element templateNode = (Element)templateNodes.item(i);
                    Element dosbox = XmlUtils.getNode(templateNode, "dosbox");
                    DosboxVersion d = new DosboxVersion(i, XmlUtils.getTextValue(dosbox, "title"), "", "", true, false, false, "", XmlUtils.getTextValue(dosbox, "version"));
                    dbSet.add(d);
                    templates.add(new ExpTemplate(templateNode, ImportDialog.getDosboxVersionId(d, dbSet)));
                }
                ArrayList<Integer> dbmapping = new ArrayList<Integer>();
                for (DosboxVersion dbversion : dbSet) {
                    dbmapping.add(dbversion.findBestMatchId(this.dbversionsList));
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bos);
                Template addedTemplate = null;
                for (ExpTemplate template : templates) {
                    template.setDbversionId(ImportDialog.getMappedDosboxVersionId(dbSet, dbmapping, template.getDbversionId()));
                    DosboxVersion assocDBVersion = DosboxVersion.findById(this.dbversionsList, template.getDbversionId());
                    int templateId = this.dbase.addOrEditTemplate(template.getTitle(), template.getDbversionId(), template.isDefault(), -1);
                    Conf gameConf = new Conf(template.getImportedFullConfig(), template.getImportedIncrConfig(), false, FileUtils.getDefaultTemplatesXmlFile().getPath(), templateId, assocDBVersion, ps);
                    gameConf.save();
                    addedTemplate = new Template(templateId, template.getTitle(), template.getDbversionId(), template.isDefault());
                }
                this.updateTemplateList(addedTemplate);
                if (bos.size() > 0) {
                    GeneralPurposeDialogs.warningMessage(this.shell, bos.toString());
                    bos.reset();
                } else if (interactive) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.import.notice.importok"));
                }
            }
            catch (XPathExpressionException e) {
                GeneralPurposeDialogs.fatalMessage(this.shell, this.settings.msg("dialog.importdefaulttemplates.error.defaultxmlinvalidformat", new Object[]{e.toString()}), e);
            }
            catch (SAXException e) {
                GeneralPurposeDialogs.fatalMessage(this.shell, this.settings.msg("dialog.importdefaulttemplates.error.defaultxmlinvalidformat", new Object[]{e.toString()}), e);
            }
            catch (Exception e) {
                GeneralPurposeDialogs.fatalMessage(this.shell, e.toString(), e);
            }
        }
    }

    private void initColumnIds() {
        columnNames = new String[22];
        MainWindow.columnNames[0] = this.settings.msg("dialog.main.profiles.column.title");
        MainWindow.columnNames[1] = this.settings.msg("dialog.main.profiles.column.setup");
        MainWindow.columnNames[2] = this.settings.msg("dialog.main.profiles.column.developer");
        MainWindow.columnNames[3] = this.settings.msg("dialog.main.profiles.column.publisher");
        MainWindow.columnNames[4] = this.settings.msg("dialog.main.profiles.column.genre");
        MainWindow.columnNames[5] = this.settings.msg("dialog.main.profiles.column.year");
        MainWindow.columnNames[6] = this.settings.msg("dialog.main.profiles.column.status");
        MainWindow.columnNames[7] = this.settings.msg("dialog.main.profiles.column.favorite");
        MainWindow.columnNames[8] = this.settings.msg("dialog.main.profiles.column.id");
        MainWindow.columnNames[9] = this.settings.msg("dialog.main.profiles.column.dosboxversionid");
        for (int i = 0; i < 10; ++i) {
            MainWindow.columnNames[i + 10] = this.ssettings.getValue("gui", "custom" + (i + 1));
        }
        MainWindow.columnNames[20] = this.settings.msg("dialog.main.profiles.column.screenshot");
        MainWindow.columnNames[21] = this.settings.msg("dialog.main.profiles.column.dosboxversiontitle");
        int amount = 0;
        for (int i = 0; i < columnNames.length; ++i) {
            if (!this.ssettings.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            ++amount;
        }
        int cNr = 0;
        this.columnIds = new int[amount];
        for (int i = 0; i < columnNames.length; ++i) {
            if (!this.ssettings.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            this.columnIds[cNr++] = i;
        }
    }

    private Menu createDosboxVersionsSubmenu(Menu parent, final int setup, final boolean prepareOnly) {
        final Menu dosboxVersionsSubMenu = new Menu(parent);
        for (int i = 0; i < this.dbversionsList.size(); ++i) {
            final MenuItem menuItem = new MenuItem(dosboxVersionsSubMenu, 0);
            menuItem.setText(this.dbversionsList.get(i).getTitle());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(dosboxVersionsSubMenu.indexOf(menuItem));
                        try {
                            List<NativeCommand> cmds = MainWindow.this.dbase.readNativeCommandsList(prof.getId(), -1);
                            FileUtils.doRunProfile(prof, dbversion, (Map<String, String>)MainWindow.getEnv(MainWindow.this.ssettings), setup, prepareOnly, cmds, MainWindow.this.display);
                        }
                        catch (IOException e) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, e);
                        }
                        catch (SQLException e) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, e);
                        }
                    }
                }
            });
        }
        return dosboxVersionsSubMenu;
    }

    private void updateViewProfileSubmenu(final Profile prof) {
        MenuItem parent = this.viewProfileSubMenu.getParentItem();
        this.viewProfileSubMenu.dispose();
        this.viewProfileSubMenu = new Menu(parent);
        parent.setMenu(this.viewProfileSubMenu);
        if (prof != null) {
            for (int i = 0; i < prof.getLinks().length; ++i) {
                String title;
                String link = prof.getLink(i);
                if (link.length() <= 0) continue;
                final MenuItem linkMenuItem = new MenuItem(this.viewProfileSubMenu, 0);
                String url = link;
                String tag = link;
                if (url.indexOf("://") == -1) {
                    url = "file://" + FileUtils.canonicalToData(url).getPath();
                    tag = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(tag)).getPath();
                }
                if ((title = prof.getLinkTitle(i)) != null && !"".equals(title)) {
                    tag = title;
                }
                linkMenuItem.setData((Object)url);
                linkMenuItem.setText(StringUtils.abbreviateMiddle((String)tag, (String)"....", (int)80));
                linkMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        PlatformUtils.openForBrowsing((String)linkMenuItem.getData());
                    }
                });
            }
            MenuItem linkMenuItem = new MenuItem(this.viewProfileSubMenu, 0);
            linkMenuItem.setText(this.settings.msg("dialog.main.profile.view.conf"));
            linkMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PlatformUtils.openForEditing(prof.getCanonicalConfFile());
                }
            });
        }
    }

    private void updateViewDosboxSubmenu(final DosboxVersion dbversion) {
        MenuItem parent = this.viewDosboxSubMenu.getParentItem();
        this.viewDosboxSubMenu.dispose();
        this.viewDosboxSubMenu = new Menu(parent);
        parent.setMenu(this.viewDosboxSubMenu);
        if (dbversion != null) {
            MenuItem linkMenuItem = new MenuItem(this.viewDosboxSubMenu, 0);
            linkMenuItem.setText(this.settings.msg("dialog.main.profile.view.conf"));
            linkMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PlatformUtils.openForEditing(dbversion.getCanonicalConfFile());
                }
            });
        }
    }

    private void updateViewTemplateSubmenu(final Template template) {
        MenuItem parent = this.viewTemplateSubMenu.getParentItem();
        this.viewTemplateSubMenu.dispose();
        this.viewTemplateSubMenu = new Menu(parent);
        parent.setMenu(this.viewTemplateSubMenu);
        if (template != null) {
            MenuItem linkMenuItem = new MenuItem(this.viewTemplateSubMenu, 0);
            linkMenuItem.setText(this.settings.msg("dialog.main.profile.view.conf"));
            linkMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PlatformUtils.openForEditing(FileUtils.constructCanonicalTemplateFileLocation(template.getId()));
                }
            });
        }
    }

    private void doExportProfilesList() {
        new ExportListDialog(this.shell, this.dbversionsList, this.profilesList).open();
    }

    private void createProfilesTab(TabFolder tabFolder) {
        TabItem profilesTabItem = new TabItem(tabFolder, 0);
        profilesTabItem.setText(this.settings.msg("dialog.main.profiles"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout compGL = new GridLayout(1, false);
        compGL.marginWidth = 0;
        compGL.marginHeight = 0;
        compGL.verticalSpacing = 0;
        compGL.horizontalSpacing = 0;
        composite.setLayout((Layout)compGL);
        profilesTabItem.setControl((Control)composite);
        Composite toolbarComposite = new Composite(composite, 0);
        toolbarComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 20;
        toolbarComposite.setLayout((Layout)rowLayout);
        ToolBar toolBar = new ToolBar(toolbarComposite, 256);
        final ToolBar toolBarRight = new ToolBar(toolbarComposite, 256);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addprofile"), "tb_new.png", (SelectionListener)this.addProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.editprofile"), "tb_edit.png", (SelectionListener)this.editProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removeprofile"), "tb_delete.png", (SelectionListener)this.removeProfAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runprofile"), "tb_run.png", (SelectionListener)this.runProfAdapter);
        this.setupToolItem = GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runprofilesetup"), "tb_setup.png", (SelectionListener)this.setupProfAdapter);
        GeneralPurposeGUI.createSeparatorToolItem(toolBar, 40);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addwizard"), "tb_wizard.png", (SelectionListener)this.addWizardAdapter);
        final ViewType[] views = new ViewType[]{new ViewType(ProfilesList.ProfilesListType.TABLE.toString(), "table.png", this.settings.msg("dialog.main.profiles.viewtype.table")), new ViewType(ProfilesList.ProfilesListType.SMALL_TILES.toString(), "tiles_small.png", this.settings.msg("dialog.main.profiles.viewtype.smalltiles")), new ViewType(ProfilesList.ProfilesListType.MEDIUM_TILES.toString(), "tiles_medium.png", this.settings.msg("dialog.main.profiles.viewtype.mediumtiles")), new ViewType(ProfilesList.ProfilesListType.LARGE_TILES.toString(), "tiles_large.png", this.settings.msg("dialog.main.profiles.viewtype.largetiles")), new ViewType(ProfilesList.ProfilesListType.SMALL_BOXES.toString(), "boxes_small.png", this.settings.msg("dialog.main.profiles.viewtype.smallboxes")), new ViewType(ProfilesList.ProfilesListType.MEDIUM_BOXES.toString(), "boxes_medium.png", this.settings.msg("dialog.main.profiles.viewtype.mediumboxes")), new ViewType(ProfilesList.ProfilesListType.LARGE_BOXES.toString(), "boxes_large.png", this.settings.msg("dialog.main.profiles.viewtype.largeboxes"))};
        ViewType currentViewType = this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(views[0].getName()) ? views[0] : views[1];
        this.viewSelector = new ToolItem(toolBarRight, 4);
        this.viewSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), currentViewType.getImage()));
        this.viewSelector.setToolTipText(currentViewType.getDisplayName());
        final Menu viewMenu = new Menu((Decorations)this.shell, 8);
        for (ViewType view : views) {
            MenuItem item = new MenuItem(viewMenu, 8);
            item.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), view.getImage()));
            item.setText(view.getDisplayName());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem menuItem = (MenuItem)event.widget;
                    ViewType newViewType = views[menuItem.getParent().indexOf(menuItem)];
                    if (!MainWindow.this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(newViewType.getName())) {
                        MainWindow.this.toggleProfileViewType(newViewType, MainWindow.this.selectProfAdapter, MainWindow.this.mouseAdapter, MainWindow.this.keyAdapter, MainWindow.this.travListener, MainWindow.this.addProfAdapter, MainWindow.this.editProfAdapter, MainWindow.this.removeProfAdapter, MainWindow.this.setupProfAdapter, MainWindow.this.runProfAdapter, MainWindow.this.prepareProfAdapter, MainWindow.this.duplicateProfAdapter, MainWindow.this.toggleProfAdapter, MainWindow.this.shortcutProfAdapter, MainWindow.this.openProfAdapter);
                    }
                }
            });
        }
        this.viewSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = MainWindow.this.viewSelector.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBarRight.toDisplay(pt);
                    viewMenu.setLocation(pt.x, pt.y);
                    viewMenu.setVisible(true);
                } else {
                    for (int i = 0; i < views.length; ++i) {
                        if (!MainWindow.this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(views[i].getName())) continue;
                        MainWindow.this.toggleProfileViewType(views[(i + 1) % views.length], MainWindow.this.selectProfAdapter, MainWindow.this.mouseAdapter, MainWindow.this.keyAdapter, MainWindow.this.travListener, MainWindow.this.addProfAdapter, MainWindow.this.editProfAdapter, MainWindow.this.removeProfAdapter, MainWindow.this.setupProfAdapter, MainWindow.this.runProfAdapter, MainWindow.this.prepareProfAdapter, MainWindow.this.duplicateProfAdapter, MainWindow.this.toggleProfAdapter, MainWindow.this.shortcutProfAdapter, MainWindow.this.openProfAdapter);
                        break;
                    }
                }
            }
        });
        ToolItem itemSeparator = new ToolItem(toolBarRight, 2);
        itemSeparator.setWidth(4);
        this.displayScreenshots = new ToolItem(toolBarRight, 32);
        this.displayScreenshots.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "screenshots.png"));
        this.displayScreenshots.setToolTipText(this.settings.msg("dialog.main.profiles.togglebutton.screenshots"));
        ToolItem itemSeparator2 = new ToolItem(toolBarRight, 2);
        itemSeparator2.setWidth(4);
        this.displayNotes = new ToolItem(toolBarRight, 32);
        this.displayNotes.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "notes.png"));
        this.displayNotes.setToolTipText(this.settings.msg("dialog.main.profiles.togglebutton.notes"));
        final SashForm sashForm = new SashForm(composite, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ControlAdapter sashResizeAdapter = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.ssettings.setIntValues("gui", "sashweights", sashForm.getWeights());
            }
        };
        SelectionAdapter linkAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUtils.openForBrowsing(event.text);
            }
        };
        this.filterFolder = new CTabFolder((Composite)sashForm, 2048);
        this.filterFolder.setUnselectedCloseVisible(true);
        this.filterFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.updateProfilesAfterTabAction();
            }
        });
        this.filterFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(MainWindow.this.shell, MainWindow.this.settings.msg("dialog.main.confirm.removefilter", new Object[]{((CTabItem)event.item).getText().trim()}))) {
                    boolean currentTabToBeClosed = event.item == MainWindow.this.filterFolder.getSelection();
                    try {
                        int filterId = (Integer)event.item.getData();
                        MainWindow.this.dbase.removeFilter(filterId);
                        MainWindow.this.filtersList.remove(Filter.findIndexById(MainWindow.this.filtersList, filterId));
                    }
                    catch (SQLException e) {
                        GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, e);
                    }
                    if (currentTabToBeClosed) {
                        MainWindow.this.filterFolder.setSelection(0);
                        MainWindow.this.updateProfilesAfterTabAction();
                    }
                } else {
                    event.doit = false;
                }
            }
        });
        this.filterFolder.addMouseListener((MouseListener)this.filterMouseAdapter);
        for (Filter filter : this.filtersList) {
            this.addFilterTab(filter);
        }
        this.filterFolder.setSelection(this.ssettings.getIntValue("gui", "filtertab"));
        this.filterFolder.getSelection().setToolTipText(this.settings.msg("dialog.filter.notice.results", new Object[]{this.profilesList.size()}));
        this.constructProfilesList();
        Composite informationGroup = new Composite((Composite)sashForm, 0);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        informationGroup.setLayout((Layout)gl);
        informationGroup.addControlListener((ControlListener)sashResizeAdapter);
        this.notesField = new Text(informationGroup, 2634);
        this.notesField.setLayoutData((Object)new GridData(4, 4, true, true));
        this.notesField.setFont(GeneralPurposeGUI.stringToFont((Device)this.display, this.notesField.getFont(), this.ssettings.getValues("gui", "notesfont")));
        sashForm.setWeights(this.ssettings.getIntValues("gui", "sashweights"));
        Composite linksComposite = new Composite(informationGroup, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 2;
        linksComposite.setLayout((Layout)gridLayout);
        linksComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.link = new Link[8];
        for (int i = 0; i < this.link.length; ++i) {
            this.link[i] = new Link(linksComposite, 0);
            this.link[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.link[i].addSelectionListener((SelectionListener)linkAdapter);
        }
        this.thumbHeight = this.ssettings.getIntValue("gui", "screenshotsheight");
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(this.thumbHeight + 20);
        final GridData scrolledCompositeGD = new GridData(4, 128, true, false, 1, 1);
        scrolledComposite.setLayoutData((Object)scrolledCompositeGD);
        this.thumbsToolBar = new Composite((Composite)scrolledComposite, 0);
        this.thumbsToolBar.setLayout((Layout)new RowLayout(256));
        scrolledComposite.setContent((Control)this.thumbsToolBar);
        scrolledComposite.getHorizontalBar().setPageIncrement(300);
        scrolledComposite.getHorizontalBar().setIncrement(50);
        this.displayScreenshots.setSelection(this.settings.getSettings().getBooleanValue("gui", "screenshotsvisible"));
        scrolledCompositeGD.exclude = !this.displayScreenshots.getSelection();
        this.displayScreenshots.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolItem item = (ToolItem)arg0.widget;
                scrolledCompositeGD.exclude = !item.getSelection();
                scrolledComposite.getParent().layout();
                MainWindow.this.settings.getSettings().setBooleanValue("gui", "screenshotsvisible", item.getSelection());
                MainWindow.this.displayProfileInformation(false);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.displayNotes.setSelection(this.settings.getSettings().getBooleanValue("gui", "notesvisible"));
        sashForm.setMaximizedControl((Control)(this.displayNotes.getSelection() ? null : this.filterFolder));
        this.displayNotes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolItem item = (ToolItem)arg0.widget;
                sashForm.setMaximizedControl(item.getSelection() ? null : MainWindow.this.filterFolder);
                MainWindow.this.settings.getSettings().setBooleanValue("gui", "notesvisible", item.getSelection());
                MainWindow.this.displayProfileInformation(false);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.menu_thumb = new Menu((Control)this.thumbsToolBar);
        SelectionAdapter removeThumbAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveThumb();
            }
        };
        SelectionAdapter openThumbsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUtils.openDirForViewing(MainWindow.this.currentThumbFile.getParentFile());
            }
        };
        SelectionAdapter refreshThumbsAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (ProfilesList.ProfilesListItem item : MainWindow.this.profile_table.getItems()) {
                    item.resetCachedInfo();
                }
                SWTImageManager.dispose();
                MainWindow.this.displayProfileInformation(true);
            }
        };
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.remove"), "delete.png", (SelectionListener)removeThumbAdapter);
        new MenuItem(this.menu_thumb, 2);
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.openfolder"), "folder.png", (SelectionListener)openThumbsAdapter);
        GeneralPurposeGUI.createIconMenuItem(this.menu_thumb, 0, this.settings, this.settings.msg("dialog.main.thumb.refresh"), "refresh.png", (SelectionListener)refreshThumbsAdapter);
    }

    private void toggleProfileViewType(ViewType newViewType, SelectionAdapter selectProfAdapter, MouseAdapter mouseAdapter, KeyAdapter keyAdapter, TraverseListener travListener, SelectionAdapter addProfAdapter, SelectionAdapter editProfAdapter, SelectionAdapter removeProfAdapter, SelectionAdapter setupProfAdapter, SelectionAdapter runProfAdapter, SelectionAdapter prepareProfAdapter, SelectionAdapter duplicateProfAdapter, SelectionAdapter toggleProfAdapter, SelectionAdapter shortcutProfAdapter, SelectionAdapter openProfAdapter) {
        this.viewSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), newViewType.getImage()));
        this.viewSelector.setToolTipText(newViewType.getDisplayName());
        this.settings.getSettings().setValue("gui", "viewstyle", newViewType.getName().toLowerCase());
        Set<Integer> selectedProfiles = this.getSelectedProfileIds();
        this.viewSelector.setEnabled(false);
        Display.getCurrent().timerExec(250, new Runnable(){

            public void run() {
                MainWindow.this.viewSelector.setEnabled(true);
            }
        });
        this.disposeProfilesList();
        this.constructProfilesList();
        this.updateProfilesList(selectedProfiles);
        this.filterFolder.layout(true);
    }

    private void disposeProfilesList() {
        for (CTabItem tab : this.filterFolder.getItems()) {
            tab.setControl(null);
        }
        this.profile_table.dispose();
    }

    private void constructProfilesList() {
        this.profile_table = this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.SMALL_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.SMALL_TILES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.MEDIUM_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.MEDIUM_TILES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.LARGE_TILES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.LARGE_TILES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.SMALL_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.SMALL_BOXES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.MEDIUM_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.MEDIUM_BOXES) : (this.settings.getSettings().getValue("gui", "viewstyle").equalsIgnoreCase(ProfilesList.ProfilesListType.LARGE_BOXES.toString()) ? new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.LARGE_BOXES) : new ProfilesList((Composite)this.filterFolder, ProfilesList.ProfilesListType.TABLE, this, this.columnIds, columnNames))))));
        for (CTabItem tab : this.filterFolder.getItems()) {
            tab.setControl(this.profile_table.getControl());
        }
        this.profile_table.addMouseListener(this.mouseAdapter);
        this.profile_table.addKeyListener(this.keyAdapter);
        this.profile_table.addTraverseListener(this.travListener);
        this.profile_table.addSelectionListener(this.selectProfAdapter);
        int operations = 19;
        DropTarget target = new DropTarget(this.profile_table.getControl(), operations);
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] filenames = (String[])event.data;
                if (filenames != null && filenames.length == 1) {
                    MainWindow.this.doAddProfile(filenames[0]);
                }
            }
        });
        final Menu menu = new Menu(this.profile_table.getControl());
        this.profile_table.setMenu(menu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.openfolder"), "folder.png", (SelectionListener)this.openProfAdapter);
        MenuItem viewLinkMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewProfileSubMenu = new Menu(viewLinkMenuItem);
        viewLinkMenuItem.setMenu(this.viewProfileSubMenu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.add"), "new.png", (SelectionListener)this.addProfAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.edit"), "edit.png", (SelectionListener)this.editProfAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.duplicate"), "duplicate.png", (SelectionListener)this.duplicateProfAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.remove"), "delete.png", (SelectionListener)this.removeProfAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.togglefavorite"), "favorite.png", (SelectionListener)this.toggleProfAdapter);
        if (PlatformUtils.IS_WINDOWS || PlatformUtils.IS_LINUX) {
            new MenuItem(menu, 2);
            GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.profile.createshortcut"), "shortcut.png", (SelectionListener)this.shortcutProfAdapter);
        }
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                if (MainWindow.this.profile_table.getSelectionIndex() != -1) {
                    Profile prof = (Profile)MainWindow.this.profilesList.get(MainWindow.this.profile_table.getSelectionIndex());
                    for (MenuItem it : menu.getItems()) {
                        if (it.getStyle() == 2) break;
                        it.dispose();
                    }
                    if (MainWindow.this.dbversionsList.size() > 1) {
                        MenuItem prepareWithMenuItem = GeneralPurposeGUI.createIconTopMenuItem(menu, 64, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.startmanuallywith"), null, null);
                        prepareWithMenuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, -1, true));
                    }
                    GeneralPurposeGUI.createIconTopMenuItem(menu, 0, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.startmanually"), null, (SelectionListener)MainWindow.this.prepareProfAdapter);
                    if (prof.hasSetup(2)) {
                        if (MainWindow.this.dbversionsList.size() > 1) {
                            MenuItem alt2WithMenuItem = GeneralPurposeGUI.createIconTopMenuItem(menu, 64, MainWindow.this.settings, new File(prof.getSetup(2)).getName(), null, null);
                            alt2WithMenuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, 2, false));
                        }
                        GeneralPurposeGUI.createIconTopMenuItem(menu, 0, MainWindow.this.settings, new File(prof.getSetup(2)).getName(), null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                MainWindow.this.doRunProfile(2, false);
                            }
                        });
                    }
                    if (prof.hasSetup(1)) {
                        if (MainWindow.this.dbversionsList.size() > 1) {
                            MenuItem alt1WithMenuItem = GeneralPurposeGUI.createIconTopMenuItem(menu, 64, MainWindow.this.settings, new File(prof.getSetup(1)).getName(), null, null);
                            alt1WithMenuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, 1, false));
                        }
                        GeneralPurposeGUI.createIconTopMenuItem(menu, 0, MainWindow.this.settings, new File(prof.getSetup(1)).getName(), null, (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                MainWindow.this.doRunProfile(1, false);
                            }
                        });
                    }
                    boolean hasSetup = prof.hasSetup(0);
                    MainWindow.this.setupToolItem.setEnabled(hasSetup);
                    if (hasSetup) {
                        if (MainWindow.this.dbversionsList.size() > 1) {
                            MenuItem setupWithMenuItem = GeneralPurposeGUI.createIconTopMenuItem(menu, 64, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.setupwith"), null, null);
                            setupWithMenuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, 0, false));
                        }
                        GeneralPurposeGUI.createIconTopMenuItem(menu, 0, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.setup"), "setup.png", (SelectionListener)MainWindow.this.setupProfAdapter);
                    }
                    if (MainWindow.this.dbversionsList.size() > 1) {
                        MenuItem runWithMenuItem = GeneralPurposeGUI.createIconTopMenuItem(menu, 64, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.runwith"), null, null);
                        runWithMenuItem.setMenu(MainWindow.this.createDosboxVersionsSubmenu(menu, -1, false));
                    }
                    GeneralPurposeGUI.createIconTopMenuItem(menu, 0, MainWindow.this.settings, MainWindow.this.settings.msg("dialog.main.profile.run"), "run.png", (SelectionListener)MainWindow.this.runProfAdapter);
                }
            }
        });
    }

    protected void doStartGameWizard() {
        this.updateWithAddedProfile((Profile)new AddGameWizardDialog(this.shell, 0).open());
    }

    private CTabItem addFilterTab(Filter filter) {
        CTabItem item = new CTabItem(this.filterFolder, filter.getFilter() == null ? 0 : 64);
        item.setText("    " + filter.getTitle() + "    ");
        item.setData((Object)filter.getId());
        return item;
    }

    private void createDosboxVersionsTab(TabFolder tabFolder) {
        TabItem dosboxTabItem = new TabItem(tabFolder, 0);
        dosboxTabItem.setText(this.settings.msg("dialog.main.dosboxversions"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        dosboxTabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        SelectionAdapter addDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddDosboxVersion();
            }
        };
        SelectionAdapter editDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditDosboxVersion();
            }
        };
        SelectionAdapter removeDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        };
        SelectionAdapter runDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunDosbox();
            }
        };
        SelectionAdapter toggleDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultVersion();
            }
        };
        SelectionAdapter openDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.dbversion_table.getSelectionIndex();
                if (index != -1) {
                    PlatformUtils.openDirForViewing(((DosboxVersion)MainWindow.this.dbversionsList.get(index)).getCanonicalConfFile().getParentFile());
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunDosbox();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 114) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (event.keyCode == 0x1000009 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 110) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        };
        TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == SWT.MOD1 && event.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        };
        SelectionAdapter selectDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.dbversion_table.getSelectionIndex();
                if (index != -1) {
                    MainWindow.this.updateViewDosboxSubmenu((DosboxVersion)MainWindow.this.dbversionsList.get(index));
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addversion"), "tb_new.png", (SelectionListener)addDosboxAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.editversion"), "tb_edit.png", (SelectionListener)editDosboxAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removeversion"), "tb_delete.png", (SelectionListener)removeDosboxAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runversion"), "tb_run.png", (SelectionListener)runDosboxAdapter);
        this.dbversion_table = new Table(composite, 67584);
        this.dbversion_table.setLinesVisible(true);
        this.dbversion_table.setHeaderVisible(true);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.title"), 0);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.version"), 1);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.path"), 2);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.default"), 3);
        this.addDBColumn(this.settings.msg("dialog.main.dosboxversions.column.id"), 4);
        Menu menu = new Menu((Control)this.dbversion_table);
        this.dbversion_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.run"), "run.png", (SelectionListener)runDosboxAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.openfolder"), "folder.png", (SelectionListener)openDosboxAdapter);
        MenuItem viewLinkMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewDosboxSubMenu = new Menu(viewLinkMenuItem);
        viewLinkMenuItem.setMenu(this.viewDosboxSubMenu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.add"), "new.png", (SelectionListener)addDosboxAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.edit"), "edit.png", (SelectionListener)editDosboxAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.remove"), "delete.png", (SelectionListener)removeDosboxAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.dosboxversion.toggledefault"), "home.png", (SelectionListener)toggleDosboxAdapter);
        this.dbversion_table.addKeyListener((KeyListener)keyAdapter);
        this.dbversion_table.addTraverseListener(travListener);
        this.dbversion_table.addMouseListener((MouseListener)mouseAdapter);
        this.dbversion_table.addSelectionListener((SelectionListener)selectDosboxAdapter);
    }

    private void createTemplatesTab(TabFolder tabFolder) {
        TabItem templatesTabItem = new TabItem(tabFolder, 0);
        templatesTabItem.setText(this.settings.msg("dialog.main.templates"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        templatesTabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        SelectionAdapter addTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddTemplate();
            }
        };
        SelectionAdapter editTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditTemplate();
            }
        };
        SelectionAdapter duplicateTemplateAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDuplicateTemplate();
            }
        };
        SelectionAdapter removeTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveTemplate();
            }
        };
        SelectionAdapter runTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunTemplate();
            }
        };
        SelectionAdapter toggleTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunTemplate();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 114) {
                    MainWindow.this.doRemoveTemplate();
                } else if (event.keyCode == 0x1000009 || event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 110) {
                    MainWindow.this.doAddTemplate();
                } else if (event.stateMask == SWT.MOD1 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        };
        TraverseListener travListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == SWT.MOD1 && event.detail == 4) {
                    MainWindow.this.doEditTemplate();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunTemplate();
                }
            }
        };
        SelectionAdapter selectTemplateAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.template_table.getSelectionIndex();
                if (index != -1) {
                    MainWindow.this.updateViewTemplateSubmenu((Template)MainWindow.this.templatesList.get(index));
                }
            }
        };
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.addtemplate"), "tb_new.png", (SelectionListener)addTemplAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.edittemplate"), "tb_edit.png", (SelectionListener)editTemplAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.removetemplate"), "tb_delete.png", (SelectionListener)removeTemplAdapter);
        GeneralPurposeGUI.createIconToolItem(toolBar, this.settings, this.settings.msg("dialog.main.runtemplate"), "tb_run.png", (SelectionListener)runTemplAdapter);
        this.template_table = new Table(composite, 67584);
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.title"), 0);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.default"), 1);
        this.addTemplateColumn(this.settings.msg("dialog.main.templates.column.id"), 2);
        Menu menu = new Menu((Control)this.template_table);
        this.template_table.setMenu(menu);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.run"), "run.png", (SelectionListener)runTemplAdapter);
        new MenuItem(menu, 2);
        MenuItem viewLinkMenuItem = GeneralPurposeGUI.createIconMenuItem(menu, 64, this.settings, this.settings.msg("dialog.main.profile.view"), "zoom.png", null);
        this.viewTemplateSubMenu = new Menu(viewLinkMenuItem);
        viewLinkMenuItem.setMenu(this.viewTemplateSubMenu);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.add"), "new.png", (SelectionListener)addTemplAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.edit"), "edit.png", (SelectionListener)editTemplAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.duplicate"), "duplicate.png", (SelectionListener)duplicateTemplateAdapter);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.remove"), "delete.png", (SelectionListener)removeTemplAdapter);
        new MenuItem(menu, 2);
        GeneralPurposeGUI.createIconMenuItem(menu, 0, this.settings, this.settings.msg("dialog.main.template.toggledefault"), "home.png", (SelectionListener)toggleTemplAdapter);
        this.template_table.addKeyListener((KeyListener)keyAdapter);
        this.template_table.addTraverseListener(travListener);
        this.template_table.addMouseListener((MouseListener)mouseAdapter);
        this.template_table.addSelectionListener((SelectionListener)selectTemplateAdapter);
    }

    private void doOpenAbout() {
        new AboutDialog(this.shell, 0).open();
    }

    private void createFileMenu() {
        Menu systemMenu;
        Menu appMenuBar = this.display.getMenuBar();
        if (appMenuBar == null) {
            appMenuBar = new Menu((Decorations)this.shell, 2);
            this.shell.setMenuBar(appMenuBar);
        }
        if ((systemMenu = this.display.getSystemMenu()) != null) {
            MenuItem prefs = MainWindow.getMenuItemById(systemMenu, -2);
            prefs.addSelectionListener((SelectionListener)this.settingsAdapter);
            MenuItem about = MainWindow.getMenuItemById(systemMenu, -1);
            about.addSelectionListener((SelectionListener)this.openAboutAdapter);
            int prefsIndex = systemMenu.indexOf(MainWindow.getMenuItemById(systemMenu, -2));
            MenuItem dbCleanupMenuItem = new MenuItem(systemMenu, 64, prefsIndex + 1);
            dbCleanupMenuItem.setText(this.settings.msg("dialog.main.menu.databasecleanup"));
            dbCleanupMenuItem.addSelectionListener((SelectionListener)this.cleanupAdapter);
        } else {
            MenuItem fileMenuItem = new MenuItem(appMenuBar, 64);
            fileMenuItem.setText(this.settings.msg("dialog.main.menu.file"));
            Menu fileMenu = new Menu(fileMenuItem);
            fileMenuItem.setMenu(fileMenu);
            GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.adjustsettings"), "settings.png", (SelectionListener)this.settingsAdapter);
            GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.databasecleanup"), "clean.png", (SelectionListener)this.cleanupAdapter);
            GeneralPurposeGUI.createIconMenuItem(fileMenu, 0, this.settings, this.settings.msg("dialog.main.menu.exit"), "stop.png", (SelectionListener)this.exitAdapter);
        }
        MenuItem profilesMenuItem = new MenuItem(appMenuBar, 64);
        profilesMenuItem.setText(this.settings.msg("dialog.main.menu.profiles"));
        Menu profilesMenu = new Menu(profilesMenuItem);
        profilesMenuItem.setMenu(profilesMenu);
        GeneralPurposeGUI.createIconMenuItem(profilesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.import"), "import.png", SWT.MOD1 | SWT.MOD3 | 0x49, (SelectionListener)this.importAdapter);
        GeneralPurposeGUI.createIconMenuItem(profilesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.importprofile"), "import.png", (SelectionListener)this.importConfAdapter);
        if (PlatformUtils.IS_WINDOWS) {
            GeneralPurposeGUI.createIconMenuItem(profilesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.importdfendprofiles"), "dfend.png", (SelectionListener)this.dfendAdapter);
        }
        new MenuItem(profilesMenu, 2);
        GeneralPurposeGUI.createIconMenuItem(profilesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.export"), "checkout.png", SWT.MOD1 | SWT.MOD3 | 0x45, (SelectionListener)this.exportAdapter);
        GeneralPurposeGUI.createIconMenuItem(profilesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.exportprofileslist"), "checkout.png", (SelectionListener)this.exportListAdapter);
        new MenuItem(profilesMenu, 2);
        GeneralPurposeGUI.createIconMenuItem(profilesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.migrateprofiles"), "case.png", (SelectionListener)this.migrateAdapter);
        MenuItem dbversionsMenuItem = new MenuItem(appMenuBar, 64);
        dbversionsMenuItem.setText(this.settings.msg("dialog.main.menu.dosboxversions"));
        Menu dbversionsMenu = new Menu(dbversionsMenuItem);
        dbversionsMenuItem.setMenu(dbversionsMenu);
        GeneralPurposeGUI.createIconMenuItem(dbversionsMenu, 0, this.settings, this.settings.msg("dialog.main.menu.locatedosbox"), "zoom.png", (SelectionListener)this.locateDosboxAdapter);
        MenuItem templatesMenuItem = new MenuItem(appMenuBar, 64);
        templatesMenuItem.setText(this.settings.msg("dialog.main.menu.templates"));
        Menu templatesMenu = new Menu(templatesMenuItem);
        templatesMenuItem.setMenu(templatesMenu);
        if (PlatformUtils.IS_WINDOWS && PlatformUtils.IS_LINUX) {
            GeneralPurposeGUI.createIconMenuItem(templatesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.exporttemplates"), "checkout.png", (SelectionListener)this.exportTemplatesAdapter);
        }
        GeneralPurposeGUI.createIconMenuItem(templatesMenu, 0, this.settings, this.settings.msg("dialog.main.menu.importdefaulttemplates"), "import.png", (SelectionListener)this.importDefaultTemplatesAdapter);
        MenuItem filterMenuItem = new MenuItem(appMenuBar, 64);
        filterMenuItem.setText(this.settings.msg("dialog.main.menu.filter"));
        Menu filterMenu = new Menu(filterMenuItem);
        filterMenuItem.setMenu(filterMenu);
        GeneralPurposeGUI.createIconMenuItem(filterMenu, 0, this.settings, this.settings.msg("dialog.main.menu.addfilter"), "filter.png", (SelectionListener)this.addFilterAdapter);
        GeneralPurposeGUI.createIconMenuItem(filterMenu, 0, this.settings, this.settings.msg("dialog.main.menu.editfilter"), "editfilter.png", (SelectionListener)this.editFilterAdapter);
        if (systemMenu == null) {
            MenuItem helpMenuItem = new MenuItem(appMenuBar, 64);
            helpMenuItem.setText(this.settings.msg("dialog.main.menu.help"));
            Menu helpMenu = new Menu(helpMenuItem);
            helpMenuItem.setMenu(helpMenu);
            GeneralPurposeGUI.createIconMenuItem(helpMenu, 0, this.settings, this.settings.msg("dialog.main.menu.about"), "about.png", (SelectionListener)this.openAboutAdapter);
        }
    }

    private static MenuItem getMenuItemById(Menu menu, int id) {
        for (MenuItem item : menu.getItems()) {
            if (item.getID() != id) continue;
            return item;
        }
        return null;
    }

    private void doExportProfiles() {
        ProfileLoader pLoader;
        if (this.profile_table.getSelectionIndex() != -1 && (pLoader = new ProfileLoader(this.shell, this.getSelectedProfiles(), false)).open() != null) {
            new ExportDialog(this.shell, this.dbversionsList, pLoader.getResult()).open();
        }
    }

    private void doImportProfiles() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"GamePack Archives", "DOSBox configuration files", "Executables, Booter Disk Images", "*"});
        dialog.setFilterExtensions(new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private static Map<String, String> getEnv(SectionsWrapper settings) {
        if (settings.getBooleanValue("environment", "use")) {
            return StringRelatedUtils.stringArrayToMap(settings.getValues("environment", "value"));
        }
        return null;
    }

    private void updateProfilesAfterTabAction() {
        int tabIndex = this.filterFolder.getSelectionIndex();
        this.ssettings.setValue("gui", "filtertab", String.valueOf(tabIndex));
        this.filterClause = this.filtersList.get(tabIndex).getFilter();
        this.updateProfilesList(this.getSelectedProfileIds());
        for (CTabItem tab : this.filterFolder.getItems()) {
            tab.setToolTipText(null);
        }
        this.filterFolder.getSelection().setToolTipText(this.settings.msg("dialog.filter.notice.results", new Object[]{this.profilesList.size()}));
        this.displayProfileInformation(false);
    }

    private void doViewProfileConf() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            PlatformUtils.openForEditing(this.profilesList.get(index).getCanonicalConfFile());
        }
    }

    private Set<Integer> getSelectedProfileIds() {
        int[] selection = this.profile_table.getSelectionIndices();
        HashSet<Integer> profileIds = new HashSet<Integer>();
        for (int i : selection) {
            profileIds.add(this.profilesList.get(i).getId());
        }
        return profileIds;
    }

    private List<Profile> getSelectedProfiles() {
        int[] selection = this.profile_table.getSelectionIndices();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (int i : selection) {
            profiles.add(this.profilesList.get(i));
        }
        return profiles;
    }

    private int[] getIndicesByIds(Set<Integer> profileIds) {
        ArrayList<Integer> tableIdxsList = new ArrayList<Integer>();
        for (int i = 0; i < this.profilesList.size(); ++i) {
            if (!profileIds.contains(this.profilesList.get(i).getId())) continue;
            tableIdxsList.add(i);
        }
        int[] tableIdxsArray = new int[tableIdxsList.size()];
        for (int i = 0; i < tableIdxsList.size(); ++i) {
            tableIdxsArray[i] = (Integer)tableIdxsList.get(i);
        }
        return tableIdxsArray;
    }

    public static void openSendToProfileDialog(String file) {
        Database dbase = Database.getInstance();
        Shell shell = new Shell();
        shell.setMinimized(true);
        shell.open();
        try {
            List<DosboxVersion> dbversionsList = dbase.readDosboxVersionsList();
            if (DosboxVersion.findDefault(dbversionsList) == null) {
                GeneralPurposeDialogs.infoMessage(shell, Settings.getInstance().msg("dialog.main.required.defaultdosboxversion"));
                try {
                    dbase.shutdown();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                return;
            }
            if (FileUtils.isGamePackArchiveFile(file)) {
                ImportDialog importDialog = new ImportDialog(shell, dbversionsList, new File(file));
                importDialog.open();
            } else {
                EditProfileDialog editProfDialog = new EditProfileDialog(shell);
                editProfDialog.sendToProfile(file);
                editProfDialog.open();
            }
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(shell, e);
        }
        try {
            dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(MainWindow.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PROGRAM_VERSION = prop.getProperty("majorversion", "?") + '.' + prop.getProperty("minorversion", "?");
        ICOS_DBGL = new String[]{"ico/016.png", "ico/024.png", "ico/032.png", "ico/048.png", "ico/064.png", "ico/128.png", "ico/256.png"};
    }
}

