/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class DFendReloadedImportThread
extends UIThread {
    private static final int[] CUST_INTS = new int[]{0, 0};
    private static final int[] CUST_IDS = new int[]{0, 0, 0, 0};
    private final boolean performCleanup;
    private final DosboxVersion defaultDBVersion;
    private File dfendPath;
    private File profsPath;
    private File confsPath;

    public DFendReloadedImportThread(Text log, ProgressBar progressBar, Label status, File dfendPath, File confsPath, boolean performCleanup, DosboxVersion defaultDBVersion) throws IOException, SQLException {
        super(log, progressBar, status);
        this.performCleanup = performCleanup;
        this.defaultDBVersion = defaultDBVersion;
        this.dfendPath = dfendPath;
        this.profsPath = new File(this.dfendPath, "Confs");
        File settingsPath = new File(this.dfendPath, "Settings");
        File settingsFile = new File(settingsPath, "DFend.ini");
        Conf dfendSettings = new Conf(settingsFile, this.ps);
        String defLoc = dfendSettings.getSettings().getValue("ProgramSets", "defloc");
        if (StringUtils.isNotBlank((CharSequence)defLoc)) {
            this.dfendPath = new File(defLoc);
        }
        this.confsPath = confsPath;
        this.objects = new ArrayList<File>(org.apache.commons.io.FileUtils.listFiles(this.profsPath, new String[]{"prof"}, false));
        progressBar.setMaximum(this.objects.size());
    }

    public void doFancyStuff(Object obj, StringBuffer messageLog) throws IOException, SQLException {
        File profFile = (File)obj;
        Conf dfendExtra = new Conf(profFile, this.ps);
        String title = dfendExtra.getSettings().getValue("ExtraInfo", "name");
        this.displayTitle(this.settings.msg("dialog.dfendimport.importing", new Object[]{title}));
        boolean favorite = dfendExtra.getSettings().getValue("ExtraInfo", "favorite").equals("1");
        String setup = dfendExtra.getSettings().getValue("Extra", "setup");
        if (StringUtils.isNotEmpty((CharSequence)setup)) {
            setup = FileUtils.canonical(new File(this.dfendPath, dfendExtra.getSettings().getValue("Extra", "setup")).getPath()).getPath();
        }
        String setupParams = dfendExtra.getSettings().getValue("Extra", "setupparameters");
        String notes = this.fixCRLF(dfendExtra.getSettings().getValue("ExtraInfo", "notes"));
        String dev = dfendExtra.getSettings().getValue("ExtraInfo", "developer");
        String pub = dfendExtra.getSettings().getValue("ExtraInfo", "publisher");
        String gen = dfendExtra.getSettings().getValue("ExtraInfo", "genre");
        String year = dfendExtra.getSettings().getValue("ExtraInfo", "year");
        String language = dfendExtra.getSettings().getValue("ExtraInfo", "language");
        String userInfo = dfendExtra.getSettings().getValue("ExtraInfo", "userinfo");
        if (StringUtils.isNotEmpty((CharSequence)userInfo)) {
            userInfo = StringUtils.join((Object[])StringUtils.split((String)this.fixCRLF(userInfo), (String)"\n"), (String)", ");
        }
        String status = this.settings.msg("dialog.dfendimport.defaultprofilestatus");
        int devId = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), dev);
        int publId = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), pub);
        int genId = KeyValuePair.findIdByValue(this.dbase.readGenresList(), gen);
        int yrId = KeyValuePair.findIdByValue(this.dbase.readYearsList(), year);
        int statId = KeyValuePair.findIdByValue(this.dbase.readStatusList(), status);
        String[] customStrings = new String[]{language, "", "", "", userInfo, "", "", ""};
        int[] custIDs = CUST_IDS;
        for (int i = 0; i < 4; ++i) {
            custIDs[i] = KeyValuePair.findIdByValue(this.dbase.readCustomList(i), customStrings[i]);
        }
        String[] links = new String[]{this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www2")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www3")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www4")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www5")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www6")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www7")), this.fixWWW(dfendExtra.getSettings().getValue("ExtraInfo", "www8"))};
        String[] linkTitles = new String[]{dfendExtra.getSettings().getValue("ExtraInfo", "wwwname"), dfendExtra.getSettings().getValue("ExtraInfo", "www2name"), dfendExtra.getSettings().getValue("ExtraInfo", "www3name"), dfendExtra.getSettings().getValue("ExtraInfo", "www4name"), dfendExtra.getSettings().getValue("ExtraInfo", "www5name"), dfendExtra.getSettings().getValue("ExtraInfo", "www6name"), dfendExtra.getSettings().getValue("ExtraInfo", "www7name"), dfendExtra.getSettings().getValue("ExtraInfo", "www8name")};
        int profileId = this.dbase.addOrEditProfile(title, dev, pub, gen, year, status, notes, favorite, new String[]{setup, "", ""}, new String[]{setupParams, "", ""}, devId, publId, genId, yrId, statId, this.defaultDBVersion.getId(), links, linkTitles, customStrings, CUST_INTS, custIDs, -1);
        Conf dfendProfile = new Conf(new File(this.confsPath, FilenameUtils.removeExtension(profFile.getName()) + ".conf"), title, profileId, this.defaultDBVersion, this.ps);
        String cap = dfendProfile.getSettings().getValue("dosbox", "captures");
        String dstCap = FileUtils.constructCapturesDir(profileId);
        String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
        File dstCapAbsolute = FileUtils.canonicalToData(dstCap);
        FileUtils.createDir(dstCapAbsolute);
        FileUtils.copyFiles(new File(cap), dstCapAbsolute);
        dfendProfile.getSettings().setValue("dosbox", "captures", dstCapRelative);
        if (this.performCleanup) {
            dfendProfile.getSettings().removeSection("joystick");
            dfendProfile.getSettings().removeSection("sdl");
        }
        dfendProfile.alterToDosboxVersionGeneration(dfendProfile);
        dfendProfile.save();
        this.dbase.updateProfileConf(FileUtils.makeRelativeToData(dfendProfile.getConfFile()).getPath(), dstCap, profileId);
        if (dfendProfile.getAutoexec().isIncomplete()) {
            this.ps.println(this.settings.msg("dialog.multiprofile.error.profileincomplete"));
        }
    }

    private String fixCRLF(String s) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)"[13][10]", (String)"\n"), (String)"[13]", (String)"").trim();
    }

    private String fixWWW(String s) {
        if (StringUtils.isNotEmpty((CharSequence)s) && !s.toLowerCase().startsWith("http://") && !s.toLowerCase().startsWith("https://")) {
            return "http://" + s;
        }
        return s;
    }

    public String getTitle(Object o) {
        return ((File)o).getName();
    }

    public void preFinish() {
    }
}

