/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.StreamGobbler;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.waldheinz.fs.fat.FatFileSystem;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectory;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectoryEntry;
import org.dbgl.waldheinz.fs.util.FileDisk;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int ZIP_BUFFER = 10240;
    private static final File DATA_DIR_FILE;
    private static final File DOSROOT_DIR_FILE;
    private static final File DOSBOX_DIR_FILE;
    private static final File TMPINST_DIR_FILE;
    private static final String TEMPLATES_DIR;
    private static final String SETUP_CONF = "setup.conf";
    private static final String TEMPLATE_CONF = "template.conf";
    public static final String PROFILES_XML = "profiles.xml";
    public static final String DOSROOT_DIR;
    public static final String CAPTURES_DIR;
    public static final String MAPPER_DIR;
    public static final String PROFILES_DIR;
    public static final String EXPORT_DIR;
    public static final String XSL_DIR;
    public static final String XSL_EXT = ".xsl";
    public static final String XML_EXT = ".xml";
    public static final String CONF_EXT = ".conf";
    public static final String MAPPER_EXT = ".map";
    public static final String GAMEPACKARCHIVE_EXT = ".dbgl.zip";
    public static final String[] CDIMAGES;
    public static final String[] EXECUTABLES;
    public static final String[] EXECUTABLES_UPPERCASE;
    public static final String[] ARCHIVES;
    static final String[] FATIMAGES;
    static final String[] BOOTERIMAGES;
    static final String[] PICTURES;
    static final String[] SETUPFILES;
    static final String[] UNLIKELYMAINFILES;
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String CNF_FILTER = "*.conf;*.CONF";
    public static final String EXE_FILTER = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
    public static final String ARC_FILTER = "*.zip;*.ZIP;*.7z;*.7Z";
    public static final String DBGLZIP_FILTER = "*.dbgl.zip;*.DBGL.ZIP";
    public static final String BTR_FILTER = "*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0";
    public static final String CDI_FILTER = "*.iso;*.ISO;*.cue;*.CUE";
    public static final String FATI_FILTER = "*.ima;*.IMA;";
    public static final String ALL_FILTER = "*";
    public static final String INVALID_FILENAME_CHARS_REGEXP = "[^a-zA-Z_0-9()]";

    public static String replaceTildeInPath(String path) {
        if ((PlatformUtils.IS_LINUX || PlatformUtils.IS_OSX) && (path.startsWith("~/") || path.length() == 1 && path.charAt(0) == '~')) {
            return path.replaceAll("^~", System.getProperty("user.home"));
        }
        return path;
    }

    private static void copyDirectoriesIfNecessary(String data) {
        FileUtils.copyDirIfNecessary(data, CAPTURES_DIR);
        File databaseFile = FileUtils.getDatabaseFile(Settings.getInstance().getSettings().getValue("database", "connectionstring"));
        if (databaseFile != null) {
            FileUtils.copyDirIfNecessary(data, databaseFile.getParent());
        }
        FileUtils.copyDirIfNecessary(data, DOSROOT_DIR);
        FileUtils.copyDirIfNecessary(data, EXPORT_DIR);
        FileUtils.copyDirIfNecessary(data, PROFILES_DIR);
        FileUtils.copyDirIfNecessary(data, TEMPLATES_DIR);
        FileUtils.copyDirIfNecessary(data, XSL_DIR);
    }

    private static void copyDirIfNecessary(String data, String dir) {
        File src = new File(data, dir);
        try {
            if (!FileUtils.isExistingDirectory(FileUtils.canonicalToData(dir)) && FileUtils.isExistingDirectory(src)) {
                org.apache.commons.io.FileUtils.copyDirectoryToDirectory(src, DATA_DIR_FILE);
            }
        }
        catch (IOException e) {
            System.err.println(Settings.getInstance().msg("general.error.copydirtodir", new String[]{src.getPath(), DATA_DIR_FILE.getPath()}));
        }
    }

    public static File getDatabaseFile(String connString) {
        if (connString.contains("file:")) {
            int start = connString.indexOf("file:") + 5;
            int end = connString.indexOf(59, start);
            if (end == -1) {
                end = connString.length();
            }
            String filename = FileUtils.replaceTildeInPath(connString.substring(start, end));
            return FileUtils.canonicalToData(filename);
        }
        return null;
    }

    public static boolean isExistingFile(File file) {
        return file.isFile() && file.exists();
    }

    public static boolean isExistingDirectory(File dir) {
        return dir.isDirectory() && dir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copy(File source, File dest) {
        block22: {
            AbstractInterruptibleChannel outStream;
            FileChannel inStream;
            block20: {
                inStream = null;
                outStream = null;
                inStream = new FileInputStream(source).getChannel();
                outStream = new FileOutputStream(dest).getChannel();
                inStream.transferTo(0L, inStream.size(), (WritableByteChannel)((Object)outStream));
                if (inStream == null) break block20;
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException ex) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                }
            }
            break block22;
            catch (IOException e) {
                block21: {
                    try {
                        System.err.println(Settings.getInstance().msg("general.error.copyfile", new Object[]{source, dest}));
                        if (inStream == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ex) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                            }
                        }
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (IOException ex) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                    }
                }
            }
        }
    }

    private static List<String> initCommands(DosboxVersion dbversion, boolean forceDBConf) {
        ArrayList<String> execCommands = new ArrayList<String>();
        if (dbversion.isUsingCurses() && PlatformUtils.IS_WINDOWS) {
            execCommands.add("rundll32");
            execCommands.add("SHELL32.DLL,ShellExec_RunDLL");
        }
        execCommands.add(dbversion.getCanonicalExecutable().getPath());
        if (dbversion.isMultiConfig() && FileUtils.isReadableFile(dbversion.getCanonicalConfFile()) || forceDBConf) {
            execCommands.add("-conf");
            execCommands.add(dbversion.getCanonicalConfFile().getPath());
        }
        return execCommands;
    }

    private static void postCommands(DosboxVersion dbversion, List<String> execCommands) {
        if (dbversion.getParameters().length() > 0) {
            for (String p : dbversion.getParameters().split(" ")) {
                execCommands.add(p);
            }
        }
        if (Settings.getInstance().getSettings().getBooleanValue("dosbox", "hideconsole")) {
            execCommands.add("-noconsole");
        }
    }

    private static void executeCommand(List<String> execCommands, File cwd, Map<String, String> env, boolean waitFor) throws IOException {
        StringBuffer cmd = new StringBuffer();
        try {
            String[] rtCmds = new String[execCommands.size()];
            for (int i = 0; i < execCommands.size(); ++i) {
                rtCmds[i] = execCommands.get(i);
                cmd.append(rtCmds[i]).append(' ');
            }
            System.out.print(cmd);
            File dir = cwd == null ? DOSROOT_DIR_FILE : cwd;
            ProcessBuilder pb = new ProcessBuilder(rtCmds);
            pb.directory(dir);
            Map<String, String> environment = pb.environment();
            if (env != null) {
                environment.putAll(env);
                System.out.print(env);
            }
            System.out.println();
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
            outputGobbler.start();
            errorGobbler.start();
            if (waitFor) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(Settings.getInstance().msg("general.error.startdosbox", new Object[]{cmd}));
        }
    }

    private static void doRunDosbox(DosboxVersion dbversion, String[] parameters, boolean forceDBConf, File cwd, Map<String, String> env, boolean waitFor) throws IOException {
        List<String> commandItems = FileUtils.initCommands(dbversion, forceDBConf);
        commandItems.addAll(Arrays.asList(parameters));
        FileUtils.postCommands(dbversion, commandItems);
        FileUtils.executeCommand(commandItems, cwd, env, waitFor);
    }

    private static File canonicalTo(File base, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                return file.getAbsoluteFile();
            }
        }
        try {
            return new File(base, file.getPath()).getCanonicalFile();
        }
        catch (IOException e) {
            return new File(base, file.getPath()).getAbsoluteFile();
        }
    }

    public static boolean areRelated(File parent, File child) {
        for (File remainder = child.getParentFile(); remainder != null; remainder = remainder.getParentFile()) {
            if (!parent.equals(remainder)) continue;
            return true;
        }
        return false;
    }

    public static String getDosRoot() {
        return DOSROOT_DIR_FILE.getPath();
    }

    public static File makeRelativeTo(File file, File basePath) {
        if (!file.isAbsolute()) {
            return file;
        }
        if (file.equals(basePath)) {
            return new File(".");
        }
        File remainder = new File(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(basePath)) {
                return remainder;
            }
            remainder = new File(parent.getName(), remainder.getPath());
        }
        return file;
    }

    public static File makeRelativeToData(File file) {
        return FileUtils.makeRelativeTo(file, DATA_DIR_FILE);
    }

    public static File makeRelativeToDosroot(File file) {
        return FileUtils.makeRelativeTo(file, DOSROOT_DIR_FILE);
    }

    public static File makeRelativeToDosbox(File file) {
        return FileUtils.makeRelativeTo(file, DOSBOX_DIR_FILE);
    }

    public static File canonical(String path) {
        return FileUtils.canonicalTo(new File("."), path);
    }

    public static File canonicalToData(String path) {
        return FileUtils.canonicalTo(DATA_DIR_FILE, path);
    }

    public static File canonicalToDosbox(String path) {
        return FileUtils.canonicalTo(DOSBOX_DIR_FILE, path);
    }

    public static File canonicalToDosroot(String path) {
        return FileUtils.canonicalTo(DOSROOT_DIR_FILE, path);
    }

    public static String sanitizeToDosroot(String path) {
        return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(path)).getPath();
    }

    public static File prefixAndSanitizeToDosroot(File basePath, File file) {
        if (!file.isAbsolute()) {
            return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(new File(basePath, file.getPath()).getPath()));
        }
        return file;
    }

    public static File constructRelativeDBConfLocation(String path) {
        return FileUtils.makeRelativeToDosbox(new File(path, DOSBOX_CONF));
    }

    public static File constructCanonicalDBExeLocation(String path) {
        return FileUtils.canonicalToDosbox(new File(path, PlatformUtils.DB_EXECUTABLE).getPath());
    }

    public static String constructCapturesDir(int profileId) {
        return CAPTURES_DIR + profileId;
    }

    public static String constructMapperFile(int profileId) {
        return MAPPER_DIR + profileId + MAPPER_EXT;
    }

    public static String constructRelativeCapturesDir(int profileId) {
        return ".." + File.separatorChar + FileUtils.constructCapturesDir(profileId);
    }

    public static File constructCanonicalTemplateFileLocation(int templateId) {
        return FileUtils.canonicalToData(TEMPLATES_DIR + templateId + CONF_EXT);
    }

    public static File getDefaultTemplatesXmlFile() {
        return FileUtils.canonicalToData(TEMPLATES_DIR + "default.xml");
    }

    public static String constructUniqueConfigFileString(int profileId, String profileTitle, File canonicalMainDir) {
        SectionsWrapper set = Settings.getInstance().getSettings();
        File path = set.getIntValue("profiledefaults", "confpath") == 0 ? new File(PROFILES_DIR) : canonicalMainDir;
        String prefix = set.getIntValue("profiledefaults", "conffile") == 0 ? String.valueOf(profileId) : profileTitle;
        File candidate = null;
        int nr = 1;
        do {
            candidate = new File(path, FileUtils.fileSystemSafe(prefix + (nr > 1 ? "(" + nr + ")" : "")) + CONF_EXT);
            ++nr;
        } while (FileUtils.isExistingFile(FileUtils.canonicalToData(candidate.getPath())));
        return candidate.getPath();
    }

    public static void doRunDosbox(DosboxVersion dbversion, Map<String, String> env) throws IOException {
        FileUtils.doRunDosbox(dbversion, new String[0], true, null, env, false);
    }

    public static void doCreateDosboxConf(DosboxVersion dbversion) throws IOException {
        FileUtils.doRunDosbox(dbversion, new String[]{"-c", "config -writeconf '" + dbversion.getCanonicalConfFile() + "'", "-c", "exit"}, false, dbversion.getCanonicalExecutable().getParentFile(), null, true);
    }

    public static void doRunProfile(Profile prof, List<DosboxVersion> dbversions, Map<String, String> env, int setup, boolean prepareOnly, List<NativeCommand> cmds, Display display) throws IOException {
        DosboxVersion dbv = DosboxVersion.findById(dbversions, prof.getDbversionId());
        FileUtils.doRunProfile(prof, dbv, env, setup, prepareOnly, cmds, display);
    }

    public static void doRunTemplate(Template template, List<DosboxVersion> dbversions, Map<String, String> env, List<NativeCommand> cmds, Display display) throws IOException {
        DosboxVersion dbv = DosboxVersion.findById(dbversions, template.getDbversionId());
        FileUtils.doRunTemplate(template, dbv, env, cmds, display);
    }

    public static void doRunProfile(Profile prof, final DosboxVersion dbversion, final Map<String, String> env, int setup, boolean prepareOnly, final List<NativeCommand> cmds, final Display display) throws IOException {
        File file;
        boolean runSetup;
        boolean bl = runSetup = setup != -1 && prof.hasSetup(setup);
        if (runSetup || prepareOnly) {
            file = FileUtils.canonicalToData(PROFILES_DIR + SETUP_CONF);
            Conf conf = prepareOnly ? new Conf(prof, null, null, file, dbversion, System.err) : new Conf(prof, prof.getSetup(setup), prof.getSetupParameters(setup), file, dbversion, System.err);
            conf.save(prepareOnly);
        } else {
            file = prof.getCanonicalConfFile();
        }
        new Thread(){

            public void run() {
                block4: {
                    try {
                        for (NativeCommand cmd : cmds) {
                            if (cmd.getCommand() == null) {
                                FileUtils.doRunDosbox(dbversion, new String[]{"-conf", file.getPath()}, false, null, env, true);
                                continue;
                            }
                            FileUtils.executeCommand(cmd.getExecCommandsCanToData(), cmd.getCwdCanToData(), env, cmd.isWaitFor());
                        }
                    }
                    catch (IOException e) {
                        if (display.isDisposed()) break block4;
                        display.syncExec(new Runnable(){

                            public void run() {
                                GeneralPurposeDialogs.warningMessage(display.getActiveShell(), e);
                            }
                        });
                    }
                }
            }
        }.start();
    }

    public static void doRunInstaller(Profile prof, Conf conf, List<DosboxVersion> dbversions, Map<String, String> env, boolean prepareOnly) throws IOException {
        DosboxVersion dbv = DosboxVersion.findById(dbversions, prof.getDbversionId());
        File file = FileUtils.canonicalToData(PROFILES_DIR + SETUP_CONF);
        Conf tmpConf = new Conf(conf, file);
        tmpConf.save(prepareOnly);
        FileUtils.doRunDosbox(dbv, new String[]{"-conf", file.getPath()}, false, null, env, true);
    }

    public static void doRunTemplate(Template template, final DosboxVersion dbversion, final Map<String, String> env, final List<NativeCommand> cmds, final Display display) throws IOException {
        final File file = FileUtils.canonicalToData(PROFILES_DIR + TEMPLATE_CONF);
        Conf conf = new Conf(template, file, dbversion, System.err);
        conf.save();
        new Thread(){

            public void run() {
                block4: {
                    try {
                        for (NativeCommand cmd : cmds) {
                            if (cmd.getCommand() == null) {
                                FileUtils.doRunDosbox(dbversion, new String[]{"-conf", file.getPath()}, false, null, env, true);
                                continue;
                            }
                            FileUtils.executeCommand(cmd.getExecCommandsCanToData(), cmd.getCwdCanToData(), env, cmd.isWaitFor());
                        }
                    }
                    catch (IOException e) {
                        if (display.isDisposed()) break block4;
                        display.syncExec(new Runnable(){

                            public void run() {
                                GeneralPurposeDialogs.warningMessage(display.getActiveShell(), e);
                            }
                        });
                    }
                }
            }
        }.start();
    }

    public static void createDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{dir}));
        }
    }

    public static void copyFiles(File srcDir, File dstDir) {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            for (File src : srcFiles) {
                if (!src.isFile()) continue;
                File dst = new File(dstDir, src.getName());
                FileUtils.copy(src, dst);
                FileUtils.fileSetLastModified(dst, src.lastModified());
            }
        }
    }

    public static void fileSetLastModified(File file, long time) {
        if (!file.setLastModified(time)) {
            System.err.println(Settings.getInstance().msg("general.error.setlastmodifiedfile", new Object[]{file.getPath()}));
        }
    }

    public static void fileSetReadOnly(File file) {
        if (!file.setReadOnly()) {
            System.err.println(Settings.getInstance().msg("general.error.setreadonlyfile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFile(File file) {
        if (!file.isFile() || !file.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFilesInDirAndDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                System.err.println(Settings.getInstance().msg("general.error.dirtobedeletedcontainsdir", new Object[]{dir.getPath()}));
                return;
            }
            for (File file : files) {
                if (file.delete()) continue;
                System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file}));
            }
        }
        if (!dir.isDirectory() || !dir.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletedir", new Object[]{dir.getPath()}));
        }
    }

    public static boolean isReadableFile(File file) {
        return file.isFile() && file.canRead();
    }

    public static void createDirIfNecessary(File dir) {
        if (!dir.isDirectory()) {
            System.out.println(Settings.getInstance().msg("general.notice.createdir", new Object[]{dir.getPath()}));
            if (!dir.mkdirs()) {
                System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{dir.getPath()}));
            }
        }
    }

    public static boolean isExecutable(String filename) {
        for (String ext : EXECUTABLES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchive(String filename) {
        for (String ext : ARCHIVES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhysFS(String mountPath) {
        for (String ext : ARCHIVES) {
            if (!mountPath.toLowerCase().endsWith(ext + ':' + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    public static int containsPhysFS(String mountPath) {
        for (String ext : ARCHIVES) {
            int idx = mountPath.toLowerCase().indexOf(ext + ':' + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isFatImage(String filename) {
        for (String ext : FATIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static int containsFatImage(String mountPath) {
        for (String ext : FATIMAGES) {
            int idx = mountPath.toLowerCase().indexOf(ext + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isBooterImage(String filename) {
        for (String ext : BOOTERIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfFile(String filename) {
        return filename.toLowerCase().endsWith(CONF_EXT);
    }

    public static boolean isGamePackArchiveFile(String filename) {
        return filename.toLowerCase().endsWith(GAMEPACKARCHIVE_EXT);
    }

    public static boolean isIsoFile(String filename) {
        for (String ext : CDIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static int containsIso(String mountPath) {
        for (String ext : CDIMAGES) {
            int idx = mountPath.toLowerCase().indexOf(ext + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isPicture(String filename) {
        for (String ext : PICTURES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static int findSetupIndex(List<File> files) {
        for (String setupFileName : SETUPFILES) {
            for (int i = 0; i < files.size(); ++i) {
                if (!files.get(i).getName().toLowerCase().equals(setupFileName)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findMostLikelyMainIndex(String title, List<File> files) {
        ArrayList<File> mostLikelyFiles = new ArrayList<File>();
        for (File f : files) {
            if (Arrays.asList(SETUPFILES).contains(f.getName().toLowerCase()) || Arrays.asList(UNLIKELYMAINFILES).contains(f.getName().toLowerCase())) continue;
            mostLikelyFiles.add(f);
        }
        if (mostLikelyFiles.isEmpty()) {
            return StringRelatedUtils.findBestMatchIndex(title, FileUtils.getNames(files.toArray(new File[0])));
        }
        return files.indexOf(mostLikelyFiles.get(StringRelatedUtils.findBestMatchIndex(title, FileUtils.getNames(mostLikelyFiles.toArray(new File[0])))));
    }

    public static File getCanMainFile(File file) {
        String f = file.getPath();
        int isoIdx = FileUtils.containsIso(f);
        int pfsIdx = FileUtils.containsPhysFS(f);
        int fatIdx = FileUtils.containsFatImage(f);
        if (isoIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, isoIdx));
        }
        if (pfsIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, pfsIdx));
        }
        if (fatIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, fatIdx));
        }
        return FileUtils.canonicalToDosroot(file.getPath());
    }

    public static List<File> getExecutablesInDirRecursive(File dir) {
        ArrayList<File> executables = new ArrayList<File>(org.apache.commons.io.FileUtils.listFiles(dir, EXECUTABLES_UPPERCASE, true));
        Collections.sort(executables, new FileComparator());
        return executables;
    }

    public static String[] getExecutablesInZipOrIsoOrFat(String archive) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File arcFile = new File(archive);
        if (archive.toLowerCase().endsWith(ARCHIVES[0])) {
            ZipFile zfile = new ZipFile(arcFile);
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            zfile.close();
        } else if (archive.toLowerCase().endsWith(ARCHIVES[1])) {
            Handler zArchive = new Handler();
            MyRandomAccessFile istream = new MyRandomAccessFile(archive, "r");
            if (zArchive.Open(istream) != 0) {
                throw new IOException(Settings.getInstance().msg("general.error.opensevenzip", new Object[]{archive}));
            }
            for (int i = 0; i < zArchive.size(); ++i) {
                SevenZipEntry entry = zArchive.getEntry(i);
                String name = entry.getName();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            zArchive.close();
        } else if (FileUtils.isIsoFile(archive)) {
            ISO9660FileSystem iso = new ISO9660FileSystem(new File(archive));
            Enumeration<ISO9660FileEntry> entries = iso.getEntries();
            while (entries.hasMoreElements()) {
                ISO9660FileEntry entry = entries.nextElement();
                String name = entry.getPath();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            iso.close();
        } else if (FileUtils.isFatImage(archive)) {
            FileDisk device = new FileDisk(new File(archive));
            result.addAll(FileUtils.readFatEntries(new FatFileSystem(device).getRoot(), ""));
            device.close();
        }
        Collections.sort(result, new FilenameComparator());
        return result.toArray(new String[result.size()]);
    }

    private static String fsDirectoryEntryNameToFileName(String name) {
        if (name.length() > 8) {
            return name.substring(0, 8).trim() + '.' + name.substring(8).trim();
        }
        return name;
    }

    private static List<String> readFatEntries(FatLfnDirectory dir, String dirPath) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<FatLfnDirectoryEntry> entries = dir.iterator();
        while (entries.hasNext()) {
            FatLfnDirectoryEntry entry = entries.next();
            String name = FileUtils.fsDirectoryEntryNameToFileName(entry.getShortName());
            if (entry.isDirectory() && !name.equals(".") && !name.equals("..")) {
                result.addAll(FileUtils.readFatEntries(entry.getDirectory(), dirPath + name + File.separatorChar));
                continue;
            }
            if (!entry.isFile() || !FileUtils.isExecutable(name)) continue;
            result.add(dirPath + name);
        }
        return result;
    }

    public static void zipEntry(File orgFile, File fileEntry, ZipOutputStream zos) throws IOException {
        ZipEntry anEntry = new ZipEntry(PlatformUtils.toArchivePath(fileEntry, orgFile.isDirectory()));
        anEntry.setTime(orgFile.lastModified());
        if (orgFile.isFile() && !orgFile.canWrite()) {
            anEntry.setExtra(new byte[]{1});
        }
        zos.putNextEntry(anEntry);
        if (orgFile.isFile()) {
            byte[] readBuffer = new byte[10240];
            int bytes = 0;
            FileInputStream is = new FileInputStream(orgFile);
            while ((bytes = is.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytes);
            }
            is.close();
        }
        zos.closeEntry();
    }

    public static void zipDir(File dirToZip, ZipOutputStream zos, File dstDirInZip) throws IOException {
        FileUtils.zipDir(dirToZip, zos, dirToZip, dstDirInZip);
    }

    private static void zipDir(File dirToZip, ZipOutputStream zos, File zipRootDir, File dstDirInZip) throws IOException {
        String[] dirList = dirToZip.list();
        if (dirList == null) {
            throw new IOException(Settings.getInstance().msg("general.error.opendir", new Object[]{dirToZip}));
        }
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(dirToZip, dirList[i]);
            FileUtils.zipEntry(f, new File(dstDirInZip, FileUtils.makeRelativeTo(f, zipRootDir).getPath()), zos);
            if (!f.isDirectory()) continue;
            FileUtils.zipDir(f, zos, zipRootDir, dstDirInZip);
        }
    }

    public static long extractZipSizeInBytes(File archive, File dirToBeExtracted) throws IOException {
        long bytes = 0L;
        ZipFile zf = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!FileUtils.areRelated(dirToBeExtracted, new File(entry.getName()))) continue;
            bytes += entry.getSize();
        }
        zf.close();
        return bytes;
    }

    public static long extractZipEntrySizeInBytes(File archive, String zipEntryToBeExtracted) throws IOException {
        ZipFile zf = new ZipFile(archive);
        ZipEntry entry = zf.getEntry(zipEntryToBeExtracted);
        zf.close();
        if (entry != null) {
            return entry.getSize();
        }
        return 0L;
    }

    public static void extractZip(File archive, File dirToBeExtracted, File dstDir, ProgressNotifyable prog) throws IOException {
        ZipFile zf = new ZipFile(archive);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!FileUtils.areRelated(dirToBeExtracted, new File(entry.getName()))) continue;
            File dstFile = FileUtils.canonicalTo(dstDir, FileUtils.strip(new File(entry.getName()), dirToBeExtracted).getPath());
            FileUtils.extractEntry(zf, entry, dstFile, prog);
        }
        zf.close();
    }

    public static void extractZip(File archive, String zipEntryToBeExtracted, File dstFile, ProgressNotifyable prog) throws IOException {
        ZipFile zf = new ZipFile(archive);
        ZipEntry entry = zf.getEntry(zipEntryToBeExtracted);
        if (entry != null) {
            FileUtils.extractEntry(zf, entry, dstFile, prog);
        }
        zf.close();
    }

    public static void extractEntry(ZipFile zf, ZipEntry srcEntry, File dstFile, ProgressNotifyable prog) throws IOException {
        if (dstFile.exists()) {
            throw new IOException(Settings.getInstance().msg("general.error.filetobeextractedexists", new Object[]{dstFile}));
        }
        if (srcEntry.isDirectory()) {
            if (!dstFile.exists()) {
                FileUtils.createDir(dstFile);
            }
        } else {
            int bytesIn;
            if (dstFile.getParentFile() != null) {
                FileUtils.createDir(dstFile.getParentFile());
            }
            FileOutputStream fos = new FileOutputStream(dstFile);
            InputStream is = zf.getInputStream(srcEntry);
            byte[] readBuffer = new byte[10240];
            while ((bytesIn = is.read(readBuffer)) != -1) {
                fos.write(readBuffer, 0, bytesIn);
            }
            fos.flush();
            fos.close();
            is.close();
            byte[] extra = srcEntry.getExtra();
            if (extra != null && extra[0] == 1) {
                FileUtils.fileSetReadOnly(dstFile);
            }
        }
        FileUtils.fileSetLastModified(dstFile, srcEntry.getTime());
        prog.incrProgress((int)(srcEntry.getSize() / 1024L));
    }

    public static File determineDstSevenzipFile(File srcDir, File dstDir, String entryName) {
        return FileUtils.canonicalTo(dstDir, FileUtils.strip(new File(entryName), srcDir).getPath());
    }

    public static int[] findRelatedEntryIds(IInArchive zArchive, File dirToBeExtracted) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < zArchive.size(); ++i) {
            if (!FileUtils.areRelated(dirToBeExtracted, new File(zArchive.getEntry(i).getName()))) continue;
            result.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])result.toArray(new Integer[0]));
    }

    public static int findEntryId(IInArchive zArchive, String filenameToBeExtracted) {
        for (int i = 0; i < zArchive.size(); ++i) {
            if (!zArchive.getEntry(i).getName().equals(filenameToBeExtracted)) continue;
            return i;
        }
        return -1;
    }

    private static File strip(File file, File basePath) {
        if (file.equals(basePath)) {
            return new File(".");
        }
        File remainder = new File(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(basePath)) {
                return remainder;
            }
            remainder = new File(parent.getName(), remainder.getPath());
        }
        return file;
    }

    public static String getUrlFromFile(File file) throws MalformedURLException {
        return file.toURI().toURL().toString();
    }

    public static String fileSystemSafe(String s) {
        return s.replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    public static String fileSystemSafeWebImages(String s) {
        return s.replaceAll(" ", "_").replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    public static File getTmpInstallFile() {
        return TMPINST_DIR_FILE;
    }

    public static boolean isStoredOnFloppyDrive(File file) {
        if (PlatformUtils.IS_OSX) {
            return false;
        }
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (File f : File.listRoots()) {
            if (!FileUtils.areRelated(f, file)) continue;
            return fsv.isFloppyDrive(f);
        }
        return false;
    }

    public static boolean isStoredOnCDRomDrive(File file) {
        if (PlatformUtils.IS_OSX) {
            return false;
        }
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (File f : File.listRoots()) {
            if (!FileUtils.areRelated(f, file)) continue;
            return fsv.isDrive(f) && fsv.getSystemTypeDescription(f).toUpperCase().contains("CD");
        }
        return false;
    }

    private static String[] getNames(File[] files) {
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getName();
        }
        return result;
    }

    public static File[] findFileSequence(File f) {
        File dir;
        ArrayList<File> result = new ArrayList<File>();
        result.add(f);
        int i = 1;
        String name = FilenameUtils.removeExtension(f.getName());
        String ext = FilenameUtils.getExtension(f.getName());
        if (name.endsWith(String.valueOf(i)) && (dir = f.getParentFile()) != null) {
            File[] files = dir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    return f.isFile();
                }
            });
            Object[] fileNames = FileUtils.getNames(files);
            if (files != null) {
                int index;
                do {
                    String nextFileName;
                    if ((index = ArrayUtils.indexOf((Object[])fileNames, (Object)(nextFileName = StringUtils.chop((String)name) + String.valueOf(++i) + '.' + ext))) < 0) continue;
                    result.add(files[index]);
                } while (index >= 0);
            }
        }
        return result.toArray(new File[0]);
    }

    public static String[] getShaders() {
        File shadersDir = new File(DOSROOT_DIR_FILE, "SHADERS");
        if (shadersDir.exists() && shadersDir.isDirectory()) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator<File> it = org.apache.commons.io.FileUtils.iterateFiles(shadersDir, new String[]{"fx"}, false);
            while (it.hasNext()) {
                result.add(it.next().getName());
            }
            Collections.sort(result);
            return result.toArray(new String[0]);
        }
        return null;
    }

    static {
        TEMPLATES_DIR = "templates" + File.separatorChar;
        DOSROOT_DIR = "dosroot" + File.separatorChar;
        CAPTURES_DIR = "captures" + File.separatorChar;
        MAPPER_DIR = "mapper" + File.separatorChar;
        PROFILES_DIR = "profiles" + File.separatorChar;
        EXPORT_DIR = "export" + File.separatorChar;
        XSL_DIR = "xsl" + File.separatorChar;
        CDIMAGES = new String[]{".iso", ".cue", ".bin"};
        EXECUTABLES = new String[]{".exe", ".com", ".bat"};
        EXECUTABLES_UPPERCASE = new String[]{"EXE", "COM", "BAT"};
        ARCHIVES = new String[]{".zip", ".7z"};
        FATIMAGES = new String[]{".ima"};
        BOOTERIMAGES = new String[]{".cp2", ".dcf", ".img", ".jrc", ".td0"};
        PICTURES = new String[]{".png", ".gif", ".jpg", ".tif", ".tiff", ".ico", ".bmp"};
        SETUPFILES = new String[]{"setup.exe", "install.exe", "setsound.exe", "setup.bat", "config.exe", "setsound.bat", "sound.bat", "sound.exe", "install.com", "install.bat", "sndsetup.exe", "soundset.exe", "config.bat", "setup.com", "setsnd.exe", "setd.exe", "configur.exe", "uwsound.exe"};
        UNLIKELYMAINFILES = new String[]{"dos4gw.exe", "readme.bat", "intro.exe", "loadpats.exe", "uvconfig.exe", "soundrv.com", "sblaster.com", "sound.bat", "univbe.exe", "midpak.com", "ultramid.exe", "mpscopy.exe", "readme.exe", "sbpro.com", "help.bat", "exists.com", "helpme.exe", "paudio.com", "bootdisk.exe", "pas16.com", "mssw95.exe", "setd.exe", "adlib.com", "sbclone.com", "sb16.com", "godir.com", "ibmsnd.com", "crack.com", "gf166.com", "__insth.bat", "adlibg.com", "space.com", "instgame.bat", "ibmbak.com", "pkunzjr.com", "nosound.com", "sview.exe", "mgraphic.exe", "title.exe", "misc.exe", "checkcd.bat", "patch.exe", "tansltl.com", "readme.com", "uninstal.exe", "source.com", "cmidpak.com", "vector.com", "view.exe", "rtm.exe", "eregcard.exe", "sndsys.com", "info.exe", "docshell.exe", "catalog.exe", "ipxsetup.exe", "yes.com", "stfx.com", "getkey.com", "lsize.com", "makepath.com", "sersetup.exe", "commit.exe", "_setup.exe", "end.exe", "what.exe", "setm.exe", "cvxsnd.com", "aria.com", "tgraphic.exe", "egraphic.exe", "smidpak.com", "tlivesa.com", "vmsnd.com", "detect.exe", "digvesa.com", "cwsdpmi.exe", "vesa.exe", "havevesa.exe", "_install.bat", "smsnd.com", "insticon.exe", "installh.bat", "install2.bat", "info.bat", "setmain.exe", "swcbbs.exe", "vbetest.exe", "pmidpak.com", "inst.exe", "cleardrv.exe", "winstall.exe", "ibm1bit.com", "tmidpak.com", "dealers.exe", "digisp.com", "drv_bz.com", "drv_sb.com", "drv_ss.com", "convert.exe", "editor.exe", "cgraphic.exe", "update.bat", "smackply.exe", "univesa.exe", "lha.exe", "makeboot.bat", "nnansi.com", "setblast.exe", "autoexec.bat", "helpme.bat", "exist.com", "fixboot.exe", "ask.com", "vesatest.exe", "manual.exe", "sbwave.com", "rmidpak.com", "diagnost.exe", "pkunzip.exe", "sinstall.exe", "megaem.exe", "vesa.com", "getdrv.exe", "drv_sbd.com", "chkvesa.exe", "chkmem.com", "setstick.exe"};
        SectionsWrapper settings = Settings.getInstance().getSettings();
        String data = FileUtils.replaceTildeInPath(settings.getValue("directory", "data"));
        boolean dataInUserDir = PlatformUtils.USE_USER_HOME_DIR || !PlatformUtils.isDirectoryWritable(new File(data));
        DATA_DIR_FILE = FileUtils.canonical(dataInUserDir ? new File(PlatformUtils.USER_DATA_DIR_FILE, data).getPath() : data);
        DOSROOT_DIR_FILE = new File(DATA_DIR_FILE, DOSROOT_DIR);
        DOSBOX_DIR_FILE = FileUtils.canonical(FileUtils.replaceTildeInPath(settings.getValue("directory", "dosbox")));
        TMPINST_DIR_FILE = new File(DOSROOT_DIR_FILE, settings.getValue("directory", "tmpinstall"));
        if (dataInUserDir) {
            FileUtils.copyDirectoriesIfNecessary(data);
        }
        FileUtils.createDirIfNecessary(DOSROOT_DIR_FILE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File file1, File file2) {
            return new FilenameComparator().compare(file1.getPath(), file2.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FilenameComparator
    implements Comparator<String> {
        @Override
        public int compare(String string1, String string2) {
            int count2;
            int count1 = StringUtils.countMatches((CharSequence)string1, (CharSequence)"\\");
            if (count1 == (count2 = StringUtils.countMatches((CharSequence)string2, (CharSequence)"\\"))) {
                return string1.compareTo(string2);
            }
            return count1 - count2;
        }
    }
}

