/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.searchengine.WebSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotudSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<table class=\"jrResults\" width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">";
    private static final String HTML_GAME_TITLE_START = "<div class=\"jrContentTitle\">";
    private static final String HTML_GAME_END_MARKER = "<td class=\"jrTableColumnLast\">";
    private static final String HOTUD_ORG_HOST_NAME = "www.hotud.org";
    private static final int RESULTS_PER_PAGE = 50;

    private HotudSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "hotud.png";
    }

    @Override
    public String getName() {
        return "Home o/t Underdogs";
    }

    @Override
    public String getSimpleName() {
        return "hotud";
    }

    @Override
    public List<WebProfile> getEntries(String title, String[] platforms) throws IOException {
        String platformFilter;
        int pages = 1;
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        String string = platformFilter = platforms.length == 1 ? "/tag/reqs/" + platforms[0] : "";
        for (int pageIdx = 0; pageIdx < pages; ++pageIdx) {
            String content = HotudSearchEngine.getResponseContent("http://www.hotud.org/component/jreviews/search-results" + platformFilter + "?criteria=1&query=all&scope=title&keywords=" + URLEncoder.encode(title.replaceAll("/", " "), "UTF-8") + "&order=alpha&page=" + (pageIdx + 1) + "&limit=" + 50, "UTF-8");
            if (pageIdx == 0) {
                pages = HotudSearchEngine.getPages(content);
            }
            if (pages > 0) {
                allEntries.addAll(HotudSearchEngine.extractEntries(content));
                continue;
            }
            if (content.indexOf("<h1 class=\"contentheading\">") == -1) continue;
            allEntries.add(this.extractSingleEntry(content));
        }
        if (platforms.length == 1) {
            for (WebProfile p : allEntries) {
                p.setPlatform(platforms[0].toUpperCase());
            }
        }
        return allEntries;
    }

    private static int getPages(String htmlChunk) {
        int i = htmlChunk.indexOf("<div class=\"jrCol4 jrPagenavResults\">");
        int j = htmlChunk.indexOf(" results", i);
        if (i == -1 || j == -1) {
            return 0;
        }
        return (int)Math.ceil((double)Integer.parseInt(htmlChunk.substring(i + 37, j).trim()) / 50.0);
    }

    private static List<WebProfile> extractEntries(String html) {
        ArrayList<WebProfile> allEntries = new ArrayList<WebProfile>();
        int gameMatchEntryIndex = (html = html.replaceAll("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (gameMatchEntryIndex != -1) {
            gameMatchEntryIndex = html.indexOf("<tr class=\"row" + (allEntries.size() % 2 + 1) + "\">", gameMatchEntryIndex);
            int gameTitleIdx = html.indexOf(HTML_GAME_TITLE_START, gameMatchEntryIndex);
            String gameTitle = HotudSearchEngine.extractNextContent(html, gameTitleIdx, "<a ", "</a>");
            String url = HotudSearchEngine.absoluteUrl(HOTUD_ORG_HOST_NAME, HotudSearchEngine.extractNextHrefContent(html, gameTitleIdx));
            int detailsIdx = html.indexOf("<div class=\"jrCustomFields\">", gameTitleIdx + HTML_GAME_TITLE_START.length());
            int yearIdx = html.indexOf("<div class=\"jrFieldLabel\">Year released</div><div class=\"jrFieldValue \">", detailsIdx);
            String year = HotudSearchEngine.extractNextContent(html, yearIdx, "<a ", "</a>");
            WebProfile gameEntry = new WebProfile();
            gameEntry.setTitle(gameTitle);
            gameEntry.setYear(year);
            gameEntry.setUrl(url);
            allEntries.add(gameEntry);
            int endIdx = html.indexOf(HTML_GAME_END_MARKER, gameTitleIdx);
            gameMatchEntryIndex = html.indexOf("<tr class=\"row" + (allEntries.size() % 2 + 1) + "\">", endIdx + HTML_GAME_END_MARKER.length());
        }
        return allEntries;
    }

    private WebProfile extractSingleEntry(String html) {
        int baseIdx = html.indexOf("<base href=");
        String base = HotudSearchEngine.extractNextHrefContent(html, baseIdx);
        int titleIdx = html.indexOf("<span itemprop=\"name\">");
        String title = HotudSearchEngine.extractNextContent(html, titleIdx, "<span ", "</span>");
        int detailsIdx = html.indexOf("<div class=\"jrListingInfoContainer\">", titleIdx);
        int yearIdx = html.indexOf("<div class=\"jrFieldLabel\">Year released</div><div class=\"jrFieldValue \">", detailsIdx);
        String year = HotudSearchEngine.extractNextContent(html, yearIdx, "<a ", "</a>");
        WebProfile gameEntry = new WebProfile();
        gameEntry.setTitle(title);
        gameEntry.setYear(year);
        gameEntry.setUrl(base);
        return this.setAdditionalFields(gameEntry, html);
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile entry) throws UnknownHostException, IOException {
        if (entry.getNotes() != null) {
            return entry;
        }
        return this.setAdditionalFields(entry, HotudSearchEngine.getResponseContent(entry.getUrl(), "UTF-8"));
    }

    private WebProfile setAdditionalFields(WebProfile result, String html) {
        int ratingIdx = html.indexOf("<span class=\"jrRatingValue\"");
        ratingIdx = html.indexOf(">", ratingIdx);
        int ratingEndIdx = html.indexOf(" ", ratingIdx + 1);
        String ratingData = html.substring(ratingIdx + 1, ratingEndIdx).replace(".", "");
        int rating = 0;
        try {
            rating = new Integer(ratingData);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int detailsIdx = html.indexOf("<div class=\"jrFieldGroup game-information\">", ratingIdx);
        int devIdx = html.indexOf("<div class=\"jrFieldLabel\">Developer</div><div class=\"jrFieldValue \">", detailsIdx);
        String developer = HotudSearchEngine.unescapeHtml(HotudSearchEngine.removeAllTags(HotudSearchEngine.extractNextContent(html, devIdx, "<a ", "</a>")));
        int pubIdx = html.indexOf("<div class=\"jrFieldLabel\">Publisher</div><div class=\"jrFieldValue \">", detailsIdx);
        String publisher = HotudSearchEngine.unescapeHtml(HotudSearchEngine.removeAllTags(HotudSearchEngine.extractNextContent(html, pubIdx, "<a ", "</a>")));
        int genreIdx = html.indexOf("<div class=\"jrFieldLabel\">Genre</div><div class=\"jrFieldValue \">", detailsIdx);
        String genre = this.stripStars(HotudSearchEngine.extractNextContent(html, genreIdx, "<a ", "</a>"));
        int platformIdx = html.indexOf("<div class=\"jrFieldLabel\">Platform</div><div class=\"jrFieldValue \">", detailsIdx);
        String platform = HotudSearchEngine.extractNextContent(html, platformIdx, "<a ", "</a>");
        int notesIdx = html.indexOf("<div class=\"jrListingFulltext\" itemprop=\"description\">", detailsIdx);
        String notes = HotudSearchEngine.unescapeHtml(HotudSearchEngine.removeAllTags(HotudSearchEngine.extractNextContent(html, notesIdx, "<div", "</div>")));
        result.setDeveloperName(developer);
        result.setPublisherName(publisher);
        result.setGenre(genre);
        result.setPlatform(platform);
        result.setNotes(notes);
        result.setRank(rating);
        return result;
    }

    private String stripStars(String s) {
        if (s.startsWith("*") && s.endsWith("*")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile entry, int coverArtMax, int screenshotsMax, boolean forceAllRegionsCoverArt) throws IOException {
        entry.setWebImages(new SearchEngineImageInformation[0]);
        return entry.getWebImages();
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new HotudSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

