/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.dbgl.waldheinz.fs.fat.AbstractDirectory;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.Fat16BootSector;

final class Fat16RootDirectory
extends AbstractDirectory {
    private final BlockDevice device;
    private final long deviceOffset;

    private Fat16RootDirectory(Fat16BootSector bs) {
        super(bs.getRootDirEntryCount(), true);
        if (bs.getRootDirEntryCount() <= 0) {
            throw new IllegalArgumentException("root directory size is " + bs.getRootDirEntryCount());
        }
        this.deviceOffset = bs.getRootDirOffset();
        this.device = bs.getDevice();
    }

    public static Fat16RootDirectory read(Fat16BootSector bs) throws IOException {
        Fat16RootDirectory result = new Fat16RootDirectory(bs);
        result.read();
        return result;
    }

    protected void read(ByteBuffer data) throws IOException {
        this.device.read(this.deviceOffset, data);
    }
}

