/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Collections;
import java.util.List;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class BrowseSearchEngineDialog
extends Dialog {
    private String title;
    private List<WebProfile> profs = null;
    private WebSearchEngine engine;
    private Object result;
    private Shell shell;
    private Settings settings = Settings.getInstance();

    public BrowseSearchEngineDialog(Shell shell, int n) {
        super(shell, n);
    }

    public BrowseSearchEngineDialog(Shell shell) {
        this(shell, 0);
    }

    public void setProfilesToBrowse(String string, List<WebProfile> list) {
        this.title = string;
        this.profs = list;
    }

    public void setEngine(WebSearchEngine webSearchEngine) {
        this.engine = webSearchEngine;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        TableColumn tableColumn;
        int n;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "mobygamesbrowser"));
        this.shell.setText(this.settings.msg("dialog.searchenginebrowser.title", new String[]{this.engine.getName()}));
        final Table table = new Table((Composite)this.shell, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int n = table.getSelectionIndex();
                WebProfile webProfile = (WebProfile)BrowseSearchEngineDialog.this.profs.get(n);
                TableColumn tableColumn = (TableColumn)event.widget;
                int n2 = (Integer)tableColumn.getData();
                switch (n2) {
                    case 0: {
                        Collections.sort(BrowseSearchEngineDialog.this.profs, new WebProfile.byTitle());
                        break;
                    }
                    case 1: {
                        Collections.sort(BrowseSearchEngineDialog.this.profs, new WebProfile.byYear());
                        break;
                    }
                    case 2: {
                        Collections.sort(BrowseSearchEngineDialog.this.profs, new WebProfile.byPlatform());
                        break;
                    }
                }
                table.removeAll();
                BrowseSearchEngineDialog.this.populate(table);
                table.setSortColumn(tableColumn);
                table.setSortDirection(128);
                for (int i = 0; i < BrowseSearchEngineDialog.this.profs.size(); ++i) {
                    if (webProfile != BrowseSearchEngineDialog.this.profs.get(i)) continue;
                    table.setSelection(i);
                    break;
                }
            }
        };
        String[] stringArray = new String[]{this.settings.msg("dialog.profile.title"), this.settings.msg("dialog.profile.year"), this.settings.msg("dialog.searchenginebrowser.column.platform")};
        for (n = 0; n < stringArray.length; ++n) {
            tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n]);
            tableColumn.setData((Object)n);
            tableColumn.addListener(13, listener);
            if (n != stringArray.length - 1) continue;
            table.setSortColumn(tableColumn);
            table.setSortDirection(128);
        }
        this.populate(table);
        for (n = 0; n < stringArray.length; ++n) {
            table.getColumn(n).pack();
        }
        table.setSelection(WebSearchEngine.getEntryBestMatchIndex(this.title, this.profs));
        table.showSelection();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                BrowseSearchEngineDialog.this.result = table.getSelectionIndex();
                BrowseSearchEngineDialog.this.shell.close();
            }
        });
        Button button = new Button((Composite)this.shell, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BrowseSearchEngineDialog.this.result = table.getSelectionIndex();
                BrowseSearchEngineDialog.this.shell.close();
            }
        });
        button.setLayoutData((Object)new GridData(80, -1));
        this.shell.setDefaultButton(button);
        button.setText(this.settings.msg("button.ok"));
        tableColumn = new Button((Composite)this.shell, 0);
        tableColumn.setLayoutData((Object)new GridData(80, -1));
        tableColumn.setText(this.settings.msg("button.cancel"));
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BrowseSearchEngineDialog.this.result = null;
                BrowseSearchEngineDialog.this.shell.close();
            }
        });
    }

    private void populate(Table table) {
        for (WebProfile webProfile : this.profs) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(0, webProfile.getTitle());
            tableItem.setText(1, webProfile.getYear());
            tableItem.setText(2, webProfile.getPlatform());
        }
    }
}

