/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.ImgSizeCommand;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public final class EditImgSizeDialog
extends Dialog {
    private ImgSizeCommand sizeCommand;
    private Object result;
    private Shell shell;
    private Settings settings = Settings.getInstance();

    public EditImgSizeDialog(Shell shell, int n) {
        super(shell, n);
    }

    public EditImgSizeDialog(Shell shell) {
        this(shell, 0);
    }

    public void setImgMountSizeCommand(String string) {
        this.sizeCommand = new ImgSizeCommand(string);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "imgsizedialog"));
        this.shell.setText(this.settings.msg("dialog.imgsize.title"));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(this.settings.msg("dialog.imgsize.params"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.imgsize.bytespersector"));
        final Spinner spinner = new Spinner((Composite)group, 2048);
        spinner.setValues(this.sizeCommand.getBytesPerSector(), 1, 4096, 0, 1, 512);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.imgsize.sectorspertrack"));
        final Spinner spinner2 = new Spinner((Composite)group, 2048);
        spinner2.setValues(this.sizeCommand.getSectorsPerTrack(), 1, 255, 0, 1, 64);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.imgsize.heads"));
        final Spinner spinner3 = new Spinner((Composite)group, 2048);
        spinner3.setValues(this.sizeCommand.getHeads(), 1, 64, 0, 1, 16);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(this.settings.msg("dialog.imgsize.cylinders"));
        final Spinner spinner4 = new Spinner((Composite)group, 2048);
        spinner4.setValues(this.sizeCommand.getCylinders(), 1, 8192, 0, 1, 20);
        Label label5 = new Label((Composite)group, 0);
        label5.setText(this.settings.msg("dialog.imgsize.totalsize"));
        final Text text = new Text((Composite)group, 2048);
        text.setEditable(false);
        text.setText(this.settings.msg("dialog.imgsize.totalsize.value", new Long[]{this.sizeCommand.getTotalSize(), this.sizeCommand.getTotalSizeInMB()}));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditImgSizeDialog.this.sizeCommand = new ImgSizeCommand(spinner.getSelection(), spinner2.getSelection(), spinner3.getSelection(), spinner4.getSelection());
                text.setText(EditImgSizeDialog.this.settings.msg("dialog.imgsize.totalsize.value", new Long[]{EditImgSizeDialog.this.sizeCommand.getTotalSize(), EditImgSizeDialog.this.sizeCommand.getTotalSizeInMB()}));
                text.pack();
            }
        };
        spinner.addModifyListener(modifyListener);
        spinner2.addModifyListener(modifyListener);
        spinner3.addModifyListener(modifyListener);
        spinner4.addModifyListener(modifyListener);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new GridLayout(2, true));
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditImgSizeDialog.this.result = EditImgSizeDialog.this.sizeCommand.toString();
                EditImgSizeDialog.this.shell.close();
            }
        });
        button.setLayoutData((Object)new GridData(80, -1));
        this.shell.setDefaultButton(button);
        button.setText(this.settings.msg("button.ok"));
        Button button2 = new Button(composite, 0);
        button2.setLayoutData((Object)new GridData(80, -1));
        button2.setText(this.settings.msg("button.cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditImgSizeDialog.this.result = null;
                EditImgSizeDialog.this.shell.close();
            }
        });
    }
}

