/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.sql.SQLException;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.MigrateThread;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class MigrateDialog
extends Dialog {
    private Text from;
    private Text logText;
    private MigrateThread migrateThread;
    private Button cancelButton;
    private Label profileLabel;
    private String result = null;
    private Shell shell;
    private Settings settings;

    public MigrateDialog(Shell shell, int n) {
        super(shell, n);
    }

    public MigrateDialog(Shell shell) {
        this(shell, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.migrateThread != null && !this.migrateThread.isAlive() && !this.cancelButton.getText().equals(this.settings.msg("button.finish"))) {
                if (this.migrateThread.isEverythingOk()) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.migration.notice.migrationok"));
                } else {
                    GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.migration.error.problem"));
                }
                this.profileLabel.setText(this.settings.msg("dialog.migration.reviewlog"));
                this.profileLabel.pack();
                this.cancelButton.setText(this.settings.msg("button.finish"));
                this.cancelButton.setEnabled(true);
                this.shell.setDefaultButton(this.cancelButton);
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "migratedialog"));
        this.shell.setText(this.settings.msg("dialog.migration.title"));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.migration.options"));
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.migration.from"));
        this.from = new Text((Composite)group, 2048);
        this.from.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final BrowseButton browseButton = new BrowseButton((Composite)group, 0);
        browseButton.connect(this.shell, this.from, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.migration.to"));
        Text text = new Text((Composite)group, 2056);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText(FileUtils.getDosRoot());
        new Label((Composite)group, 0);
        final Button button = new Button((Composite)group, 0);
        this.shell.setDefaultButton(button);
        button.setLayoutData((Object)new GridData(120, -1));
        button.setText(this.settings.msg("dialog.migration.startmigration"));
        this.cancelButton = new Button((Composite)group, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MigrateDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(120, -1));
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        new Label((Composite)group, 0);
        Group group2 = new Group((Composite)this.shell, 0);
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(this.settings.msg("dialog.migration.progress"));
        group2.setLayout((Layout)new GridLayout());
        final ProgressBar progressBar = new ProgressBar((Composite)group2, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)group2, 0);
        this.logText = new Text((Composite)group2, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!MigrateDialog.this.isValid()) {
                    return;
                }
                try {
                    MigrateDialog.this.migrateThread = new MigrateThread(MigrateDialog.this.logText, progressBar, MigrateDialog.this.profileLabel, new File(MigrateDialog.this.from.getText()));
                    MigrateDialog.this.result = MigrateDialog.this.from.getText();
                    MigrateDialog.this.from.setEnabled(false);
                    browseButton.setEnabled(false);
                    button.setEnabled(false);
                    MigrateDialog.this.cancelButton.setEnabled(false);
                    MigrateDialog.this.migrateThread.start();
                }
                catch (SQLException sQLException) {
                    GeneralPurposeDialogs.warningMessage(MigrateDialog.this.shell, sQLException);
                    MigrateDialog.this.migrateThread = null;
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.from.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.migration.required.from"), (Control)this.from);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

