/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.listeners;

import org.dbgl.model.ThumbInfo;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class PaintListener
implements Listener {
    private static final SectionsWrapper set = Settings.getInstance().getSettings();

    public void handleEvent(Event event) {
        if (event.widget instanceof Gallery) {
            GalleryItem galleryItem = (GalleryItem)event.item;
            ThumbInfo thumbInfo = (ThumbInfo)galleryItem.getData();
            String string = thumbInfo.getMainThumb();
            if (thumbInfo.isUpdated()) {
                if (string == null) {
                    galleryItem.setImage(null);
                } else {
                    Rectangle rectangle = galleryItem.getBounds();
                    galleryItem.setImage(SWTImageManager.getResizedImage(event.display, rectangle.width - 4, rectangle.height - 22, set.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"), string));
                }
                galleryItem.setData((Object)thumbInfo);
            }
        } else if (event.widget instanceof Table) {
            Table table = (Table)event.widget;
            Widget widget = event.item;
            Integer n = (Integer)table.getData();
            if (event.index == n) {
                ThumbInfo thumbInfo = (ThumbInfo)widget.getData();
                String string = thumbInfo.getMainThumb();
                if (string != null) {
                    int n2 = table.getColumn(n.intValue()).getWidth();
                    int n3 = set.getIntValue("gui", "screenshotscolumnheight");
                    Image image = set.getBooleanValue("gui", "screenshotscolumnstretch") ? SWTImageManager.getResizedImage(event.display, n2, n3, set.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"), string) : SWTImageManager.getResizedImage(event.display, n3, string, null);
                    int n4 = Math.max(0, (n2 - image.getBounds().width - 2) / 2);
                    int n5 = Math.max(0, (n3 - image.getBounds().height - 2) / 2);
                    event.gc.drawImage(image, event.x + n4, event.y + n5);
                }
                if (thumbInfo.isUpdated()) {
                    widget.setData((Object)thumbInfo);
                }
            }
        }
    }
}

