/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.ArrayList;
import java.util.List;

public class OrderingVector {
    private static final int MAX_ORDERING_COLS = 8;
    private static final String[] GAME_LIST_ORDER = new String[]{"LOWER(GAM.TITLE)", "GAM.SETUP", "LOWER(DEV.NAME)", "LOWER(PUBL.NAME)", "LOWER(GEN.NAME)", "YR.YEAR", "LOWER(STAT.STAT)", "GAM.FAVORITE", "GAM.ID", "GAM.DBVERSION_ID", "LOWER(CUST1.VALUE)", "LOWER(CUST2.VALUE)", "LOWER(CUST3.VALUE)", "LOWER(CUST4.VALUE)", "LOWER(GAM.CUSTOM5)", "LOWER(GAM.CUSTOM6)", "LOWER(GAM.CUSTOM7)", "LOWER(GAM.CUSTOM8)", "GAM.CUSTOM9", "GAM.CUSTOM10", "LOWER(GAM.CAPTURES)"};
    private final List<OrderingElement> vector = new ArrayList<OrderingElement>();

    public OrderingVector(int[] nArray, boolean[] blArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.vector.add(new OrderingElement(nArray[i], blArray[i]));
        }
    }

    public void addOrdering(int n, boolean bl) {
        OrderingElement orderingElement = new OrderingElement(n, bl);
        int n2 = this.vector.indexOf(orderingElement);
        if (n2 != -1) {
            this.vector.remove(n2);
        }
        this.vector.add(0, orderingElement);
        if (this.vector.size() > 8) {
            this.vector.remove(8);
        }
    }

    public int[] getColumns() {
        int[] nArray = new int[this.vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.vector.get(i).column;
        }
        return nArray;
    }

    public boolean[] getAscendings() {
        boolean[] blArray = new boolean[this.vector.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.vector.get(i).ascending;
        }
        return blArray;
    }

    public String toClause() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.vector.isEmpty()) {
            stringBuffer.append(" ORDER BY ");
        }
        for (int i = 0; i < this.vector.size(); ++i) {
            OrderingElement orderingElement = this.vector.get(i);
            stringBuffer.append(orderingElement.toString());
            if (i + 1 >= this.vector.size()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private static class OrderingElement {
        private final int column;
        private final boolean ascending;

        OrderingElement(int n, boolean bl) {
            this.column = n;
            this.ascending = bl;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.column == ((OrderingElement)object).column;
        }

        public String toString() {
            return GAME_LIST_ORDER[this.column == 21 ? 9 : this.column] + (this.ascending ? " ASC" : " DESC");
        }
    }
}

