/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.IOException;
import java.util.Comparator;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.swtdesigner.SWTImageManager;
import org.eclipse.swt.graphics.ImageData;
import org.w3c.dom.Element;

public class WebProfile
implements Comparable<WebProfile> {
    private String title;
    private String platform;
    private String year;
    private String url;
    private String developerName;
    private String publisherName;
    private String genre;
    private String notes;
    private int rank;
    private String coreGameCoverUrl;
    private SearchEngineImageInformation[] webImages;
    private Element xmlElementWithAllImages;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String string) {
        this.platform = string;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String string) {
        this.year = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getScreenshotsUrl() {
        return this.url + "/screenshots";
    }

    public String getCoverArtUrl() {
        return this.url + "/cover-art";
    }

    public String getCoreGameCoverUrl() {
        return this.coreGameCoverUrl;
    }

    public void setCoreGameCoverUrl(String string) {
        this.coreGameCoverUrl = string;
    }

    public ImageData getWebImage(int n) throws IOException {
        if (this.webImages[n].data == null) {
            this.webImages[n].data = SWTImageManager.getImageData(this.webImages[n].url);
        }
        return this.webImages[n].data;
    }

    public SearchEngineImageInformation[] getWebImages() {
        return (SearchEngineImageInformation[])this.webImages.clone();
    }

    public void setWebImages(SearchEngineImageInformation[] searchEngineImageInformationArray) {
        this.webImages = (SearchEngineImageInformation[])searchEngineImageInformationArray.clone();
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String string) {
        this.developerName = string;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public void setPublisherName(String string) {
        this.publisherName = string;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String string) {
        this.genre = string;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int n) {
        this.rank = n;
    }

    public Element getXmlElementWithAllImages() {
        return this.xmlElementWithAllImages;
    }

    public void setXmlElementWithAllImages(Element element) {
        this.xmlElementWithAllImages = element;
    }

    public int hashCode() {
        return this.platform.hashCode() ^ this.title.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WebProfile webProfile = (WebProfile)object;
        return this.platform.equalsIgnoreCase(webProfile.platform) && this.title.equalsIgnoreCase(webProfile.title);
    }

    @Override
    public int compareTo(WebProfile webProfile) {
        if (webProfile.platform.equalsIgnoreCase(this.platform)) {
            return this.title.compareToIgnoreCase(webProfile.title);
        }
        return this.platform.compareToIgnoreCase(webProfile.platform);
    }

    public String toString() {
        return this.title + '@' + this.platform;
    }

    public static final class byPlatform
    implements Comparator<WebProfile> {
        @Override
        public int compare(WebProfile webProfile, WebProfile webProfile2) {
            return webProfile.platform.compareToIgnoreCase(webProfile2.platform);
        }
    }

    public static final class byYear
    implements Comparator<WebProfile> {
        @Override
        public int compare(WebProfile webProfile, WebProfile webProfile2) {
            return webProfile.year.compareToIgnoreCase(webProfile2.year);
        }
    }

    public static final class byTitle
    implements Comparator<WebProfile> {
        @Override
        public int compare(WebProfile webProfile, WebProfile webProfile2) {
            return webProfile.title.compareToIgnoreCase(webProfile2.title);
        }
    }
}

