/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.StreamGobbler;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.ShortFile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.waldheinz.fs.fat.FatFileSystem;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectory;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectoryEntry;
import org.dbgl.waldheinz.fs.util.FileDisk;
import org.eclipse.swt.widgets.Display;

public final class FileUtils {
    private static final int ZIP_BUFFER = 10240;
    private static final File DATA_DIR_FILE;
    private static final File DOSROOT_DIR_FILE;
    private static final File DOSBOX_DIR_FILE;
    private static final File TMPINST_DIR_FILE;
    private static final String TEMPLATES_DIR;
    private static final String SETUP_CONF = "setup.conf";
    private static final String TEMPLATE_CONF = "template.conf";
    public static final String PROFILES_XML = "profiles.xml";
    public static final String DOSROOT_DIR;
    public static final String CAPTURES_DIR;
    public static final String MAPPER_DIR;
    public static final String PROFILES_DIR;
    public static final String EXPORT_DIR;
    public static final String XSL_DIR;
    public static final String XSL_EXT = ".xsl";
    public static final String XML_EXT = ".xml";
    public static final String CONF_EXT = ".conf";
    public static final String MAPPER_EXT = ".map";
    public static final String GAMEPACKARCHIVE_EXT = ".dbgl.zip";
    public static final String[] CDIMAGES;
    public static final String[] EXECUTABLES;
    public static final String[] EXECUTABLES_UPPERCASE;
    public static final String[] ARCHIVES;
    static final String[] FATIMAGES;
    static final String[] BOOTERIMAGES;
    static final String[] PICTURES;
    static final String[] SETUPFILES;
    static final String[] UNLIKELYMAINFILES;
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String CNF_FILTER = "*.conf;*.CONF";
    public static final String EXE_FILTER = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
    public static final String ARC_FILTER = "*.zip;*.ZIP;*.7z;*.7Z";
    public static final String DBGLZIP_FILTER = "*.dbgl.zip;*.DBGL.ZIP";
    public static final String BTR_FILTER = "*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0";
    public static final String CDI_FILTER = "*.iso;*.ISO;*.cue;*.CUE";
    public static final String FATI_FILTER = "*.ima;*.IMA;";
    public static final String ALL_FILTER = "*";
    public static final String INVALID_FILENAME_CHARS_REGEXP = "[^a-zA-Z_0-9()]";

    public static String replaceTildeInPath(String string) {
        if ((PlatformUtils.IS_LINUX || PlatformUtils.IS_OSX) && (string.startsWith("~/") || string.length() == 1 && string.charAt(0) == '~')) {
            return string.replaceAll("^~", System.getProperty("user.home"));
        }
        return string;
    }

    private static void copyDirectoriesIfNecessary(String string) {
        FileUtils.copyDirIfNecessary(string, CAPTURES_DIR);
        File file = FileUtils.getDatabaseFile(Settings.getInstance().getSettings().getValue("database", "connectionstring"));
        if (file != null) {
            FileUtils.copyDirIfNecessary(string, file.getParent());
        }
        FileUtils.copyDirIfNecessary(string, DOSROOT_DIR);
        FileUtils.copyDirIfNecessary(string, EXPORT_DIR);
        FileUtils.copyDirIfNecessary(string, PROFILES_DIR);
        FileUtils.copyDirIfNecessary(string, TEMPLATES_DIR);
        FileUtils.copyDirIfNecessary(string, XSL_DIR);
    }

    private static void copyDirIfNecessary(String string, String string2) {
        File file = new File(string, string2);
        try {
            if (!FileUtils.isExistingDirectory(FileUtils.canonicalToData(string2)) && FileUtils.isExistingDirectory(file)) {
                org.apache.commons.io.FileUtils.copyDirectoryToDirectory(file, DATA_DIR_FILE);
            }
        }
        catch (IOException iOException) {
            System.err.println(Settings.getInstance().msg("general.error.copydirtodir", new String[]{file.getPath(), DATA_DIR_FILE.getPath()}));
        }
    }

    public static File getDatabaseFile(String string) {
        if (string.contains("file:")) {
            int n = string.indexOf("file:") + 5;
            int n2 = string.indexOf(59, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = FileUtils.replaceTildeInPath(string.substring(n, n2));
            return FileUtils.canonicalToData(string2);
        }
        return null;
    }

    public static boolean isExistingFile(File file) {
        return file.isFile() && file.exists();
    }

    public static boolean isExistingDirectory(File file) {
        return file.isDirectory() && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copy(File file, File file2) {
        block22: {
            AbstractInterruptibleChannel abstractInterruptibleChannel;
            FileChannel fileChannel;
            block20: {
                fileChannel = null;
                abstractInterruptibleChannel = null;
                fileChannel = new FileInputStream(file).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
                fileChannel.transferTo(0L, fileChannel.size(), (WritableByteChannel)((Object)abstractInterruptibleChannel));
                if (fileChannel == null) break block20;
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{file}));
                }
            }
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{file}));
                }
            }
            break block22;
            catch (IOException iOException) {
                block21: {
                    try {
                        System.err.println(Settings.getInstance().msg("general.error.copyfile", new Object[]{file, file2}));
                        if (fileChannel == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (fileChannel != null) {
                            try {
                                fileChannel.close();
                            }
                            catch (IOException iOException2) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{file}));
                            }
                        }
                        if (abstractInterruptibleChannel != null) {
                            try {
                                abstractInterruptibleChannel.close();
                            }
                            catch (IOException iOException3) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{file}));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        fileChannel.close();
                    }
                    catch (IOException iOException4) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{file}));
                    }
                }
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException5) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{file}));
                    }
                }
            }
        }
    }

    private static List<String> initCommands(DosboxVersion dosboxVersion, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dosboxVersion.isUsingCurses() && PlatformUtils.IS_WINDOWS) {
            arrayList.add("rundll32");
            arrayList.add("SHELL32.DLL,ShellExec_RunDLL");
        }
        arrayList.add(dosboxVersion.getCanonicalExecutable().getPath());
        if (dosboxVersion.isMultiConfig() && FileUtils.isReadableFile(dosboxVersion.getCanonicalConfFile()) || bl) {
            arrayList.add("-conf");
            arrayList.add(dosboxVersion.getCanonicalConfFile().getPath());
        }
        return arrayList;
    }

    private static void postCommands(DosboxVersion dosboxVersion, List<String> list) {
        if (dosboxVersion.getParameters().length() > 0) {
            for (String string : dosboxVersion.getParameters().split(" ")) {
                list.add(string);
            }
        }
        if (Settings.getInstance().getSettings().getBooleanValue("dosbox", "hideconsole")) {
            list.add("-noconsole");
        }
    }

    private static void executeCommand(List<String> list, File file, Map<String, String> map, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i);
                stringBuffer.append(stringArray[i]).append(' ');
            }
            System.out.print(stringBuffer);
            File file2 = file == null ? DOSROOT_DIR_FILE : file;
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.directory(file2);
            Map<String, String> map2 = processBuilder.environment();
            if (map != null) {
                map2.putAll(map);
                System.out.print(map);
            }
            System.out.println();
            Process process = processBuilder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "DOSBox stderr");
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "DOSBox stdout");
            streamGobbler2.start();
            streamGobbler.start();
            if (bl) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IOException(Settings.getInstance().msg("general.error.startdosbox", new Object[]{stringBuffer}));
        }
    }

    private static void doRunDosbox(DosboxVersion dosboxVersion, String[] stringArray, boolean bl, File file, Map<String, String> map, boolean bl2) throws IOException {
        List<String> list = FileUtils.initCommands(dosboxVersion, bl);
        list.addAll(Arrays.asList(stringArray));
        FileUtils.postCommands(dosboxVersion, list);
        FileUtils.executeCommand(list, file, map, bl2);
    }

    private static File canonicalTo(File file, String string) {
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            try {
                return file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                return file2.getAbsoluteFile();
            }
        }
        try {
            return new File(file, file2.getPath()).getCanonicalFile();
        }
        catch (IOException iOException) {
            return new File(file, file2.getPath()).getAbsoluteFile();
        }
    }

    public static boolean areRelated(File file, File file2) {
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file.equals(file3)) continue;
            return true;
        }
        return false;
    }

    public static String getDosRoot() {
        return DOSROOT_DIR_FILE.getPath();
    }

    public static File makeRelativeTo(File file, File file2) {
        if (!file.isAbsolute()) {
            return file;
        }
        if (file.equals(file2)) {
            return new File(".");
        }
        File file3 = new File(file.getName());
        for (File file4 = file.getParentFile(); file4 != null; file4 = file4.getParentFile()) {
            if (file4.equals(file2)) {
                return file3;
            }
            file3 = new File(file4.getName(), file3.getPath());
        }
        return file;
    }

    public static File makeRelativeToData(File file) {
        return FileUtils.makeRelativeTo(file, DATA_DIR_FILE);
    }

    public static File makeRelativeToDosroot(File file) {
        return FileUtils.makeRelativeTo(file, DOSROOT_DIR_FILE);
    }

    public static File makeRelativeToDosbox(File file) {
        return FileUtils.makeRelativeTo(file, DOSBOX_DIR_FILE);
    }

    public static File canonical(String string) {
        return FileUtils.canonicalTo(new File("."), string);
    }

    public static File canonicalToData(String string) {
        return FileUtils.canonicalTo(DATA_DIR_FILE, string);
    }

    public static File canonicalToDosbox(String string) {
        return FileUtils.canonicalTo(DOSBOX_DIR_FILE, string);
    }

    public static File canonicalToDosroot(String string) {
        return FileUtils.canonicalTo(DOSROOT_DIR_FILE, string);
    }

    public static String sanitizeToDosroot(String string) {
        return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(string)).getPath();
    }

    public static File prefixAndSanitizeToDosroot(File file, File file2) {
        if (!file2.isAbsolute()) {
            return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(new File(file, file2.getPath()).getPath()));
        }
        return file2;
    }

    public static File constructRelativeDBConfLocation(String string) {
        return FileUtils.makeRelativeToDosbox(new File(string, DOSBOX_CONF));
    }

    public static File constructCanonicalDBExeLocation(String string) {
        return FileUtils.canonicalToDosbox(new File(string, PlatformUtils.DB_EXECUTABLE).getPath());
    }

    public static String constructCapturesDir(int n) {
        return CAPTURES_DIR + n;
    }

    public static String constructMapperFile(int n) {
        return MAPPER_DIR + n + MAPPER_EXT;
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        File file3 = file.getParentFile();
        if (file3 == null) {
            return file2.getPath();
        }
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        if (string2.startsWith(string)) {
            return string2.substring(string.length() + 1);
        }
        return ".." + File.separatorChar + FileUtils.getRelativePath(file3, file2);
    }

    public static String constructRelativeCapturesDir(int n, File file, int n2) {
        File file2 = null;
        file2 = n2 < 3 ? DOSROOT_DIR_FILE : file;
        File file3 = FileUtils.canonicalToData(FileUtils.constructCapturesDir(n));
        try {
            return FileUtils.getRelativePath(file2, file3);
        }
        catch (IOException iOException) {
            return file3.getPath();
        }
    }

    public static File constructCanonicalTemplateFileLocation(int n) {
        return FileUtils.canonicalToData(TEMPLATES_DIR + n + CONF_EXT);
    }

    public static File getDefaultTemplatesXmlFile() {
        return FileUtils.canonicalToData(TEMPLATES_DIR + "default.xml");
    }

    public static String constructUniqueConfigFileString(int n, String string, File file) {
        SectionsWrapper sectionsWrapper = Settings.getInstance().getSettings();
        File file2 = sectionsWrapper.getIntValue("profiledefaults", "confpath") == 0 || file == null ? new File(PROFILES_DIR) : file;
        String string2 = sectionsWrapper.getIntValue("profiledefaults", "conffile") == 0 ? String.valueOf(n) : string;
        File file3 = null;
        int n2 = 1;
        do {
            file3 = new File(file2, FileUtils.fileSystemSafe(string2 + (n2 > 1 ? "(" + n2 + ")" : "")) + CONF_EXT);
            ++n2;
        } while (FileUtils.isExistingFile(FileUtils.canonicalToData(file3.getPath())));
        return file3.getPath();
    }

    public static void doRunDosbox(DosboxVersion dosboxVersion, Map<String, String> map) throws IOException {
        FileUtils.doRunDosbox(dosboxVersion, new String[0], true, null, map, false);
    }

    public static void doCreateDosboxConf(DosboxVersion dosboxVersion) throws IOException {
        FileUtils.doRunDosbox(dosboxVersion, new String[]{"-c", "config -writeconf '" + dosboxVersion.getCanonicalConfFile() + "'", "-c", "exit"}, false, dosboxVersion.getCanonicalExecutable().getParentFile(), null, true);
    }

    public static void doRunProfile(Profile profile, List<DosboxVersion> list, Map<String, String> map, int n, boolean bl, List<NativeCommand> list2, Display display) throws IOException {
        DosboxVersion dosboxVersion = DosboxVersion.findById(list, profile.getDbversionId());
        FileUtils.doRunProfile(profile, dosboxVersion, map, n, bl, list2, display);
    }

    public static void doRunTemplate(Template template, List<DosboxVersion> list, Map<String, String> map, List<NativeCommand> list2, Display display) throws IOException {
        DosboxVersion dosboxVersion = DosboxVersion.findById(list, template.getDbversionId());
        FileUtils.doRunTemplate(template, dosboxVersion, map, list2, display);
    }

    public static void doRunProfile(Profile profile, final DosboxVersion dosboxVersion, final Map<String, String> map, int n, boolean bl, final List<NativeCommand> list, final Display display) throws IOException {
        File file;
        boolean bl2;
        boolean bl3 = bl2 = n != -1 && profile.hasSetup(n);
        if (bl2 || bl) {
            file = FileUtils.canonicalToData(PROFILES_DIR + SETUP_CONF);
            Conf conf = bl ? new Conf(profile, null, null, file, dosboxVersion, System.err) : new Conf(profile, profile.getSetup(n), profile.getSetupParameters(n), file, dosboxVersion, System.err);
            conf.save(bl);
        } else {
            file = profile.getCanonicalConfFile();
        }
        new Thread(){

            @Override
            public void run() {
                block4: {
                    try {
                        for (NativeCommand nativeCommand : list) {
                            if (nativeCommand.getCommand() == null) {
                                FileUtils.doRunDosbox(dosboxVersion, new String[]{"-conf", file.getPath()}, false, null, map, true);
                                continue;
                            }
                            FileUtils.executeCommand(nativeCommand.getExecCommandsCanToData(), nativeCommand.getCwdCanToData(), map, nativeCommand.isWaitFor());
                        }
                    }
                    catch (IOException iOException) {
                        if (display.isDisposed()) break block4;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                GeneralPurposeDialogs.warningMessage(display.getActiveShell(), iOException);
                            }
                        });
                    }
                }
            }
        }.start();
    }

    public static void doRunInstaller(Profile profile, Conf conf, List<DosboxVersion> list, Map<String, String> map, boolean bl) throws IOException {
        DosboxVersion dosboxVersion = DosboxVersion.findById(list, profile.getDbversionId());
        File file = FileUtils.canonicalToData(PROFILES_DIR + SETUP_CONF);
        Conf conf2 = new Conf(conf, file);
        conf2.save(bl);
        FileUtils.doRunDosbox(dosboxVersion, new String[]{"-conf", file.getPath()}, false, null, map, true);
    }

    public static void doRunTemplate(Template template, final DosboxVersion dosboxVersion, final Map<String, String> map, final List<NativeCommand> list, final Display display) throws IOException {
        final File file = FileUtils.canonicalToData(PROFILES_DIR + TEMPLATE_CONF);
        Conf conf = new Conf(template, file, dosboxVersion, System.err);
        conf.save();
        new Thread(){

            @Override
            public void run() {
                block4: {
                    try {
                        for (NativeCommand nativeCommand : list) {
                            if (nativeCommand.getCommand() == null) {
                                FileUtils.doRunDosbox(dosboxVersion, new String[]{"-conf", file.getPath()}, false, null, map, true);
                                continue;
                            }
                            FileUtils.executeCommand(nativeCommand.getExecCommandsCanToData(), nativeCommand.getCwdCanToData(), map, nativeCommand.isWaitFor());
                        }
                    }
                    catch (IOException iOException) {
                        if (display.isDisposed()) break block4;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                GeneralPurposeDialogs.warningMessage(display.getActiveShell(), iOException);
                            }
                        });
                    }
                }
            }
        }.start();
    }

    public static void createDir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{file}));
        }
    }

    public static void copyFiles(File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                if (!file3.isFile()) continue;
                File file4 = new File(file2, file3.getName());
                FileUtils.copy(file3, file4);
                FileUtils.fileSetLastModified(file4, file3.lastModified());
            }
        }
    }

    public static void fileSetLastModified(File file, long l) {
        if (!file.setLastModified(l)) {
            System.err.println(Settings.getInstance().msg("general.error.setlastmodifiedfile", new Object[]{file.getPath()}));
        }
    }

    public static void fileSetReadOnly(File file) {
        if (!file.setReadOnly()) {
            System.err.println(Settings.getInstance().msg("general.error.setreadonlyfile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFile(File file) {
        if (!file.isFile() || !file.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFilesInDirAndDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                System.err.println(Settings.getInstance().msg("general.error.dirtobedeletedcontainsdir", new Object[]{file.getPath()}));
                return;
            }
            for (File file2 : fileArray) {
                if (file2.delete()) continue;
                System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file2}));
            }
        }
        if (!file.isDirectory() || !file.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletedir", new Object[]{file.getPath()}));
        }
    }

    public static boolean isReadableFile(File file) {
        return file.isFile() && file.canRead();
    }

    public static void createDirIfNecessary(File file) {
        if (!file.isDirectory()) {
            System.out.println(Settings.getInstance().msg("general.notice.createdir", new Object[]{file.getPath()}));
            if (!file.mkdirs()) {
                System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{file.getPath()}));
            }
        }
    }

    public static boolean isExecutable(String string) {
        for (String string2 : EXECUTABLES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchive(String string) {
        for (String string2 : ARCHIVES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhysFS(String string) {
        for (String string2 : ARCHIVES) {
            if (!string.toLowerCase().endsWith(string2 + ':' + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    public static int containsPhysFS(String string) {
        for (String string2 : ARCHIVES) {
            int n = string.toLowerCase().indexOf(string2 + ':' + File.separatorChar);
            if (n == -1) continue;
            return n + string2.length();
        }
        return -1;
    }

    public static boolean isFatImage(String string) {
        for (String string2 : FATIMAGES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static int containsFatImage(String string) {
        for (String string2 : FATIMAGES) {
            int n = string.toLowerCase().indexOf(string2 + File.separatorChar);
            if (n == -1) continue;
            return n + string2.length();
        }
        return -1;
    }

    public static boolean isBooterImage(String string) {
        for (String string2 : BOOTERIMAGES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfFile(String string) {
        return string.toLowerCase().endsWith(CONF_EXT);
    }

    public static boolean isGamePackArchiveFile(String string) {
        return string.toLowerCase().endsWith(GAMEPACKARCHIVE_EXT);
    }

    public static boolean isIsoFile(String string) {
        for (String string2 : CDIMAGES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static int containsIso(String string) {
        for (String string2 : CDIMAGES) {
            int n = string.toLowerCase().indexOf(string2 + File.separatorChar);
            if (n == -1) continue;
            return n + string2.length();
        }
        return -1;
    }

    public static boolean isPicture(String string) {
        for (String string2 : PICTURES) {
            if (!string.toLowerCase().endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static int findSetupIndex(List<File> list) {
        for (String string : SETUPFILES) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).getName().toLowerCase().equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findMostLikelyMainIndex(String string, List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (Arrays.asList(SETUPFILES).contains(file.getName().toLowerCase()) || Arrays.asList(UNLIKELYMAINFILES).contains(file.getName().toLowerCase())) continue;
            arrayList.add(file);
        }
        if (arrayList.isEmpty()) {
            return StringRelatedUtils.findBestMatchIndex(string, FileUtils.getNames(list.toArray(new File[0])));
        }
        return list.indexOf(arrayList.get(StringRelatedUtils.findBestMatchIndex(string, FileUtils.getNames(arrayList.toArray(new File[0])))));
    }

    public static File getCanMainFile(File file) {
        String string = file.getPath();
        int n = FileUtils.containsIso(string);
        int n2 = FileUtils.containsPhysFS(string);
        int n3 = FileUtils.containsFatImage(string);
        if (n != -1) {
            return FileUtils.canonicalToDosroot(string.substring(0, n));
        }
        if (n2 != -1) {
            return FileUtils.canonicalToDosroot(string.substring(0, n2));
        }
        if (n3 != -1) {
            return FileUtils.canonicalToDosroot(string.substring(0, n3));
        }
        return FileUtils.canonicalToDosroot(file.getPath());
    }

    public static List<File> getExecutablesInDirRecursive(File file) {
        ArrayList<File> arrayList = new ArrayList<File>(org.apache.commons.io.FileUtils.listFiles(file, EXECUTABLES_UPPERCASE, true));
        Collections.sort(arrayList, new FileComparator());
        return arrayList;
    }

    public static String[] getExecutablesInZipOrIsoOrFat(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (string.toLowerCase().endsWith(ARCHIVES[0])) {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (zipEntry.isDirectory() || !FileUtils.isExecutable(string2)) continue;
                arrayList.add(PlatformUtils.archiveToNativePath(string2));
            }
            zipFile.close();
        } else if (string.toLowerCase().endsWith(ARCHIVES[1])) {
            Handler handler = new Handler();
            MyRandomAccessFile myRandomAccessFile = new MyRandomAccessFile(string, "r");
            if (handler.Open(myRandomAccessFile) != 0) {
                throw new IOException(Settings.getInstance().msg("general.error.opensevenzip", new Object[]{string}));
            }
            for (int i = 0; i < handler.size(); ++i) {
                SevenZipEntry sevenZipEntry = handler.getEntry(i);
                String string3 = sevenZipEntry.getName();
                if (sevenZipEntry.isDirectory() || !FileUtils.isExecutable(string3)) continue;
                arrayList.add(PlatformUtils.archiveToNativePath(string3));
            }
            handler.close();
        } else if (FileUtils.isIsoFile(string)) {
            ISO9660FileSystem iSO9660FileSystem = new ISO9660FileSystem(new File(string));
            Enumeration<ISO9660FileEntry> enumeration = iSO9660FileSystem.getEntries();
            while (enumeration.hasMoreElements()) {
                ISO9660FileEntry iSO9660FileEntry = enumeration.nextElement();
                String string4 = iSO9660FileEntry.getPath();
                if (iSO9660FileEntry.isDirectory() || !FileUtils.isExecutable(string4)) continue;
                arrayList.add(PlatformUtils.archiveToNativePath(string4));
            }
            iSO9660FileSystem.close();
        } else if (FileUtils.isFatImage(string)) {
            FileDisk fileDisk = new FileDisk(new File(string));
            arrayList.addAll(FileUtils.readFatEntries(new FatFileSystem(fileDisk).getRoot(), ""));
            fileDisk.close();
        }
        Collections.sort(arrayList, new FilenameComparator());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String fsDirectoryEntryNameToFileName(String string) {
        if (string.length() > 8) {
            return string.substring(0, 8).trim() + '.' + string.substring(8).trim();
        }
        return string;
    }

    private static List<String> readFatEntries(FatLfnDirectory fatLfnDirectory, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<FatLfnDirectoryEntry> iterator = fatLfnDirectory.iterator();
        while (iterator.hasNext()) {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = iterator.next();
            String string2 = FileUtils.fsDirectoryEntryNameToFileName(fatLfnDirectoryEntry.getShortName());
            if (fatLfnDirectoryEntry.isDirectory() && !string2.equals(".") && !string2.equals("..")) {
                arrayList.addAll(FileUtils.readFatEntries(fatLfnDirectoryEntry.getDirectory(), string + string2 + File.separatorChar));
                continue;
            }
            if (!fatLfnDirectoryEntry.isFile() || !FileUtils.isExecutable(string2)) continue;
            arrayList.add(string + string2);
        }
        return arrayList;
    }

    public static void zipEntry(File file, File file2, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(PlatformUtils.toArchivePath(file2, file.isDirectory()));
        zipEntry.setTime(file.lastModified());
        if (file.isFile() && !file.canWrite()) {
            zipEntry.setExtra(new byte[]{1});
        }
        zipOutputStream.putNextEntry(zipEntry);
        if (file.isFile()) {
            byte[] byArray = new byte[10240];
            int n = 0;
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
        }
        zipOutputStream.closeEntry();
    }

    public static void zipDir(File file, ZipOutputStream zipOutputStream, File file2) throws IOException {
        FileUtils.zipDir(file, zipOutputStream, file, file2);
    }

    private static void zipDir(File file, ZipOutputStream zipOutputStream, File file2, File file3) throws IOException {
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException(Settings.getInstance().msg("general.error.opendir", new Object[]{file}));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file4 = new File(file, stringArray[i]);
            FileUtils.zipEntry(file4, new File(file3, FileUtils.makeRelativeTo(file4, file2).getPath()), zipOutputStream);
            if (!file4.isDirectory()) continue;
            FileUtils.zipDir(file4, zipOutputStream, file2, file3);
        }
    }

    public static long extractZipSizeInBytes(File file, File file2) throws IOException {
        long l = 0L;
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!FileUtils.areRelated(file2, new File(zipEntry.getName()))) continue;
            l += zipEntry.getSize();
        }
        zipFile.close();
        return l;
    }

    public static long extractZipEntrySizeInBytes(File file, String string) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry(string);
        zipFile.close();
        if (zipEntry != null) {
            return zipEntry.getSize();
        }
        return 0L;
    }

    public static void extractZip(File file, File file2, File file3, ProgressNotifyable progressNotifyable) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!FileUtils.areRelated(file2, new File(zipEntry.getName()))) continue;
            File file4 = new File(file3, FileUtils.strip(new File(zipEntry.getName()), file2).getPath());
            FileUtils.extractEntry(zipFile, zipEntry, file4, progressNotifyable);
        }
        zipFile.close();
    }

    public static void extractZip(File file, String string, File file2, ProgressNotifyable progressNotifyable) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry != null) {
            FileUtils.extractEntry(zipFile, zipEntry, file2, progressNotifyable);
        }
        zipFile.close();
    }

    public static void extractEntry(ZipFile zipFile, ZipEntry zipEntry, File file, ProgressNotifyable progressNotifyable) throws IOException {
        File file2 = null;
        File file3 = null;
        if (PlatformUtils.IS_WINDOWS && file.getName().contains("~") && !(file2 = file.getCanonicalFile()).getName().equals(file.getName()) && file2.exists()) {
            file3 = FileUtils.getUniqueFileName(file2);
            file2.renameTo(file3);
        }
        if (file.exists()) {
            throw new IOException(Settings.getInstance().msg("general.error.filetobeextractedexists", new Object[]{file}));
        }
        if (zipEntry.isDirectory()) {
            if (!file.exists()) {
                FileUtils.createDir(file);
            }
        } else {
            int n;
            if (file.getParentFile() != null) {
                FileUtils.createDir(file.getParentFile());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = new byte[10240];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream.close();
            byte[] byArray2 = zipEntry.getExtra();
            if (byArray2 != null && byArray2.length == 1 && byArray2[0] == 1) {
                FileUtils.fileSetReadOnly(file);
            }
        }
        FileUtils.fileSetLastModified(file, zipEntry.getTime());
        if (file2 != null && file3 != null) {
            file3.renameTo(file2);
        }
        progressNotifyable.incrProgress((int)(zipEntry.getSize() / 1024L));
    }

    public static File determineDstSevenzipFile(File file, File file2, String string) {
        return FileUtils.canonicalTo(file2, FileUtils.strip(new File(string), file).getPath());
    }

    public static int[] findRelatedEntryIds(IInArchive iInArchive, File file) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < iInArchive.size(); ++i) {
            if (!FileUtils.areRelated(file, new File(iInArchive.getEntry(i).getName()))) continue;
            arrayList.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])arrayList.toArray(new Integer[0]));
    }

    public static int findEntryId(IInArchive iInArchive, String string) {
        for (int i = 0; i < iInArchive.size(); ++i) {
            if (!iInArchive.getEntry(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static File strip(File file, File file2) {
        if (file.equals(file2)) {
            return new File(".");
        }
        File file3 = new File(file.getName());
        for (File file4 = file.getParentFile(); file4 != null; file4 = file4.getParentFile()) {
            if (file4.equals(file2)) {
                return file3;
            }
            file3 = new File(file4.getName(), file3.getPath());
        }
        return file;
    }

    public static String getUrlFromFile(File file) throws MalformedURLException {
        return file.toURI().toURL().toString();
    }

    public static String fileSystemSafe(String string) {
        return string.replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    public static String fileSystemSafeWebImages(String string) {
        return string.replaceAll(" ", "_").replaceAll(INVALID_FILENAME_CHARS_REGEXP, "");
    }

    public static File getUniqueFileName(File file) {
        return new File(file.getParentFile(), UUID.randomUUID() + "__" + file.getName());
    }

    public static File getTmpInstallFile() {
        return TMPINST_DIR_FILE;
    }

    public static boolean isStoredOnFloppyDrive(File file) {
        if (PlatformUtils.IS_OSX) {
            return false;
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        for (File file2 : File.listRoots()) {
            if (!FileUtils.areRelated(file2, file)) continue;
            return fileSystemView.isFloppyDrive(file2);
        }
        return false;
    }

    public static boolean isStoredOnCDRomDrive(File file) {
        if (PlatformUtils.IS_OSX) {
            return false;
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        for (File file2 : File.listRoots()) {
            if (!FileUtils.areRelated(file2, file)) continue;
            return fileSystemView.isDrive(file2) && fileSystemView.getSystemTypeDescription(file2).toUpperCase().contains("CD");
        }
        return false;
    }

    private static String[] getNames(File[] fileArray) {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName();
        }
        return stringArray;
    }

    public static File[] findFileSequence(File file) {
        File file2;
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        int n = 1;
        String string = FilenameUtils.removeExtension(file.getName());
        String string2 = FilenameUtils.getExtension(file.getName());
        if (string.endsWith(String.valueOf(n)) && (file2 = file.getParentFile()) != null) {
            File[] fileArray = file2.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            });
            Object[] objectArray = FileUtils.getNames(fileArray);
            if (fileArray != null) {
                int n2;
                do {
                    String string3;
                    if ((n2 = ArrayUtils.indexOf((Object[])objectArray, (Object)(string3 = StringUtils.chop((String)string) + String.valueOf(++n) + '.' + string2))) < 0) continue;
                    arrayList.add(fileArray[n2]);
                } while (n2 >= 0);
            }
        }
        return arrayList.toArray(new File[0]);
    }

    public static String[] getShaders() {
        File file = new File(DOSROOT_DIR_FILE, "SHADERS");
        if (file.exists() && file.isDirectory()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<File> iterator = org.apache.commons.io.FileUtils.iterateFiles(file, new String[]{"fx"}, false);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getName());
            }
            Collections.sort(arrayList);
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    public static Set<ShortFile> listShortFiles(File file) {
        TreeSet<ShortFile> treeSet = new TreeSet<ShortFile>();
        for (File file2 : file.listFiles()) {
            treeSet.add(FileUtils.createShortFile(file2, treeSet));
        }
        return treeSet;
    }

    public static List<File> convertToShortFileSet(List<File> list) {
        TreeSet<ShortFile> treeSet = new TreeSet<ShortFile>();
        for (File object : list) {
            treeSet.add(FileUtils.createShortFile(object, treeSet));
        }
        ArrayList arrayList = new ArrayList();
        for (ShortFile shortFile : treeSet) {
            arrayList.add(new File(shortFile.getFile().getParentFile(), shortFile.getName()));
        }
        return arrayList;
    }

    private static ShortFile createShortFile(File file, Set<ShortFile> set) {
        String string = file.getName().toUpperCase();
        boolean bl = false;
        if (StringUtils.contains((CharSequence)string, (int)32)) {
            string = StringUtils.remove((String)string, (char)' ');
            bl = true;
        }
        int n = 0;
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            if (string.length() - n2 - 1 > 3) {
                string = StringUtils.stripStart((String)string, (String)".");
                bl = true;
            }
            n = (n2 = string.indexOf(46)) != -1 ? n2 : string.length();
        } else {
            n = string.length();
        }
        boolean bl2 = n > 8;
        ShortFile shortFile = null;
        if (!(bl |= bl2)) {
            shortFile = new ShortFile(file, StringUtils.removeEnd((String)string, (String)"."));
        } else {
            StringBuffer stringBuffer;
            int n3 = 1;
            do {
                String string2 = String.valueOf(n3++);
                stringBuffer = new StringBuffer(StringUtils.left((String)string, (int)Math.min(8 - string2.length() - 1, n)));
                stringBuffer.append('~').append(string2);
                n2 = string.lastIndexOf(46);
                if (n2 == -1) continue;
                stringBuffer.append(StringUtils.left((String)string.substring(n2), (int)4));
            } while ((shortFile = new ShortFile(file, StringUtils.removeEnd((String)stringBuffer.toString(), (String)"."))).isContainedIn(set));
        }
        return shortFile;
    }

    static {
        TEMPLATES_DIR = "templates" + File.separatorChar;
        DOSROOT_DIR = "dosroot" + File.separatorChar;
        CAPTURES_DIR = "captures" + File.separatorChar;
        MAPPER_DIR = "mapper" + File.separatorChar;
        PROFILES_DIR = "profiles" + File.separatorChar;
        EXPORT_DIR = "export" + File.separatorChar;
        XSL_DIR = "xsl" + File.separatorChar;
        CDIMAGES = new String[]{".iso", ".cue", ".bin"};
        EXECUTABLES = new String[]{".exe", ".com", ".bat"};
        EXECUTABLES_UPPERCASE = new String[]{"EXE", "COM", "BAT"};
        ARCHIVES = new String[]{".zip", ".7z"};
        FATIMAGES = new String[]{".ima"};
        BOOTERIMAGES = new String[]{".cp2", ".dcf", ".img", ".jrc", ".td0"};
        PICTURES = new String[]{".png", ".gif", ".jpg", ".tif", ".tiff", ".ico", ".bmp"};
        SETUPFILES = new String[]{"setup.exe", "install.exe", "setsound.exe", "setup.bat", "config.exe", "setsound.bat", "sound.bat", "sound.exe", "install.com", "install.bat", "sndsetup.exe", "soundset.exe", "config.bat", "setup.com", "setsnd.exe", "setd.exe", "configur.exe", "uwsound.exe"};
        UNLIKELYMAINFILES = new String[]{"dos4gw.exe", "readme.bat", "intro.exe", "loadpats.exe", "uvconfig.exe", "soundrv.com", "sblaster.com", "sound.bat", "univbe.exe", "midpak.com", "ultramid.exe", "mpscopy.exe", "readme.exe", "sbpro.com", "help.bat", "exists.com", "helpme.exe", "paudio.com", "bootdisk.exe", "pas16.com", "mssw95.exe", "setd.exe", "adlib.com", "sbclone.com", "sb16.com", "godir.com", "ibmsnd.com", "crack.com", "gf166.com", "__insth.bat", "adlibg.com", "space.com", "instgame.bat", "ibmbak.com", "pkunzjr.com", "nosound.com", "sview.exe", "mgraphic.exe", "title.exe", "misc.exe", "checkcd.bat", "patch.exe", "tansltl.com", "readme.com", "uninstal.exe", "source.com", "cmidpak.com", "vector.com", "view.exe", "rtm.exe", "eregcard.exe", "sndsys.com", "info.exe", "docshell.exe", "catalog.exe", "ipxsetup.exe", "yes.com", "stfx.com", "getkey.com", "lsize.com", "makepath.com", "sersetup.exe", "commit.exe", "_setup.exe", "end.exe", "what.exe", "setm.exe", "cvxsnd.com", "aria.com", "tgraphic.exe", "egraphic.exe", "smidpak.com", "tlivesa.com", "vmsnd.com", "detect.exe", "digvesa.com", "cwsdpmi.exe", "vesa.exe", "havevesa.exe", "_install.bat", "smsnd.com", "insticon.exe", "installh.bat", "install2.bat", "info.bat", "setmain.exe", "swcbbs.exe", "vbetest.exe", "pmidpak.com", "inst.exe", "cleardrv.exe", "winstall.exe", "ibm1bit.com", "tmidpak.com", "dealers.exe", "digisp.com", "drv_bz.com", "drv_sb.com", "drv_ss.com", "convert.exe", "editor.exe", "cgraphic.exe", "update.bat", "smackply.exe", "univesa.exe", "lha.exe", "makeboot.bat", "nnansi.com", "setblast.exe", "autoexec.bat", "helpme.bat", "exist.com", "fixboot.exe", "ask.com", "vesatest.exe", "manual.exe", "sbwave.com", "rmidpak.com", "diagnost.exe", "pkunzip.exe", "sinstall.exe", "megaem.exe", "vesa.com", "getdrv.exe", "drv_sbd.com", "chkvesa.exe", "chkmem.com", "setstick.exe"};
        SectionsWrapper sectionsWrapper = Settings.getInstance().getSettings();
        String string = FileUtils.replaceTildeInPath(sectionsWrapper.getValue("directory", "data"));
        boolean bl = PlatformUtils.USE_USER_HOME_DIR || !PlatformUtils.isDirectoryWritable(new File(string));
        DATA_DIR_FILE = FileUtils.canonical(bl ? new File(PlatformUtils.USER_DATA_DIR_FILE, string).getPath() : string);
        DOSROOT_DIR_FILE = new File(DATA_DIR_FILE, DOSROOT_DIR);
        DOSBOX_DIR_FILE = FileUtils.canonical(FileUtils.replaceTildeInPath(sectionsWrapper.getValue("directory", "dosbox")));
        TMPINST_DIR_FILE = new File(DOSROOT_DIR_FILE, sectionsWrapper.getValue("directory", "tmpinstall"));
        if (bl) {
            FileUtils.copyDirectoriesIfNecessary(string);
        }
        FileUtils.createDirIfNecessary(DOSROOT_DIR_FILE);
    }

    public static final class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            return new FilenameComparator().compare(file.getPath(), file2.getPath());
        }
    }

    public static final class FilenameComparator
    implements Comparator<String> {
        @Override
        public int compare(String string, String string2) {
            int n;
            int n2 = StringUtils.countMatches((CharSequence)string, (CharSequence)"\\");
            if (n2 == (n = StringUtils.countMatches((CharSequence)string2, (CharSequence)"\\"))) {
                return string.compareTo(string2);
            }
            return n2 - n;
        }
    }
}

