/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.waldheinz.fs.fat.FatDirectoryEntry;

public abstract class AbstractDirectory {
    public static final int MAX_LABEL_LENGTH = 11;
    private final List<FatDirectoryEntry> entries = new ArrayList<FatDirectoryEntry>();
    private final boolean isRoot;
    private int capacity;

    protected AbstractDirectory(int n, boolean bl) {
        this.capacity = n;
        this.isRoot = bl;
    }

    protected abstract void read(ByteBuffer var1) throws IOException;

    public final FatDirectoryEntry getEntry(int n) {
        return this.entries.get(n);
    }

    public final int getEntryCount() {
        return this.entries.size();
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public final void read() throws IOException {
        FatDirectoryEntry fatDirectoryEntry;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.capacity * 32);
        this.read(byteBuffer);
        byteBuffer.flip();
        for (int i = 0; i < this.capacity && (fatDirectoryEntry = FatDirectoryEntry.read(byteBuffer)) != null; ++i) {
            if (fatDirectoryEntry.isVolumeLabel()) {
                if (this.isRoot) continue;
                throw new IOException("volume label in non-root directory");
            }
            this.entries.add(fatDirectoryEntry);
        }
    }
}

