/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import org.dbgl.waldheinz.fs.fat.AbstractDirectory;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.BootSector;
import org.dbgl.waldheinz.fs.fat.ClusterChain;
import org.dbgl.waldheinz.fs.fat.ClusterChainDirectory;
import org.dbgl.waldheinz.fs.fat.Fat;
import org.dbgl.waldheinz.fs.fat.Fat16BootSector;
import org.dbgl.waldheinz.fs.fat.Fat16RootDirectory;
import org.dbgl.waldheinz.fs.fat.Fat32BootSector;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectory;
import org.dbgl.waldheinz.fs.fat.FatType;

public final class FatFileSystem {
    private final Fat fat;
    private final BootSector bs;
    private final FatLfnDirectory rootDir;
    private final AbstractDirectory rootDirStore;
    private final FatType fatType;

    public FatFileSystem(BlockDevice blockDevice) throws IOException {
        Object object;
        this.bs = BootSector.read(blockDevice);
        if (this.bs.getNrFats() <= 0) {
            throw new IOException("boot sector says there are no FATs");
        }
        this.fatType = this.bs.getFatType();
        this.fat = Fat.read(this.bs, 0);
        for (int i = 1; i < this.bs.getNrFats(); ++i) {
            object = Fat.read(this.bs, i);
            if (this.fat.equals(object)) continue;
            System.err.println("FAT " + i + " differs from FAT 0");
        }
        if (this.fatType == FatType.FAT32) {
            Fat32BootSector fat32BootSector = (Fat32BootSector)this.bs;
            object = new ClusterChain(this.fat, fat32BootSector.getRootDirFirstCluster());
            this.rootDirStore = ClusterChainDirectory.readRoot((ClusterChain)object);
        } else {
            this.rootDirStore = Fat16RootDirectory.read((Fat16BootSector)this.bs);
        }
        this.rootDir = new FatLfnDirectory(this.rootDirStore, this.fat);
    }

    public FatLfnDirectory getRoot() {
        return this.rootDir;
    }
}

