/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dbgl.waldheinz.fs.fat.BlockDevice;

class Sector {
    private final BlockDevice device;
    protected final long offset;
    protected final ByteBuffer buffer;

    protected Sector(BlockDevice blockDevice, long l, int n) {
        this.offset = l;
        this.device = blockDevice;
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected void read() throws IOException {
        this.buffer.rewind();
        this.buffer.limit(this.buffer.capacity());
        this.device.read(this.offset, this.buffer);
    }

    public BlockDevice getDevice() {
        return this.device;
    }

    protected int get16(int n) {
        return this.buffer.getShort(n) & 0xFFFF;
    }

    protected long get32(int n) {
        return this.buffer.getInt(n);
    }

    protected int get8(int n) {
        return this.buffer.get(n) & 0xFF;
    }
}

